/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.mediacollection;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollection;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerMediaCollectionsNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerMediaCollectionsNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Media Collections", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"ID", "CollectionName"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getMediaCollections()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerMediaCollection lunaServerMediaCollection = (LunaServerMediaCollection)vector.elementAt(i);
            objectArray[i][0] = lunaServerMediaCollection;
            objectArray[i][1] = lunaServerMediaCollection.collectionName;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-collections-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), null, null, "Delete Media Collection Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Media Collection Command")) {
            this.lunaServerNode.createNewCollection();
        } else if (string.equals("Delete Media Collection Command")) {
            if (vector != null && vector.size() > 0) {
                this.lunaServerNode.removeCollections(vector);
            }
        } else if (string.equals("Edit Media Collection Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editCollection((LunaServerMediaCollection)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editCollection((LunaServerMediaCollection)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerMediaCollectionsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerCollectionsNode: " + string, n);
    }
}

