/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.mediacollection;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.IndexedStringObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollectionEditComponent;
import com.luna.insight.admin.lunaserver.sharedmediacollection.LunaServerSharedMediaCollection;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;

public class LunaServerMediaCollection
extends EditableDataObject
implements IndexedObject,
IndexedStringObject,
DatabaseRecord {
    public static final String RECORD_TYPE_MEDIACOLLECTION = "Media Collection";
    protected LunaServer lunaServer;
    protected String collectionName = "";
    protected String id = null;
    protected String cid = null;
    protected String iid = null;
    protected String uid = null;
    protected LunaServerMediaCollectionEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;
    protected Vector availableLocales = null;
    protected Set credentials = new HashSet();

    public LunaServerMediaCollection(LunaServer lunaServer, String string, String string2, String string3, String string4, String string5) {
        this.lunaServer = lunaServer;
        this.id = string == null ? "" : string;
        this.collectionName = string5 == null ? "" : string5;
        this.cid = string3 == null ? "" : string3;
        this.uid = string4 == null ? "" : string4;
        this.iid = string2 == null ? "" : string2;
    }

    public LunaServerMediaCollection(int n, LunaServer lunaServer) {
        this.lunaServer = lunaServer;
    }

    public void addCredentialIndex(int n) {
        this.credentials.add(new Integer(n));
    }

    public String getCollectionID() {
        return this.cid;
    }

    public String getUniqueCollectionID() {
        return this.uid;
    }

    public String getInstitutionID() {
        return this.iid;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.collectionName;
    }

    public int getIndex() {
        return this.getStringIDSimple(this.id);
    }

    public String getStringIndex() {
        return this.id;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerMediaCollectionEditComponent();
        this.editComponent.getCollectionNameField().setText(this.id);
        this.editComponent.getCollectionNameField().setText(this.collectionName);
        Vector<String> vector = new Vector<String>();
        vector.add(RECORD_TYPE_MEDIACOLLECTION);
        return this.editComponent;
    }

    public void save() {
    }

    public void cancel() {
        LunaServerMediaCollection.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Media Collection - " + this.collectionName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-collections-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerMediaCollection) {
            LunaServerMediaCollection lunaServerMediaCollection = (LunaServerMediaCollection)object;
            return LunaServerMediaCollection.stringsAreEqual(this.id, lunaServerMediaCollection.id);
        }
        if (object instanceof LunaServerSharedMediaCollection) {
            LunaServerSharedMediaCollection lunaServerSharedMediaCollection = (LunaServerSharedMediaCollection)object;
            return LunaServerMediaCollection.stringsAreEqual(this.id, lunaServerSharedMediaCollection.getID());
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerMediaCollection) {
            LunaServerMediaCollection lunaServerMediaCollection = (LunaServerMediaCollection)databaseRecord;
            return this.id == lunaServerMediaCollection.id && LunaServerMediaCollection.stringsAreEqual(this.collectionName, lunaServerMediaCollection.collectionName);
        }
        return false;
    }

    public String getID() {
        return this.id;
    }

    public int getStringIDSimple(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i) * (string.length() - i) * 491;
        }
        return n;
    }

    public static void debugOut(String string) {
        LunaServerMediaCollection.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerCollection: " + string, n);
    }
}

