/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.mediacollection;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMap;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerCredentialCollectionMapsNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerCredentialCollectionMapsNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Credential Settings", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"Map ID", "Credential", "Media Collection", "Max Resolution", "Max Export Resolution", "Collection Annotation Enabled"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getCredentialCollectionMaps()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap = (LunaServerCredentialCollectionMap)vector.elementAt(i);
            objectArray[i][0] = lunaServerCredentialCollectionMap;
            objectArray[i][1] = lunaServerCredentialCollectionMap.credentialName;
            objectArray[i][2] = lunaServerCredentialCollectionMap.collectionName;
            objectArray[i][3] = new Integer(lunaServerCredentialCollectionMap.maxResolution);
            objectArray[i][4] = new Integer(lunaServerCredentialCollectionMap.maxExportResolution);
            objectArray[i][5] = new Boolean(lunaServerCredentialCollectionMap.annotationEnabled);
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), null, "Edit Credential Collection Map Command", null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit Credential Collection Map Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editCredentialCollectionMap((LunaServerCredentialCollectionMap)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editCredentialCollectionMap((LunaServerCredentialCollectionMap)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerCredentialCollectionMapsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerCredentialCollectionMapsNode: " + string, n);
    }
}

