/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.mediacollection;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMapEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class LunaServerCredentialCollectionMap
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected String mapId;
    protected LunaServer lunaServer;
    protected int credentialId = 0;
    protected String collectionId = "";
    protected int maxResolution = 0;
    protected int maxExportResolution = 0;
    protected String credentialName = "";
    protected String collectionName = "";
    protected boolean annotationEnabled = false;
    protected LunaServerCredentialCollectionMapEditComponent editComponent = null;

    public LunaServerCredentialCollectionMap(LunaServer lunaServer, int n, String string, int n2, int n3, String string2, String string3, boolean bl) {
        this.lunaServer = lunaServer;
        this.credentialId = n;
        this.collectionId = string;
        this.mapId = n + "-" + string;
        this.maxResolution = n2;
        this.maxExportResolution = n3;
        this.credentialName = string2;
        this.collectionName = string3;
        this.annotationEnabled = bl;
    }

    public LunaServer getLunaServer() {
        return this.lunaServer;
    }

    public String toString() {
        return this.getMapId();
    }

    public String getMapId() {
        return this.mapId;
    }

    public int getIndex() {
        return -1;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerCredentialCollectionMapEditComponent();
        this.editComponent.getMaxResolutionField().setText(Integer.toString(this.maxResolution));
        this.editComponent.getMaxExportResolutionField().setText(Integer.toString(this.maxExportResolution));
        this.editComponent.getMaxResolutionField().selectAll();
        this.editComponent.getAnnotationEnabledCheckBox().setSelected(this.annotationEnabled);
        return this.editComponent;
    }

    public void save() {
        LunaServerCredentialCollectionMap.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.maxResolution, Integer.parseInt(this.editComponent.getMaxResolutionField().getText()))) {
            this.maxResolution = Integer.parseInt(this.editComponent.getMaxResolutionField().getText());
        }
        if (this.hasChanged(this.maxExportResolution, Integer.parseInt(this.editComponent.getMaxExportResolutionField().getText()))) {
            this.maxExportResolution = Integer.parseInt(this.editComponent.getMaxExportResolutionField().getText());
        }
        if (this.hasChanged(this.annotationEnabled, this.editComponent.getAnnotationEnabledCheckBox().isSelected())) {
            this.annotationEnabled = this.editComponent.getAnnotationEnabledCheckBox().isSelected();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void insert() {
        this.lunaServer.commitDataObject(this);
    }

    public void cancel() {
        LunaServerCredentialCollectionMap.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Credential Collection Map- " + this.credentialId + "-" + this.collectionId;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.getMapId();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerCredentialCollectionMap) {
            LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap = (LunaServerCredentialCollectionMap)object;
            return this.mapId.compareTo(lunaServerCredentialCollectionMap.mapId) == 0;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerCredentialCollectionMap) {
            LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap = (LunaServerCredentialCollectionMap)databaseRecord;
            return this.maxResolution == lunaServerCredentialCollectionMap.maxResolution && this.maxExportResolution == lunaServerCredentialCollectionMap.maxExportResolution && LunaServerCredentialCollectionMap.stringsAreEqual(this.mapId, lunaServerCredentialCollectionMap.mapId) && this.annotationEnabled == lunaServerCredentialCollectionMap.annotationEnabled;
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerCredentialCollectionMap.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerCredentialCollectionMap: " + string, n);
    }

    public int compareTo(Object object) {
        return this.mapId.compareTo(((LunaServerCredentialCollectionMap)object).mapId);
    }
}

