/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.maintenance;

import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.maintenance.LunaServerMaintenance;
import com.luna.insight.admin.lunaserver.maintenance.LunaServerMaintenanceDisplay;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class LunaServerMaintenanceNode
extends ControlPanelNode
implements ActionListener {
    protected LunaServerNode lunaServerNode = null;
    protected LunaServerMaintenanceDisplay maintenanceDisplay = null;

    public LunaServerMaintenanceNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Server Maintenance Mode", false);
        this.lunaServerNode = lunaServerNode;
    }

    public JComponent getDisplayComponent() {
        return new JLabel();
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.lunaServerNode.getAdminAccount().createPermittedServerMenuItem("Run...", "Open Maintenance Command", this.lunaServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-creation-indexer-icon.gif");
        }
        return this.treeIcon;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.maintenanceDisplay.getStartButton()) {
            this.runMaintenance();
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.runMaintenance();
        }
    }

    public void launchMaintenanceSetup() {
        if (this.maintenanceDisplay == null || this.maintenanceDisplay.isClosed()) {
            this.maintenanceDisplay = new LunaServerMaintenanceDisplay(this.insightAdministrator);
            this.maintenanceDisplay.setFrameIcon(this.getIcon());
            this.maintenanceDisplay.getServerHost().setText(this.lunaServerNode.getLunaServer().getLunaServerAddress());
            this.maintenanceDisplay.getServerPort().setText(this.lunaServerNode.getLunaServer().getLunaServerPort());
            this.maintenanceDisplay.getStartButton().addActionListener(this);
            this.maintenanceDisplay.show();
        } else {
            InsightAdministrator.getInsightAdministrator().setSelectedFrame(this.maintenanceDisplay);
        }
    }

    public void runMaintenance() {
        LunaServerMaintenance lunaServerMaintenance = new LunaServerMaintenance(this.lunaServerNode.getLunaServer(), this.maintenanceDisplay.getServerHost().getText(), this.maintenanceDisplay.getServerPort().getText());
        lunaServerMaintenance.sendRequest();
        this.maintenanceDisplay.dispose();
    }

    public static void debugOut(String string) {
        LunaServerMaintenanceNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerMaintenanceNode: " + string, n);
    }
}

