/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.ipranges;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRanges;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Hashtable;
import java.util.Vector;

public class LunaServerIPRangesRecordHandler
extends DatabaseRecordHandler {
    public LunaServerIPRangesRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "LunaServerIpRangeRecordHandler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        DatabaseConnector databaseConnector = null;
        try {
            LunaServerIPRanges lunaServerIPRanges = (LunaServerIPRanges)databaseRecord;
            if (lunaServerIPRanges.setAsDefault && this.isDefaultSet(lunaServerIPRanges.id)) {
                this.debugOut("At least 1 IP range has been set as default");
                databaseRecord = null;
            } else {
                databaseConnector = this.getDatabaseConnector();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ID", 2, stringBuffer2, lunaServerIPRanges.id);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CredentialsID", 2, stringBuffer2, lunaServerIPRanges.credentialId);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Location", 1, stringBuffer2, lunaServerIPRanges.location);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Description", 1, stringBuffer2, lunaServerIPRanges.description);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StartIp", 1, stringBuffer2, lunaServerIPRanges.startIp);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EndIp", 1, stringBuffer2, lunaServerIPRanges.endIp);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SetAsDefault", 2, stringBuffer2, lunaServerIPRanges.setAsDefault);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MinimalClientSide", 2, stringBuffer2, lunaServerIPRanges.minimalClientSide);
                String string = "INSERT INTO IPRANGES (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertIpRangeQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in commitIpRangeRecord(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM IPRANGES WHERE ID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteIpRangeQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteIpRangeRecord(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector vector = new Vector();
        DatabaseConnector databaseConnector = null;
        try {
            Object object;
            Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IPRANGES", null, "*");
            sqlQueryGenerator.addOrderBy("IPRANGES", "ID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Luna IP Ranges query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    object = new LunaServerIPRanges((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ID"), databaseConnector.getIntegerFieldByName("credentialsId"), databaseConnector.getFieldByName("Location"), databaseConnector.getFieldByName("Description"), databaseConnector.getFieldByName("StartIp"), databaseConnector.getFieldByName("EndIp"), databaseConnector.getIntegerFieldByName("SetAsDefault") == 1, databaseConnector.getIntegerFieldByName("MinimalClientSide") == 1);
                    hashtable.put(new Integer(((LunaServerIPRanges)object).id), object);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            object = vector;
            return object;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getIpRangeRecords(): " + exception);
            Vector vector2 = vector;
            return vector2;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord(DatabaseRecord)");
        LunaServerIPRanges lunaServerIPRanges = null;
        int n = databaseRecord.getIndex();
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IPRANGES", null, "*");
            sqlQueryGenerator.appendToWhere("ID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Luna IP Range query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                lunaServerIPRanges = new LunaServerIPRanges((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ID"), databaseConnector.getIntegerFieldByName("credentialsId"), databaseConnector.getFieldByName("Location"), databaseConnector.getFieldByName("Description"), databaseConnector.getFieldByName("StartIp"), databaseConnector.getFieldByName("EndIp"), databaseConnector.getIntegerFieldByName("SetAsDefault") == 1, databaseConnector.getIntegerFieldByName("MinimalClientSide") == 1);
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return lunaServerIPRanges;
    }

    public String getNextValidIDQuery() {
        return "SELECT ID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IPRANGES" + " ORDER BY ID";
    }

    private boolean isDefaultSet(int n) {
        this.debugOut("in isDefaultSet()");
        DatabaseConnector databaseConnector = null;
        try {
            Integer n2;
            databaseConnector = this.getDatabaseConnector();
            String string = "SELECT COUNT(*) AS CNT FROM IPRANGES WHERE IPRANGES.ID <> " + n + " AND " + "IPRANGES" + ".SetAsDefault = 1";
            databaseConnector.setQuery(string);
            this.debugOut("Check UseAsDefault query: \n" + string, 3);
            databaseConnector.runQuery();
            if (databaseConnector.more() && (n2 = new Integer(databaseConnector.getIntegerField("CNT"))) > 0) {
                return true;
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isDefaultSet(): " + exception);
            return false;
        }
        return false;
    }

    public void updateMaxIDValue(long l) {
    }
}

