/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.ipranges;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRanges;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerIPRangesNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerIPRangesNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "IP Ranges", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"Location", "Description", "Credential ID", "Start IP", "End IP", "Set as Default", "Minimal Animations"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getIpRanges()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerIPRanges lunaServerIPRanges = (LunaServerIPRanges)vector.elementAt(i);
            objectArray[i][0] = lunaServerIPRanges;
            objectArray[i][1] = lunaServerIPRanges.description;
            objectArray[i][2] = new Integer(lunaServerIPRanges.credentialId);
            objectArray[i][3] = lunaServerIPRanges.startIp;
            objectArray[i][4] = lunaServerIPRanges.endIp;
            objectArray[i][5] = new Boolean(lunaServerIPRanges.setAsDefault);
            objectArray[i][6] = new Boolean(lunaServerIPRanges.minimalClientSide);
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.lunaServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New IP Range Command", this.lunaServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), "New IP Range Command", "Edit IP Range Command", "Delete IP Range Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New IP Range Command")) {
            this.lunaServerNode.createNewIpRange();
        } else if (string.equals("Delete IP Range Command")) {
            if (vector != null && vector.size() > 0) {
                this.lunaServerNode.removeIpRanges(vector);
            }
        } else if (string.equals("Edit IP Range Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editIpRange((LunaServerIPRanges)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editIpRange((LunaServerIPRanges)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerIPRangesNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerIpRangesNode: " + string, n);
    }
}

