/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.ipranges;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredential;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRangesEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class LunaServerIPRanges
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected int id;
    protected int credentialId;
    protected LunaServer lunaServer;
    protected String location = "";
    protected String description = "";
    protected String startIp = "";
    protected String endIp = "";
    protected boolean setAsDefault = false;
    protected boolean minimalClientSide = false;
    private Vector credentials;
    private List selectableCredentials = new ArrayList();
    protected LunaServerIPRangesEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public LunaServerIPRanges(LunaServer lunaServer, int n, int n2, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.lunaServer = lunaServer;
        this.id = n;
        this.credentialId = n2;
        this.location = string == null ? "" : string;
        this.description = string2 == null ? "" : string2;
        this.startIp = string3 == null ? "" : string3;
        this.endIp = string4 == null ? "" : string4;
        this.setAsDefault = bl;
        this.minimalClientSide = bl2;
    }

    public LunaServerIPRanges(int n, LunaServer lunaServer) {
        this.id = n;
        this.lunaServer = lunaServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.location;
    }

    public int getIndex() {
        return this.id;
    }

    public int getIPRangeId() {
        return this.id;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerIPRangesEditComponent();
        this.credentials = this.lunaServer.getCredentials();
        this.editComponent.getLocationField().setText(this.location);
        this.editComponent.getDescriptionField().setText(this.description);
        this.editComponent.getStartIpField().setText(this.startIp);
        this.editComponent.getEndIpField().setText(this.endIp);
        this.editComponent.getSetAsDefaultCheckBox().setSelected(this.setAsDefault);
        this.editComponent.getMinimalClientSideCheckBox().setSelected(this.minimalClientSide);
        int n = -1;
        Vector<String> vector = new Vector<String>();
        this.selectableCredentials.clear();
        Enumeration enumeration = this.credentials.elements();
        while (enumeration.hasMoreElements()) {
            LunaServerCredential lunaServerCredential = (LunaServerCredential)enumeration.nextElement();
            String string = lunaServerCredential.getCredentialId() + " - " + lunaServerCredential.getName();
            vector.addElement(string);
            this.selectableCredentials.add(new Integer(lunaServerCredential.getCredentialId()));
            if (lunaServerCredential.getCredentialId() != this.credentialId) continue;
            n = this.selectableCredentials.size() - 1;
        }
        this.editComponent.getCredentialComboBox().setModel(new DefaultComboBoxModel(vector));
        this.editComponent.getCredentialComboBox().setSelectedIndex(n);
        return this.editComponent;
    }

    public void save() {
        LunaServerIPRanges.debugOut("Save...", 3);
        this.requiresCommit = false;
        int n = this.credentialId;
        try {
            n = (Integer)this.selectableCredentials.get(this.editComponent.getCredentialComboBox().getSelectedIndex());
        }
        catch (Exception exception) {
            n = this.credentialId;
        }
        if (this.hasChanged(this.credentialId, n)) {
            this.credentialId = n;
        }
        if (this.hasChanged(this.location, this.editComponent.getLocationField().getText())) {
            this.location = this.editComponent.getLocationField().getText();
        }
        if (this.hasChanged(this.description, this.editComponent.getDescriptionField().getText())) {
            this.description = this.editComponent.getDescriptionField().getText();
        }
        if (this.hasChanged(this.startIp, this.editComponent.getStartIpField().getText())) {
            this.startIp = this.editComponent.getStartIpField().getText();
        }
        if (this.hasChanged(this.endIp, this.editComponent.getEndIpField().getText())) {
            this.endIp = this.editComponent.getEndIpField().getText();
        }
        if (this.hasChanged(this.setAsDefault, this.editComponent.getSetAsDefaultCheckBox().isSelected())) {
            this.setAsDefault = this.editComponent.getSetAsDefaultCheckBox().isSelected();
        }
        if (this.hasChanged(this.minimalClientSide, this.editComponent.getMinimalClientSideCheckBox().isSelected())) {
            this.minimalClientSide = this.editComponent.getMinimalClientSideCheckBox().isSelected();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void cancel() {
        LunaServerIPRanges.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit IP Range - " + this.location;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerIPRanges) {
            LunaServerIPRanges lunaServerIPRanges = (LunaServerIPRanges)object;
            return this.id == lunaServerIPRanges.id;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerIPRanges) {
            LunaServerIPRanges lunaServerIPRanges = (LunaServerIPRanges)databaseRecord;
            return this.id == lunaServerIPRanges.id && this.credentialId == lunaServerIPRanges.credentialId && this.setAsDefault == lunaServerIPRanges.setAsDefault && LunaServerIPRanges.stringsAreEqual(this.location, lunaServerIPRanges.location) && LunaServerIPRanges.stringsAreEqual(this.description, lunaServerIPRanges.description) && LunaServerIPRanges.stringsAreEqual(this.startIp, lunaServerIPRanges.startIp) && LunaServerIPRanges.stringsAreEqual(this.endIp, lunaServerIPRanges.endIp);
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerIPRanges.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerUser: " + string, n);
    }

    public int compareTo(Object object) {
        return this.location.compareTo(((LunaServerIPRanges)object).location);
    }
}

