/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.extendedcollectionproperties;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.extendedcollectionproperties.LunaServerExtendedCollectionPropertiesEditComponent;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class LunaServerExtendedCollectionProperties
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected String collectionId;
    protected String collectionName;
    protected int defaultGroupId;
    protected LunaServer lunaServer;
    protected String introductionText = "";
    protected String homeGraphicUrl = "";
    protected String headerGraphicUrl = "";
    protected String theme = "";
    protected boolean useAsDefault = false;
    private Vector mediaGroups;
    private List selectableMediaGroups = new ArrayList();
    protected LunaServerExtendedCollectionPropertiesEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public LunaServerExtendedCollectionProperties(LunaServer lunaServer, String string, String string2, int n, String string3, String string4, String string5, String string6, boolean bl) {
        this.lunaServer = lunaServer;
        this.collectionId = string == null ? "" : string;
        this.collectionName = string2;
        this.defaultGroupId = n;
        this.introductionText = string3 == null ? "" : string3;
        this.homeGraphicUrl = string4 == null ? "" : string4;
        this.headerGraphicUrl = string5 == null ? "" : string5;
        this.theme = string6 == null ? "" : string6;
        this.useAsDefault = bl;
    }

    public LunaServerExtendedCollectionProperties(String string, LunaServer lunaServer) {
        this.collectionId = string;
        this.lunaServer = lunaServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.collectionId;
    }

    public int getIndex() {
        return 0;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerExtendedCollectionPropertiesEditComponent();
        this.mediaGroups = this.lunaServer.getMediaGroups();
        this.editComponent.getIntroductionTextField().setText(this.introductionText);
        this.editComponent.getHeaderGraphicUrlField().setText(this.headerGraphicUrl);
        this.editComponent.getThemeField().setText(this.theme);
        this.editComponent.getUseAsDefaultCheckBox().setSelected(this.useAsDefault);
        int n = -1;
        Vector<String> vector = new Vector<String>();
        this.selectableMediaGroups.clear();
        Enumeration enumeration = this.mediaGroups.elements();
        while (enumeration.hasMoreElements()) {
            LunaServerMediaGroup lunaServerMediaGroup = (LunaServerMediaGroup)enumeration.nextElement();
            String string = lunaServerMediaGroup.getMediaGroupId() + " - " + lunaServerMediaGroup.getName();
            vector.addElement(string);
            this.selectableMediaGroups.add(new Integer(lunaServerMediaGroup.getMediaGroupId()));
            if (lunaServerMediaGroup.getMediaGroupId() != this.defaultGroupId) continue;
            n = this.selectableMediaGroups.size() - 1;
        }
        vector.addElement("0 - no media group selected");
        this.selectableMediaGroups.add(new Integer(0));
        this.editComponent.getMediaGroupComboBox().setModel(new DefaultComboBoxModel(vector));
        this.editComponent.getMediaGroupComboBox().setSelectedIndex(n);
        return this.editComponent;
    }

    public void save() {
        LunaServerExtendedCollectionProperties.debugOut("Save...", 3);
        this.requiresCommit = false;
        int n = this.defaultGroupId;
        try {
            n = (Integer)this.selectableMediaGroups.get(this.editComponent.getMediaGroupComboBox().getSelectedIndex());
        }
        catch (Exception exception) {
            n = this.defaultGroupId;
        }
        if (this.hasChanged(this.defaultGroupId, n)) {
            this.defaultGroupId = n;
        }
        if (this.hasChanged(this.introductionText, this.editComponent.getIntroductionTextField().getText())) {
            this.introductionText = this.editComponent.getIntroductionTextField().getText();
        }
        if (this.hasChanged(this.headerGraphicUrl, this.editComponent.getHeaderGraphicUrlField().getText())) {
            this.headerGraphicUrl = this.editComponent.getHeaderGraphicUrlField().getText();
        }
        if (this.hasChanged(this.theme, this.editComponent.getThemeField().getText())) {
            this.theme = this.editComponent.getThemeField().getText();
        }
        if (this.hasChanged(this.useAsDefault, this.editComponent.getUseAsDefaultCheckBox().isSelected())) {
            this.useAsDefault = this.editComponent.getUseAsDefaultCheckBox().isSelected();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void cancel() {
        LunaServerExtendedCollectionProperties.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Extended Collection Properties - " + this.collectionId;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.collectionId;
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerExtendedCollectionProperties) {
            LunaServerExtendedCollectionProperties lunaServerExtendedCollectionProperties = (LunaServerExtendedCollectionProperties)object;
            return this.collectionId == lunaServerExtendedCollectionProperties.collectionId;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerExtendedCollectionProperties) {
            LunaServerExtendedCollectionProperties lunaServerExtendedCollectionProperties = (LunaServerExtendedCollectionProperties)databaseRecord;
            return LunaServerExtendedCollectionProperties.stringsAreEqual(this.collectionId, lunaServerExtendedCollectionProperties.collectionId) && LunaServerExtendedCollectionProperties.stringsAreEqual(this.introductionText, lunaServerExtendedCollectionProperties.introductionText) && this.defaultGroupId == lunaServerExtendedCollectionProperties.defaultGroupId && this.useAsDefault == lunaServerExtendedCollectionProperties.useAsDefault && LunaServerExtendedCollectionProperties.stringsAreEqual(this.headerGraphicUrl, lunaServerExtendedCollectionProperties.headerGraphicUrl) && LunaServerExtendedCollectionProperties.stringsAreEqual(this.theme, lunaServerExtendedCollectionProperties.theme);
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerExtendedCollectionProperties.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerUser: " + string, n);
    }

    public int compareTo(Object object) {
        return this.collectionId.compareTo(((LunaServerExtendedCollectionProperties)object).collectionId);
    }
}

