/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.credential;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredential;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerCredentialsNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerCredentialsNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Credentials", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"ID", "Name", "Description", "Export Allowed", "Use as Default", "Public Content Allowed", "My Uploads Allowed", "My Uploads Formats"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getCredentials()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerCredential lunaServerCredential = (LunaServerCredential)vector.elementAt(i);
            objectArray[i][0] = lunaServerCredential;
            objectArray[i][1] = lunaServerCredential.credentialName;
            objectArray[i][2] = lunaServerCredential.description;
            objectArray[i][3] = new Boolean(lunaServerCredential.isExportAllowed);
            objectArray[i][4] = new Boolean(lunaServerCredential.isDefault);
            objectArray[i][5] = new Boolean(lunaServerCredential.isPublicContentAllowed);
            objectArray[i][6] = new Boolean(lunaServerCredential.isUploadAllowed);
            objectArray[i][7] = lunaServerCredential.uploadFormats;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.lunaServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New Credential Command", this.lunaServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), "New Credential Command", "Edit Credential Command", "Delete Credential Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Credential Command")) {
            this.lunaServerNode.createNewCredential();
        } else if (string.equals("Delete Credential Command")) {
            if (vector != null && vector.size() > 0) {
                this.lunaServerNode.removeCredentials(vector);
            }
        } else if (string.equals("Edit Credential Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editCredential((LunaServerCredential)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editCredential((LunaServerCredential)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerCredentialsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerCredentialsNode: " + string, n);
    }
}

