/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.credential;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredential;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMap;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class LunaServerCredentialRecordHandler
extends DatabaseRecordHandler {
    public LunaServerCredentialRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "LunaServerCredentialRecordHandler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        DatabaseConnector databaseConnector = null;
        try {
            LunaServerCredential lunaServerCredential = (LunaServerCredential)databaseRecord;
            if (lunaServerCredential.isDefault && this.isDefaultSet(lunaServerCredential.id)) {
                this.debugOut("At least 1 credential has been set as default");
                databaseRecord = null;
            } else {
                databaseConnector = this.getDatabaseConnector();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ID", 2, stringBuffer2, lunaServerCredential.id);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Name", 1, stringBuffer2, lunaServerCredential.credentialName);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Description", 1, stringBuffer2, lunaServerCredential.description);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ExportAllowed", 2, stringBuffer2, lunaServerCredential.isExportAllowed);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UseAsDefault", 2, stringBuffer2, lunaServerCredential.isDefault);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "PublicContentAllowed", 2, stringBuffer2, lunaServerCredential.isPublicContentAllowed);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UploadAllowed", 2, stringBuffer2, lunaServerCredential.isUploadAllowed);
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SupportedUploadFormats", 1, stringBuffer2, lunaServerCredential.uploadFormats);
                String string = "INSERT INTO CREDENTIALS (" + stringBuffer + ") VALUES (" + stringBuffer2 + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertCredentialQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                Iterator iterator = lunaServerCredential.credentialCollectionMaps.iterator();
                while (iterator.hasNext()) {
                    LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap = (LunaServerCredentialCollectionMap)iterator.next();
                    lunaServerCredentialCollectionMap.insert();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in commitCredentialRecord(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM CREDENTIALS WHERE ID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteCredentialQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string2 = "DELETE FROM CREDENTIALCOLLECTIONMAP WHERE CredentialID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string2);
            this.debugOut("delete CredentialCollectionMap query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteCredentialRecord(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector vector = new Vector();
        DatabaseConnector databaseConnector = null;
        try {
            Object object;
            Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CREDENTIALS", null, "*");
            sqlQueryGenerator.addOrderBy("CREDENTIALS", "NAME");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Credentials query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                object = new LunaServerCredential((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ID"), databaseConnector.getFieldByName("Name"), databaseConnector.getFieldByName("Description"), databaseConnector.getIntegerFieldByName("ExportAllowed") == 1, databaseConnector.getIntegerFieldByName("UseAsDefault") == 1, databaseConnector.getIntegerFieldByName("PublicContentAllowed") == 1, databaseConnector.getIntegerFieldByName("UploadAllowed") == 1, databaseConnector.getFieldByName("SupportedUploadFormats"));
                hashtable.put(new Integer(((LunaServerCredential)object).id), object);
                databaseConnector.next();
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CREDENTIALCOLLECTIONMAP", null, "*");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                object = new Integer(databaseConnector.getIntegerField("CredentialID"));
                LunaServerCredential lunaServerCredential = (LunaServerCredential)hashtable.get(object);
                if (lunaServerCredential != null) {
                    lunaServerCredential.addMediaCollectionIndex(databaseConnector.getField("CollectionID"));
                    LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap = new LunaServerCredentialCollectionMap((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("CredentialID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("MaxResolution"), databaseConnector.getIntegerFieldByName("MaxExportResolution"), "", "", databaseConnector.getIntegerFieldByName("AnnotationEnabled") == 1);
                    lunaServerCredential.addCredentialCollectionMapIndex(lunaServerCredentialCollectionMap);
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            object = vector;
            return object;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getCredentialRecords(): " + exception);
            Vector vector2 = vector;
            return vector2;
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    private boolean isDefaultSet(int n) {
        this.debugOut("in isDefaultSet()");
        DatabaseConnector databaseConnector = null;
        try {
            Integer n2;
            databaseConnector = this.getDatabaseConnector();
            String string = "SELECT COUNT(*) AS CNT FROM CREDENTIALS WHERE CREDENTIALS.ID <> " + n + " AND " + "CREDENTIALS" + ".UseAsDefault = 1";
            databaseConnector.setQuery(string);
            this.debugOut("Check UseAsDefault query: \n" + string, 3);
            databaseConnector.runQuery();
            if (databaseConnector.more() && (n2 = new Integer(databaseConnector.getIntegerField("CNT"))) > 0) {
                return true;
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in isDefaultSet(): " + exception);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        LunaServerCredential lunaServerCredential = null;
        int n = databaseRecord.getIndex();
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CREDENTIALS", null, "*");
            sqlQueryGenerator.appendToWhere("ID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Credential query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                lunaServerCredential = new LunaServerCredential((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ID"), databaseConnector.getFieldByName("Name"), databaseConnector.getFieldByName("Description"), databaseConnector.getIntegerFieldByName("exportAllowed") == 1, databaseConnector.getIntegerFieldByName("UseAsDefault") == 1, databaseConnector.getIntegerFieldByName("PublicContentAllowed") == 1, databaseConnector.getIntegerFieldByName("UploadAllowed") == 1, databaseConnector.getFieldByName("SupportedUploadFormats"));
                databaseConnector.next();
            }
            databaseConnector.close();
            if (lunaServerCredential != null) {
                sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("CREDENTIALCOLLECTIONMAP", "*");
                sqlQueryGenerator.appendToWhere("CredentialID = " + lunaServerCredential.id);
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Media collection membership query: \n" + databaseConnector.getQuery());
                databaseConnector.runQuery();
                while (databaseConnector.more()) {
                    lunaServerCredential.addMediaCollectionIndex(databaseConnector.getField("CollectionID"));
                    LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap = new LunaServerCredentialCollectionMap((LunaServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("CredentialID"), databaseConnector.getFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("MaxResolution"), databaseConnector.getIntegerFieldByName("MaxExportResolution"), "", "", databaseConnector.getIntegerFieldByName("AnnotationEnabled") == 1);
                    lunaServerCredential.addCredentialCollectionMapIndex(lunaServerCredentialCollectionMap);
                    databaseConnector.next();
                }
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return lunaServerCredential;
    }

    public String getNextValidIDQuery() {
        return "SELECT ID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "CREDENTIALS" + " ORDER BY ID";
    }

    public void updateMaxIDValue(long l) {
    }
}

