/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.credential;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredentialEditComponent;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMap;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;

public class LunaServerCredential
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected int id;
    protected LunaServer lunaServer;
    protected String credentialName = "";
    protected boolean isExportAllowed = false;
    protected boolean isDefault = false;
    protected String description = "";
    protected int defaultMaxResolution = 5;
    protected int defaultMaxExportResolution = 4;
    protected boolean isPublicContentAllowed = false;
    protected boolean isUploadAllowed = false;
    protected String uploadFormats = "";
    protected Vector mediaCollections = new Vector();
    protected Vector credentialCollectionMaps = new Vector();
    protected LunaServerCredentialEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public LunaServerCredential(LunaServer lunaServer, int n, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3) {
        this.lunaServer = lunaServer;
        this.id = n;
        this.credentialName = string == null ? "" : string;
        this.description = string2 == null ? "" : string2;
        this.isDefault = bl2;
        this.isExportAllowed = bl;
        this.isPublicContentAllowed = bl3;
        this.isUploadAllowed = bl4;
        this.uploadFormats = string3;
    }

    public LunaServerCredential(int n, LunaServer lunaServer) {
        this.id = n;
        this.lunaServer = lunaServer;
    }

    public void addMediaCollectionIndex(String string) {
        String string2 = new String(string);
        if (!this.mediaCollections.contains(string2)) {
            this.mediaCollections.add(string2);
        }
    }

    public void addCredentialCollectionMapIndex(LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap) {
        if (!this.credentialCollectionMaps.contains(lunaServerCredentialCollectionMap)) {
            this.credentialCollectionMaps.add(lunaServerCredentialCollectionMap);
        }
    }

    public String toString() {
        return Integer.toString(this.getIndex());
    }

    public String getName() {
        return this.credentialName;
    }

    public int getIndex() {
        return this.id;
    }

    public int getCredentialId() {
        return this.id;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerCredentialEditComponent();
        this.editComponent.getCredentialField().setText(this.credentialName);
        this.editComponent.getDescriptionField().setText(this.description);
        this.editComponent.getExportAllowedCheckBox().setSelected(this.isExportAllowed);
        this.editComponent.getDefaultCheckBox().setSelected(this.isDefault);
        this.editComponent.getPublicContentAllowedCheckBox().setSelected(this.isPublicContentAllowed);
        this.editComponent.getUploadAllowedCheckBox().setSelected(this.isUploadAllowed);
        this.editComponent.getCredentialField().selectAll();
        this.editComponent.getUploadFormatsField().setText(this.uploadFormats);
        Vector vector = new Vector(this.lunaServer.getMediaCollections());
        vector.addAll(this.lunaServer.getSharedMediaCollections());
        this.itemSelector = new ListItemSelector("Available Media Collections", "Assigned Media Collections", vector, this.mediaCollections, 1);
        this.editComponent.getMediaCollectionsSelectionPanel().add(this.itemSelector);
        return this.editComponent;
    }

    public void save() {
        LunaServerCredential.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.credentialName, this.editComponent.getCredentialField().getText())) {
            this.credentialName = this.editComponent.getCredentialField().getText();
        }
        if (this.hasChanged(this.description, this.editComponent.getDescriptionField().getText())) {
            this.description = this.editComponent.getDescriptionField().getText();
        }
        if (this.hasChanged(this.isExportAllowed, this.editComponent.getExportAllowedCheckBox().isSelected())) {
            this.isExportAllowed = this.editComponent.getExportAllowedCheckBox().isSelected();
        }
        if (this.hasChanged(this.isDefault, this.editComponent.getDefaultCheckBox().isSelected())) {
            this.isDefault = this.editComponent.getDefaultCheckBox().isSelected();
        }
        if (this.hasChanged(this.isPublicContentAllowed, this.editComponent.getPublicContentAllowedCheckBox().isSelected())) {
            this.isPublicContentAllowed = this.editComponent.getPublicContentAllowedCheckBox().isSelected();
        }
        if (this.hasChanged(this.isUploadAllowed, this.editComponent.getUploadAllowedCheckBox().isSelected())) {
            this.isUploadAllowed = this.editComponent.getUploadAllowedCheckBox().isSelected();
        }
        if (this.hasChanged(this.uploadFormats, this.editComponent.getUploadFormatsField().getText())) {
            this.uploadFormats = this.editComponent.getUploadFormatsField().getText();
        }
        if (this.hasChanged(this.mediaCollections, this.itemSelector.getChosenItemIndices(1))) {
            this.mediaCollections = this.itemSelector.getChosenItemIndices(1);
            Iterator iterator = this.credentialCollectionMaps.iterator();
            while (iterator.hasNext()) {
                LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap = (LunaServerCredentialCollectionMap)iterator.next();
                if (this.mediaCollections.contains(lunaServerCredentialCollectionMap.getCollectionId())) continue;
                iterator.remove();
            }
            iterator = this.mediaCollections.iterator();
            while (iterator.hasNext()) {
                this.addCredentialCollectionMapIndex(new LunaServerCredentialCollectionMap(this.lunaServer, this.id, iterator.next().toString(), this.defaultMaxResolution, this.defaultMaxExportResolution, this.credentialName, "", true));
            }
        }
        LunaServerCredential.debugOut("itemSelector: " + this.itemSelector.getChosenItemIndices(1));
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void cancel() {
        LunaServerCredential.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Credential - " + this.credentialName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerCredential) {
            LunaServerCredential lunaServerCredential = (LunaServerCredential)object;
            return this.id == lunaServerCredential.id;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerCredential) {
            LunaServerCredential lunaServerCredential = (LunaServerCredential)databaseRecord;
            return this.id == lunaServerCredential.id && LunaServerCredential.stringsAreEqual(this.credentialName, lunaServerCredential.credentialName) && LunaServerCredential.stringsAreEqual(this.description, lunaServerCredential.description) && this.isDefault == lunaServerCredential.isDefault && this.isExportAllowed == lunaServerCredential.isExportAllowed && this.isPublicContentAllowed == lunaServerCredential.isPublicContentAllowed && this.isUploadAllowed == lunaServerCredential.isUploadAllowed && this.mediaCollections.containsAll(lunaServerCredential.mediaCollections) && lunaServerCredential.mediaCollections.containsAll(this.mediaCollections) && LunaServerCredential.stringsAreEqual(this.uploadFormats, lunaServerCredential.uploadFormats);
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerCredential.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerCredential: " + string, n);
    }

    public int compareTo(Object object) {
        return this.credentialName.compareTo(((LunaServerCredential)object).credentialName);
    }
}

