/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.config;

import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.AdministeredServerConfigurationFileProperties;
import com.luna.insight.admin.ColorChooser;
import com.luna.insight.admin.ColorChooserParent;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.lunaserver.config.LunaServerConfigurationFilePropertiesEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.ImageIcon;

public class LunaServerConfigurationFileProperties
extends AdministeredServerConfigurationFileProperties
implements ColorChooserParent {
    protected LunaServerConfigurationFilePropertiesEditComponent editComponent = null;
    protected boolean synchedFieldStandards = false;
    protected String defaultFuzzyDateHelpFile = null;
    protected String multipleCollectionImage = null;
    protected int mcBgColorR = 0;
    protected int mcBgColorG = 0;
    protected int mcBgColorB = 0;
    protected int candidateMcBgColorR = 0;
    protected int candidateMcBgColorG = 0;
    protected int candidateMcBgColorB = 0;
    protected String logFileName = "insight-user-log.txt";
    protected int debugLevel = 1;
    protected String connectString = "insight/Insight-User-Test/sql70=true";
    protected String sqlLevel = null;
    protected String useDistinctKeyword = null;
    protected String databaseConnector = null;
    protected String jdbcDriverName = null;
    protected String jdbcUrlPrefix = null;
    protected String username = null;
    protected String password = null;
    protected String debugFilename = null;
    protected String debugModeOn = null;
    protected String defaultDatabaseConnector = null;
    protected String defaultJdbcDriverName = null;
    protected String defaultJdbcUrlPrefix = null;
    protected String defaultUsername = null;
    protected String defaultPassword = null;
    protected String defaultDebugFilename = null;
    protected String defaultDebugModeOn = null;
    protected EditDialog colorChooserEditDialog = null;

    public LunaServerConfigurationFileProperties(AdministeredServer administeredServer, String string) {
        super(administeredServer, string);
        this.refresh();
    }

    public void commit() {
        LunaServerConfigurationFileProperties.debugOut("in commit()");
        EnhancedProperties enhancedProperties = new EnhancedProperties();
        LunaServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "AssumeSynchronizedFieldStandards", this.synchedFieldStandards ? "1" : "0", "AssumeSynchronizedFieldStandards - This toggles the client startup optimization that will assume that all collection servers implement their field standards in the exact same way.  If you're not sure, disable this by putting a 0. The default is 0.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DefaultFuzzyDateHelpFile", this.defaultFuzzyDateHelpFile, "DefaultFuzzyDateHelpFile - Specify the path to the default fuzzy date help file that should be used when the individual fuzzy date help files of each selected collection server do not agree.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MultipleCollectionImage", this.multipleCollectionImage, "MultipleCollectionImage - The URL for the background image to load when multiple collections are selected.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MultipleCollectionColorR", "" + this.mcBgColorR, "MultipleCollectionColor - The RGB values for the background color to use when multiple collection are selected.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MultipleCollectionColorG", "" + this.mcBgColorG);
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "MultipleCollectionColorB", "" + this.mcBgColorB);
        LunaServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "LogFilename", this.logFileName, "LogFilename - the name of a text file to log activity to.  Default is insight-user-log.txt");
        LunaServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "DebugLevel", this.debugLevel + "", "DebugLevel - The level of debugging information provided on the server's console.  0 = off, 1 = low, 2 = medium, 3 = high.  If this value is empty, it will not change the default (or already set) debug level.  Use an empty value below if a database server (Insight Smart Server) is creating a User Server.");
        LunaServerConfigurationFileProperties.setRequiredProperty(enhancedProperties, "UserDatabaseConnect", this.connectString, "UserDatabaseConnect - the database connect string for the Insight User Server.  See note above.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseQueryMode", this.sqlLevel, "DatabaseQueryMode - The level of SQL 92 compilance that the host database implements. 0 = ENTRY_LEVEL_SQL_92, 1 = INTERMEDIATE_LEVEL_SQL_92.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "UseDistinctKeyword", this.useDistinctKeyword, "UseDistinctKeyword - Setting this value to 1 indicates that the use of the DISTINCT keywords is authorized.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseConnector", this.databaseConnector, "DatabaseConnector - Specify the database connection to use.  Available options are JDBC, RDO (default), and ADO.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "JDBCDriverName", this.jdbcDriverName, "Classname of the JDBC driver to use if the DatabaseConnector is set to JDBC.  If the DatabaseConnector is set to anything else, this will be ignored.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "JDBCUrlPrefix", this.jdbcUrlPrefix);
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DefaultUsername", this.username, "Default username and password used to establish a database connection.  If this parameter is not specified, the connection will be made using DSN properties.");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DefaultPassword", this.password);
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseDebugFilename", this.debugFilename, "DatabaseDebugFilename - the location of the text file to log database connection activity. Default is c:\\\\temp\\\\DatabaseConnector.txt");
        LunaServerConfigurationFileProperties.setOptionalProperty(enhancedProperties, "DatabaseDebugMode", this.debugModeOn, "DatabaseDebugMode - indicates whether debug is active.  0 -> off, 1 -> on.  The default is on.");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.configFileName);
            enhancedProperties.store(fileOutputStream, "InsightLunaServer Configuration");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            LunaServerConfigurationFileProperties.debugOut("Exception while trying to write user server data to disc: " + exception);
        }
    }

    public void refresh() {
        Object object;
        LunaServerConfigurationFileProperties.debugOut("in refresh()");
        EnhancedProperties enhancedProperties = new EnhancedProperties();
        try {
            LunaServerConfigurationFileProperties.debugOut("Configuration file is " + this.configFileName + ".");
            object = new FileInputStream(this.configFileName);
            enhancedProperties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            LunaServerConfigurationFileProperties.debugOut("Cannot read configuration file!");
        }
        if (enhancedProperties != null) {
            if (enhancedProperties.getProperty("AssumeSynchronizedFieldStandards") != null) {
                this.synchedFieldStandards = enhancedProperties.getProperty("AssumeSynchronizedFieldStandards", "0").equals("1");
            }
            this.defaultFuzzyDateHelpFile = enhancedProperties.getProperty("DefaultFuzzyDateHelpFile", this.defaultFuzzyDateHelpFile);
            this.multipleCollectionImage = enhancedProperties.getProperty("MultipleCollectionImage", this.multipleCollectionImage);
            try {
                this.mcBgColorR = Integer.parseInt(enhancedProperties.getProperty("MultipleCollectionColorR", "" + this.mcBgColorR));
                this.mcBgColorG = Integer.parseInt(enhancedProperties.getProperty("MultipleCollectionColorG", "" + this.mcBgColorG));
                this.mcBgColorB = Integer.parseInt(enhancedProperties.getProperty("MultipleCollectionColorB", "" + this.mcBgColorB));
            }
            catch (Exception exception) {
                LunaServerConfigurationFileProperties.debugOut("*********: " + exception);
                this.mcBgColorR = 0;
                this.mcBgColorG = 0;
                this.mcBgColorB = 0;
            }
            this.logFileName = enhancedProperties.getProperty("LogFilename", this.logFileName);
            try {
                this.debugLevel = Integer.parseInt(enhancedProperties.getProperty("DebugLevel", this.debugLevel + ""));
            }
            catch (Exception exception) {
                LunaServerConfigurationFileProperties.debugOut("Exception while parsing debugLevel: " + exception);
            }
            this.connectString = enhancedProperties.getProperty("UserDatabaseConnect", this.connectString);
            this.sqlLevel = enhancedProperties.getProperty("DatabaseQueryMode", this.sqlLevel);
            this.useDistinctKeyword = enhancedProperties.getProperty("UseDistinctKeyword", this.useDistinctKeyword);
            this.databaseConnector = enhancedProperties.getProperty("DatabaseConnector", this.databaseConnector);
            this.debugFilename = enhancedProperties.getProperty("DatabaseDebugFilename", this.debugFilename);
            this.debugModeOn = enhancedProperties.getProperty("DatabaseDebugMode", this.debugModeOn);
            this.jdbcDriverName = enhancedProperties.getProperty("JDBCDriverName", this.jdbcDriverName);
            this.jdbcUrlPrefix = enhancedProperties.getProperty("JDBCUrlPrefix", this.jdbcUrlPrefix);
            this.username = enhancedProperties.getProperty("DefaultUsername", this.username);
            this.password = enhancedProperties.getProperty("DefaultPassword", this.password);
        }
        try {
            object = new File(this.configFileName);
            String string = ((File)object).getParent() + File.separator + "InsightBackend.dat";
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            this.defaultDatabaseConnector = properties.getProperty("DatabaseConnector");
            this.defaultJdbcDriverName = properties.getProperty("JDBCDriverName");
            this.defaultJdbcUrlPrefix = properties.getProperty("JDBCUrlPrefix");
            this.defaultUsername = properties.getProperty("DefaultUsername");
            this.defaultPassword = properties.getProperty("DefaultPassword");
            this.defaultDebugFilename = properties.getProperty("DatabaseDebugFilename");
            this.defaultDebugModeOn = properties.getProperty("DatabaseDebugMode");
        }
        catch (Exception exception) {
            LunaServerConfigurationFileProperties.debugOut("Exception while loading InsightBackend.dat: " + exception);
        }
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerConfigurationFilePropertiesEditComponent();
        this.editComponent.getAssumeSynchedFieldStandardsCheckBox().setSelected(this.synchedFieldStandards);
        this.editComponent.getDefaultFuzzyDateHelpFileField().setText(this.defaultFuzzyDateHelpFile);
        this.editComponent.getMultipleCollectionImageField().setText(this.multipleCollectionImage);
        this.editComponent.getMultipleCollectionBgColorButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LunaServerConfigurationFileProperties.this.chooseBgColor();
            }
        });
        this.candidateMcBgColorR = this.mcBgColorR;
        this.candidateMcBgColorG = this.mcBgColorG;
        this.candidateMcBgColorB = this.mcBgColorB;
        this.setNewColor(null, new Color(this.candidateMcBgColorR, this.candidateMcBgColorG, this.candidateMcBgColorB));
        this.editComponent.getLogFileNameField().setText(this.logFileName);
        this.editComponent.getDebugLevelComboBox().setSelectedIndex(this.debugLevel);
        this.editComponent.getDatabaseConnectStringField().setText(this.connectString);
        try {
            this.editComponent.getSqlLevelComboBox().setSelectedIndex(Integer.parseInt(this.sqlLevel));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editComponent.getUseDistinctKeywordCheckBox().setSelected("1".equals(this.useDistinctKeyword));
        this.editComponent.getDatabaseConnectorComboBox().setSelectedItem(this.databaseConnector == null ? this.defaultDatabaseConnector : this.databaseConnector);
        this.editComponent.getEnableDatabaseConnectorCheckBox().setSelected(this.databaseConnector != null);
        this.editComponent.getJdbcDriverNameField().setText(this.jdbcDriverName == null ? this.defaultJdbcDriverName : this.jdbcDriverName);
        this.editComponent.getEnableJdbcDriverNameCheckBox().setSelected(this.jdbcDriverName != null);
        this.editComponent.getJdbcUrlPrefixField().setText(this.jdbcUrlPrefix == null ? this.defaultJdbcUrlPrefix : this.jdbcUrlPrefix);
        this.editComponent.getEnableJdbcUrlPrefixCheckBox().setSelected(this.jdbcUrlPrefix != null);
        this.editComponent.getUsernameField().setText(this.username == null ? this.defaultUsername : this.username);
        this.editComponent.getEnableUsernameCheckBox().setSelected(this.username != null);
        this.editComponent.getPasswordField().setText(this.password == null ? this.defaultPassword : this.password);
        this.editComponent.getEnablePasswordCheckBox().setSelected(this.password != null);
        this.editComponent.getDebugFilenameField().setText(this.debugFilename == null ? this.defaultDebugFilename : this.debugFilename);
        this.editComponent.getEnableDebugFilenameCheckBox().setSelected(this.debugFilename != null);
        this.editComponent.getDebugModeCheckBox().setSelected("1".equals(this.debugModeOn == null ? this.defaultDebugModeOn : this.debugModeOn));
        this.editComponent.getEnableDebugModeCheckBox().setSelected(this.debugModeOn != null);
        this.editComponent.getEditDefaultPropertiesButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LunaServerConfigurationFileProperties.this.getAdministeredServer().editDefaultConfigurationFileProperties();
            }
        });
        this.editComponent.setOptionalFieldsEnabledAppropriately();
        this.editComponent.getDatabaseConnectStringField().selectAll();
        return this.editComponent;
    }

    public void save() {
        Color color;
        LunaServerConfigurationFileProperties.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.synchedFieldStandards, this.editComponent.getAssumeSynchedFieldStandardsCheckBox().isSelected())) {
            this.synchedFieldStandards = this.editComponent.getAssumeSynchedFieldStandardsCheckBox().isSelected();
        }
        if (this.hasChanged(this.defaultFuzzyDateHelpFile, this.editComponent.getDefaultFuzzyDateHelpFileField().getText())) {
            this.defaultFuzzyDateHelpFile = this.editComponent.getDefaultFuzzyDateHelpFileField().getText();
        }
        if (this.hasChanged(this.multipleCollectionImage, this.editComponent.getMultipleCollectionImageField().getText())) {
            this.multipleCollectionImage = this.editComponent.getMultipleCollectionImageField().getText();
        }
        if (this.hasChanged(this.mcBgColorR, (color = new Color(this.candidateMcBgColorR, this.candidateMcBgColorG, this.candidateMcBgColorB)).getRed())) {
            this.mcBgColorR = color.getRed();
        }
        if (this.hasChanged(this.mcBgColorG, color.getGreen())) {
            this.mcBgColorG = color.getGreen();
        }
        if (this.hasChanged(this.mcBgColorB, color.getBlue())) {
            this.mcBgColorB = color.getBlue();
        }
        LunaServerConfigurationFileProperties.debugOut("mcBgColorR: " + this.mcBgColorR + ", mcBgColorG: " + this.mcBgColorG + ", mcBgColorB: " + this.mcBgColorB);
        if (this.hasChanged(this.logFileName, this.editComponent.getLogFileNameField().getText())) {
            this.logFileName = this.editComponent.getLogFileNameField().getText();
        }
        if (this.hasChanged(this.debugLevel, this.editComponent.getDebugLevelComboBox().getSelectedIndex())) {
            this.debugLevel = this.editComponent.getDebugLevelComboBox().getSelectedIndex();
        }
        if (this.hasChanged(this.connectString, this.editComponent.getDatabaseConnectStringField().getText())) {
            this.connectString = this.editComponent.getDatabaseConnectStringField().getText();
        }
        if (this.hasChanged(this.sqlLevel, "" + this.editComponent.getSqlLevelComboBox().getSelectedIndex())) {
            this.sqlLevel = "" + this.editComponent.getSqlLevelComboBox().getSelectedIndex();
        }
        if (this.hasChanged("1".equals(this.useDistinctKeyword), this.editComponent.getUseDistinctKeywordCheckBox().isSelected())) {
            this.useDistinctKeyword = this.editComponent.getUseDistinctKeywordCheckBox().isSelected() ? "1" : "0";
        }
        String string = null;
        string = this.editComponent.getEnableDatabaseConnectorCheckBox().isSelected() ? (String)this.editComponent.getDatabaseConnectorComboBox().getSelectedItem() : null;
        if (this.hasChanged(this.databaseConnector, string)) {
            this.databaseConnector = string;
        }
        String string2 = null;
        string2 = this.editComponent.getEnableJdbcDriverNameCheckBox().isSelected() ? this.editComponent.getJdbcDriverNameField().getText() : null;
        if (this.hasChanged(this.jdbcDriverName, string2)) {
            this.jdbcDriverName = string2;
        }
        String string3 = null;
        string3 = this.editComponent.getEnableJdbcUrlPrefixCheckBox().isSelected() ? this.editComponent.getJdbcUrlPrefixField().getText() : null;
        if (this.hasChanged(this.jdbcUrlPrefix, string3)) {
            this.jdbcUrlPrefix = string3;
        }
        String string4 = null;
        string4 = this.editComponent.getEnableUsernameCheckBox().isSelected() ? this.editComponent.getUsernameField().getText() : null;
        if (this.hasChanged(this.username, string4)) {
            this.username = string4;
        }
        String string5 = null;
        string5 = this.editComponent.getEnablePasswordCheckBox().isSelected() ? this.editComponent.getPasswordField().getText() : null;
        if (this.hasChanged(this.password, string5)) {
            this.password = string5;
        }
        String string6 = null;
        string6 = this.editComponent.getEnableDebugFilenameCheckBox().isSelected() ? this.editComponent.getDebugFilenameField().getText() : null;
        if (this.hasChanged(this.debugFilename, string6)) {
            this.debugFilename = string6;
        }
        String string7 = null;
        string7 = this.editComponent.getEnableDebugModeCheckBox().isSelected() ? (this.editComponent.getDebugModeCheckBox().isSelected() ? "1" : "0") : null;
        if (this.hasChanged(this.debugModeOn, string7)) {
            this.debugModeOn = string7;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.server.commitConfigurationFileProperties();
        } else {
            this.server.cancelConfigurationFilePropertiesEdit();
        }
        if (this.colorChooserEditDialog != null) {
            this.colorChooserEditDialog.cancel();
        }
    }

    public void cancel() {
        LunaServerConfigurationFileProperties.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.server.cancelConfigurationFilePropertiesEdit();
        if (this.colorChooserEditDialog != null) {
            this.colorChooserEditDialog.cancel();
        }
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-node-icon.gif");
    }

    public void chooseBgColor() {
        LunaServerConfigurationFileProperties.debugOut("in chooseBgColor()");
        if (this.colorChooserEditDialog == null) {
            String string = "Multiple Collection Background Color";
            this.colorChooserEditDialog = new EditDialog(null, false, new ColorChooser(this, string, ""));
            this.colorChooserEditDialog.show();
        } else {
            InsightAdministrator.getInsightAdministrator().setSelectedFrame(this.colorChooserEditDialog);
        }
    }

    public Color getColor(ColorChooser colorChooser) {
        Color color = null;
        try {
            color = new Color(this.candidateMcBgColorR, this.candidateMcBgColorG, this.candidateMcBgColorB);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            color = Color.black;
        }
        return color;
    }

    public void setNewColor(ColorChooser colorChooser, Color color) {
        if (color != null) {
            this.candidateMcBgColorR = color.getRed();
            this.candidateMcBgColorG = color.getGreen();
            this.candidateMcBgColorB = color.getBlue();
            if (this.editComponent != null) {
                this.editComponent.getMultipleCollectionBgColorDisplayPanel().setBackground(color);
                String string = "[" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + "]";
                this.editComponent.getMultipleCollectionBgColorRGBLabel().setText(string);
            }
        }
    }

    public void cancelColorChooserEdit(ColorChooser colorChooser) {
        this.colorChooserEditDialog = null;
    }

    public static void debugOut(String string) {
        LunaServerConfigurationFileProperties.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerConfigurationFileProperties: " + string, n);
    }
}

