/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.applicationconfiguration;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.applicationconfiguration.LunaServerApplicationConfiguration;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class LunaServerApplicationConfigurationNode
extends TableDisplayControlPanelNode {
    protected LunaServerNode lunaServerNode = null;

    public LunaServerApplicationConfigurationNode(LunaServerNode lunaServerNode) {
        super(lunaServerNode.getLunaServer().getInsightAdministrator(), "Application Configuration", false);
        this.lunaServerNode = lunaServerNode;
        this.columnNames = new Object[]{"Attribute", "Value"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.lunaServerNode.getLunaServer().getApplicationConfigurations()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            LunaServerApplicationConfiguration lunaServerApplicationConfiguration = (LunaServerApplicationConfiguration)vector.elementAt(i);
            objectArray[i][0] = lunaServerApplicationConfiguration;
            objectArray[i][1] = lunaServerApplicationConfiguration.attributeValue;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.lunaServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New Application Configuration Command", this.lunaServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.lunaServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.lunaServerNode.getAdminAccount(), "New Application Configuration Command", "Edit Application Configuration Command", "Delete Application Configuration Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Application Configuration Command")) {
            this.lunaServerNode.createNewApplicationConfiguration();
        } else if (string.equals("Delete Application Configuration Command")) {
            if (vector != null && vector.size() > 0) {
                this.lunaServerNode.removeApplicationConfigurations(vector);
            }
        } else if (string.equals("Edit Application Configuration Command") && vector != null && vector.size() == 1) {
            this.lunaServerNode.editApplicationConfiguration((LunaServerApplicationConfiguration)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.lunaServerNode.editApplicationConfiguration((LunaServerApplicationConfiguration)object);
        }
    }

    public static void debugOut(String string) {
        LunaServerApplicationConfigurationNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerApplicationConfigurationsNode: " + string, n);
    }
}

