/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver.applicationconfiguration;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.applicationconfiguration.LunaServerApplicationConfigurationEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class LunaServerApplicationConfiguration
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected LunaServer lunaServer;
    protected String attribute = "";
    protected String attributeValue = "";
    protected LunaServerApplicationConfigurationEditComponent editComponent = null;

    public LunaServerApplicationConfiguration(LunaServer lunaServer, String string, String string2) {
        this.lunaServer = lunaServer;
        this.attribute = string == null ? "" : string;
        this.attributeValue = string2 == null ? "" : string2;
    }

    public LunaServerApplicationConfiguration(LunaServer lunaServer) {
        this.lunaServer = lunaServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.attribute;
    }

    public int getIndex() {
        return 0;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new LunaServerApplicationConfigurationEditComponent();
        this.editComponent.getAttributeField().setText(this.attribute);
        this.editComponent.getAttributeValueField().setText(this.attributeValue);
        return this.editComponent;
    }

    public void save() {
        LunaServerApplicationConfiguration.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.attribute, this.editComponent.getAttributeField().getText())) {
            this.attribute = this.editComponent.getAttributeField().getText();
        }
        if (this.hasChanged(this.attributeValue, this.editComponent.getAttributeValueField().getText())) {
            this.attributeValue = this.editComponent.getAttributeValueField().getText();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lunaServer.commitDataObject(this);
        } else {
            this.lunaServer.cancelEdit(this);
        }
    }

    public void cancel() {
        LunaServerApplicationConfiguration.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.lunaServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Application Configuration - " + this.attribute;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof LunaServerApplicationConfiguration) {
            LunaServerApplicationConfiguration lunaServerApplicationConfiguration = (LunaServerApplicationConfiguration)object;
            return LunaServerApplicationConfiguration.stringsAreEqual(this.attribute, lunaServerApplicationConfiguration.attribute);
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof LunaServerApplicationConfiguration) {
            LunaServerApplicationConfiguration lunaServerApplicationConfiguration = (LunaServerApplicationConfiguration)databaseRecord;
            return LunaServerApplicationConfiguration.stringsAreEqual(this.attribute, lunaServerApplicationConfiguration.attribute) && LunaServerApplicationConfiguration.stringsAreEqual(this.attributeValue, lunaServerApplicationConfiguration.attributeValue);
        }
        return false;
    }

    public static void debugOut(String string) {
        LunaServerApplicationConfiguration.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerApplicationConfiguration: " + string, n);
    }

    public int compareTo(Object object) {
        return this.attribute.compareTo(((LunaServerApplicationConfiguration)object).attribute);
    }
}

