/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdminAccountsNode;
import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.LunaServerConnectEditComponent;
import com.luna.insight.admin.lunaserver.applicationconfiguration.LunaServerApplicationConfiguration;
import com.luna.insight.admin.lunaserver.applicationconfiguration.LunaServerApplicationConfigurationNode;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredential;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredentialsNode;
import com.luna.insight.admin.lunaserver.extendedcollectionproperties.LunaServerExtendedCollectionProperties;
import com.luna.insight.admin.lunaserver.extendedcollectionproperties.LunaServerExtendedCollectionPropertiesNode;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRanges;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRangesNode;
import com.luna.insight.admin.lunaserver.maintenance.LunaServerMaintenanceNode;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMap;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMapsNode;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollection;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollectionsNode;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroup;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroupsNode;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentation;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentationsNode;
import com.luna.insight.admin.lunaserver.sharedmediacollection.LunaServerSharedMediaCollection;
import com.luna.insight.admin.lunaserver.sharedmediacollection.LunaServerSharedMediaCollectionsNode;
import com.luna.insight.admin.lunaserver.user.LunaServerUser;
import com.luna.insight.admin.lunaserver.user.LunaServerUsersNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;

public class LunaServerNode
extends AdministeredServerNode {
    public static final String COMMAND_NEW_APPLICATIONCONFIGURATION = "New Application Configuration Command";
    public static final String COMMAND_DELETE_APPLICATIONCONFIGURATION = "Delete Application Configuration Command";
    public static final String COMMAND_EDIT_APPLICATIONCONFIGURATION = "Edit Application Configuration Command";
    public static final String COMMAND_NEW_MEDIACOLLECTION = "New Media Collection Command";
    public static final String COMMAND_DELETE_MEDIACOLLECTION = "Delete Media Collection Command";
    public static final String COMMAND_EDIT_MEDIACOLLECTION = "Edit Media Collection Command";
    public static final String COMMAND_NEW_SHAREDMEDIACOLLECTION = "NewShared Media Collection Command";
    public static final String COMMAND_DELETE_SHAREDMEDIACOLLECTION = "DeleteShared Media Collection Command";
    public static final String COMMAND_EDIT_SHAREDMEDIACOLLECTION = "EditShared Media Collection Command";
    public static final String COMMAND_NEW_USER = "New User Command";
    public static final String COMMAND_DELETE_USER = "Delete User Command";
    public static final String COMMAND_EDIT_USER = "Edit User Command";
    public static final String COMMAND_EDIT_MEDIAGROUP = "Edit Media Group Command";
    public static final String COMMAND_EDIT_PRESENTATION = "Edit Presentation Command";
    public static final String COMMAND_NEW_IPRANGE = "New IP Range Command";
    public static final String COMMAND_DELETE_IPRANGE = "Delete IP Range Command";
    public static final String COMMAND_EDIT_IPRANGE = "Edit IP Range Command";
    public static final String COMMAND_NEW_CREDENTIAL = "New Credential Command";
    public static final String COMMAND_DELETE_CREDENTIAL = "Delete Credential Command";
    public static final String COMMAND_EDIT_CREDENTIAL = "Edit Credential Command";
    public static final String COMMAND_OPEN_MAINTENANCE = "Open Maintenance Command";
    public static final String COMMAND_EDIT_CREDENTIAL_COLLECTION_MAP = "Edit Credential Collection Map Command";
    public static final String COMMAND_EDIT_EXTENDED_COLLECTION_PROPERTIES = "Edit Extended Collection Properties Command";
    protected LunaServer lunaServer = null;
    protected LunaServerApplicationConfigurationNode appConfigsNode = null;
    protected LunaServerMediaCollectionsNode collectionsNode = null;
    protected LunaServerSharedMediaCollectionsNode sharedCollectionsNode = null;
    protected LunaServerUsersNode usersNode = null;
    protected LunaServerMediaGroupsNode mediaGroupsNode = null;
    protected LunaServerPresentationsNode presentationsNode = null;
    protected LunaServerCredentialsNode credentialsNode = null;
    protected LunaServerCredentialCollectionMapsNode credentialCollectionMapsNode = null;
    protected LunaServerExtendedCollectionPropertiesNode extendedCollectionPropertiesNode = null;
    protected LunaServerIPRangesNode ipRangesNode = null;
    protected LunaServerMaintenanceNode maintenanceNode = null;

    public LunaServerNode(LunaServer lunaServer) {
        super(lunaServer);
        this.lunaServer = lunaServer;
        lunaServer.setNode(this);
    }

    protected void createInformationModel() {
        this.labelText = "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Remove Command")) {
            LunaServerNode.debugOut("Remove LunaServer.");
            if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete this LunaServer registration?", "Delete Confirmation")) {
                if (this.lunaServer.disconnect()) {
                    TreeNode treeNode = this.getParent();
                    this.removeFromParent();
                    this.insightAdministrator.reloadTreeModel(treeNode);
                } else {
                    LunaServerNode.debugOut("Couldn't disconnect LunaServer.");
                }
            }
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_APPLICATIONCONFIGURATION)) {
            LunaServerNode.debugOut("Add a new application configuration attribute.");
            this.createNewApplicationConfiguration();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_MEDIACOLLECTION)) {
            LunaServerNode.debugOut("Add a new media collection.");
            this.createNewCollection();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_USER)) {
            LunaServerNode.debugOut("Add a new user.");
            this.createNewUser();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_CREDENTIAL)) {
            LunaServerNode.debugOut("Add a new credential.");
            this.createNewCredential();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_IPRANGE)) {
            LunaServerNode.debugOut("Add a new IP range.");
            this.createNewIpRange();
        } else if (actionEvent.getActionCommand().equals(COMMAND_OPEN_MAINTENANCE)) {
            LunaServerNode.debugOut("Open Maintenance Dialog");
            this.openMaintenance();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void connect() {
        LunaServerNode.debugOut("Connect LunaServer.");
        EditableDataObject editableDataObject = new EditableDataObject(){
            private LunaServerConnectEditComponent usce = null;

            public EditComponent getEditComponent() {
                this.usce = new LunaServerConnectEditComponent();
                boolean bl = LunaServerNode.this.lunaServer.isPasswordRemembered();
                String string = LunaServerNode.this.lunaServer.getAccountUsername();
                String string2 = "";
                if (bl) {
                    string2 = LunaServerNode.this.lunaServer.getAccountPassword();
                }
                this.usce.getUsernameField().setText(string);
                this.usce.getPasswordField().setText(string2);
                this.usce.getRememberCheckBox().setSelected(bl);
                this.usce.getUsernameField().selectAll();
                return this.usce;
            }

            public void save() {
                LunaServerNode.this.doConnect(this.usce.getUsernameField().getText(), new String(this.usce.getPasswordField().getPassword()), this.usce.getRememberCheckBox().isSelected());
            }

            public void cancel() {
            }

            public String getSaveButtonText() {
                return "Login";
            }

            public String getEditWindowTitle() {
                return "Login";
            }

            public ImageIcon getEditWindowIcon() {
                return IconMaker.createImage("images/user-server-node-icon.gif");
            }
        };
        new EditDialog(this.insightAdministrator.getFrame(), true, editableDataObject).show();
    }

    public void doConnect(String string, String string2, boolean bl) {
        if (this.lunaServer.isConnected()) {
            this.insightAdministrator.showWarningDialog("Already connected.  Disconnect first, and then try connecting again.", "Already Connected");
            return;
        }
        this.username = string;
        this.password = string2;
        this.lunaServer.setPasswordRemembered(bl);
        if (this.lunaServer.connect(string, string2)) {
            if (this.adminAccountsNode == null) {
                this.adminAccountsNode = new AdminAccountsNode(this);
            }
            this.add(this.adminAccountsNode);
            if (this.appConfigsNode == null) {
                this.appConfigsNode = new LunaServerApplicationConfigurationNode(this);
            }
            this.add(this.appConfigsNode);
            if (this.usersNode == null) {
                this.usersNode = new LunaServerUsersNode(this);
            }
            this.add(this.usersNode);
            if (this.mediaGroupsNode == null) {
                this.mediaGroupsNode = new LunaServerMediaGroupsNode(this);
            }
            this.add(this.mediaGroupsNode);
            if (this.presentationsNode == null) {
                this.presentationsNode = new LunaServerPresentationsNode(this);
            }
            this.add(this.presentationsNode);
            if (this.collectionsNode == null) {
                this.collectionsNode = new LunaServerMediaCollectionsNode(this);
            }
            this.add(this.collectionsNode);
            if (this.sharedCollectionsNode == null) {
                this.sharedCollectionsNode = new LunaServerSharedMediaCollectionsNode(this);
            }
            this.add(this.sharedCollectionsNode);
            if (this.credentialsNode == null) {
                this.credentialsNode = new LunaServerCredentialsNode(this);
            }
            this.add(this.credentialsNode);
            if (this.credentialCollectionMapsNode == null) {
                this.credentialCollectionMapsNode = new LunaServerCredentialCollectionMapsNode(this);
            }
            this.add(this.credentialCollectionMapsNode);
            if (this.extendedCollectionPropertiesNode == null) {
                this.extendedCollectionPropertiesNode = new LunaServerExtendedCollectionPropertiesNode(this);
            }
            this.add(this.extendedCollectionPropertiesNode);
            if (this.ipRangesNode == null) {
                this.ipRangesNode = new LunaServerIPRangesNode(this);
            }
            this.add(this.ipRangesNode);
            if (this.maintenanceNode == null) {
                this.maintenanceNode = new LunaServerMaintenanceNode(this);
            }
            this.add(this.maintenanceNode);
            this.expandNode();
        }
        this.refreshData();
    }

    public void disconnect() {
        LunaServerNode.debugOut("Disconnect LunaServer.");
        this.lunaServer.disconnect();
        this.removeAllChildren();
        this.refreshData();
    }

    public void edit() {
        LunaServerNode.debugOut("Edit LunaServer.");
        this.lunaServer.edit();
    }

    public void refreshData() {
        if (!this.lunaServer.getAccountUsername().equals("") && this.lunaServer.isConnected()) {
            this.setText(this.lunaServer.getName() + " (" + this.lunaServer.getAccountUsername() + ")");
        } else {
            this.setText(this.lunaServer.getName());
        }
        this.lunaServer.getInsightAdministrator().reloadTreeModel(this);
    }

    public LunaServer getLunaServer() {
        return this.lunaServer;
    }

    public AdminAccount getAdminAccount() {
        return this.lunaServer.getAdminAccount();
    }

    public JComponent getDisplayComponent() {
        if (this.labelText == null) {
            this.createInformationModel();
        }
        return new JLabel(this.labelText);
    }

    public ImageIcon getIcon() {
        if (this.lunaServer.isConnected()) {
            if (this.treeIcon == null) {
                this.treeIcon = IconMaker.createImage("images/user-server-node-icon.gif");
            }
            return this.treeIcon;
        }
        if (this.disconnectedIcon == null) {
            this.disconnectedIcon = IconMaker.createImage("images/disconnected-user-server-node-icon.gif");
        }
        return this.disconnectedIcon;
    }

    public void createNewApplicationConfiguration() {
        this.lunaServer.addDataObject(new LunaServerApplicationConfiguration(this.lunaServer));
    }

    public void removeApplicationConfigurations(Vector vector) {
        LunaServerNode.debugOut("Removing attribute: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected attributes?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.lunaServer.removeDataObject((LunaServerApplicationConfiguration)vector.elementAt(i));
            }
            this.appConfigsNode.updateInformationDisplay();
        }
    }

    public void editApplicationConfiguration(LunaServerApplicationConfiguration lunaServerApplicationConfiguration) {
        LunaServerNode.debugOut("Editing attribute: " + lunaServerApplicationConfiguration);
        this.lunaServer.editDataObject(lunaServerApplicationConfiguration);
    }

    public void createNewCollection() {
        LunaServerNode.debugOut("Media Collection creation not allowed");
    }

    public void removeCollections(Vector vector) {
        LunaServerNode.debugOut("Removing media collections: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("IMPORTANT\n\nAre you sure you want to delete the selected collections from LUNA?\n\nThis must be followed by running Merge and Load in the Publisher and restarting the LUNA service.\n\n", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.lunaServer.removeDataObject((LunaServerMediaCollection)vector.elementAt(i));
            }
            this.collectionsNode.updateInformationDisplay();
        }
    }

    public void editCollection(LunaServerMediaCollection lunaServerMediaCollection) {
        LunaServerNode.debugOut("Editing media collection: " + lunaServerMediaCollection);
        LunaServerNode.debugOut("Media collection editing not allowed");
    }

    public void editCollection(LunaServerSharedMediaCollection lunaServerSharedMediaCollection) {
        LunaServerNode.debugOut("Editing shared media collection: " + lunaServerSharedMediaCollection);
        LunaServerNode.debugOut("Shared media collection editing not allowed");
    }

    public void createNewUser() {
        LunaServerNode.debugOut("User creation not allowed");
    }

    public void removeUsers(Vector vector) {
        LunaServerNode.debugOut("Removing users: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("By deleting the users, you will orphan any media groups or presentations that are associated with these users.\n\nYou may reassign a new owner to the media groups and presentations.\n\nKeep track of the User ID's before deletion.\n", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.lunaServer.removeDataObject((LunaServerUser)vector.elementAt(i));
            }
            this.usersNode.updateInformationDisplay();
        }
    }

    public void editUser(LunaServerUser lunaServerUser) {
        LunaServerNode.debugOut("Editing user: " + lunaServerUser);
        this.lunaServer.editDataObject(lunaServerUser);
    }

    public void editMediaGroup(LunaServerMediaGroup lunaServerMediaGroup) {
        LunaServerNode.debugOut("Editing media group: " + lunaServerMediaGroup);
        this.lunaServer.editDataObject(lunaServerMediaGroup);
    }

    public void editPresentation(LunaServerPresentation lunaServerPresentation) {
        LunaServerNode.debugOut("Editing presentation: " + lunaServerPresentation);
        this.lunaServer.editDataObject(lunaServerPresentation);
    }

    public void createNewCredential() {
        this.lunaServer.addDataObject(new LunaServerCredential(this.lunaServer.getLunaServerConnector().getNextValidCredentialID(), this.lunaServer));
    }

    public void removeCredentials(Vector vector) {
        LunaServerNode.debugOut("Removing credentials: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected credentials?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.lunaServer.removeDataObject((LunaServerCredential)vector.elementAt(i));
            }
            this.credentialsNode.updateInformationDisplay();
        }
    }

    public void editCredential(LunaServerCredential lunaServerCredential) {
        LunaServerNode.debugOut("Editing credential: " + lunaServerCredential);
        this.lunaServer.editDataObject(lunaServerCredential);
    }

    public void editCredentialCollectionMap(LunaServerCredentialCollectionMap lunaServerCredentialCollectionMap) {
        LunaServerNode.debugOut("Editing credential collection map: " + lunaServerCredentialCollectionMap);
        this.lunaServer.editDataObject(lunaServerCredentialCollectionMap);
    }

    public void editExtendedCollectionProperties(LunaServerExtendedCollectionProperties lunaServerExtendedCollectionProperties) {
        LunaServerNode.debugOut("Editing extended collection properties: " + lunaServerExtendedCollectionProperties);
        this.lunaServer.editDataObject(lunaServerExtendedCollectionProperties);
    }

    public void createNewIpRange() {
        this.lunaServer.addDataObject(new LunaServerIPRanges(this.lunaServer.getLunaServerConnector().getNextValidIpRangeID(), this.lunaServer));
    }

    public void removeIpRanges(Vector vector) {
        LunaServerNode.debugOut("Removing IP ranges: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected IP ranges?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.lunaServer.removeDataObject((LunaServerIPRanges)vector.elementAt(i));
            }
            this.ipRangesNode.updateInformationDisplay();
        }
    }

    public void editIpRange(LunaServerIPRanges lunaServerIPRanges) {
        LunaServerNode.debugOut("Editing IP range: " + lunaServerIPRanges);
        this.lunaServer.editDataObject(lunaServerIPRanges);
    }

    public void openMaintenance() {
        this.maintenanceNode.launchMaintenanceSetup();
    }

    protected Properties loadProperties(String string) {
        String string2 = string;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            LunaServerNode.debugOut("Cannot read configuration file. exc: " + iOException);
        }
        return properties;
    }

    public static void debugOut(String string) {
        LunaServerNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServerNode: " + string, n);
    }
}

