/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.RecordCommitFailedException;
import com.luna.insight.admin.RecordDeleteFailedException;
import com.luna.insight.admin.lunaserver.LunaServer;
import com.luna.insight.admin.lunaserver.applicationconfiguration.LunaServerApplicationConfiguration;
import com.luna.insight.admin.lunaserver.applicationconfiguration.LunaServerApplicationConfigurationRecordHandler;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredential;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredentialRecordHandler;
import com.luna.insight.admin.lunaserver.extendedcollectionproperties.LunaServerExtendedCollectionProperties;
import com.luna.insight.admin.lunaserver.extendedcollectionproperties.LunaServerExtendedCollectionPropertiesRecordHandler;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRanges;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRangesRecordHandler;
import com.luna.insight.admin.lunaserver.maintenance.LunaServerMaintenanceRecordHandler;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMap;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMapRecordHandler;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollection;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollectionRecordHandler;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroup;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroupRecordHandler;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentation;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentationRecordHandler;
import com.luna.insight.admin.lunaserver.sharedmediacollection.LunaServerSharedMediaCollection;
import com.luna.insight.admin.lunaserver.sharedmediacollection.LunaServerSharedMediaCollectionRecordHandler;
import com.luna.insight.admin.lunaserver.user.LunaServerUser;
import com.luna.insight.admin.lunaserver.user.LunaServerUserRecordHandler;
import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import java.util.Properties;
import java.util.Vector;

public class LunaServerConnector
extends AdministeredServerConnector {
    public static final String US_TABLE_APPLICATION_CONFIGURATIONS = "APPLICATIONCONFIGURATION";
    public static final String US_TABLE_MEDIA_COLLECTIONS = "MEDIACOLLECTIONS";
    public static final String US_TABLE_SHARED_MEDIA_COLLECTIONS = "SHAREDMEDIACOLLECTIONS";
    public static final String US_TABLE_CREDENTIALS = "CREDENTIALS";
    public static final String US_TABLE_CREDENTIAL_COLLECTION_MAP = "CREDENTIALCOLLECTIONMAP";
    public static final String US_TABLE_IPRANGES = "IPRANGES";
    public static final String US_TABLE_USERS = "USERS";
    public static final String US_TABLE_MEDIA_GROUPS = "MEDIAGROUPS";
    public static final String US_TABLE_PRESENTATIONS = "PRESENTATIONS";
    public static final String US_TABLE_EXTENDED_COLLECTION_PROPERTIES = "EXTENDEDCOLLECTIONPROPERTIES";
    public static final String US_TABLE_MEDIA_FIELDS = "MEDIAFIELDS";
    protected LunaServerApplicationConfigurationRecordHandler lunaServerApplicationConfigurationHandler = null;
    protected LunaServerMediaCollectionRecordHandler lunaServerMediaCollectionHandler = null;
    protected LunaServerSharedMediaCollectionRecordHandler lunaServerSharedMediaCollectionHandler = null;
    protected LunaServerUserRecordHandler lunaServerUserHandler = null;
    protected LunaServerCredentialRecordHandler lunaServerCredentialHandler = null;
    protected LunaServerCredentialCollectionMapRecordHandler lunaServerCredentialCollectionMapHandler = null;
    protected LunaServerIPRangesRecordHandler lunaServerIpRangeHandler = null;
    protected LunaServerMaintenanceRecordHandler lunaServerMaintenanceHandler = null;
    protected LunaServerMediaGroupRecordHandler lunaServerMediaGroupHandler = null;
    protected LunaServerPresentationRecordHandler lunaServerPresentationHandler = null;
    protected LunaServerExtendedCollectionPropertiesRecordHandler lunaServerExtendedCollectionPropertiesHandler = null;

    public LunaServerConnector(LunaServer lunaServer, Properties properties) {
        this.COMPONENT_CODE = "LunaServerConnector";
        this.server = lunaServer;
        this.dbConnectorGenerator = DatabaseConnectorGenerator.getCustomGenerator(properties);
        this.setConnectString(properties.getProperty(lunaServer.getConnectStringKey()));
        if (this.msAccessMode) {
            this.distinctKeyword = "DISTINCTROW";
        }
        if (!this.useDistinctKeyword) {
            this.distinctKeyword = "";
        }
        this.lunaServerApplicationConfigurationHandler = new LunaServerApplicationConfigurationRecordHandler(this);
        this.lunaServerMediaCollectionHandler = new LunaServerMediaCollectionRecordHandler(this);
        this.lunaServerSharedMediaCollectionHandler = new LunaServerSharedMediaCollectionRecordHandler(this);
        this.lunaServerUserHandler = new LunaServerUserRecordHandler(this);
        this.lunaServerCredentialHandler = new LunaServerCredentialRecordHandler(this);
        this.lunaServerCredentialCollectionMapHandler = new LunaServerCredentialCollectionMapRecordHandler(this);
        this.lunaServerIpRangeHandler = new LunaServerIPRangesRecordHandler(this);
        this.lunaServerMaintenanceHandler = new LunaServerMaintenanceRecordHandler(this);
        this.lunaServerMediaGroupHandler = new LunaServerMediaGroupRecordHandler(this);
        this.lunaServerPresentationHandler = new LunaServerPresentationRecordHandler(this);
        this.lunaServerExtendedCollectionPropertiesHandler = new LunaServerExtendedCollectionPropertiesRecordHandler(this);
    }

    public void commitRecord(DatabaseRecord databaseRecord) throws RecordCommitFailedException {
        if (databaseRecord != null) {
            if (databaseRecord instanceof LunaServerApplicationConfiguration) {
                this.lunaServerApplicationConfigurationHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerMediaCollection) {
                this.lunaServerMediaCollectionHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerSharedMediaCollection) {
                this.lunaServerSharedMediaCollectionHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerUser) {
                this.lunaServerUserHandler.updateRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerMediaGroup) {
                this.lunaServerMediaGroupHandler.updateRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerPresentation) {
                this.lunaServerPresentationHandler.updateRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerCredential) {
                this.lunaServerCredentialHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerCredentialCollectionMap) {
                this.lunaServerCredentialCollectionMapHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerExtendedCollectionProperties) {
                this.lunaServerExtendedCollectionPropertiesHandler.commitRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerIPRanges) {
                this.lunaServerIpRangeHandler.commitRecord(databaseRecord);
            } else {
                super.commitRecord(databaseRecord);
            }
        }
    }

    public void deleteRecord(DatabaseRecord databaseRecord) throws RecordDeleteFailedException {
        if (databaseRecord != null) {
            if (databaseRecord instanceof LunaServerApplicationConfiguration) {
                this.lunaServerApplicationConfigurationHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerMediaCollection) {
                this.lunaServerMediaCollectionHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerSharedMediaCollection) {
                this.lunaServerSharedMediaCollectionHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerUser) {
                this.lunaServerUserHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerCredential) {
                this.lunaServerCredentialHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerCredentialCollectionMap) {
                this.lunaServerCredentialCollectionMapHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerExtendedCollectionProperties) {
                this.lunaServerExtendedCollectionPropertiesHandler.deleteRecord(databaseRecord);
            } else if (databaseRecord instanceof LunaServerIPRanges) {
                this.lunaServerIpRangeHandler.deleteRecord(databaseRecord);
            } else {
                super.deleteRecord(databaseRecord);
            }
        }
    }

    public Vector getApplicationConfigurationRecords() {
        return this.lunaServerApplicationConfigurationHandler.getRecords();
    }

    public int getNextValidApplicationConfigurationID() {
        return this.lunaServerApplicationConfigurationHandler.getNextValidID();
    }

    public Vector getMediaCollectionRecords() {
        return this.lunaServerMediaCollectionHandler.getRecords();
    }

    public Vector getSharedMediaCollectionRecords() {
        return this.lunaServerSharedMediaCollectionHandler.getRecords();
    }

    public int getNextValidCollectionID() {
        return this.lunaServerMediaCollectionHandler.getNextValidID();
    }

    public Vector getUserRecords() {
        return this.lunaServerUserHandler.getRecords();
    }

    public int getNextValidUserID() {
        return this.lunaServerUserHandler.getNextValidID();
    }

    public Vector getCredentialRecords() {
        return this.lunaServerCredentialHandler.getRecords();
    }

    public Vector getMediaGroupRecords() {
        return this.lunaServerMediaGroupHandler.getRecords();
    }

    public Vector getPresentationRecords() {
        return this.lunaServerPresentationHandler.getRecords();
    }

    public Vector getExtendedCollectionPropertiesRecords() {
        return this.lunaServerExtendedCollectionPropertiesHandler.getRecords();
    }

    public int getNextValidCredentialID() {
        return this.lunaServerCredentialHandler.getNextValidID();
    }

    public Vector getCredentialCollectionMapRecords() {
        return this.lunaServerCredentialCollectionMapHandler.getRecords();
    }

    public Vector getIpRangeRecords() {
        return this.lunaServerIpRangeHandler.getRecords();
    }

    public int getNextValidIpRangeID() {
        return this.lunaServerIpRangeHandler.getNextValidID();
    }

    public String getMaintenanceGuid() {
        return this.lunaServerMaintenanceHandler.getAttributeValue("maintenanceGuid");
    }

    public String getLunaServerAddress() {
        return this.lunaServerMaintenanceHandler.getAttributeValue("lunaServerAddress");
    }

    public String getLunaServerPort() {
        return this.lunaServerMaintenanceHandler.getAttributeValue("lunaServerPort");
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut(this.COMPONENT_CODE + ": " + string, 3);
    }
}

