/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.lunaserver;

import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.AdministeredServerEditComponent;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.lunaserver.LunaServerConnector;
import com.luna.insight.admin.lunaserver.LunaServerNode;
import com.luna.insight.admin.lunaserver.applicationconfiguration.LunaServerApplicationConfiguration;
import com.luna.insight.admin.lunaserver.config.LunaServerConfigurationFileProperties;
import com.luna.insight.admin.lunaserver.credential.LunaServerCredential;
import com.luna.insight.admin.lunaserver.extendedcollectionproperties.LunaServerExtendedCollectionProperties;
import com.luna.insight.admin.lunaserver.ipranges.LunaServerIPRanges;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerCredentialCollectionMap;
import com.luna.insight.admin.lunaserver.mediacollection.LunaServerMediaCollection;
import com.luna.insight.admin.lunaserver.mediagroup.LunaServerMediaGroup;
import com.luna.insight.admin.lunaserver.presentation.LunaServerPresentation;
import com.luna.insight.admin.lunaserver.user.LunaServerUser;
import com.luna.insight.admin.verifier.NonDuplicateJTextComponentVerifier;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class LunaServer
extends AdministeredServer {
    public static String LUNA_CONNECT_STRING_KEY = "DatabaseConnect";
    private Hashtable applicationConfigurationsTable = new Hashtable();
    private Hashtable collectionsTable = new Hashtable();
    private Hashtable usersTable = new Hashtable();
    private Hashtable mediaGroupsTable = new Hashtable();
    private Hashtable presentationsTable = new Hashtable();
    private Hashtable credentialsTable = new Hashtable();
    private Hashtable credentialCollectionMapsTable = new Hashtable();
    private Hashtable extendedCollectionPropertiesTable = new Hashtable();
    private Hashtable ipRangesTable = new Hashtable();

    public LunaServer(String string, InsightAdministrator insightAdministrator) {
        super(string, insightAdministrator);
    }

    public String getConnectStringKey() {
        return LUNA_CONNECT_STRING_KEY;
    }

    public void setNode(LunaServerNode lunaServerNode) {
        this.parentNode = lunaServerNode;
    }

    public void edit() {
        if (this.editDialog == null) {
            this.oldName = this.getName();
            this.editDialog = new EditDialog(this.insightAdministrator.getFrame(), true, this);
            this.editDialog.show();
        } else {
            this.insightAdministrator.setSelectedFrame(this.editDialog);
        }
    }

    public void commitEdit() {
        if (this.creationCompleted) {
            this.insightAdministrator.removeLunaServerFromStore(this.oldName);
            this.insightAdministrator.registerNewLunaServer(this);
            this.parentNode.refreshData();
        }
    }

    public AdministeredServerConnector getServerConnector() {
        return this.getLunaServerConnector();
    }

    public void saveToDisk() {
        if (this.creationCompleted) {
            this.insightAdministrator.removeLunaServerFromStore(this.getName());
        }
        if (this.creationCompleted) {
            this.insightAdministrator.registerNewLunaServer(this);
        }
    }

    public LunaServerConnector getLunaServerConnector() {
        if (this.serverConnector == null) {
            Properties properties = new Properties();
            properties.setProperty("DefaultUsername", this.databaseUsername);
            properties.setProperty("DefaultPassword", this.databasePassword);
            properties.setProperty("DatabaseConnector", this.databaseConnector);
            properties.setProperty("JDBCDriverName", this.jdbcDriverName);
            properties.setProperty("JDBCUrlPrefix", this.jdbcUrlPrefix);
            properties.setProperty(this.getConnectStringKey(), this.connectString);
            this.serverConnector = new LunaServerConnector(this, properties);
        }
        return (LunaServerConnector)this.serverConnector;
    }

    public EditComponent getEditComponent() {
        LunaServer.debugOut("in getEditComponent");
        this.editComponent = new AdministeredServerEditComponent(this);
        JLabel jLabel = this.editComponent.getNameLabel();
        jLabel.setText("Luna Manager Name:");
        JTextField jTextField = this.editComponent.getNameField();
        jTextField.setInputVerifier(new NonDuplicateJTextComponentVerifier(InsightAdministrator.getExistingLunaServerNames(this.name)));
        this.editComponent.getNameField().setText(this.getName());
        if (this.getConnectString() != null && this.getConnectString().length() > 0) {
            this.editComponent.getConnectStringField().setText(this.getConnectString());
        }
        if (this.databaseUsername != null && this.databaseUsername.length() > 0) {
            this.editComponent.getDatabaseUsernameField().setText(this.databaseUsername);
        }
        if (this.databasePassword != null && this.databasePassword.length() > 0) {
            this.editComponent.getDatabasePasswordField().setText(this.databasePassword);
        }
        if (this.databaseConnector != null && this.databaseConnector.length() > 0) {
            this.editComponent.getDatabaseConnectorComboBox().setSelectedItem(this.databaseConnector);
        }
        if (this.globalEscapeDelimiter != null && this.globalEscapeDelimiter.length() > 0) {
            this.editComponent.getGlobalEscapeDelimiterField().setText(this.globalEscapeDelimiter);
        }
        if (this.unicodeFieldPrefix != null && this.unicodeFieldPrefix.length() > 0) {
            this.editComponent.getUnicodeFieldPrefixField().setText(this.unicodeFieldPrefix);
        }
        if (this.jdbcDriverName != null && this.jdbcDriverName.length() > 0) {
            this.editComponent.getJdbcDriverNameField().setText(this.jdbcDriverName);
        }
        if (this.jdbcUrlPrefix != null && this.jdbcUrlPrefix.length() > 0) {
            this.editComponent.getJdbcUrlPrefixField().setText(this.jdbcUrlPrefix);
        }
        if (this.configFilePath != null && this.configFilePath.length() > 0) {
            this.editComponent.getConfigFileNameField().setText(this.configFilePath);
        }
        this.editComponent.setJdbcFieldsAppropriately();
        this.editComponent.getNameField().selectAll();
        this.editComponent.getConfigFileNameField().setCaretPosition(0);
        return this.editComponent;
    }

    public String getSaveButtonText() {
        if (this.isNew()) {
            return "Save";
        }
        return "Save";
    }

    public boolean isNew() {
        return "".equals(this.getName());
    }

    public String getEditWindowTitle() {
        if (this.isNew()) {
            return "Register New Luna Manager";
        }
        return "Edit Luna Manager - " + this.getName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-node-icon.gif");
    }

    protected Hashtable getEditDialogCache(EditableDataObject editableDataObject) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof LunaServerApplicationConfiguration) {
                return this.applicationConfigurationsTable;
            }
            if (editableDataObject instanceof LunaServerMediaCollection) {
                return this.collectionsTable;
            }
            if (editableDataObject instanceof LunaServerUser) {
                return this.usersTable;
            }
            if (editableDataObject instanceof LunaServerMediaGroup) {
                return this.mediaGroupsTable;
            }
            if (editableDataObject instanceof LunaServerPresentation) {
                return this.presentationsTable;
            }
            if (editableDataObject instanceof LunaServerCredential) {
                return this.credentialsTable;
            }
            if (editableDataObject instanceof LunaServerCredentialCollectionMap) {
                return this.credentialCollectionMapsTable;
            }
            if (editableDataObject instanceof LunaServerExtendedCollectionProperties) {
                return this.extendedCollectionPropertiesTable;
            }
            if (editableDataObject instanceof LunaServerIPRanges) {
                return this.ipRangesTable;
            }
            return super.getEditDialogCache(editableDataObject);
        }
        return null;
    }

    public void updateParentNode(EditableDataObject editableDataObject) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof LunaServerApplicationConfiguration) {
                ((LunaServerNode)this.parentNode).appConfigsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerMediaCollection) {
                ((LunaServerNode)this.parentNode).collectionsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerUser) {
                ((LunaServerNode)this.parentNode).usersNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerMediaGroup) {
                ((LunaServerNode)this.parentNode).mediaGroupsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerPresentation) {
                ((LunaServerNode)this.parentNode).presentationsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerCredential) {
                ((LunaServerNode)this.parentNode).credentialsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerCredentialCollectionMap) {
                ((LunaServerNode)this.parentNode).credentialCollectionMapsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerExtendedCollectionProperties) {
                ((LunaServerNode)this.parentNode).extendedCollectionPropertiesNode.updateInformationDisplay();
            } else if (editableDataObject instanceof LunaServerIPRanges) {
                ((LunaServerNode)this.parentNode).ipRangesNode.updateInformationDisplay();
            } else {
                super.updateParentNode(editableDataObject);
            }
        }
    }

    public Vector getApplicationConfigurations() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getApplicationConfigurationRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMediaCollections() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getMediaCollectionRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getSharedMediaCollections() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getSharedMediaCollectionRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getUsers() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getUserRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getCredentials() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getCredentialRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getExtendedCollectionProperties() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getExtendedCollectionPropertiesRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getMediaGroups() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getMediaGroupRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getPresentations() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getPresentationRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getIpRanges() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getIpRangeRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getCredentialCollectionMaps() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getLunaServerConnector().getCredentialCollectionMapRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public String getMaintenanceGuid() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            String string = this.getLunaServerConnector().getMaintenanceGuid();
            this.insightAdministrator.showWaitCursor(false);
            return string;
        }
        return null;
    }

    public String getLunaServerAddress() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            String string = this.getLunaServerConnector().getLunaServerAddress();
            this.insightAdministrator.showWaitCursor(false);
            return string;
        }
        return null;
    }

    public String getLunaServerPort() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            String string = this.getLunaServerConnector().getLunaServerPort();
            this.insightAdministrator.showWaitCursor(false);
            return string;
        }
        return null;
    }

    public void refreshConfigurationFileProperties() {
        LunaServer.debugOut("in refreshConfigurationInformation()...");
        this.insightAdministrator.showWaitCursor(true);
        this.configFileProperties = new LunaServerConfigurationFileProperties(this, this.configFilePath);
        this.configFileProperties.refresh();
        this.insightAdministrator.showWaitCursor(false);
    }

    public static void debugOut(String string) {
        LunaServer.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LunaServer: " + string, n);
    }
}

