/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.vocab;

import com.luna.insight.admin.NodeChild;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.vocab.CsVocabValue;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CsVocabValuesNode
extends TableDisplayControlPanelNode
implements ActionListener,
NodeChild {
    protected CollectionServerNode collectionServerNode = null;
    protected int fieldID = 0;

    public CsVocabValuesNode(CollectionServerNode collectionServerNode, int n, String string) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), string + " Vocabulary", false);
        this.collectionServerNode = collectionServerNode;
        this.fieldID = n;
        this.columnNames = new Object[]{"Value"};
    }

    public int getDeterminantIndex() {
        return this.fieldID;
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getVocabValues(this.fieldID)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CsVocabValue csVocabValue = (CsVocabValue)vector.elementAt(i);
            objectArray[i][0] = csVocabValue;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New Vocab Value Command", this));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-vocab-values-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionServerNode.getAdminAccount(), "New Vocab Value Command", "Edit Vocab Value Command", "Delete Vocab Value Command");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionPerformed(actionEvent.getActionCommand(), null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Vocab Value Command")) {
            this.createNewVocabValue();
        } else if (string.equals("Delete Vocab Value Command")) {
            if (vector != null && vector.size() > 0) {
                this.removeVocabValues(vector);
            }
        } else if (string.equals("Edit Vocab Value Command") && vector != null && vector.size() == 1) {
            this.editVocabValue((CsVocabValue)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.editVocabValue((CsVocabValue)object);
        }
    }

    public void createNewVocabValue() {
        this.collectionServerNode.getCollectionServer().addDataObject(new CsVocabValue(this.fieldID, this.collectionServerNode.getCollectionServer().getCollectionServerConnector().getNextValidVocabValueID(this.fieldID), this.collectionServerNode.getCollectionServer()));
    }

    public void removeVocabValues(Vector vector) {
        CsVocabValuesNode.debugOut("Removing VocabValues: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected vocabulary values?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                CsVocabValue csVocabValue = (CsVocabValue)vector.elementAt(i);
                this.collectionServerNode.getCollectionServer().removeDataObject(csVocabValue);
                this.collectionServerNode.vocabulariesNode.updateNodeChild(csVocabValue);
            }
            this.updateInformationDisplay();
        }
    }

    public void editVocabValue(CsVocabValue csVocabValue) {
        CsVocabValuesNode.debugOut("Editing VocabValue: " + csVocabValue);
        this.collectionServerNode.getCollectionServer().editDataObject(csVocabValue);
    }

    public static void debugOut(String string) {
        CsVocabValuesNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsVocabValuesNode: " + string, n);
    }
}

