/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.usergroup;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroup;
import com.luna.insight.admin.collserver.usergroup.PersonalCollectionServerUserGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class PersonalCollectionServerUserGroupsNode
extends TableDisplayControlPanelNode {
    protected CollectionServerNode collectionServerNode = null;

    public PersonalCollectionServerUserGroupsNode(CollectionServerNode collectionServerNode) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), "Personal Collection User Groups", false);
        this.collectionServerNode = collectionServerNode;
        this.columnNames = new Object[]{"Group Name", "Code Key", "Profile ID", "Connection Pool ID", "Connection Reserve", "IP Address Range", "Browser IP Address Range", "Created"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getUserGroups(new Integer(-1))), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof CollectionServerUserGroup) continue;
            PersonalCollectionServerUserGroup personalCollectionServerUserGroup = (PersonalCollectionServerUserGroup)vector.elementAt(i);
            objectArray[i][0] = personalCollectionServerUserGroup;
            objectArray[i][1] = personalCollectionServerUserGroup.codeKey;
            objectArray[i][2] = "" + personalCollectionServerUserGroup.profileID;
            objectArray[i][3] = "" + personalCollectionServerUserGroup.connectionPoolID;
            objectArray[i][4] = "" + personalCollectionServerUserGroup.connectionReserve;
            objectArray[i][5] = personalCollectionServerUserGroup.ipAddressRange;
            objectArray[i][6] = personalCollectionServerUserGroup.browserIpAddressRange;
            objectArray[i][7] = new SimpleDate(personalCollectionServerUserGroup.createdTimestamp).getFull();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New PC User Group Command", this.collectionServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-user-groups-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionServerNode.getAdminAccount(), "New User Group Command", "Edit User Group Command", "Delete User Group Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New User Group Command")) {
            this.collectionServerNode.createNewUserGroup(new Integer(-1));
        } else if (string.equals("Delete User Group Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionServerNode.removeUserGroups(vector);
            }
        } else if (string.equals("Edit User Group Command") && vector != null && vector.size() == 1) {
            this.collectionServerNode.editPersonalCollectionUserGroup((PersonalCollectionServerUserGroup)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionServerNode.editPersonalCollectionUserGroup((PersonalCollectionServerUserGroup)object);
        }
    }

    public static void debugOut(String string) {
        PersonalCollectionServerUserGroupsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerUserGroupsNode: " + string, n);
    }
}

