/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.usergroup;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPool;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroupEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class PersonalCollectionServerUserGroup
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public static final int PERSONAL_COLLECTION_USER_GROUP_UID = -1;
    protected Integer uniqueCollectionID;
    protected int groupID;
    protected CollectionServer collectionServer;
    protected String groupName = "";
    protected String codeKey = "";
    protected int connectionReserve = 0;
    protected int connectionPoolID = 0;
    protected String ipAddressRange = "";
    protected String browserIpAddressRange = "0.0.0.0-255.255.255.255";
    protected int profileID = 0;
    protected String createdTimestamp = "";
    protected CollectionServerUserGroupEditComponent editComponent = null;
    private Vector profiles;
    private List selectableProfiles = new ArrayList();

    public PersonalCollectionServerUserGroup(CollectionServer collectionServer, int n, String string, String string2, int n2, int n3, String string3, String string4, int n4, String string5) {
        this.uniqueCollectionID = new Integer(-1);
        this.collectionServer = collectionServer;
        this.groupID = n;
        this.groupName = string == null ? "" : string;
        this.codeKey = string2 == null ? "" : string2;
        this.profileID = n4;
        this.connectionPoolID = n3;
        this.connectionReserve = n2;
        this.ipAddressRange = string3 == null ? "" : string3;
        this.browserIpAddressRange = string4 == null ? "" : string4;
        this.createdTimestamp = string5 == null ? new SimpleDate().get() : string5;
    }

    public PersonalCollectionServerUserGroup(int n, CollectionServer collectionServer) {
        this.uniqueCollectionID = new Integer(-1);
        this.groupID = n;
        this.collectionServer = collectionServer;
        this.createdTimestamp = new SimpleDate().get();
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.groupName;
    }

    public int getIndex() {
        return this.groupID;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public EditComponent getEditComponent() {
        Object object;
        Object object2;
        int n;
        this.editComponent = new CollectionServerUserGroupEditComponent();
        this.editComponent.getGroupNameField().setText(this.groupName);
        this.editComponent.getCodeKeyField().setText(this.codeKey);
        this.editComponent.getConnectionReserveField().setText("" + this.connectionReserve);
        Vector vector = this.collectionServer.getUserGroups(this.uniqueCollectionID);
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            PersonalCollectionServerUserGroup personalCollectionServerUserGroup = (PersonalCollectionServerUserGroup)vector.elementAt(i);
            if (!vector2.contains(personalCollectionServerUserGroup.ipAddressRange)) {
                vector2.addElement(personalCollectionServerUserGroup.ipAddressRange);
                this.editComponent.getIpRangeComboBox().addItem(personalCollectionServerUserGroup.ipAddressRange);
            }
            if (this.ipAddressRange.equals(personalCollectionServerUserGroup.ipAddressRange)) {
                this.editComponent.getIpRangeComboBox().setSelectedItem(personalCollectionServerUserGroup.ipAddressRange);
            }
            if (!vector3.contains(personalCollectionServerUserGroup.browserIpAddressRange)) {
                vector3.addElement(personalCollectionServerUserGroup.browserIpAddressRange);
                this.editComponent.getBrowserIpRangeComboBox().addItem(personalCollectionServerUserGroup.browserIpAddressRange);
            }
            if (!this.browserIpAddressRange.equals(personalCollectionServerUserGroup.browserIpAddressRange)) continue;
            this.editComponent.getBrowserIpRangeComboBox().setSelectedItem(personalCollectionServerUserGroup.browserIpAddressRange);
        }
        Vector vector4 = this.collectionServer.getConnectionPools();
        for (n = 0; n < vector4.size(); ++n) {
            int n2 = ((CollectionServerConnectionPool)vector4.elementAt(n)).getIndex();
            object2 = ((CollectionServerConnectionPool)vector4.elementAt(n)).getName();
            object = "" + n2 + " - " + (String)object2;
            this.editComponent.getConnectionPoolComboBox().addItem(object);
            if (this.connectionPoolID != n2) continue;
            this.editComponent.getConnectionPoolComboBox().setSelectedItem(object);
        }
        n = -1;
        Vector<String> vector5 = new Vector<String>();
        this.profiles = this.collectionServer.getProfiles();
        object2 = this.profiles.elements();
        while (object2.hasMoreElements()) {
            object = (CollectionServerProfile)object2.nextElement();
            if (((CollectionServerProfile)object).collectionId != 0) continue;
            String string = ((CollectionServerProfile)object).getDisplayName();
            if (string == null || string.length() == 0) {
                string = "Profile (no name)";
            }
            vector5.addElement(string);
            this.selectableProfiles.add(new Integer(((CollectionServerProfile)object).getProfileId()));
            if (((CollectionServerProfile)object).getProfileId() != this.profileID) continue;
            n = this.selectableProfiles.size() - 1;
        }
        this.editComponent.getProfileComboBox().setModel(new DefaultComboBoxModel(vector5));
        this.editComponent.getProfileComboBox().setSelectedIndex(n);
        this.editComponent.getGroupNameField().selectAll();
        this.editComponent.getGroupNameField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        PersonalCollectionServerUserGroup.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.groupName, this.editComponent.getGroupNameField().getText())) {
            this.groupName = this.editComponent.getGroupNameField().getText();
        }
        if (this.hasChanged(this.codeKey, this.editComponent.getCodeKeyField().getText())) {
            this.codeKey = this.editComponent.getCodeKeyField().getText();
        }
        try {
            if (this.hasChanged(this.connectionReserve, Integer.parseInt(this.editComponent.getConnectionReserveField().getText()))) {
                this.connectionReserve = Integer.parseInt(this.editComponent.getConnectionReserveField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged((Object)this.ipAddressRange, this.editComponent.getIpRangeComboBox().getSelectedItem())) {
            this.ipAddressRange = (String)this.editComponent.getIpRangeComboBox().getSelectedItem();
        }
        if (this.hasChanged((Object)this.browserIpAddressRange, this.editComponent.getBrowserIpRangeComboBox().getSelectedItem())) {
            this.browserIpAddressRange = (String)this.editComponent.getBrowserIpRangeComboBox().getSelectedItem();
        }
        String string = (String)this.editComponent.getConnectionPoolComboBox().getSelectedItem();
        int n = this.connectionPoolID;
        try {
            n = Integer.parseInt(string.substring(0, string.indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged("" + this.connectionPoolID, "" + n)) {
            this.connectionPoolID = n;
        }
        int n2 = this.profileID;
        try {
            n2 = (Integer)this.selectableProfiles.get(this.editComponent.getProfileComboBox().getSelectedIndex());
        }
        catch (Exception exception) {
            n2 = this.profileID;
        }
        if (this.hasChanged(this.profileID, n2)) {
            this.profileID = n2;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        PersonalCollectionServerUserGroup.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit User Group - " + this.groupName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-user-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof PersonalCollectionServerUserGroup) {
            PersonalCollectionServerUserGroup personalCollectionServerUserGroup = (PersonalCollectionServerUserGroup)object;
            return this.groupID == personalCollectionServerUserGroup.groupID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof PersonalCollectionServerUserGroup) {
            PersonalCollectionServerUserGroup personalCollectionServerUserGroup = (PersonalCollectionServerUserGroup)databaseRecord;
            return this.groupID == personalCollectionServerUserGroup.groupID && PersonalCollectionServerUserGroup.stringsAreEqual(this.groupName, personalCollectionServerUserGroup.groupName) && PersonalCollectionServerUserGroup.stringsAreEqual(this.codeKey, personalCollectionServerUserGroup.codeKey) && this.connectionReserve == personalCollectionServerUserGroup.connectionReserve && PersonalCollectionServerUserGroup.stringsAreEqual(this.ipAddressRange, personalCollectionServerUserGroup.ipAddressRange) && PersonalCollectionServerUserGroup.stringsAreEqual(this.browserIpAddressRange, personalCollectionServerUserGroup.browserIpAddressRange) && this.connectionPoolID == personalCollectionServerUserGroup.connectionPoolID && this.profileID == personalCollectionServerUserGroup.profileID && PersonalCollectionServerUserGroup.stringsAreEqual(this.createdTimestamp, personalCollectionServerUserGroup.createdTimestamp);
        }
        return false;
    }

    public static void debugOut(String string) {
        PersonalCollectionServerUserGroup.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("PersonalCollectionServerUserGroup: " + string, n);
    }
}

