/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.usergroup;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPool;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroupEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class CollectionServerUserGroup
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected Integer uniqueCollectionID;
    protected int groupID;
    protected Collection collection;
    protected String groupName = "";
    protected String codeKey = "";
    protected int connectionReserve = 0;
    protected int connectionPoolID = 0;
    protected String ipAddressRange = "";
    protected String browserIpAddressRange = "0.0.0.0-255.255.255.255";
    protected int profileID = 0;
    protected String createdTimestamp = "";
    protected CollectionServerUserGroupEditComponent editComponent = null;
    private Vector profiles;
    private List selectableProfiles = new ArrayList();

    public CollectionServerUserGroup(Integer n, Collection collection, int n2, String string, String string2, int n3, int n4, String string3, String string4, int n5, String string5) {
        this.uniqueCollectionID = n;
        this.collection = collection;
        this.groupID = n2;
        this.groupName = string == null ? "" : string;
        this.codeKey = string2 == null ? "" : string2;
        this.profileID = n5;
        this.connectionPoolID = n4;
        this.connectionReserve = n3;
        this.ipAddressRange = string3 == null ? "" : string3;
        this.browserIpAddressRange = string4 == null ? "" : string4;
        this.createdTimestamp = string5 == null ? new SimpleDate().get() : string5;
    }

    public CollectionServerUserGroup(Integer n, int n2, Collection collection) {
        this.uniqueCollectionID = n;
        this.groupID = n2;
        this.collection = collection;
        this.createdTimestamp = new SimpleDate().get();
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.groupName;
    }

    public int getIndex() {
        return this.groupID;
    }

    public EditComponent getEditComponent() {
        Object object;
        Object object2;
        int n;
        this.editComponent = new CollectionServerUserGroupEditComponent();
        this.editComponent.getGroupNameField().setText(this.groupName);
        this.editComponent.getCodeKeyField().setText(this.codeKey);
        this.editComponent.getConnectionReserveField().setText("" + this.connectionReserve);
        Vector vector = this.collection.getServer().getUserGroups(this.uniqueCollectionID);
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerUserGroup collectionServerUserGroup = (CollectionServerUserGroup)vector.elementAt(i);
            if (!vector2.contains(collectionServerUserGroup.ipAddressRange)) {
                vector2.addElement(collectionServerUserGroup.ipAddressRange);
                this.editComponent.getIpRangeComboBox().addItem(collectionServerUserGroup.ipAddressRange);
            }
            if (this.ipAddressRange.equals(collectionServerUserGroup.ipAddressRange)) {
                this.editComponent.getIpRangeComboBox().setSelectedItem(collectionServerUserGroup.ipAddressRange);
            }
            if (!vector3.contains(collectionServerUserGroup.browserIpAddressRange)) {
                vector3.addElement(collectionServerUserGroup.browserIpAddressRange);
                this.editComponent.getBrowserIpRangeComboBox().addItem(collectionServerUserGroup.browserIpAddressRange);
            }
            if (!this.browserIpAddressRange.equals(collectionServerUserGroup.browserIpAddressRange)) continue;
            this.editComponent.getBrowserIpRangeComboBox().setSelectedItem(collectionServerUserGroup.browserIpAddressRange);
        }
        Vector vector4 = this.collection.getServer().getConnectionPools();
        for (n = 0; n < vector4.size(); ++n) {
            int n2 = ((CollectionServerConnectionPool)vector4.elementAt(n)).getIndex();
            object2 = ((CollectionServerConnectionPool)vector4.elementAt(n)).getName();
            object = "" + n2 + " - " + (String)object2;
            this.editComponent.getConnectionPoolComboBox().addItem(object);
            if (this.connectionPoolID != n2) continue;
            this.editComponent.getConnectionPoolComboBox().setSelectedItem(object);
        }
        n = -1;
        Vector<String> vector5 = new Vector<String>();
        this.selectableProfiles.clear();
        this.profiles = this.collection != null && !this.collection.getServer().getServerNode().getCollectionsWithDuplicateUIDAndVCIDEntries().contains(this.uniqueCollectionID) ? this.collection.getServer().getProfiles(this.collection.getUserCollectionID()) : this.collection.getServer().getProfiles();
        object2 = this.collection.getServer().getConfigurations(this.uniqueCollectionID, false);
        Enumeration enumeration = this.profiles.elements();
        while (enumeration.hasMoreElements()) {
            object = (CollectionServerProfile)enumeration.nextElement();
            if (((CollectionServerProfile)object).collectionId == 0) continue;
            String string = ((CollectionServerProfile)object).getDisplayName();
            if (string == null || string.length() <= 0) {
                int n3 = ((CollectionServerProfile)object).getCollectionId();
                String string2 = "";
                Enumeration enumeration2 = ((Vector)object2).elements();
                while (enumeration2.hasMoreElements()) {
                    CollectionServerConfiguration collectionServerConfiguration = (CollectionServerConfiguration)enumeration2.nextElement();
                    if (collectionServerConfiguration == null || collectionServerConfiguration.getUserCollection() != n3) continue;
                    string2 = collectionServerConfiguration.collectionName;
                    break;
                }
                string = ((CollectionServerProfile)object).getProfileId() + " - Collection: " + string2;
            }
            vector5.addElement(string);
            this.selectableProfiles.add(new Integer(((CollectionServerProfile)object).getProfileId()));
            if (((CollectionServerProfile)object).getProfileId() != this.profileID) continue;
            n = this.selectableProfiles.size() - 1;
        }
        this.editComponent.getProfileComboBox().setModel(new DefaultComboBoxModel(vector5));
        this.editComponent.getProfileComboBox().setSelectedIndex(n);
        this.editComponent.getGroupNameField().selectAll();
        this.editComponent.getGroupNameField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CollectionServerUserGroup.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.groupName, this.editComponent.getGroupNameField().getText())) {
            this.groupName = this.editComponent.getGroupNameField().getText();
        }
        if (this.hasChanged(this.codeKey, this.editComponent.getCodeKeyField().getText())) {
            this.codeKey = this.editComponent.getCodeKeyField().getText();
        }
        try {
            if (this.hasChanged(this.connectionReserve, Integer.parseInt(this.editComponent.getConnectionReserveField().getText()))) {
                this.connectionReserve = Integer.parseInt(this.editComponent.getConnectionReserveField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged((Object)this.ipAddressRange, this.editComponent.getIpRangeComboBox().getSelectedItem())) {
            this.ipAddressRange = (String)this.editComponent.getIpRangeComboBox().getSelectedItem();
        }
        if (this.hasChanged((Object)this.browserIpAddressRange, this.editComponent.getBrowserIpRangeComboBox().getSelectedItem())) {
            this.browserIpAddressRange = (String)this.editComponent.getBrowserIpRangeComboBox().getSelectedItem();
        }
        String string = (String)this.editComponent.getConnectionPoolComboBox().getSelectedItem();
        int n = this.connectionPoolID;
        try {
            n = Integer.parseInt(string.substring(0, string.indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged("" + this.connectionPoolID, "" + n)) {
            this.connectionPoolID = n;
        }
        int n2 = this.profileID;
        try {
            n2 = (Integer)this.selectableProfiles.get(this.editComponent.getProfileComboBox().getSelectedIndex());
        }
        catch (Exception exception) {
            n2 = this.profileID;
        }
        if (this.hasChanged(this.profileID, n2)) {
            this.profileID = n2;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collection.getServer().commitDataObject(this);
        } else {
            this.collection.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CollectionServerUserGroup.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collection.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit User Group - " + this.groupName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-user-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerUserGroup) {
            CollectionServerUserGroup collectionServerUserGroup = (CollectionServerUserGroup)object;
            return this.groupID == collectionServerUserGroup.groupID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerUserGroup) {
            CollectionServerUserGroup collectionServerUserGroup = (CollectionServerUserGroup)databaseRecord;
            return this.groupID == collectionServerUserGroup.groupID && CollectionServerUserGroup.stringsAreEqual(this.groupName, collectionServerUserGroup.groupName) && CollectionServerUserGroup.stringsAreEqual(this.codeKey, collectionServerUserGroup.codeKey) && this.connectionReserve == collectionServerUserGroup.connectionReserve && CollectionServerUserGroup.stringsAreEqual(this.ipAddressRange, collectionServerUserGroup.ipAddressRange) && CollectionServerUserGroup.stringsAreEqual(this.browserIpAddressRange, collectionServerUserGroup.browserIpAddressRange) && this.connectionPoolID == collectionServerUserGroup.connectionPoolID && this.profileID == collectionServerUserGroup.profileID && CollectionServerUserGroup.stringsAreEqual(this.createdTimestamp, collectionServerUserGroup.createdTimestamp);
        }
        return false;
    }

    public static void debugOut(String string) {
        CollectionServerUserGroup.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerUserGroup: " + string, n);
    }
}

