/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.task;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.admin.collserver.task.CcTaskItemFactory;
import com.luna.insight.admin.collserver.task.CcTaskRecord;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CcTaskItemRecordHandler
extends DatabaseRecordHandler {
    public CcTaskItemRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcTaskItemRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.doInsert(databaseRecord, -1);
    }

    public void doInsert(DatabaseRecord databaseRecord, int n) {
        this.debugOut("in doInsert()");
        try {
            CcTaskItem ccTaskItem = (CcTaskItem)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TaskItemID", 2, stringBuffer2, ccTaskItem.getIndex() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ItemName", 1, stringBuffer2, ccTaskItem.getTaskItemName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ItemType", 2, stringBuffer2, ccTaskItem.getTaskItemType() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StartTime", 1, stringBuffer2, ccTaskItem.getTaskItemStartTime() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EndTime", 1, stringBuffer2, ccTaskItem.getTaskItemCompleteTime() + "");
            int n2 = 0;
            AdminAccount adminAccount = ccTaskItem.getCompletedByAccount();
            if (adminAccount != null) {
                n2 = adminAccount.getIndex();
            }
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "CompletedByAccountID", 2, stringBuffer2, n2 + "");
            databaseConnector.setQuery("INSERT INTO CCTASKITEMS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert table:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string = "INSERT INTO CCTASKITEMMAP (TaskID, TaskItemID) VALUES (" + n + ", " + databaseRecord.getIndex() + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertTaskItemMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM CCTASKITEMS WHERE TaskItemID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteTaskItemQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string2 = "DELETE FROM CCTASKITEMMAP WHERE TaskItemID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string2);
            this.debugOut("deleteTaskItemMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public void clearItemsForTask(int n) {
        try {
            Vector<Integer> vector = new Vector<Integer>();
            String string = "SELECT * FROM CCTASKITEMMAP WHERE TaskID = " + n;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(string);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    vector.addElement(new Integer(databaseConnector.getIntegerFieldByName("TaskItemID")));
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            String string2 = "DELETE FROM CCTASKITEMMAP WHERE TaskID = " + n;
            databaseConnector.setQuery(string2);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            SqlBatchController sqlBatchController = new SqlBatchController(databaseConnector, 100);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                int n2 = (Integer)enumeration.nextElement();
                sqlBatchController.postSqlCommand("DELETE FROM CCTASKITEMS WHERE TaskItemID = " + n2);
            }
            sqlBatchController.executeRemainingCommands();
        }
        catch (Exception exception) {
            this.debugOut("Exception in clearItemsForTask(): " + exception);
        }
    }

    public Vector getRecords() {
        return this.getRecords(null, null);
    }

    public Vector getRecords(Hashtable hashtable) {
        return this.getRecords(null, hashtable);
    }

    public Vector getRecords(CcTaskRecord ccTaskRecord, Hashtable hashtable) {
        Vector<CcTaskItem> vector = new Vector<CcTaskItem>();
        try {
            int n = ccTaskRecord != null ? ccTaskRecord.getIndex() : -1;
            Hashtable hashtable2 = new Hashtable();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCTASKITEMS", null, "*");
            sqlQueryGenerator.addTable("CCTASKITEMMAP", null, "*");
            sqlQueryGenerator.addJoin("CCTASKITEMS", "CCTASKITEMMAP", "TaskItemID", 0);
            if (n != -1) {
                sqlQueryGenerator.appendToWhere("TaskID = " + n);
            }
            sqlQueryGenerator.addOrderBy("CCTASKITEMS", "TaskItemID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CcTaskItem ccTaskItem;
                    AdminAccount adminAccount = null;
                    int n2 = databaseConnector.getIntegerFieldByName("CompletedByAccountID");
                    if (hashtable != null) {
                        adminAccount = (AdminAccount)hashtable.get(new Integer(n2));
                    }
                    if ((ccTaskItem = CcTaskItemFactory.getTaskItem((CollectionServer)this.serverConnector.getAdministeredServer(), ccTaskRecord, databaseConnector.getIntegerFieldByName("TaskItemID"), databaseConnector.getFieldByName("ItemName"), databaseConnector.getIntegerFieldByName("ItemType"), databaseConnector.getLongField("StartTime"), databaseConnector.getLongField("EndTime"), adminAccount)) != null) {
                        vector.addElement(ccTaskItem);
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        return null;
    }

    public String getNextValidIDQuery() {
        return "SELECT TaskItemID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "CCTASKITEMS" + " ORDER BY TaskItemID";
    }

    public void updateTaskItemStartTime(CcTaskItem ccTaskItem) {
        this.debugOut("in updateTaskItemStartTime()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("UPDATE CCTASKITEMS SET StartTime = " + this.prepForInsertQuery("" + ccTaskItem.getTaskItemStartTime()) + " WHERE TaskItemID = " + ccTaskItem.getIndex());
            this.debugOut("Update task item start time query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateTaskItemStartTime(): " + exception);
        }
    }

    public void updateTaskItemCompletionTime(CcTaskItem ccTaskItem) {
        this.debugOut("in updateTaskItemCompletionTime()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("UPDATE CCTASKITEMS SET EndTime = " + this.prepForInsertQuery("" + ccTaskItem.getTaskItemCompleteTime()) + " WHERE TaskItemID = " + ccTaskItem.getIndex());
            this.debugOut("Update task item completion time query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateTaskItemCompletionTime(): " + exception);
        }
    }

    public void updateMaxIDValue(long l) {
    }
}

