/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.task;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.admin.collserver.task.CcTaskItemListener;
import com.luna.insight.admin.collserver.task.CcTaskLockFailedException;
import com.luna.insight.admin.collserver.task.CcTaskRecord;
import com.luna.insight.server.Debug;
import java.util.List;
import java.util.Vector;

public abstract class CcAbstractTaskItem
implements CcTaskItem,
Comparable {
    protected CollectionServer server;
    protected CcTaskRecord taskRecord;
    protected int taskItemID;
    protected long startTime;
    protected long completeTime;
    protected AdminAccount taskItemCompleter;
    protected List taskItemListeners;

    public static void debugOut(String string) {
        CcAbstractTaskItem.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcAbstractTaskItem: " + string, n);
    }

    public CcAbstractTaskItem(CollectionServer collectionServer, CcTaskRecord ccTaskRecord, int n, long l, long l2, AdminAccount adminAccount) {
        this.server = collectionServer;
        this.taskRecord = ccTaskRecord;
        this.taskItemID = n;
        this.startTime = l;
        this.completeTime = l2;
        this.taskItemCompleter = adminAccount;
    }

    public abstract String getTaskItemName();

    public abstract int getTaskItemType();

    public abstract void startTaskItem();

    public boolean skipAheadOfIncompleteTasks() {
        List list = this.getTaskRecord().getPreviousIncompleteTaskItems(this);
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The following task item" + (list.size() == 1 ? " is " : "s are ") + "incomplete:");
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append("\n     " + ((CcTaskItem)list.get(i)).getTaskItemName());
            }
            stringBuffer.append("\nDo you wish to skip ahead?");
            return InsightAdministrator.getInsightAdministrator().showYesNoConfirmDialog(stringBuffer.toString(), "Continue Anyway?");
        }
        return true;
    }

    public CcTaskRecord getTaskRecord() {
        return this.taskRecord;
    }

    public int getTaskItemID() {
        return this.taskItemID;
    }

    public void setTaskItemID(int n) {
        this.taskItemID = n;
    }

    public Object getTaskItemKey() {
        return "Server-" + this.server.getName() + "-TaskItemID-" + this.getTaskItemID();
    }

    public boolean isTaskItemStarted() {
        return this.startTime > 0L;
    }

    public void startTaskItem(AdminAccount adminAccount) {
        try {
            if (this.skipAheadOfIncompleteTasks()) {
                this.server.getCollectionServerConnector().lockTask(this.getTaskRecord(), this.server.getAdminAccount());
                this.startTime = System.currentTimeMillis();
                this.taskItemCompleter = adminAccount;
                this.server.getCollectionServerConnector().updateTaskItemStartTime(this);
                if (this.taskRecord.getStartTime() <= 0L) {
                    this.taskRecord.setStartTime(this.startTime);
                    this.server.getCollectionServerConnector().updateTaskStartTime(this.taskRecord);
                }
                this.startTaskItem();
            }
        }
        catch (CcTaskLockFailedException ccTaskLockFailedException) {
            InsightAdministrator.getInsightAdministrator().showWarningDialog(ccTaskLockFailedException.toString(), "Start Task Item Failed");
        }
    }

    public long getTaskItemStartTime() {
        return this.startTime;
    }

    public long getTaskItemCompleteTime() {
        return this.completeTime;
    }

    public boolean isTaskItemComplete() {
        return this.completeTime > 0L;
    }

    public void setTaskItemComplete() {
        this.server.getCollectionServerConnector().unlockTask(this.getTaskRecord(), this.server.getAdminAccount());
        this.completeTime = System.currentTimeMillis();
        this.server.getCollectionServerConnector().updateTaskItemCompletionTime(this);
        if (this.taskRecord.allItemsComplete()) {
            this.taskRecord.setCompleteTime(this.completeTime);
            this.server.getCollectionServerConnector().updateTaskCompletionTime(this.taskRecord);
        }
        for (int i = 0; this.taskItemListeners != null && i < this.taskItemListeners.size(); ++i) {
            ((CcTaskItemListener)this.taskItemListeners.get(i)).taskItemCompleted(this);
        }
    }

    public void setTaskItemCancelled() {
        this.server.getCollectionServerConnector().unlockTask(this.getTaskRecord(), this.server.getAdminAccount());
    }

    public AdminAccount getCompletedByAccount() {
        if (this.isTaskItemComplete()) {
            return this.taskItemCompleter;
        }
        return null;
    }

    public void addTaskItemListener(CcTaskItemListener ccTaskItemListener) {
        if (this.taskItemListeners == null) {
            this.taskItemListeners = new Vector(1);
        }
        this.taskItemListeners.add(ccTaskItemListener);
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseRecord) {
            return this.equalsRecord((DatabaseRecord)object);
        }
        return false;
    }

    public int getIndex() {
        return this.getTaskItemID();
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcTaskItem) {
            return this.getTaskItemKey().equals(((CcTaskItem)databaseRecord).getTaskItemKey());
        }
        return false;
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.getTaskItemType() - ((CcAbstractTaskItem)object).getTaskItemType();
    }
}

