/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.table;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CcTableRecordsNode
extends TableDisplayControlPanelNode {
    protected CollectionNode collectionNode = null;

    public CcTableRecordsNode(CollectionNode collectionNode) {
        super(collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Tables", false);
        this.collectionNode = collectionNode;
        this.columnNames = new Object[]{"Record Type", "Table Name", "Hierarchy", "Primary Object Table", "Primary Object Key"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionNode.getCollectionServerNode().getCollectionServer().getTableRecords(this.collectionNode.getCollection())), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CcTableRecord ccTableRecord = (CcTableRecord)vector.elementAt(i);
            objectArray[i][0] = ccTableRecord.entityTypeName;
            objectArray[i][1] = ccTableRecord;
            objectArray[i][2] = new Boolean(ccTableRecord.isHierarchy());
            objectArray[i][3] = new Boolean(ccTableRecord.isPrimaryObjectTable());
            objectArray[i][4] = ccTableRecord.getPrimaryObjectKey();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New Table Record Command", this.collectionNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-tables-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.collectionNode.getCollectionServerNode().getAdminAccount(), "New Table Record Command", "Edit Table Record Command", "Delete Table Record Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Table Record Command")) {
            this.collectionNode.getCollectionServerNode().createNewTableRecord(this.collectionNode.getCollection().getUniqueCollectionID());
        } else if (string.equals("Delete Table Record Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionNode.getCollectionServerNode().removeTableRecords(vector);
            }
        } else if (string.equals("Edit Table Record Command") && vector != null && vector.size() == 1) {
            this.collectionNode.getCollectionServerNode().editTableRecord((CcTableRecord)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionNode.getCollectionServerNode().editTableRecord((CcTableRecord)object);
        }
    }

    public static void debugOut(String string) {
        CcTableRecordsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcTableRecordsNode: " + string, n);
    }
}

