/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.table;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.table.CcTableRecordEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class CcTableRecord
extends EditableDataObject
implements DatabaseRecord {
    public static final String INSIGHT_TABLE_RECORD = "Insight Table Record";
    protected int tableID;
    protected Collection collection;
    protected String tableName = "";
    protected boolean isHierarchy = false;
    protected int parentChildTableID;
    protected boolean isPrimaryObjectTable = false;
    protected String primaryObjectKey = "";
    protected String entityTypeName = "";
    protected CcTableRecordEditComponent editComponent = null;

    public static void debugOut(String string) {
        CcTableRecord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcTableRecord: " + string, n);
    }

    public CcTableRecord(Collection collection, int n) {
        this.collection = collection;
        this.tableID = n;
    }

    public CcTableRecord(Collection collection, int n, String string, boolean bl, int n2, boolean bl2, String string2, String string3) {
        this.collection = collection;
        this.tableID = n;
        this.tableName = string == null ? "" : string;
        this.isHierarchy = bl;
        this.parentChildTableID = n2;
        this.isPrimaryObjectTable = bl2;
        this.primaryObjectKey = string2 == null ? "" : string2;
        this.entityTypeName = string3;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public int getTableID() {
        return this.tableID;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isHierarchy() {
        return this.isHierarchy;
    }

    public int getParentChildTableID() {
        return this.parentChildTableID;
    }

    public boolean isPrimaryObjectTable() {
        return this.isPrimaryObjectTable;
    }

    public String getPrimaryObjectKey() {
        return this.primaryObjectKey;
    }

    public void setTableID(int n) {
        this.tableID = n;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setIsHierarchy(boolean bl) {
        this.isHierarchy = bl;
    }

    public void setParentChildTableID(int n) {
        this.parentChildTableID = n;
    }

    public void setIsPrimaryObjectTable(boolean bl) {
        this.isPrimaryObjectTable = bl;
    }

    public void setPrimaryObjectKey(String string) {
        this.primaryObjectKey = string;
    }

    public String toString() {
        return this.getTableName();
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcTableRecordEditComponent();
        this.editComponent.getTableNameField().setText(this.tableName);
        this.editComponent.getPrimaryObjectsTableCheckBox().setSelected(this.isPrimaryObjectTable);
        this.editComponent.getPrimaryObjectKeyField().setText(this.primaryObjectKey);
        this.editComponent.setEnabledComponents();
        return this.editComponent;
    }

    public void save() {
        CcTableRecord.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.tableName, this.editComponent.getTableNameField().getText())) {
            this.tableName = this.editComponent.getTableNameField().getText();
        }
        if (this.hasChanged(this.isPrimaryObjectTable, this.editComponent.getPrimaryObjectsTableCheckBox().isSelected())) {
            this.isPrimaryObjectTable = this.editComponent.getPrimaryObjectsTableCheckBox().isSelected();
        }
        if (this.hasChanged(this.primaryObjectKey, this.editComponent.getPrimaryObjectKeyField().getText())) {
            this.primaryObjectKey = this.editComponent.getPrimaryObjectKeyField().getText();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collection.getServer().commitDataObject(this);
        } else {
            this.collection.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CcTableRecord.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collection.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Table Record - " + this.tableName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-tables-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CcTableRecord) {
            CcTableRecord ccTableRecord = (CcTableRecord)object;
            return this.tableID == ccTableRecord.tableID;
        }
        return super.equals(object);
    }

    public int getIndex() {
        return this.tableID;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcTableRecord) {
            CcTableRecord ccTableRecord = (CcTableRecord)databaseRecord;
            return this.getTableID() == ccTableRecord.getTableID() && CcTableRecord.stringsAreEqual(this.getTableName(), ccTableRecord.getTableName()) && this.isHierarchy() == ccTableRecord.isHierarchy() && this.getParentChildTableID() == ccTableRecord.getParentChildTableID() && this.isPrimaryObjectTable() == ccTableRecord.isPrimaryObjectTable() && CcTableRecord.stringsAreEqual(this.getPrimaryObjectKey(), ccTableRecord.getPrimaryObjectKey());
        }
        return databaseRecord == this;
    }
}

