/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.stoplist;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.stoplist.CcStopWordEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class CcStopWord
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected int stopWordID;
    protected CollectionServer collectionServer;
    protected String stopWord = "";
    protected CcStopWordEditComponent editComponent = null;

    public CcStopWord(CollectionServer collectionServer, int n, String string) {
        this.collectionServer = collectionServer;
        this.stopWordID = n;
        this.stopWord = string == null ? "" : string;
    }

    public CcStopWord(int n, CollectionServer collectionServer) {
        this.stopWordID = n;
        this.collectionServer = collectionServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.stopWord;
    }

    public int getIndex() {
        return this.stopWordID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcStopWordEditComponent();
        this.editComponent.getStopWordField().setText(this.stopWord);
        this.editComponent.getStopWordField().selectAll();
        this.editComponent.getStopWordField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CcStopWord.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.stopWord, this.editComponent.getStopWordField().getText())) {
            this.stopWord = this.editComponent.getStopWordField().getText();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CcStopWord.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Stop Word - " + this.stopWord;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-stop-list-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CcStopWord) {
            CcStopWord ccStopWord = (CcStopWord)object;
            return this.stopWordID == ccStopWord.stopWordID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcStopWord) {
            CcStopWord ccStopWord = (CcStopWord)databaseRecord;
            return this.stopWordID == ccStopWord.stopWordID && CcStopWord.stringsAreEqual(this.stopWord, ccStopWord.stopWord);
        }
        return false;
    }

    public static void debugOut(String string) {
        CcStopWord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcStopWord: " + string, n);
    }
}

