/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.stoplist;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.stoplist.CcStopWord;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CcStopListNode
extends TableDisplayControlPanelNode {
    protected CollectionServerNode collectionServerNode = null;

    public CcStopListNode(CollectionServerNode collectionServerNode) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), "Stop List", false);
        this.collectionServerNode = collectionServerNode;
        this.columnNames = new Object[]{"Term"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getStopWords()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CcStopWord ccStopWord = (CcStopWord)vector.elementAt(i);
            objectArray[i][0] = ccStopWord;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New Stop Word Command", this.collectionServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-stop-list-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionServerNode.getAdminAccount(), "New Stop Word Command", "Edit Stop Word Command", "Delete Stop Word Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Stop Word Command")) {
            this.collectionServerNode.createNewStopWord();
        } else if (string.equals("Delete Stop Word Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionServerNode.removeStopWords(vector);
            }
        } else if (string.equals("Edit Stop Word Command") && vector != null && vector.size() == 1) {
            this.collectionServerNode.editStopWord((CcStopWord)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionServerNode.editStopWord((CcStopWord)object);
        }
    }

    public static void debugOut(String string) {
        CcStopListNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcStopListNode: " + string, n);
    }
}

