/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.profile;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.inscribe.CcMedeProfile;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public class CollectionServerProfileRecordHandler
extends DatabaseRecordHandler {
    private boolean supportsMpd = true;
    private boolean supportsMede = true;

    public CollectionServerProfileRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CollectionServerProfileRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.supportsMede = this.getSupportsMede();
        this.supportsMpd = this.getSupportsMpd();
        try {
            CollectionServerProfile collectionServerProfile = (CollectionServerProfile)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO IRPROFILE ");
            stringBuffer.append("( ProfileID, CollectionID, SPSNum, ExportPriv, ExportPresentationPriv, EditPriv, ");
            stringBuffer.append(" EditVocabPriv, MaxViewableSize, HTMLExport, SaveGroups, DeleteGroups, ");
            stringBuffer.append(" EditLinkPriv, EditMVIPriv");
            if (this.supportsMpd) {
                stringBuffer.append(", EditMpdPriv");
            }
            if (this.supportsMede) {
                stringBuffer.append(", ApprovalLevel, MEDEPermissions");
            }
            stringBuffer.append(", DisplayName ");
            stringBuffer.append(", EditPersonalCollections)");
            stringBuffer.append("VALUES ( " + collectionServerProfile.getProfileId() + ", ");
            stringBuffer.append(collectionServerProfile.getCollectionId() + ", ");
            stringBuffer.append(collectionServerProfile.getSpsNum() + ", ");
            stringBuffer.append(collectionServerProfile.getExportPriv() + ", ");
            stringBuffer.append(collectionServerProfile.getExportPresentationPriv() + ", ");
            stringBuffer.append(this.convertToInt(collectionServerProfile.getEditPriv()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerProfile.getEditVocabPriv()) + ", ");
            stringBuffer.append(collectionServerProfile.getEditMaxViewableSize() + ", ");
            stringBuffer.append(this.convertToInt(collectionServerProfile.getHtmlExport()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerProfile.getSaveGroups()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerProfile.getDeleteGroups()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerProfile.getEditLinkPriv()) + ", ");
            stringBuffer.append(this.convertToInt(collectionServerProfile.getEditMviPriv()));
            if (this.supportsMpd) {
                stringBuffer.append(", " + this.convertToInt(collectionServerProfile.getEditMpdPriv()));
            }
            if (this.supportsMede) {
                stringBuffer.append(", " + collectionServerProfile.getApprovalLevel());
                stringBuffer.append(", " + collectionServerProfile.getMedePermissions());
            }
            stringBuffer.append(", " + this.prepForInsertQuery(collectionServerProfile.getDisplayName()));
            stringBuffer.append(", " + this.convertToInt(collectionServerProfile.editPersonalCollections) + ");");
            databaseConnector.setQuery(stringBuffer.toString());
            this.debugOut("insertProfileQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        CollectionServerProfile collectionServerProfile = (CollectionServerProfile)databaseRecord;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM IRPROFILE WHERE (ProfileID = " + collectionServerProfile.getProfileId() + " AND CollectionID = " + collectionServerProfile.getCollectionId() + ");";
            databaseConnector.setQuery(string);
            this.debugOut("deleteProfileQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        return this.getRecords(-1);
    }

    public Vector getRecords(int n) {
        return this.getRecords(n, false);
    }

    public Vector getRecords(int n, boolean bl) {
        this.debugOut("in getRecords()");
        Vector<CollectionServerProfile> vector = new Vector<CollectionServerProfile>();
        int n2 = n;
        this.getSupportsMpd();
        this.getSupportsMede();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRPROFILE", null, "*");
            if (n2 != -1) {
                sqlQueryGenerator.appendToWhere("IRPROFILE.CollectionID = " + n2);
            }
            sqlQueryGenerator.addOrderBy("IRPROFILE", "ProfileID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Profiles query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    boolean bl2 = false;
                    try {
                        bl2 = databaseConnector.getIntegerFieldByName("EditMpdPriv") == 1;
                    }
                    catch (Exception exception) {
                        this.debugOut("Caught the editMpdPrivValue exception because the column does not exist");
                        this.supportsMpd = false;
                        bl2 = false;
                    }
                    int n3 = 0;
                    int n4 = 0;
                    try {
                        n3 = databaseConnector.getIntegerFieldByName("ApprovalLevel");
                        n4 = databaseConnector.getIntegerFieldByName("MEDEPermissions");
                    }
                    catch (Exception exception) {
                        this.debugOut("Caught the ApprovalLevel exception because the column does not exist");
                        this.supportsMede = false;
                        n3 = 0;
                        n4 = 0;
                    }
                    if (!bl) {
                        CollectionServerProfile collectionServerProfile = new CollectionServerProfile((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ProfileID"), databaseConnector.getIntegerFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("SaveGroups") == 1, databaseConnector.getIntegerFieldByName("DeleteGroups") == 1, databaseConnector.getIntegerFieldByName("SpsNum"), databaseConnector.getIntegerFieldByName("ExportPriv"), databaseConnector.getIntegerFieldByName("ExportPresentationPriv"), 0, databaseConnector.getIntegerFieldByName("EditPriv") == 1, databaseConnector.getIntegerFieldByName("EditVocabPriv") == 1, databaseConnector.getIntegerFieldByName("MaxViewableSize"), databaseConnector.getIntegerFieldByName("HtmlExport") == 1, databaseConnector.getIntegerFieldByName("EditLinkPriv") == 1, databaseConnector.getIntegerFieldByName("EditMviPriv") == 1, bl2, this.supportsMpd, databaseConnector.getFieldByName("DisplayName"), this.supportsMede, n3, n4, databaseConnector.getBooleanField("EditPersonalCollections", false));
                        vector.addElement(collectionServerProfile);
                    } else {
                        CcMedeProfile ccMedeProfile = new CcMedeProfile((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ProfileID"), databaseConnector.getIntegerFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("SaveGroups") == 1, databaseConnector.getIntegerFieldByName("DeleteGroups") == 1, databaseConnector.getIntegerFieldByName("SpsNum"), databaseConnector.getIntegerFieldByName("ExportPriv"), databaseConnector.getIntegerFieldByName("ExportPresentationPriv"), 0, databaseConnector.getIntegerFieldByName("EditPriv") == 1, databaseConnector.getIntegerFieldByName("EditVocabPriv") == 1, databaseConnector.getIntegerFieldByName("MaxViewableSize"), databaseConnector.getIntegerFieldByName("HtmlExport") == 1, databaseConnector.getIntegerFieldByName("EditLinkPriv") == 1, databaseConnector.getIntegerFieldByName("EditMviPriv") == 1, bl2, this.supportsMpd, databaseConnector.getFieldByName("DisplayName"), this.supportsMede, n3, n4, databaseConnector.getBooleanField("EditPersonalCollections", false));
                        vector.addElement(ccMedeProfile);
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CollectionServerProfile collectionServerProfile = null;
        int n = ((CollectionServerProfile)databaseRecord).getProfileId();
        int n2 = ((CollectionServerProfile)databaseRecord).getCollectionId();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRPROFILE", null, "*");
            sqlQueryGenerator.appendToWhere("IRPROFILE.ProfileID = " + n + " AND " + "IRPROFILE" + ".CollectionID = " + n2);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Profile query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                boolean bl = false;
                try {
                    bl = databaseConnector.getIntegerFieldByName("EditMpdPriv") == 1;
                }
                catch (Exception exception) {
                    this.debugOut("Caught the editMpdPrivValue exception in getRecord(record) because the column does not exist");
                    this.supportsMpd = false;
                    bl = false;
                }
                int n3 = 0;
                int n4 = 0;
                try {
                    n3 = databaseConnector.getIntegerFieldByName("ApprovalLevel");
                    n4 = databaseConnector.getIntegerFieldByName("MEDEPermissions");
                }
                catch (Exception exception) {
                    this.debugOut("Caught the ApprovalLevel exception in getRecord(record) because the column does not exist");
                    this.supportsMede = false;
                    n3 = 0;
                    n4 = 0;
                }
                collectionServerProfile = new CollectionServerProfile((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ProfileID"), databaseConnector.getIntegerFieldByName("CollectionID"), databaseConnector.getIntegerFieldByName("SaveGroups") == 1, databaseConnector.getIntegerFieldByName("DeleteGroups") == 1, databaseConnector.getIntegerFieldByName("SpsNum"), databaseConnector.getIntegerFieldByName("ExportPriv"), databaseConnector.getIntegerFieldByName("ExportPresentationPriv"), 0, databaseConnector.getIntegerFieldByName("EditPriv") == 1, databaseConnector.getIntegerFieldByName("EditVocabPriv") == 1, databaseConnector.getIntegerFieldByName("MaxViewableSize"), databaseConnector.getIntegerFieldByName("HtmlExport") == 1, databaseConnector.getIntegerFieldByName("EditLinkPriv") == 1, databaseConnector.getIntegerFieldByName("EditMviPriv") == 1, bl, this.supportsMpd, databaseConnector.getFieldByName("DisplayName"), this.supportsMede, n3, n4, databaseConnector.getBooleanField("EditPersonalCollections", false));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        return collectionServerProfile;
    }

    public String getNextValidIDQuery() {
        return "SELECT ProfileID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRPROFILE" + " ORDER BY ProfileID";
    }

    public void updateMaxIDValue(long l) {
    }

    public boolean getSupportsMpd() {
        return true;
    }

    public boolean getSupportsMede() {
        return true;
    }
}

