/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.profile;

import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.NodeChild;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.admin.collserver.profile.CollectionServerProfileNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CollectionServerProfileNodeChild
extends TableDisplayControlPanelNode
implements ActionListener,
NodeChild {
    protected CollectionServerNode collectionServerNode = null;
    protected int highestProfileId = 0;
    protected int collectionId = -1;
    protected boolean supportsMpd = true;
    protected boolean supportsMede = true;

    public CollectionServerProfileNodeChild(InsightAdministrator insightAdministrator, CollectionServerProfileNode collectionServerProfileNode, int n, String string, boolean bl) {
        super(insightAdministrator, string, bl);
        this.collectionId = n;
        this.name = string;
        this.collectionServerNode = collectionServerProfileNode.getCollectionServerNode();
        this.columnNames = string.equals("Personal Collections") ? new Object[]{"ProfileID", "Display Name", "Save Groups", "Delete Groups", "SPSNum", "Export", "Export Presentation", "Edit Virtual Collections", "Max Size", "Source Export", "HTML Eport", "EditLink", "EditMvi", "EditMpd", "Edit Personal Collections"} : new Object[]{"ProfileID", "Display Name", "Save Groups", "Delete Groups", "SPSNum", "Export", "Export Presentation", "Edit Virtual Collections", "Max Size", "Source Export", "HTML Eport", "EditLink", "EditMvi", "EditMpd"};
    }

    public int getDeterminantIndex() {
        return this.collectionId;
    }

    public void updateInformationDisplay() {
        if (this.tableModel == null) {
            this.createInformationModel();
        }
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getProfiles(this.collectionId)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        if (vector.size() == 0) {
            this.supportsMpd = this.collectionServerNode.getCollectionServer().getCollectionServerConnector().getSupportsMpd();
        }
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerProfile collectionServerProfile = (CollectionServerProfile)vector.elementAt(i);
            this.supportsMpd = collectionServerProfile.getSupportsMpd();
            objectArray[i][0] = collectionServerProfile;
            this.highestProfileId = Math.max(this.highestProfileId, Integer.parseInt(collectionServerProfile.toString()));
            objectArray[i][1] = collectionServerProfile.getDisplayName();
            objectArray[i][2] = new Boolean(collectionServerProfile.getSaveGroups());
            objectArray[i][3] = new Boolean(collectionServerProfile.getDeleteGroups());
            objectArray[i][4] = new Integer(collectionServerProfile.getSpsNum());
            objectArray[i][5] = this.convertExportPriv(collectionServerProfile.getExportPriv());
            objectArray[i][6] = this.convertExportPresentationPriv(collectionServerProfile.getExportPresentationPriv());
            objectArray[i][7] = new Boolean(collectionServerProfile.isEditVC());
            objectArray[i][8] = this.convertExportPriv(collectionServerProfile.getEditMaxViewableSize());
            objectArray[i][9] = new Boolean(collectionServerProfile.isExportSource());
            objectArray[i][10] = new Boolean(collectionServerProfile.getHtmlExport());
            objectArray[i][11] = new Boolean(collectionServerProfile.getEditLinkPriv());
            objectArray[i][12] = new Boolean(collectionServerProfile.getEditMviPriv());
            objectArray[i][13] = new Boolean(collectionServerProfile.getEditMpdPriv());
            if (!this.name.equals("Personal Collections")) continue;
            objectArray[i][14] = new Boolean(collectionServerProfile.editPersonalCollections);
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New Profile Command", this));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-profiles-node-child-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setActionCommand("New Profile Command");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Edit");
        jMenuItem.setActionCommand("Edit Profile Command");
        jMenuItem.addActionListener(actionListener);
        if (n != 1) {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.setActionCommand("Delete Profile Command");
        jMenuItem.addActionListener(actionListener);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Profile Command")) {
            CollectionServerProfileNodeChild.debugOut("in actionPerformed, CollectionServerNode.COMMAND_NEW_PROFILE");
            int n = this.collectionServerNode.getCollectionServer().getCollectionServerConnector().getNextValidProfileID();
            this.collectionServerNode.getCollectionServer().addDataObject(new CollectionServerProfile(this.collectionServerNode.getCollectionServer(), n, this.collectionId, this.supportsMpd, this.supportsMede));
        } else if (string.equals("Delete Profile Command")) {
            CollectionServerProfileNodeChild.debugOut("in actionPerformed, CollectionServerNode.COMMAND_DELETE_PROFILE");
            if (vector != null && vector.size() > 0) {
                this.collectionServerNode.removeProfile(vector);
            }
        } else if (string.equals("Edit Profile Command")) {
            CollectionServerProfileNodeChild.debugOut("in actionPerformed, CollectionServerNode.COMMAND_EDIT_PROFILE");
            if (vector != null && vector.size() == 1) {
                this.collectionServerNode.editProfile((CollectionServerProfile)vector.firstElement());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("New Profile Command")) {
            this.actionPerformed("New Profile Command", new Vector());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null && object instanceof EditableDataObject) {
            this.collectionServerNode.editProfile((CollectionServerProfile)object);
        }
    }

    private String convertExportPriv(int n) {
        String string = "";
        if (n == 0) {
            string = "up to 96 pixels";
        } else if (n == 1) {
            string = "up to 192 pixels";
        } else if (n == 2) {
            string = "up to 384 pixels";
        } else if (n == 3) {
            string = "up to 768 pixels";
        } else if (n == 4) {
            string = "up to 1536 pixels";
        } else if (n == 5) {
            string = "up to 3072 pixels";
        } else if (n == 6) {
            string = "up to 6144 pixels";
        } else if (n == 7) {
            string = "up to 12288 pixels";
        } else if (n == 8) {
            string = "up to 24576 pixels";
        }
        return string;
    }

    private String convertExportPresentationPriv(int n) {
        String string = "";
        if (n == 0) {
            string = "None";
        } else if (n == 1) {
            string = "640 X 480";
        } else if (n == 2) {
            string = "800 X 600";
        } else if (n == 3) {
            string = "1024 X 768";
        } else if (n == 4) {
            string = "1152 X 864";
        } else if (n == 5) {
            string = "1280 X 960";
        } else if (n == 6) {
            string = "1280 X 1024";
        } else if (n == 7) {
            string = "1600 X 1024";
        } else if (n == 8) {
            string = "1600 X 1200";
        }
        return string;
    }

    public String toString() {
        return this.name;
    }

    public static void debugOut(String string) {
        CollectionServerProfileNodeChild.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerProfileNodeChild: " + string, n);
    }
}

