/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.profile;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.NodeChildConstituent;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.config.CollectionServerConfigurationEditComponent;
import com.luna.insight.admin.collserver.profile.CollectionServerProfileEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.inscribe.MedePrivileges;
import com.luna.insight.server.profile.CollectionProfile;
import javax.swing.ImageIcon;

public class CollectionServerProfile
extends EditableDataObject
implements DatabaseRecord,
NodeChildConstituent {
    public static final String PERSONAL_COLLECTIONS = "Personal Collections";
    protected CollectionServer collectionServer = null;
    public int profileId = -1;
    public int collectionId = -1;
    public boolean saveGroups = false;
    public boolean deleteGroups = false;
    public int spsNum = -1;
    public int exportPriv = 8;
    public int exportPresentationPriv = 8;
    public int printPriv = 0;
    public boolean editPriv = false;
    public boolean editVocabPriv = false;
    public int editMaxViewableSize = 8;
    public boolean editPersonalCollections = false;
    public boolean htmlExport = false;
    public boolean editLinkPriv = false;
    public boolean editMviPriv = false;
    public boolean editMpdPriv = false;
    public boolean supportsMpd = true;
    public String displayName = "";
    public boolean supportsMede = true;
    public int approvalLevel = 0;
    public int medePermissions = 0;
    private CollectionServerProfileEditComponent editComponent = null;
    public CollectionServerConfigurationEditComponent configurationEditComponent = null;

    public CollectionServerProfile(CollectionProfile collectionProfile, Integer n) {
        this.profileId = collectionProfile.getId();
        this.collectionId = n;
        this.saveGroups = collectionProfile.isSaveGroup();
        this.deleteGroups = collectionProfile.isDeleteGroup();
        this.spsNum = collectionProfile.getSps();
        this.exportPriv = collectionProfile.getMaxExportSize();
        this.exportPresentationPriv = collectionProfile.getMaxPresentationExportSize();
        this.printPriv = collectionProfile.isPrint() ? 1 : 0;
        this.editPriv = collectionProfile.isEdit();
        this.editVocabPriv = collectionProfile.isEditVocab();
        this.editMaxViewableSize = collectionProfile.getMaxViewableSize();
        this.htmlExport = collectionProfile.isHTMLExport();
        this.editLinkPriv = collectionProfile.isEditLink();
        this.editMviPriv = collectionProfile.isEditMVI();
        this.editMpdPriv = collectionProfile.isEditMPD();
        this.supportsMede = true;
        this.supportsMpd = true;
        this.approvalLevel = collectionProfile.getApprovalLevel();
        this.medePermissions = collectionProfile.getMedePermissions();
        this.editPersonalCollections = collectionProfile.isEditPersonalCollections();
        this.displayName = collectionProfile.getDisplayName();
    }

    public CollectionServerProfile(CollectionServer collectionServer, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, boolean bl3, boolean bl4, int n7, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string, boolean bl10, int n8, int n9, boolean bl11) {
        this.collectionServer = collectionServer;
        this.profileId = n;
        this.collectionId = n2;
        this.saveGroups = bl;
        this.deleteGroups = bl2;
        this.spsNum = n3;
        this.exportPriv = n4;
        this.exportPresentationPriv = n5;
        this.printPriv = n6;
        this.editPriv = bl3;
        this.editVocabPriv = bl4;
        this.editMaxViewableSize = n7;
        this.htmlExport = bl5;
        this.editLinkPriv = bl6;
        this.editMviPriv = bl7;
        this.editMpdPriv = bl8;
        this.editPersonalCollections = bl11;
        this.supportsMpd = bl9;
        if (!bl9) {
            bl8 = false;
        }
        this.approvalLevel = n8;
        this.medePermissions = n9;
        this.supportsMede = bl10;
        if (!bl10) {
            this.approvalLevel = 0;
            this.medePermissions = 0;
        }
        this.displayName = string != null ? string : "";
    }

    public CollectionServerProfile(CollectionServer collectionServer, int n, int n2, boolean bl, boolean bl2) {
        this.collectionServer = collectionServer;
        this.profileId = n;
        this.collectionId = n2;
        this.supportsMpd = bl;
        if (!bl) {
            this.editMpdPriv = false;
        }
        this.supportsMede = bl2;
        if (!bl2) {
            this.approvalLevel = 0;
            this.medePermissions = 0;
        }
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CollectionServerProfileEditComponent();
        if (this.collectionId != 0) {
            this.editComponent.getEditPCPriv().setVisible(false);
            this.editComponent.getAllowEditingPCLabel().setVisible(false);
        }
        this.editComponent.getDisplayNameField().setText(this.displayName);
        this.editComponent.getSaveGroups().setSelected(this.saveGroups);
        this.editComponent.getDeleteGroups().setSelected(this.deleteGroups);
        if (this.spsNum != -1) {
            this.editComponent.getSpsNum().setText("" + this.spsNum);
        }
        this.editComponent.getExportPriv().addItem(new String("up to    96 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to   192 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to   384 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to   768 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to  1536 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to  3072 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to  6144 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to 12288 pixels"));
        this.editComponent.getExportPriv().addItem(new String("up to 24576 pixels"));
        this.editComponent.getExportPriv().setSelectedIndex(this.exportPriv);
        this.editComponent.getExportPresentationPriv().addItem(new String("None"));
        this.editComponent.getExportPresentationPriv().addItem(new String("640 X 480"));
        this.editComponent.getExportPresentationPriv().addItem(new String("800 X 600"));
        this.editComponent.getExportPresentationPriv().addItem(new String("1024 X 768"));
        this.editComponent.getExportPresentationPriv().addItem(new String("1152 X 864"));
        this.editComponent.getExportPresentationPriv().addItem(new String("1280 X 960"));
        this.editComponent.getExportPresentationPriv().addItem(new String("1280 X 1024"));
        this.editComponent.getExportPresentationPriv().addItem(new String("1600 X 1024"));
        this.editComponent.getExportPresentationPriv().addItem(new String("1600 X 1200"));
        this.editComponent.getExportPresentationPriv().setSelectedIndex(this.exportPresentationPriv);
        this.editComponent.getEditVCPriv().setSelected(MedePrivileges.hasMedePrivilege(this.medePermissions, 128));
        this.editComponent.getExportSourcePriv().setSelected(MedePrivileges.hasMedePrivilege(this.medePermissions, 256));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to    96 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to   192 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to   384 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to   768 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to  1536 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to  3072 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to  6144 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to 12288 pixels"));
        this.editComponent.getEditMaxViewableSize().addItem(new String("up to 24576 pixels"));
        this.editComponent.getEditMaxViewableSize().setSelectedIndex(this.editMaxViewableSize);
        this.editComponent.getHtmlExport().setSelected(this.htmlExport);
        this.editComponent.getEditLinkPriv().setSelected(this.editLinkPriv);
        this.editComponent.getEditMviPriv().setSelected(this.editMviPriv);
        this.editComponent.getEditMpdPriv().setSelected(this.editMpdPriv);
        this.editComponent.getEditMpdPriv().setEnabled(this.supportsMpd);
        this.editComponent.getEditPCPriv().setSelected(this.editPersonalCollections);
        return this.editComponent;
    }

    public void save() {
        CollectionServerProfile.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.editPersonalCollections, this.editComponent.getEditPCPriv().isSelected())) {
            this.editPersonalCollections = this.editComponent.getEditPCPriv().isSelected();
        }
        if (this.hasChanged(this.displayName, this.editComponent.getDisplayNameField().getText())) {
            this.displayName = this.editComponent.getDisplayNameField().getText();
        }
        if (this.hasChanged(new Boolean(this.saveGroups), new Boolean(this.editComponent.getSaveGroups().isSelected()))) {
            this.saveGroups = this.editComponent.getSaveGroups().isSelected();
        }
        if (this.hasChanged(new Boolean(this.deleteGroups), new Boolean(this.editComponent.getDeleteGroups().isSelected()))) {
            this.deleteGroups = this.editComponent.getDeleteGroups().isSelected();
        }
        if (this.hasChanged(new Integer(this.spsNum), new Integer(Integer.parseInt(this.editComponent.getSpsNum().getText())))) {
            this.spsNum = Integer.parseInt(this.editComponent.getSpsNum().getText());
        }
        if (this.hasChanged(this.exportPriv, this.editComponent.getExportPriv().getSelectedIndex())) {
            this.exportPriv = this.editComponent.getExportPriv().getSelectedIndex();
        }
        if (this.hasChanged(this.exportPresentationPriv, this.editComponent.getExportPresentationPriv().getSelectedIndex())) {
            this.exportPresentationPriv = this.editComponent.getExportPresentationPriv().getSelectedIndex();
        }
        boolean bl = this.editComponent.getEditVCPriv().isSelected();
        if (this.hasChanged(new Boolean(MedePrivileges.hasMedePrivilege(this.medePermissions, 128)), new Boolean(bl))) {
            this.medePermissions = bl ? MedePrivileges.addPrivileges(this.medePermissions, 128) : MedePrivileges.removePrivileges(this.medePermissions, 128);
        }
        boolean bl2 = this.editComponent.getExportSourcePriv().isSelected();
        if (this.hasChanged(new Boolean(MedePrivileges.hasMedePrivilege(this.medePermissions, 256)), new Boolean(bl2))) {
            this.medePermissions = bl2 ? MedePrivileges.addPrivileges(this.medePermissions, 256) : MedePrivileges.removePrivileges(this.medePermissions, 256);
        }
        if (this.hasChanged(this.editMaxViewableSize, this.editComponent.getEditMaxViewableSize().getSelectedIndex())) {
            this.editMaxViewableSize = this.editComponent.getEditMaxViewableSize().getSelectedIndex();
        }
        if (this.hasChanged(new Boolean(this.htmlExport), new Boolean(this.editComponent.getHtmlExport().isSelected()))) {
            this.htmlExport = this.editComponent.getHtmlExport().isSelected();
        }
        if (this.hasChanged(new Boolean(this.editLinkPriv), new Boolean(this.editComponent.getEditLinkPriv().isSelected()))) {
            this.editLinkPriv = this.editComponent.getEditLinkPriv().isSelected();
        }
        if (this.hasChanged(new Boolean(this.editMviPriv), new Boolean(this.editComponent.getEditMviPriv().isSelected()))) {
            this.editMviPriv = this.editComponent.getEditMviPriv().isSelected();
        }
        if (this.hasChanged(new Boolean(this.editMpdPriv), new Boolean(this.editComponent.getEditMpdPriv().isSelected()))) {
            this.editMpdPriv = this.editComponent.getEditMpdPriv().isSelected();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CollectionServerProfile.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Editing Profile";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-profiles-node-icon.gif");
    }

    public int getIndex() {
        return -1;
    }

    public int getParentNodeID() {
        return this.collectionId;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerProfile) {
            CollectionServerProfile collectionServerProfile = (CollectionServerProfile)databaseRecord;
            return this.displayName.equals(collectionServerProfile.displayName) && this.profileId == collectionServerProfile.profileId && this.collectionId == collectionServerProfile.collectionId && this.saveGroups == collectionServerProfile.saveGroups && this.deleteGroups == collectionServerProfile.deleteGroups && this.spsNum == collectionServerProfile.spsNum && this.exportPriv == collectionServerProfile.exportPriv && this.exportPresentationPriv == collectionServerProfile.exportPresentationPriv && this.editPriv == collectionServerProfile.editPriv && this.editVocabPriv == collectionServerProfile.editVocabPriv && this.editMaxViewableSize == collectionServerProfile.editMaxViewableSize && this.htmlExport == collectionServerProfile.htmlExport && this.editLinkPriv == collectionServerProfile.editLinkPriv && this.editMviPriv == collectionServerProfile.editMviPriv && this.editMpdPriv == collectionServerProfile.editMpdPriv && this.editPersonalCollections == collectionServerProfile.editPersonalCollections;
        }
        return false;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public int getCollectionId() {
        return this.collectionId;
    }

    public boolean getSaveGroups() {
        return this.saveGroups;
    }

    public boolean getDeleteGroups() {
        return this.deleteGroups;
    }

    public int getSpsNum() {
        return this.spsNum;
    }

    public int getExportPriv() {
        return this.exportPriv;
    }

    public int getExportPresentationPriv() {
        return this.exportPresentationPriv;
    }

    public int getPrintPriv() {
        return this.printPriv;
    }

    public boolean getEditPriv() {
        return this.editPriv;
    }

    public boolean getEditVocabPriv() {
        return this.editVocabPriv;
    }

    public int getEditMaxViewableSize() {
        return this.editMaxViewableSize;
    }

    public boolean getHtmlExport() {
        return this.htmlExport;
    }

    public boolean getEditLinkPriv() {
        return this.editLinkPriv;
    }

    public boolean getEditMviPriv() {
        return this.editMviPriv;
    }

    public boolean getEditMpdPriv() {
        return this.editMpdPriv;
    }

    public boolean getSupportsMpd() {
        return this.supportsMpd;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean getSupportsMede() {
        return this.supportsMede;
    }

    public int getApprovalLevel() {
        return this.approvalLevel;
    }

    public int getMedePermissions() {
        return this.medePermissions;
    }

    public boolean isEditVC() {
        return MedePrivileges.hasMedePrivilege(this.medePermissions, 128);
    }

    public boolean isExportSource() {
        return MedePrivileges.hasMedePrivilege(this.medePermissions, 256);
    }

    public String toString() {
        return new String("" + this.profileId);
    }

    public String getUniqueIdentifier() {
        return this.profileId + "_" + this.collectionId;
    }

    public static void debugOut(String string) {
        CollectionServerProfile.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerProfile: " + string, n);
    }
}

