/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.server.Debug;
import java.util.List;
import java.util.Vector;

public class PageContainer {
    protected static final int PAGE_SIZE = 50;
    protected String objectType = "";
    protected List results;
    protected int resultCount = 0;
    protected int start = 0;
    protected int length = 50;
    protected int page = 1;
    protected int totalPages = 1;

    public static void debugOut(String string) {
        Debug.debugOut("PageContainer: " + string, 2);
    }

    public PageContainer(String string) {
        this.objectType = string;
    }

    public void setResults(List list) {
        this.results = list;
        this.resultCount = list != null ? list.size() : 0;
        this.getPageCount(true);
        this.setPage(1);
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        if (n >= 0 && n < this.getResultCount()) {
            this.setPage(this.getPageNumber(n));
        }
    }

    public int getPosition() {
        return this.start + 1;
    }

    public int getLength() {
        return this.length;
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getPageNumber(int n) {
        if (n >= 0) {
            return n / 50 + 1;
        }
        return 1;
    }

    public int getPageNumber(Object object) {
        return this.getPageNumber(this.results != null ? this.results.indexOf(object) : -1);
    }

    public int getPageCount() {
        return this.getPageCount(false);
    }

    public int getPageCount(boolean bl) {
        if (bl) {
            this.totalPages = this.getResultCount() / 50;
            if (this.getResultCount() % 50 > 0) {
                ++this.totalPages;
            }
        }
        return this.totalPages;
    }

    public void prevPage() {
        this.setPage(this.page - 1);
    }

    public void nextPage() {
        this.setPage(this.page + 1);
    }

    public void setPage(int n) {
        if (n > 0 && n <= this.getPageCount()) {
            this.start = this.getPageStartPosition(n);
            this.page = n;
            this.length = this.getResultCount() - this.start;
            if (this.length > 50) {
                this.length = 50;
            }
        }
    }

    public List getPage() {
        Vector vector = new Vector(this.length);
        for (int i = this.start; i < this.start + this.length && i < this.results.size(); ++i) {
            vector.add(this.results.get(i));
        }
        return vector;
    }

    public int getPageStartPosition(int n) {
        if (n > this.getPageCount()) {
            return 0;
        }
        if (n > 1) {
            return (n - 1) * 50;
        }
        return 0;
    }

    public String getRangeData() {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.getResultCount() > 0) {
            int n = this.getPosition();
            stringBuffer.append(this.objectType + "s ");
            stringBuffer.append(n);
            stringBuffer.append(" - ");
            stringBuffer.append(n + this.getLength() - 1);
            stringBuffer.append(" of ");
            stringBuffer.append(this.getResultCount());
        } else {
            stringBuffer.append("No " + this.objectType.toLowerCase() + "s");
        }
        return stringBuffer.toString();
    }

    public String getPageData() {
        return this.getPageData(true);
    }

    public String getPageData(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.getResultCount() > 0) {
            int n = this.getPageNumber();
            int n2 = this.getPageCount();
            stringBuffer.append(n + " of " + n2);
            if (bl) {
                stringBuffer.append(n2 > 1 ? " pages" : " page");
            }
        }
        return stringBuffer.toString();
    }
}

