/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.AdminDesktopPane;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecordThumbnail;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaThumbnailLoader;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingEditComponent;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecordThumbnail;
import com.luna.insight.admin.manytomanymap.MappedThumbnail;
import com.luna.insight.server.FieldValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CcThumbnailDetailWindow
extends JInternalFrame
implements KeyListener,
FocusListener {
    public static final int LARGE_THUMBNAIL_RESOLUTION = 2;
    protected CcObjectMediaMappingEditComponent controller;
    protected MappedThumbnail thumb;
    protected JScrollPane scroller = null;
    protected JPanel internalPanel = null;

    public CcThumbnailDetailWindow(CcObjectMediaMappingEditComponent ccObjectMediaMappingEditComponent, MappedThumbnail mappedThumbnail) {
        super("Expanded View", true, true, true, true);
        this.controller = ccObjectMediaMappingEditComponent;
        this.thumb = mappedThumbnail;
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                CcThumbnailDetailWindow.this.close();
            }
        });
        ImageIcon imageIcon = ccObjectMediaMappingEditComponent.getWindowIcon();
        if (imageIcon != null) {
            this.setFrameIcon(imageIcon);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.scroller = new JScrollPane();
        this.getContentPane().add((Component)this.scroller, "Center");
        this.internalPanel = new JPanel(new BorderLayout(2, 2));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        if (mappedThumbnail instanceof CcObjectRecordThumbnail) {
            this.setTitle("Expanded Object View - " + ((CcObjectRecordThumbnail)mappedThumbnail).getObjectID());
            jLabel.setText("Loading object " + ((CcObjectRecordThumbnail)mappedThumbnail).getObjectID() + " record data.");
        } else {
            this.setTitle("Expanded Image View - " + ((CcMediaRecordThumbnail)mappedThumbnail).getImageID());
            jLabel.setText("Loading larger image.");
        }
        this.internalPanel.add((Component)jLabel, "Center");
        this.scroller.getViewport().add(this.internalPanel);
        this.scroller.getViewport().doLayout();
        this.scroller.getVerticalScrollBar().setUnitIncrement(10);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(10);
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            MetalLookAndFeel cfr_ignored_0 = (MetalLookAndFeel)UIManager.getLookAndFeel();
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        }
        this.scroller.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, colorUIResource));
        this.pack();
        Dimension dimension = new Dimension(CcBatchProfileResolution.PIXEL_SIZES[2] + 25, CcBatchProfileResolution.PIXEL_SIZES[2] + 25);
        int n = new JScrollBar().getPreferredSize().width;
        this.setPreferredSize(new Dimension(dimension.width + n, dimension.height + n));
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public MappedThumbnail getThumbnail() {
        return this.thumb;
    }

    public void show() {
        AdminDesktopPane adminDesktopPane = InsightAdministrator.getInsightAdministrator().getDesktop();
        adminDesktopPane.add(this);
        super.show();
    }

    public void startLoading() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (CcThumbnailDetailWindow.this.thumb instanceof CcObjectRecordThumbnail) {
                    CcThumbnailDetailWindow.this.loadObjectData((CcObjectRecordThumbnail)CcThumbnailDetailWindow.this.thumb);
                } else if (CcThumbnailDetailWindow.this.thumb instanceof CcMediaRecordThumbnail) {
                    CcThumbnailDetailWindow.this.loadImageData((CcMediaRecordThumbnail)CcThumbnailDetailWindow.this.thumb);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setSelected(boolean bl) {
        try {
            super.setSelected(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestFocus();
    }

    public void close() {
        this.closeDialog(null);
        this.controller.windowClosed(this);
    }

    protected void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    protected void loadObjectData(CcObjectRecordThumbnail ccObjectRecordThumbnail) {
        FieldValue fieldValue;
        int n;
        CcObjectRecord ccObjectRecord = ccObjectRecordThumbnail.getObjectRecord();
        List list = this.controller.getServer().getCollectionServerConnector().getObjectData(ccObjectRecord);
        this.internalPanel.removeAll();
        boolean bl = true;
        for (n = 0; list != null && n < list.size(); ++n) {
            fieldValue = (FieldValue)list.get(n);
            if (fieldValue.value == null || fieldValue.value.length() <= 0) continue;
            bl = false;
            break;
        }
        n = new JLabel((String)"BLAH").getPreferredSize().height;
        if (bl) {
            this.internalPanel.setLayout(new GridLayout(1, 1, 5, 5));
            JLabel jLabel = new JLabel("No data for object " + ccObjectRecord.getObjectID() + ".");
            jLabel.setSize(jLabel.getPreferredSize().width, n * 2);
            jLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
            jLabel.setHorizontalAlignment(2);
            jLabel.setVerticalAlignment(0);
            this.internalPanel.add(jLabel);
        } else {
            this.internalPanel.setLayout(new BorderLayout(0, 0));
            JPanel jPanel = new JPanel(new GridLayout(list == null ? 0 : list.size(), 1, 0, 5));
            JPanel jPanel2 = new JPanel(new GridLayout(list == null ? 0 : list.size(), 1, 0, 5));
            for (int i = 0; list != null && i < list.size(); ++i) {
                fieldValue = (FieldValue)list.get(i);
                JLabel jLabel = new JLabel(fieldValue.displayName + ":   ");
                JLabel jLabel2 = new JLabel(fieldValue.value);
                if (i == 0) {
                    jLabel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MetalLookAndFeel.getPrimaryControl()), new EmptyBorder(2, 2, 0, 2)));
                } else if (i == list.size() - 1) {
                    jLabel.setBorder(new EmptyBorder(0, 2, 2, 2));
                } else {
                    jLabel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MetalLookAndFeel.getPrimaryControl()), new EmptyBorder(0, 2, 0, 2)));
                }
                jLabel2.setBorder(jLabel.getBorder());
                jPanel.add(jLabel);
                jPanel2.add(jLabel2);
            }
            this.internalPanel.add((Component)jPanel, "West");
            this.internalPanel.add((Component)jPanel2, "Center");
        }
        this.refreshLayout();
    }

    protected void loadImageData(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        CcMediaRecord ccMediaRecord = ccMediaRecordThumbnail.getImageRecord();
        String string = this.controller.getServer().getCollectionServerConnector().getImageFileUrl(ccMediaRecord, 2);
        ImageIcon imageIcon = CcMediaThumbnailLoader.getImage(string);
        JLabel jLabel = new JLabel(imageIcon);
        this.internalPanel.removeAll();
        this.internalPanel.setLayout(new BorderLayout(0, 0));
        this.internalPanel.add((Component)jLabel, "Center");
        this.refreshLayout();
    }

    protected void refreshLayout() {
        this.scroller.doLayout();
        this.scroller.getViewport().doLayout();
        this.internalPanel.doLayout();
        this.scroller.getViewport().doLayout();
        this.scroller.invalidate();
        this.scroller.validate();
        this.scroller.repaint();
        this.scroller.getVerticalScrollBar().repaint();
        this.scroller.getHorizontalScrollBar().repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            Rectangle rectangle = component.getBounds();
            Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), rectangle, this.scroller.getViewport());
            this.scroller.getViewport().scrollRectToVisible(rectangle2);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.close();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

