/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingEditComponent;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class CcObjectRecordFieldsSelector
extends JPanel
implements ActionListener {
    protected static final int OBJECT_RECORD_FIELDS = 2;
    protected static final String APPLY_FIELDS_COMMAND = "apply-fields-command";
    protected static final String CANCEL_COMMAND = "cancel-command";
    protected static final Dimension DEFAULT_SIZE = new Dimension(310, 120);
    protected List fields;
    protected CcObjectMediaMappingEditComponent objMedEditComponent;
    protected JLabel fieldSelectionLabel;
    protected List fieldSelectionBoxes = new Vector(2);
    protected JPanel fieldSelectionBoxPanel;
    protected JButton applyFieldsButton;
    protected JButton cancelButton;

    public static void debugOut(String string) {
        CcObjectRecordFieldsSelector.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcObjectRecordFieldsSelector: " + string, n);
    }

    public CcObjectRecordFieldsSelector(List list) {
        this.fields = list;
        this.initComponents();
    }

    public void setObjectMediaMappingEditComponent(CcObjectMediaMappingEditComponent ccObjectMediaMappingEditComponent) {
        this.objMedEditComponent = ccObjectMediaMappingEditComponent;
    }

    protected void initComponents() {
        this.setLayout(null);
        this.setSize(DEFAULT_SIZE);
        this.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.black)));
        this.fieldSelectionLabel = this.createLabel("Select the object record fields.");
        this.fieldSelectionLabel.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.black), new EmptyBorder(0, 4, 0, 0)));
        this.fieldSelectionBoxPanel = new JPanel(new VerticalStackResizeWidthLayout(2)){

            public void doLayout() {
                super.doLayout();
                for (int i = 0; i < CcObjectRecordFieldsSelector.this.fieldSelectionBoxes.size(); ++i) {
                    ((JComboBox)CcObjectRecordFieldsSelector.this.fieldSelectionBoxes.get(i)).doLayout();
                }
            }
        };
        this.loadFieldSelectionBoxPanel();
        this.fieldSelectionBoxPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.fieldSelectionBoxPanel.setSize(this.fieldSelectionBoxPanel.getPreferredSize());
        this.applyFieldsButton = this.createButton("Apply Fields", APPLY_FIELDS_COMMAND);
        this.cancelButton = this.createButton("Close", CANCEL_COMMAND);
        this.add(this.fieldSelectionLabel);
        this.add(this.fieldSelectionBoxPanel);
        this.add(this.applyFieldsButton);
        this.add(this.cancelButton);
    }

    public void doLayout() {
        int n = 2;
        Insets insets = this.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        int n4 = this.getWidth() - insets.left - insets.right;
        this.fieldSelectionLabel.setBounds(n2, n3, this.getWidth() - insets.left - insets.right, this.fieldSelectionLabel.getHeight());
        this.cancelButton.setSize(this.cancelButton.getPreferredSize());
        this.applyFieldsButton.setSize(this.applyFieldsButton.getPreferredSize());
        if (n + this.applyFieldsButton.getWidth() + n + this.cancelButton.getWidth() + n > n4) {
            int n5 = (n4 - n * 3) / 2;
            this.cancelButton.setBounds(this.getWidth() - insets.right - n5 - n, this.getHeight() - insets.bottom - this.cancelButton.getHeight() - n, n5, this.cancelButton.getHeight());
            this.applyFieldsButton.setBounds(n2 + n, this.cancelButton.getY(), this.cancelButton.getX() - n - n2 - n, this.applyFieldsButton.getHeight());
        } else {
            this.cancelButton.setLocation(this.getWidth() - insets.right - this.cancelButton.getWidth() - n, this.getHeight() - insets.bottom - this.cancelButton.getHeight() - n);
            this.applyFieldsButton.setLocation(this.cancelButton.getX() - n - this.applyFieldsButton.getWidth(), this.cancelButton.getY());
        }
        this.fieldSelectionBoxPanel.setBounds(n2, n3 += this.fieldSelectionLabel.getHeight() + 2, this.getWidth() - insets.left - insets.right, this.applyFieldsButton.getY() - 2 - n3);
        this.fieldSelectionBoxPanel.doLayout();
        this.fieldSelectionBoxPanel.repaint();
    }

    public Field[] getSelectedFields() {
        Field[] fieldArray = new Field[this.fieldSelectionBoxes.size()];
        for (int i = 0; i < this.fieldSelectionBoxes.size(); ++i) {
            fieldArray[i] = (Field)((JComboBox)this.fieldSelectionBoxes.get(i)).getSelectedItem();
        }
        return fieldArray;
    }

    public void updateFieldList(List list) {
        Field[] fieldArray = this.getSelectedFields();
        this.fields = list;
        this.loadFieldSelectionBoxPanel();
        for (int i = 0; i < fieldArray.length || i < this.fieldSelectionBoxes.size(); ++i) {
            int n = this.getFieldIndex(fieldArray[i]);
            if (n <= -1) continue;
            ((JComboBox)this.fieldSelectionBoxes.get(i)).setSelectedIndex(n);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CcObjectRecordFieldsSelector.debugOut("Received action: " + string);
        if (string.equals(APPLY_FIELDS_COMMAND)) {
            if (this.objMedEditComponent != null) {
                this.objMedEditComponent.applyFields();
            }
        } else if (string.equals(CANCEL_COMMAND) && this.objMedEditComponent != null) {
            this.objMedEditComponent.cancelChangeFields();
        }
    }

    protected void loadFieldSelectionBoxPanel() {
        this.fieldSelectionBoxPanel.removeAll();
        this.fieldSelectionBoxes.clear();
        for (int i = 0; i < 2; ++i) {
            JComboBox jComboBox = this.createFieldSelectionBox(i);
            this.fieldSelectionBoxes.add(jComboBox);
            this.fieldSelectionBoxPanel.add(jComboBox);
        }
    }

    protected JComboBox createFieldSelectionBox(int n) {
        JComboBox jComboBox = new JComboBox();
        for (int i = 0; i < this.fields.size(); ++i) {
            jComboBox.addItem(this.fields.get(i));
        }
        jComboBox.setSelectedIndex(n);
        jComboBox.doLayout();
        jComboBox.setSize(jComboBox.getPreferredSize());
        return jComboBox;
    }

    protected int getFieldIndex(Field field) {
        int n = -1;
        for (int i = 0; field != null && this.fields != null && i < this.fields.size(); ++i) {
            if (((Field)this.fields.get((int)i)).fieldID != field.fieldID) continue;
            n = i;
            break;
        }
        return n;
    }

    protected JButton createButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setSize(jButton.getPreferredSize());
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        return jButton;
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setSize(jLabel.getPreferredSize());
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }
}

