/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.ProgressListener;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecord;
import com.luna.insight.admin.manytomanymap.ManyToManyMap;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class CcObjectMediaMappingManager
extends ManyToManyMap {
    protected Integer uniqueCollectionID;
    protected CollectionServer server;
    protected Field[] fields;
    protected ProgressListener progressListener;
    protected Map objectMap = new TreeMap();
    protected Map imageMap = new TreeMap();
    protected List objectRecords = new Vector();
    protected List imageRecords = new Vector();
    protected Comparator comparator;
    protected Object mediaGroup = null;

    public static void debugOut(String string) {
        CcObjectMediaMappingManager.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcObjectMediaMappingManager: " + string, n);
    }

    public CcObjectMediaMappingManager(Integer n, CollectionServer collectionServer) {
        this.server = collectionServer;
        this.uniqueCollectionID = n;
        this.comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof CcObjectRecord) {
                    return ((CcObjectRecord)object).getSortString().compareTo(((CcObjectRecord)object2).getSortString());
                }
                return (int)(((CcMediaRecord)object).getImageID() - ((CcMediaRecord)object2).getImageID());
            }
        };
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public void setMediaGroup(Object object) {
        this.mediaGroup = object;
    }

    public Object getMediaGroup() {
        return this.mediaGroup;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public boolean isPopulated() {
        return !this.objectRecords.isEmpty() || !this.imageRecords.isEmpty();
    }

    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
        if (!this.isPopulated()) {
            this.server.getCollectionServerConnector().populateObjectImageMappingManager(this);
            this.setRecordChanges(true);
        } else {
            this.server.getCollectionServerConnector().setObjectFieldValues(this);
        }
    }

    public void setObjectRecordFields() {
        for (int i = 0; i < this.objectRecords.size(); ++i) {
            ((CcObjectRecord)this.objectRecords.get(i)).setFields(this.getFields());
        }
    }

    public CollectionServer getServer() {
        return this.server;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public void setFieldValue(long l, int n, String string) {
        CcObjectRecord ccObjectRecord = this.getObjectRecord(l);
        if (ccObjectRecord != null) {
            ccObjectRecord.setFieldValue(n, string);
        }
    }

    public CcMediaRecord setImageData(long l, int n, String string, String string2) {
        return this.setImageData(l, n, string, string2, false);
    }

    public CcMediaRecord setImageData(long l, int n, String string, String string2, boolean bl) {
        CcMediaRecord ccMediaRecord = this.getImageRecord(l);
        if (bl && ccMediaRecord == null) {
            ccMediaRecord = new CcMediaRecord(l);
            this.addImageRecord(ccMediaRecord);
        }
        if (ccMediaRecord != null && !ccMediaRecord.isRecordComplete()) {
            ccMediaRecord.setMediaType(n);
            ccMediaRecord.setImageUrl(string);
            ccMediaRecord.setImageFilename(string2);
        }
        return ccMediaRecord;
    }

    public boolean addObjectRecord(CcObjectRecord ccObjectRecord) {
        return this.addObjectRecord(ccObjectRecord, true);
    }

    public boolean addObjectRecord(CcObjectRecord ccObjectRecord, boolean bl) {
        Long l = new Long(ccObjectRecord.getObjectID());
        if (!this.objectMap.containsKey(l)) {
            this.objectRecords.add(ccObjectRecord);
            if (bl) {
                this.addOrphan(ccObjectRecord);
            }
            this.objectMap.put(l, ccObjectRecord);
            return true;
        }
        return false;
    }

    public boolean addImageRecord(CcMediaRecord ccMediaRecord) {
        return this.addImageRecord(ccMediaRecord, true);
    }

    public boolean addImageRecord(CcMediaRecord ccMediaRecord, boolean bl) {
        Long l = new Long(ccMediaRecord.getImageID());
        if (!this.imageMap.containsKey(l)) {
            this.imageRecords.add(ccMediaRecord);
            if (bl) {
                this.addOrphan(ccMediaRecord);
            }
            this.imageMap.put(l, ccMediaRecord);
            return true;
        }
        return false;
    }

    public boolean removeImageRecord(CcMediaRecord ccMediaRecord) {
        Long l = new Long(ccMediaRecord.getImageID());
        this.imageMap.remove(l);
        this.imageRecords.remove(ccMediaRecord);
        this.removeObject(ccMediaRecord);
        return true;
    }

    public void addObjectImageMapping(long l, long l2) {
        this.addObjectImageMapping(l, l2, false);
    }

    public void addObjectImageMapping(long l, long l2, boolean bl) {
        CcObjectRecord ccObjectRecord = this.getObjectRecord(l);
        CcMediaRecord ccMediaRecord = this.getImageRecord(l2);
        if (bl) {
            if (ccObjectRecord == null) {
                ccObjectRecord = new CcObjectRecord(l);
                this.addObjectRecord(ccObjectRecord, false);
            }
            if (ccMediaRecord == null) {
                ccMediaRecord = new CcMediaRecord(l2);
                this.addImageRecord(ccMediaRecord, false);
            }
        }
        this.map(ccObjectRecord, ccMediaRecord);
    }

    public CcObjectRecord getObjectRecord(long l) {
        return (CcObjectRecord)this.objectMap.get(new Long(l));
    }

    public CcMediaRecord getImageRecord(long l) {
        return (CcMediaRecord)this.imageMap.get(new Long(l));
    }

    public List getAllObjectRecords() {
        return this.objectRecords;
    }

    public List getAllImageRecords() {
        return this.imageRecords;
    }

    public List getMatchingObjectRecords(Field field, String string) {
        Vector<CcObjectRecord> vector = new Vector<CcObjectRecord>();
        for (int i = 0; i < this.objectRecords.size(); ++i) {
            CcObjectRecord ccObjectRecord = (CcObjectRecord)this.objectRecords.get(i);
            if (!ccObjectRecord.contains(field.fieldID, string)) continue;
            vector.add(ccObjectRecord);
        }
        Collections.sort(vector, this.comparator);
        return vector;
    }

    public List getMatchingImageRecords(long l) {
        Vector<CcMediaRecord> vector = new Vector<CcMediaRecord>(1);
        CcMediaRecord ccMediaRecord = this.getImageRecord(l);
        if (ccMediaRecord != null) {
            vector.add(ccMediaRecord);
        }
        Collections.sort(vector, this.comparator);
        return vector;
    }

    public List getOrphanedObjectRecords() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getOrphans();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CcObjectRecord)) continue;
            arrayList.add(e);
        }
        Collections.sort(arrayList, this.comparator);
        return arrayList;
    }

    public List getOrphanedImageRecords() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getOrphans();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CcMediaRecord)) continue;
            arrayList.add(e);
        }
        Collections.sort(arrayList, this.comparator);
        return arrayList;
    }

    public void sortObjectRecords() {
        Collections.sort(this.objectRecords, this.comparator);
    }

    public void sortImageRecords() {
        Collections.sort(this.imageRecords, this.comparator);
    }

    public List getMappingsList(Object object) {
        List list = super.getMappingsList(object);
        if (list != null) {
            Collections.sort(list, this.comparator);
        }
        return list;
    }
}

