/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecordThumbnail;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaThumbnailLoadManager;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingManager;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingProgessPanel;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecordFieldsSelectionDialog;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecordFieldsSelector;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecordThumbnail;
import com.luna.insight.admin.collserver.objectmediamap.CcThumbnailDetailWindow;
import com.luna.insight.admin.collserver.objectmediamap.ConfirmDialog;
import com.luna.insight.admin.collserver.objectmediamap.PageContainer;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.admin.manytomanymap.ManyToManyMapEditComponent;
import com.luna.insight.admin.manytomanymap.ManyToManyMapListener;
import com.luna.insight.admin.manytomanymap.MapRecord;
import com.luna.insight.admin.manytomanymap.MappedThumbnail;
import com.luna.insight.admin.manytomanymap.MappedThumbnailViewer;
import com.luna.insight.client.IconMaker;
import com.luna.insight.client.layouts.DynamicGridLayout;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CcObjectMediaMappingEditComponent
extends ManyToManyMapEditComponent
implements DocumentListener,
KeyListener,
ManyToManyMapListener {
    protected static final Dimension DEFAULT_SIZE = new Dimension(800, 600);
    protected static final LayoutManager OBJECT_THUMBNAIL_LAYOUT = new VerticalStackResizeWidthLayout();
    protected static final LayoutManager MEDIA_THUMBNAIL_LAYOUT = new DynamicGridLayout(12, 12, 10, 10);
    protected static final ImageIcon PASSIVE_PREV_PAGE_ICON = IconMaker.createImage("images/passive-prev-page-icon.gif");
    protected static final ImageIcon ROLLOVER_PREV_PAGE_ICON = IconMaker.createImage("images/rollover-prev-page-icon.gif");
    protected static final ImageIcon PASSIVE_NEXT_PAGE_ICON = IconMaker.createImage("images/passive-next-page-icon.gif");
    protected static final ImageIcon ROLLOVER_NEXT_PAGE_ICON = IconMaker.createImage("images/rollover-next-page-icon.gif");
    protected static final String GET_ORPHANED_OBJECTS_COMMAND = "get-orphaned-objects-command";
    protected static final String GET_ALL_OBJECTS_COMMAND = "get-all-objects-command";
    protected static final String FIND_OBJECTS_COMMAND = "find-objects-command";
    protected static final String GET_ORPHANED_IMAGES_COMMAND = "get-orphaned-media-command";
    protected static final String GET_ALL_IMAGES_COMMAND = "get-all-media-command";
    protected static final String FIND_IMAGES_COMMAND = "find-media-command";
    protected static final String CHANGE_FIELDS_COMMAND = "change-fields-command";
    protected static final String UNDO_COMMAND = "undo-command";
    protected static final String PREV_OBJ_PAGE_COMMAND = "prev-object-page-command";
    protected static final String NEXT_OBJ_PAGE_COMMAND = "next-object-page-command";
    protected static final String PREV_IMG_PAGE_COMMAND = "prev-media-page-command";
    protected static final String NEXT_IMG_PAGE_COMMAND = "next-media-page-command";
    protected static boolean CHANGE_CONFIRM_DIALOG_ACTIVE = true;
    protected int HEADER_HEIGHT = 0;
    protected int BUTTON_PANEL_HEIGHT = 77;
    protected int PROGRESS_PANEL_HEIGHT = 23;
    protected InsightAdministrator insightAdmin;
    protected CollectionServer server;
    protected CcObjectMediaMappingManager manager;
    protected PageContainer objectPageSet = new PageContainer("Object");
    protected PageContainer imagePageSet = new PageContainer("Image");
    protected CcObjectRecordFieldsSelector fieldSelectionPanel;
    protected CcObjectRecordFieldsSelectionDialog changeFieldsDialog;
    protected JPanel objectsLineBorder;
    protected JPanel imagesLineBorder;
    protected JLabel objectRecordsLabel;
    protected JLabel imageRecordsLabel;
    protected JLabel objectRecCountLabel;
    protected JLabel imageRecCountLabel;
    protected JPanel objectButtonsPanel;
    protected JButton showOrphanObjButton;
    protected JButton showAllObjButton;
    protected JButton findObjButton;
    protected JComboBox findObjFieldBox;
    protected JTextField findObjTextField;
    protected JPanel imageButtonsPanel;
    protected JButton showOrphanImgButton;
    protected JButton showAllImgButton;
    protected JButton findImgButton;
    protected JLabel findImgFieldBox;
    protected JTextField findImgTextField;
    protected JButton prevObjPageButton;
    protected JButton nextObjPageButton;
    protected JLabel objRangeDataLabel;
    protected JLabel objPageDataLabel;
    protected JPanel objPagingButtonsPanel;
    protected JButton prevImgPageButton;
    protected JButton nextImgPageButton;
    protected JLabel imgRangeDataLabel;
    protected JLabel imgPageDataLabel;
    protected JPanel imgPagingButtonsPanel;
    protected CcObjectMediaMappingProgessPanel progressPanel;
    protected JButton changeFieldsButton;
    protected JButton undoButton;
    protected Thread applyFieldsThread;
    protected CcMediaThumbnailLoadManager loadManager;
    protected boolean flushThumbnails = false;
    protected CcTaskItem objImgTaskItem = null;
    protected Map detailWindows = new TreeMap();

    public static void debugOut(String string) {
        CcObjectMediaMappingEditComponent.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcObjectMediaMappingEditComponent: " + string, n);
    }

    public CcObjectMediaMappingEditComponent(CcObjectMediaMappingManager ccObjectMediaMappingManager, CcObjectRecordFieldsSelector ccObjectRecordFieldsSelector) {
        super(ccObjectMediaMappingManager);
        this.server = ccObjectMediaMappingManager.getServer();
        this.manager = ccObjectMediaMappingManager;
        this.insightAdmin = this.server.getInsightAdministrator();
        this.fieldSelectionPanel = ccObjectRecordFieldsSelector;
        this.fieldSelectionPanel.setObjectMediaMappingEditComponent(this);
        ccObjectMediaMappingManager.addManyToManyMapListener(this);
        this.initComponents();
        Runnable runnable = new Runnable(){

            public void run() {
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        1.access$000(this.this$1).applyFields();
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }

            static /* synthetic */ CcObjectMediaMappingEditComponent access$000(1 var0) {
                return var0.CcObjectMediaMappingEditComponent.this;
            }
        };
        SwingUtilities.invokeLater(runnable);
        this.loadManager = new CcMediaThumbnailLoadManager();
        this.loadManager.start();
    }

    public CollectionServer getServer() {
        return this.server;
    }

    public CollectionServerNode getServerNode() {
        return this.server.getServerNode();
    }

    public void setTaskItem(CcTaskItem ccTaskItem) {
        this.objImgTaskItem = ccTaskItem;
    }

    public CcTaskItem getTaskItem() {
        return this.objImgTaskItem;
    }

    public CcObjectRecordFieldsSelector getFieldsSelector() {
        return this.fieldSelectionPanel;
    }

    public CcMediaThumbnailLoadManager getLoadManager() {
        return this.loadManager;
    }

    public boolean flushThumbnails() {
        return this.flushThumbnails;
    }

    public void setFlushThumbnails(boolean bl) {
        this.flushThumbnails = bl;
    }

    public String getMediaGroupTitle() {
        if (this.manager.getMediaGroup() instanceof CsMediaGroup) {
            return "Group \"" + ((CsMediaGroup)this.manager.getMediaGroup()).getName() + "\"";
        }
        if (this.manager.getMediaGroup() instanceof CcMediaBatch) {
            return "Batch \"" + ((CcMediaBatch)this.manager.getMediaGroup()).getBatchName() + "\"";
        }
        return "";
    }

    public String getMediaRecordsTitle() {
        return this.getMediaGroupTitle() + " Media Records";
    }

    protected void initComponents() {
        this.setSize(DEFAULT_SIZE);
        this.setBorder(new EmptyBorder(5, 5, 2, 5));
        this.objectRecordsLabel = this.createLabel("Object Data Records");
        this.objectRecordsLabel.setBorder(new EmptyBorder(2, 4, 0, 0));
        this.imageRecordsLabel = this.createLabel(this.getMediaRecordsTitle());
        this.imageRecordsLabel.setBorder(new EmptyBorder(2, 4, 0, 0));
        this.HEADER_HEIGHT = this.objectRecordsLabel.getHeight();
        this.add(this.objectRecordsLabel);
        this.add(this.imageRecordsLabel);
        this.objectRecCountLabel = this.createLabel("");
        this.objectRecCountLabel.setBorder(new EmptyBorder(2, 0, 0, 4));
        this.imageRecCountLabel = this.createLabel("");
        this.imageRecCountLabel.setBorder(new EmptyBorder(2, 0, 0, 4));
        this.add(this.objectRecCountLabel);
        this.add(this.imageRecCountLabel);
        this.changeFieldsButton = this.createButton("Change data fields", CHANGE_FIELDS_COMMAND);
        this.add(this.changeFieldsButton);
        this.undoButton = this.createButton("Undo", UNDO_COMMAND);
        this.undoButton.setEnabled(false);
        this.add(this.undoButton);
        this.progressPanel = new CcObjectMediaMappingProgessPanel();
        this.add(this.progressPanel);
        this.manager.setProgressListener(this.progressPanel);
        this.prevObjPageButton = this.createImageButton(PASSIVE_PREV_PAGE_ICON, ROLLOVER_PREV_PAGE_ICON, ROLLOVER_PREV_PAGE_ICON, PREV_OBJ_PAGE_COMMAND, this);
        this.nextObjPageButton = this.createImageButton(PASSIVE_NEXT_PAGE_ICON, ROLLOVER_NEXT_PAGE_ICON, ROLLOVER_NEXT_PAGE_ICON, NEXT_OBJ_PAGE_COMMAND, this);
        this.objRangeDataLabel = this.createLabel(this.objectPageSet.getRangeData());
        this.objPageDataLabel = this.createLabel("");
        this.objPagingButtonsPanel = new JPanel(null){

            public void doLayout() {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = Math.min(CcObjectMediaMappingEditComponent.this.prevObjPageButton.getHeight(), this.getHeight() - insets.top - insets.bottom);
                CcObjectMediaMappingEditComponent.this.prevObjPageButton.setLocation(n, n2);
                CcObjectMediaMappingEditComponent.this.objPageDataLabel.setSize(CcObjectMediaMappingEditComponent.this.objPageDataLabel.getPreferredSize());
                CcObjectMediaMappingEditComponent.this.objPageDataLabel.setBounds(n += CcObjectMediaMappingEditComponent.this.prevObjPageButton.getWidth() + 4, n2, CcObjectMediaMappingEditComponent.this.objPageDataLabel.getWidth(), n3);
                CcObjectMediaMappingEditComponent.this.objPageDataLabel.doLayout();
                CcObjectMediaMappingEditComponent.this.nextObjPageButton.setLocation(n += CcObjectMediaMappingEditComponent.this.objPageDataLabel.getWidth() + 4, n2);
                CcObjectMediaMappingEditComponent.this.objRangeDataLabel.setBounds(n += CcObjectMediaMappingEditComponent.this.nextObjPageButton.getWidth() + 4, n2, this.getWidth() - insets.right - n, n3);
                CcObjectMediaMappingEditComponent.this.objRangeDataLabel.doLayout();
            }
        };
        this.objPagingButtonsPanel.add(this.prevObjPageButton);
        this.objPagingButtonsPanel.add(this.nextObjPageButton);
        this.objPagingButtonsPanel.add(this.objRangeDataLabel);
        this.objPagingButtonsPanel.add(this.objPageDataLabel);
        this.showOrphanObjButton = this.createButton("Show Orphans", GET_ORPHANED_OBJECTS_COMMAND);
        this.showAllObjButton = this.createButton("Show All", GET_ALL_OBJECTS_COMMAND);
        this.findObjButton = this.createButton("Find", FIND_OBJECTS_COMMAND);
        this.findObjButton.setEnabled(false);
        this.findObjFieldBox = new JComboBox();
        this.findObjTextField = this.createTextField();
        this.objectButtonsPanel = new JPanel(null){

            public void doLayout() {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = this.getWidth() - insets.left - insets.right;
                int n4 = 2 * (n3 - 8 - CcObjectMediaMappingEditComponent.this.findObjButton.getWidth()) / 3;
                int n5 = Math.max(CcObjectMediaMappingEditComponent.this.findObjFieldBox.getHeight(), CcObjectMediaMappingEditComponent.this.findObjButton.getHeight());
                CcObjectMediaMappingEditComponent.this.objPagingButtonsPanel.setBounds(n, n2, n3, 14);
                CcObjectMediaMappingEditComponent.this.objPagingButtonsPanel.doLayout();
                CcObjectMediaMappingEditComponent.this.findObjButton.setBounds(this.getWidth() - insets.right - CcObjectMediaMappingEditComponent.this.findObjButton.getWidth(), n2 += CcObjectMediaMappingEditComponent.this.objPagingButtonsPanel.getHeight() + 4, CcObjectMediaMappingEditComponent.this.findObjButton.getWidth(), n5);
                CcObjectMediaMappingEditComponent.this.findObjFieldBox.setBounds(n, n2, n4, n5);
                CcObjectMediaMappingEditComponent.this.findObjFieldBox.doLayout();
                CcObjectMediaMappingEditComponent.this.findObjTextField.setBounds(n += CcObjectMediaMappingEditComponent.this.findObjFieldBox.getWidth() + 4, n2, CcObjectMediaMappingEditComponent.this.findObjButton.getX() - 4 - n, n5);
                n = insets.left;
                n2 += n5 + 4;
                n4 = (n3 - 4) / 2;
                n5 = Math.max(CcObjectMediaMappingEditComponent.this.showOrphanObjButton.getPreferredSize().height, CcObjectMediaMappingEditComponent.this.showAllObjButton.getPreferredSize().height) - insets.bottom;
                CcObjectMediaMappingEditComponent.this.showOrphanObjButton.setBounds(n, n2, n4, n5);
                CcObjectMediaMappingEditComponent.this.showAllObjButton.setBounds(n += CcObjectMediaMappingEditComponent.this.showOrphanObjButton.getWidth() + 4, n2, this.getWidth() - insets.right - n, n5);
            }
        };
        this.objectButtonsPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.objectButtonsPanel.setOpaque(false);
        this.objectButtonsPanel.add(this.objPagingButtonsPanel);
        this.objectButtonsPanel.add(this.showOrphanObjButton);
        this.objectButtonsPanel.add(this.showAllObjButton);
        this.objectButtonsPanel.add(this.findObjButton);
        this.objectButtonsPanel.add(this.findObjFieldBox);
        this.objectButtonsPanel.add(this.findObjTextField);
        this.prevImgPageButton = this.createImageButton(PASSIVE_PREV_PAGE_ICON, ROLLOVER_PREV_PAGE_ICON, ROLLOVER_PREV_PAGE_ICON, PREV_IMG_PAGE_COMMAND, this);
        this.nextImgPageButton = this.createImageButton(PASSIVE_NEXT_PAGE_ICON, ROLLOVER_NEXT_PAGE_ICON, ROLLOVER_NEXT_PAGE_ICON, NEXT_IMG_PAGE_COMMAND, this);
        this.imgRangeDataLabel = this.createLabel(this.imagePageSet.getRangeData());
        this.imgPageDataLabel = this.createLabel("");
        this.imgPagingButtonsPanel = new JPanel(null){

            public void doLayout() {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = Math.min(CcObjectMediaMappingEditComponent.this.prevImgPageButton.getHeight(), this.getHeight() - insets.top - insets.bottom);
                CcObjectMediaMappingEditComponent.this.prevImgPageButton.setLocation(n, n2);
                CcObjectMediaMappingEditComponent.this.imgPageDataLabel.setSize(CcObjectMediaMappingEditComponent.this.imgPageDataLabel.getPreferredSize());
                CcObjectMediaMappingEditComponent.this.imgPageDataLabel.setBounds(n += CcObjectMediaMappingEditComponent.this.prevImgPageButton.getWidth() + 4, n2, CcObjectMediaMappingEditComponent.this.imgPageDataLabel.getWidth(), n3);
                CcObjectMediaMappingEditComponent.this.imgPageDataLabel.doLayout();
                CcObjectMediaMappingEditComponent.this.nextImgPageButton.setLocation(n += CcObjectMediaMappingEditComponent.this.imgPageDataLabel.getWidth() + 4, n2);
                CcObjectMediaMappingEditComponent.this.imgRangeDataLabel.setBounds(n += CcObjectMediaMappingEditComponent.this.nextImgPageButton.getWidth() + 4, n2, this.getWidth() - insets.right - n, n3);
                CcObjectMediaMappingEditComponent.this.imgRangeDataLabel.doLayout();
            }
        };
        this.imgPagingButtonsPanel.add(this.prevImgPageButton);
        this.imgPagingButtonsPanel.add(this.nextImgPageButton);
        this.imgPagingButtonsPanel.add(this.imgRangeDataLabel);
        this.imgPagingButtonsPanel.add(this.imgPageDataLabel);
        this.showOrphanImgButton = this.createButton("Show Orphans", GET_ORPHANED_IMAGES_COMMAND);
        this.showAllImgButton = this.createButton("Show All", GET_ALL_IMAGES_COMMAND);
        this.findImgButton = this.createButton("Find", FIND_IMAGES_COMMAND);
        this.findImgButton.setEnabled(false);
        this.findImgFieldBox = this.createLabel("Medium ID");
        this.findImgFieldBox.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), new EmptyBorder(0, 4, 0, 0)));
        this.findImgTextField = this.createTextField();
        this.imageButtonsPanel = new JPanel(null){

            public void doLayout() {
                Insets insets = this.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                int n3 = this.getWidth() - insets.left - insets.right;
                int n4 = 2 * (n3 - 8 - CcObjectMediaMappingEditComponent.this.findImgButton.getWidth()) / 3;
                int n5 = Math.max(CcObjectMediaMappingEditComponent.this.findImgFieldBox.getHeight(), CcObjectMediaMappingEditComponent.this.findImgButton.getHeight());
                CcObjectMediaMappingEditComponent.this.imgPagingButtonsPanel.setBounds(n, n2, n3, 14);
                CcObjectMediaMappingEditComponent.this.imgPagingButtonsPanel.doLayout();
                CcObjectMediaMappingEditComponent.this.findImgButton.setBounds(this.getWidth() - insets.right - CcObjectMediaMappingEditComponent.this.findImgButton.getWidth(), n2 += CcObjectMediaMappingEditComponent.this.imgPagingButtonsPanel.getHeight() + 4, CcObjectMediaMappingEditComponent.this.findImgButton.getWidth(), n5);
                CcObjectMediaMappingEditComponent.this.findImgFieldBox.setBounds(n, n2, n4, n5);
                CcObjectMediaMappingEditComponent.this.findImgFieldBox.doLayout();
                CcObjectMediaMappingEditComponent.this.findImgTextField.setBounds(n += CcObjectMediaMappingEditComponent.this.findImgFieldBox.getWidth() + 4, n2, CcObjectMediaMappingEditComponent.this.findImgButton.getX() - 4 - n, n5);
                n = insets.left;
                n2 += n5 + 4;
                n4 = (n3 - 4) / 2;
                n5 = Math.max(CcObjectMediaMappingEditComponent.this.showOrphanImgButton.getPreferredSize().height, CcObjectMediaMappingEditComponent.this.showAllImgButton.getPreferredSize().height) - insets.bottom;
                CcObjectMediaMappingEditComponent.this.showOrphanImgButton.setBounds(n, n2, n4, n5);
                CcObjectMediaMappingEditComponent.this.showAllImgButton.setBounds(n += CcObjectMediaMappingEditComponent.this.showOrphanImgButton.getWidth() + 4, n2, this.getWidth() - insets.right - n, n5);
            }
        };
        this.imageButtonsPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.imageButtonsPanel.setOpaque(false);
        this.imageButtonsPanel.add(this.imgPagingButtonsPanel);
        this.imageButtonsPanel.add(this.showOrphanImgButton);
        this.imageButtonsPanel.add(this.showAllImgButton);
        this.imageButtonsPanel.add(this.findImgButton);
        this.imageButtonsPanel.add(this.findImgFieldBox);
        this.imageButtonsPanel.add(this.findImgTextField);
        this.add(this.objectButtonsPanel);
        this.add(this.imageButtonsPanel);
        this.objectsLineBorder = new JPanel();
        this.objectsLineBorder.setBorder(BorderFactory.createLineBorder(Color.black));
        this.imagesLineBorder = new JPanel();
        this.imagesLineBorder.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add(this.objectsLineBorder);
        this.add(this.imagesLineBorder);
        this.updateObjectPageControls();
        this.updateImagePageControls();
    }

    public void calculateSideBounds() {
        Insets insets = this.getInsets();
        int n = (this.getWidth() - insets.left - insets.right - 10) / 2;
        int n2 = this.getHeight() - insets.top - insets.bottom - this.HEADER_HEIGHT - this.BUTTON_PANEL_HEIGHT - 10 - this.PROGRESS_PANEL_HEIGHT;
        this.setWestSideBounds(new Rectangle(insets.left, insets.top + this.HEADER_HEIGHT, n, n2));
        this.setEastSideBounds(new Rectangle(this.westSideBounds.x + this.westSideBounds.width + 10, this.getWestSideBounds().y, this.getWidth() - insets.right - 10 - this.getWestSideBounds().x - this.getWestSideBounds().width, n2));
    }

    public void doLayout() {
        super.doLayout();
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        this.objectRecCountLabel.setSize(this.objectRecCountLabel.getPreferredSize());
        this.objectRecCountLabel.setLocation(this.getWestSideBounds().x + this.getWestSideBounds().width - this.objectRecCountLabel.getWidth(), n2);
        this.imageRecCountLabel.setSize(this.imageRecCountLabel.getPreferredSize());
        this.imageRecCountLabel.setLocation(this.getEastSideBounds().x + this.getEastSideBounds().width - this.imageRecCountLabel.getWidth(), n2);
        this.objectRecordsLabel.setSize(this.objectRecordsLabel.getPreferredSize());
        this.objectRecordsLabel.setBounds(this.getWestSideBounds().x, n2, this.getWestSideBounds().width - this.objectRecCountLabel.getWidth(), this.objectRecordsLabel.getHeight());
        this.imageRecordsLabel.setSize(this.imageRecordsLabel.getPreferredSize());
        this.imageRecordsLabel.setBounds(this.getEastSideBounds().x, n2, this.getEastSideBounds().width - this.imageRecCountLabel.getWidth(), this.imageRecordsLabel.getHeight());
        this.objectButtonsPanel.setLocation(this.getWestSideBounds().x, this.getWestSideBounds().y + this.getWestSideBounds().height);
        this.objectButtonsPanel.setSize(this.getWestSideBounds().width, this.BUTTON_PANEL_HEIGHT);
        this.objectButtonsPanel.doLayout();
        this.imageButtonsPanel.setLocation(this.getEastSideBounds().x, this.getEastSideBounds().y + this.getEastSideBounds().height);
        this.imageButtonsPanel.setSize(this.getEastSideBounds().width, this.BUTTON_PANEL_HEIGHT);
        this.imageButtonsPanel.doLayout();
        this.objectsLineBorder.setBounds(this.objectRecordsLabel.getX(), this.objectRecordsLabel.getY(), this.getWestSideBounds().width, this.getWestSideBounds().height + this.HEADER_HEIGHT + this.BUTTON_PANEL_HEIGHT);
        this.imagesLineBorder.setBounds(this.imageRecordsLabel.getX(), this.imageRecordsLabel.getY(), this.getEastSideBounds().width, this.getEastSideBounds().height + this.HEADER_HEIGHT + this.BUTTON_PANEL_HEIGHT);
        n = this.getWestSideBounds().x;
        n2 = this.objectsLineBorder.getY() + this.objectsLineBorder.getHeight() + 5;
        this.changeFieldsButton.setSize(Math.min(this.changeFieldsButton.getPreferredSize().width, this.getWestSideBounds().width + 10 + this.getEastSideBounds().width), this.changeFieldsButton.getPreferredSize().height);
        this.changeFieldsButton.setLocation(n, n2);
        this.undoButton.setSize(Math.min(this.undoButton.getPreferredSize().width, this.getWestSideBounds().width + 10 + this.getEastSideBounds().width), this.undoButton.getPreferredSize().height);
        this.undoButton.setLocation(n += this.changeFieldsButton.getWidth() + 10, n2);
        this.progressPanel.setBounds(n += this.undoButton.getWidth() + 10, n2, this.getEastSideBounds().x + this.getEastSideBounds().width - n, this.PROGRESS_PANEL_HEIGHT);
    }

    public void loadObjectPageSet(List list) {
        this.objectPageSet.setResults(list);
        this.moveToObjectPage(1, true);
    }

    public void moveToObjectPage(int n) {
        this.moveToObjectPage(n, false);
    }

    public void moveToObjectPage(int n, boolean bl) {
        if (bl || this.objectPageSet.getPageNumber() != n) {
            this.objectPageSet.setPage(n);
            this.updateObjectPageControls();
            this.populateWestViewer(this.getObjectThumbnails(this.objectPageSet.getPage(), false));
        }
    }

    public void loadImagePageSet(List list) {
        this.loadImagePageSet(list, 1);
    }

    public void loadImagePageSet(List list, int n) {
        this.imagePageSet.setResults(list);
        this.moveToImagePage(n, true);
    }

    public void moveToImagePage(int n) {
        this.moveToImagePage(n, false);
    }

    public void moveToImagePage(int n, boolean bl) {
        if (bl || this.imagePageSet.getPageNumber() != n) {
            this.imagePageSet.setPage(n);
            this.updateImagePageControls();
            this.populateEastViewer(this.getImageThumbnails(this.imagePageSet.getPage(), true));
        }
    }

    public void updateObjectPageControls() {
        this.objPageDataLabel.setText(this.objectPageSet.getPageData());
        this.objRangeDataLabel.setText(this.objectPageSet.getRangeData());
        this.prevObjPageButton.setEnabled(this.objectPageSet.getPageNumber() > 1);
        this.nextObjPageButton.setEnabled(this.objectPageSet.getPageNumber() < this.objectPageSet.getPageCount());
    }

    public void updateImagePageControls() {
        this.imgPageDataLabel.setText(this.imagePageSet.getPageData());
        this.imgRangeDataLabel.setText(this.imagePageSet.getRangeData());
        this.prevImgPageButton.setEnabled(this.imagePageSet.getPageNumber() > 1);
        this.nextImgPageButton.setEnabled(this.imagePageSet.getPageNumber() < this.imagePageSet.getPageCount());
    }

    protected void updateView() {
        this.updateView(false);
    }

    protected void updateView(boolean bl) {
        this.deselectAllThumbnails();
        this.splitTopViewer.removeAllThumbnails();
        this.splitBottomViewer.removeAllThumbnails();
        if (this.currentMode == 0 && this.lastMode != 0) {
            this.populateWestViewer(this.westThumbnails);
            this.populateEastViewer(this.eastThumbnails);
        }
        this.setTargets();
        if (this.anchorThumbnail != null && this.anchorViewer != null) {
            this.anchorThumbnail.select(true, true);
            this.anchorThumbnail.getViewer().scrollToThumbnail(this.anchorThumbnail);
            List list = this.theMap.getMappingsList(this.anchorThumbnail.getMapObject());
            if (this.currentMode == 0) {
                if ((bl || this.anchorThumbnail != this.lastAnchorThumbnail) && list != null && list.size() > 0) {
                    Object e = list.get(0);
                    if (e instanceof CcObjectRecord) {
                        this.moveToObjectPage(this.objectPageSet.getPageNumber(e));
                    } else if (e instanceof CcMediaRecord) {
                        this.moveToImagePage(this.imagePageSet.getPageNumber(e));
                    }
                }
                this.targetViewer.selectThumbnails(list, true, false, bl || this.anchorThumbnail != this.lastAnchorThumbnail);
            } else {
                Vector<MappedThumbnail> vector = this.targetThumbnails;
                if (list != null && list.size() > 0) {
                    Object e = list.get(0);
                    List list2 = null;
                    if (e instanceof CcObjectRecord) {
                        list2 = this.getObjectThumbnails(list, true);
                    } else if (e instanceof CcMediaRecord) {
                        list2 = this.getImageThumbnails(list, true);
                    }
                    boolean bl2 = false;
                    for (int i = 0; list2 != null && i < list2.size(); ++i) {
                        MappedThumbnail mappedThumbnail = (MappedThumbnail)list2.get(i);
                        if (vector.contains(mappedThumbnail)) continue;
                        if (!bl2) {
                            vector = new Vector<MappedThumbnail>(vector);
                            bl2 = true;
                        }
                        vector.add(mappedThumbnail);
                    }
                }
                this.splitTopViewer.populate(this.getThumbnails(vector, list, true));
                this.splitTopViewer.selectAllThumbnails(true, false);
                this.splitBottomViewer.populate(this.getThumbnails(vector, list, false));
                this.selectionCntLabel.setText(this.getSelectionCountText(this.splitTopViewer.getThumbnailCount(), this.targetSide));
                if (this.targetSide == 0) {
                    this.availableCntLabel.setText(this.getAvailableCountText(this.manager.getAllObjectRecords().size() - this.splitTopViewer.getThumbnailCount(), this.targetSide));
                } else {
                    this.availableCntLabel.setText(this.getAvailableCountText(this.manager.getAllImageRecords().size() - this.splitTopViewer.getThumbnailCount(), this.targetSide));
                }
            }
            this.lastAnchorThumbnail = this.anchorThumbnail;
        }
        this.doLayout();
    }

    public List getObjectThumbnails(List list) {
        return this.getObjectThumbnails(list, true);
    }

    public List getObjectThumbnails(List list, boolean bl) {
        Vector<CcObjectRecordThumbnail> vector = new Vector<CcObjectRecordThumbnail>(list.size());
        List list2 = bl ? this.getWestThumbnails() : null;
        CcObjectRecordThumbnail ccObjectRecordThumbnail = null;
        for (int i = 0; i < list.size(); ++i) {
            CcObjectRecord ccObjectRecord = (CcObjectRecord)list.get(i);
            ccObjectRecordThumbnail = null;
            for (int j = 0; list2 != null && j < list2.size() && !(ccObjectRecordThumbnail = (CcObjectRecordThumbnail)list2.get(j)).mapObjectEquals(ccObjectRecord); ++j) {
                ccObjectRecordThumbnail = null;
            }
            if (ccObjectRecordThumbnail == null) {
                ccObjectRecordThumbnail = new CcObjectRecordThumbnail(this, ccObjectRecord);
            }
            vector.add(ccObjectRecordThumbnail);
        }
        return vector;
    }

    public List getImageThumbnails(List list) {
        return this.getImageThumbnails(list, true);
    }

    public List getImageThumbnails(List list, boolean bl) {
        Vector<CcMediaRecordThumbnail> vector = new Vector<CcMediaRecordThumbnail>(list.size());
        List list2 = bl ? this.getEastThumbnails() : null;
        CcMediaRecordThumbnail ccMediaRecordThumbnail = null;
        for (int i = 0; i < list.size(); ++i) {
            CcMediaRecord ccMediaRecord = (CcMediaRecord)list.get(i);
            ccMediaRecordThumbnail = null;
            for (int j = 0; list2 != null && j < list2.size() && !(ccMediaRecordThumbnail = (CcMediaRecordThumbnail)list2.get(j)).mapObjectEquals(ccMediaRecord); ++j) {
                ccMediaRecordThumbnail = null;
            }
            if (ccMediaRecordThumbnail == null) {
                ccMediaRecordThumbnail = new CcMediaRecordThumbnail(this, ccMediaRecord);
            }
            vector.add(ccMediaRecordThumbnail);
        }
        return vector;
    }

    public String getMappedThumbnailKey(MappedThumbnail mappedThumbnail) {
        if (mappedThumbnail instanceof CcObjectRecordThumbnail) {
            return "Object-" + ((CcObjectRecordThumbnail)mappedThumbnail).getObjectID();
        }
        if (mappedThumbnail instanceof CcMediaRecordThumbnail) {
            return "Medium-" + ((CcMediaRecordThumbnail)mappedThumbnail).getImageID();
        }
        return null;
    }

    public void showThumbnailDetails(MappedThumbnail mappedThumbnail) {
        String string = this.getMappedThumbnailKey(mappedThumbnail);
        CcThumbnailDetailWindow ccThumbnailDetailWindow = (CcThumbnailDetailWindow)this.detailWindows.get(string);
        if (ccThumbnailDetailWindow == null) {
            ccThumbnailDetailWindow = new CcThumbnailDetailWindow(this, mappedThumbnail);
            this.detailWindows.put(string, ccThumbnailDetailWindow);
            ccThumbnailDetailWindow.show();
            ccThumbnailDetailWindow.startLoading();
        } else {
            this.insightAdmin.setSelectedFrame(ccThumbnailDetailWindow);
        }
    }

    public void windowClosed(CcThumbnailDetailWindow ccThumbnailDetailWindow) {
        this.detailWindows.remove(this.getMappedThumbnailKey(ccThumbnailDetailWindow.getThumbnail()));
    }

    public void closeDetailWindow(MappedThumbnail mappedThumbnail) {
        String string = this.getMappedThumbnailKey(mappedThumbnail);
        CcThumbnailDetailWindow ccThumbnailDetailWindow = (CcThumbnailDetailWindow)this.detailWindows.get(string);
        if (ccThumbnailDetailWindow != null) {
            ccThumbnailDetailWindow.close();
        }
    }

    public void closeAllDetailWindows() {
        Object[] objectArray = this.detailWindows.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((CcThumbnailDetailWindow)objectArray[i]).close();
        }
    }

    public void deleteImageRecord(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        if (this.isImageDeleteConfirmed(ccMediaRecordThumbnail)) {
            this.server.getCollectionServerConnector().removeImageRecord(this.manager.getUniqueCollectionID(), ccMediaRecordThumbnail.getImageRecord());
            this.manager.removeImageRecord(ccMediaRecordThumbnail.getImageRecord());
            if (ccMediaRecordThumbnail.isAnchor()) {
                this.anchorThumbnail = null;
            }
            this.setFlushThumbnails(true);
            this.loadImagePageSet(this.manager.getAllImageRecords(), this.imagePageSet.getPageNumber(ccMediaRecordThumbnail.getImageRecord()));
            this.updateView(true);
            this.setFlushThumbnails(false);
            this.imageRecCountLabel.setText(this.manager.getAllImageRecords().size() + " total " + (this.manager.getAllImageRecords().size() == 1 ? "medium" : "media"));
            this.undoButton.setEnabled(this.manager.hasChangeHistory());
            Runnable runnable = new Runnable(){

                public void run() {
                    if (CcObjectMediaMappingEditComponent.this.anchorThumbnail != null) {
                        CcObjectMediaMappingEditComponent.this.anchorThumbnail.invalidate();
                        CcObjectMediaMappingEditComponent.this.anchorThumbnail.validate();
                        CcObjectMediaMappingEditComponent.this.anchorThumbnail.repaint();
                        CcObjectMediaMappingEditComponent.this.anchorThumbnail.doLayout();
                    }
                    CcObjectMediaMappingEditComponent.this.eastViewer.refreshLayout();
                    CcObjectMediaMappingEditComponent.this.eastViewer.repaint();
                    CcObjectMediaMappingEditComponent.this.setBounds(CcObjectMediaMappingEditComponent.this.getBounds());
                }
            };
            SwingUtilities.invokeLater(runnable);
            this.closeDetailWindow(ccMediaRecordThumbnail);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CcObjectMediaMappingEditComponent.debugOut("Received action: " + string);
        if (string.equals(CHANGE_FIELDS_COMMAND)) {
            this.changeFields();
        } else if (string.equals(UNDO_COMMAND)) {
            this.undo();
        } else if (string.equals(GET_ALL_OBJECTS_COMMAND)) {
            this.showAllObjects();
        } else if (string.equals(GET_ORPHANED_OBJECTS_COMMAND)) {
            this.showOrphanedObjects();
        } else if (string.equals(FIND_OBJECTS_COMMAND)) {
            this.findObjects();
        } else if (string.equals(GET_ALL_IMAGES_COMMAND)) {
            this.showAllImages();
        } else if (string.equals(GET_ORPHANED_IMAGES_COMMAND)) {
            this.showOrphanedImages();
        } else if (string.equals(FIND_IMAGES_COMMAND)) {
            this.findImages();
        } else if (string.equals(PREV_OBJ_PAGE_COMMAND)) {
            this.setFlushThumbnails(true);
            this.moveToObjectPage(this.objectPageSet.getPageNumber() - 1);
            if (this.anchorSide == 0) {
                this.resetView();
            } else {
                this.updateView();
            }
            this.setFlushThumbnails(false);
        } else if (string.equals(NEXT_OBJ_PAGE_COMMAND)) {
            this.setFlushThumbnails(true);
            this.moveToObjectPage(this.objectPageSet.getPageNumber() + 1);
            if (this.anchorSide == 0) {
                this.resetView();
            } else {
                this.updateView();
            }
            this.setFlushThumbnails(false);
        } else if (string.equals(PREV_IMG_PAGE_COMMAND)) {
            this.setFlushThumbnails(true);
            this.moveToImagePage(this.imagePageSet.getPageNumber() - 1);
            if (this.anchorSide == 1) {
                this.resetView();
            } else {
                this.updateView();
            }
            this.setFlushThumbnails(false);
        } else if (string.equals(NEXT_IMG_PAGE_COMMAND)) {
            this.setFlushThumbnails(true);
            this.moveToImagePage(this.imagePageSet.getPageNumber() + 1);
            if (this.anchorSide == 1) {
                this.resetView();
            } else {
                this.updateView();
            }
            this.setFlushThumbnails(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void undo() {
        MapRecord mapRecord = this.manager.undoLastChange();
        this.mapStateAltered(mapRecord);
        if (mapRecord != null) {
            MappedThumbnail mappedThumbnail = null;
            MappedThumbnailViewer mappedThumbnailViewer = null;
            if (mapRecord.getObjectA() instanceof CcObjectRecord) {
                this.moveToObjectPage(this.objectPageSet.getPageNumber((CcObjectRecord)mapRecord.getObjectA()));
                mappedThumbnail = this.westViewer.getThumbnail((CcObjectRecord)mapRecord.getObjectA());
                mappedThumbnailViewer = this.eastViewer;
            } else if (mapRecord.getObjectA() instanceof CcMediaRecord) {
                this.moveToImagePage(this.imagePageSet.getPageNumber((CcMediaRecord)mapRecord.getObjectA()));
                mappedThumbnail = this.eastViewer.getThumbnail((CcMediaRecord)mapRecord.getObjectA());
                mappedThumbnailViewer = this.westViewer;
            }
            if (mappedThumbnail != null) {
                this.anchorThumbnail = null;
                this.thumbnailPressed(mappedThumbnail, 1);
                final MappedThumbnail mappedThumbnail2 = mappedThumbnailViewer.getThumbnail(mapRecord.getObjectB());
                if (mappedThumbnail2 != null) {
                    final boolean bl = mappedThumbnail2.isSelected();
                    mappedThumbnail2.select(!bl, false);
                    mappedThumbnailViewer.scrollToThumbnail(mappedThumbnail2);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            mappedThumbnail2.select(bl, false);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
    }

    protected void changeFields() {
        if (this.changeFieldsDialog == null) {
            this.changeFieldsDialog = new CcObjectRecordFieldsSelectionDialog(this.insightAdmin.getFrame(), true, this);
            this.changeFieldsDialog.show();
        } else {
            this.insightAdmin.setSelectedFrame(this.changeFieldsDialog);
        }
    }

    protected void cancelChangeFields() {
        if (this.changeFieldsDialog != null) {
            this.changeFieldsDialog.closeDialog();
        }
        this.changeFieldsDialog = null;
    }

    public synchronized void applyFields() {
        if (this.applyFieldsThread == null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    int n;
                    Field[] fieldArray = CcObjectMediaMappingEditComponent.this.fieldSelectionPanel.getSelectedFields();
                    CcObjectMediaMappingEditComponent.this.findObjFieldBox.removeAllItems();
                    for (n = 0; n < fieldArray.length; ++n) {
                        CcObjectMediaMappingEditComponent.this.findObjFieldBox.addItem(fieldArray[n]);
                    }
                    CcObjectMediaMappingEditComponent.this.findObjFieldBox.doLayout();
                    CcObjectMediaMappingEditComponent.this.findObjFieldBox.setSize(CcObjectMediaMappingEditComponent.this.findObjFieldBox.getPreferredSize());
                    n = CcObjectMediaMappingEditComponent.this.manager.isPopulated() ? 1 : 0;
                    CcObjectMediaMappingEditComponent.this.manager.setFields(fieldArray);
                    CcObjectMediaMappingEditComponent.this.objectRecCountLabel.setText(CcObjectMediaMappingEditComponent.this.manager.getAllObjectRecords().size() + " total object" + (CcObjectMediaMappingEditComponent.this.manager.getAllObjectRecords().size() == 1 ? "" : "s"));
                    CcObjectMediaMappingEditComponent.this.imageRecCountLabel.setText(CcObjectMediaMappingEditComponent.this.manager.getAllImageRecords().size() + " total " + (CcObjectMediaMappingEditComponent.this.manager.getAllImageRecords().size() == 1 ? "medium" : "media"));
                    CcObjectMediaMappingEditComponent.this.setFlushThumbnails(true);
                    CcObjectMediaMappingEditComponent.this.loadObjectPageSet(CcObjectMediaMappingEditComponent.this.manager.getAllObjectRecords());
                    if (n == 0) {
                        CcObjectMediaMappingEditComponent.this.loadImagePageSet(CcObjectMediaMappingEditComponent.this.manager.getAllImageRecords());
                    }
                    if (CcObjectMediaMappingEditComponent.this.anchorViewer == CcObjectMediaMappingEditComponent.this.westViewer) {
                        CcObjectMediaMappingEditComponent.this.resetView();
                    } else {
                        CcObjectMediaMappingEditComponent.this.updateView(true);
                    }
                    CcObjectMediaMappingEditComponent.this.setFlushThumbnails(false);
                    CcObjectMediaMappingEditComponent.this.clearApplyFieldsThread();
                }
            };
            this.applyFieldsThread = new Thread(runnable);
            this.applyFieldsThread.start();
        }
    }

    public synchronized void clearApplyFieldsThread() {
        this.applyFieldsThread = null;
    }

    public void showAllObjects() {
        this.setFlushThumbnails(true);
        this.loadObjectPageSet(this.manager.getAllObjectRecords());
        if (this.anchorViewer != this.westViewer) {
            this.updateView(true);
        } else {
            this.resetView();
        }
        this.setFlushThumbnails(false);
    }

    public void showOrphanedObjects() {
        this.setFlushThumbnails(true);
        this.loadObjectPageSet(this.manager.getOrphanedObjectRecords());
        if (this.anchorViewer != this.westViewer) {
            this.updateView(true);
        } else {
            this.resetView();
        }
        this.setFlushThumbnails(false);
    }

    public void findObjects() {
        this.setFlushThumbnails(true);
        String string = this.findObjTextField.getText();
        Field field = (Field)this.findObjFieldBox.getSelectedItem();
        if (string != null && string.length() > 0 && field != null) {
            this.loadObjectPageSet(this.manager.getMatchingObjectRecords(field, string));
            if (this.anchorViewer != this.westViewer) {
                this.updateView(true);
            } else {
                this.resetView();
            }
        }
        this.setFlushThumbnails(false);
    }

    public void showAllImages() {
        this.setFlushThumbnails(true);
        this.loadImagePageSet(this.manager.getAllImageRecords());
        if (this.anchorViewer != this.eastViewer) {
            this.updateView(true);
        } else {
            this.resetView();
        }
        this.setFlushThumbnails(false);
    }

    public void showOrphanedImages() {
        this.setFlushThumbnails(true);
        this.loadImagePageSet(this.manager.getOrphanedImageRecords());
        if (this.anchorViewer != this.eastViewer) {
            this.updateView(true);
        } else {
            this.resetView();
        }
        this.setFlushThumbnails(false);
    }

    public void findImages() {
        this.setFlushThumbnails(true);
        try {
            long l = Long.parseLong(this.findImgTextField.getText());
            this.loadImagePageSet(this.manager.getMatchingImageRecords(l));
            if (this.anchorViewer != this.eastViewer) {
                this.updateView(true);
            } else {
                this.resetView();
            }
        }
        catch (NumberFormatException numberFormatException) {
            CcObjectMediaMappingEditComponent.debugOut("Unable to convert '" + this.findImgTextField.getText() + "' into a media ID.");
        }
        this.setFlushThumbnails(false);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.findObjTextField.getDocument()) {
            this.findObjButton.setEnabled(this.findObjTextField.getText().length() > 0);
        } else if (documentEvent.getDocument() == this.findImgTextField.getDocument()) {
            this.findImgButton.setEnabled(this.findImgTextField.getText().length() > 0);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.findObjTextField.getDocument()) {
            this.findObjButton.setEnabled(this.findObjTextField.getText().length() > 0);
        } else if (documentEvent.getDocument() == this.findImgTextField.getDocument()) {
            this.findImgButton.setEnabled(this.findImgTextField.getText().length() > 0);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.findObjTextField) {
            if (keyEvent.getKeyCode() == 10) {
                this.findObjButton.doClick();
                keyEvent.consume();
            }
        } else if (keyEvent.getSource() == this.findImgTextField && keyEvent.getKeyCode() == 10) {
            this.findImgButton.doClick();
            keyEvent.consume();
        }
    }

    public void mapStateAltered(MapRecord mapRecord) {
        this.undoButton.setEnabled(this.manager.hasChangeHistory());
    }

    public void thumbnailPressed(MappedThumbnail mappedThumbnail, int n) {
        int n2 = this.currentMode;
        if (n >= 2) {
            n2 = 1;
        }
        if (this.anchorThumbnail == null) {
            this.anchorThumbnail = mappedThumbnail;
            this.anchorViewer = mappedThumbnail.getViewer();
        } else if (mappedThumbnail.getViewer() == this.anchorViewer) {
            if (mappedThumbnail == this.anchorThumbnail && n == 1) {
                this.anchorThumbnail = null;
                this.anchorViewer = null;
                this.lastAnchorThumbnail = null;
                n2 = 0;
            } else {
                this.anchorThumbnail = mappedThumbnail;
            }
        } else if (this.isMapChangeConfirmed(this.anchorThumbnail, mappedThumbnail, mappedThumbnail.isSelected())) {
            if (mappedThumbnail.isSelected()) {
                this.theMap.unmap(this.anchorThumbnail.getMapObject(), mappedThumbnail.getMapObject());
            } else {
                this.theMap.map(this.anchorThumbnail.getMapObject(), mappedThumbnail.getMapObject());
            }
        }
        this.switchMode(n2);
        this.updateView();
    }

    public String getSelectionCountText(int n, int n2) {
        if (n2 == 0) {
            return n + " object" + (n == 1 ? "" : "s") + " mapped.";
        }
        return n + " image" + (n == 1 ? "" : "s") + " mapped.";
    }

    public String getAvailableCountText(int n, int n2) {
        if (n2 == 0) {
            return n + " object" + (n == 1 ? "" : "s") + " available.";
        }
        return n + (n == 1 ? "medium" : "media") + " available.";
    }

    public LayoutManager getThumbnailLayout(int n) {
        if (n == 0) {
            return OBJECT_THUMBNAIL_LAYOUT;
        }
        return MEDIA_THUMBNAIL_LAYOUT;
    }

    public void save() {
        CcObjectMediaMappingEditComponent.debugOut("Save.", 3);
        CcObjectMediaMappingEditComponent.debugOut("Changes detected? " + this.manager.hasChanged());
        if (this.manager.hasChanged()) {
            this.server.getCollectionServerConnector().saveObjectImageMappings(this.manager);
        }
        if (this.objImgTaskItem != null) {
            this.objImgTaskItem.setTaskItemComplete();
        }
        this.cancel(false);
    }

    public void cancel() {
        this.cancel(true);
    }

    public void cancel(boolean bl) {
        CcObjectMediaMappingEditComponent.debugOut("Cancel.", 3);
        this.cancelChangeFields();
        this.progressPanel.cancel();
        if (this.loadManager != null) {
            this.loadManager.setStillNeeded(false);
        }
        if (bl && this.objImgTaskItem != null) {
            this.objImgTaskItem.setTaskItemCancelled();
        }
        this.closeAllDetailWindows();
        this.server.cancelEditObjectImageMappings(this.manager.getUniqueCollectionID(), this.manager.getMediaGroup());
    }

    public String getWindowTitle() {
        String string = this.getMediaGroupTitle();
        return (string.length() > 0 ? string + " - " : "") + "Manage Objects-to-Media Mappings";
    }

    public ImageIcon getWindowIcon() {
        return IconMaker.createImage("images/collection-creation-object-image-mapping-icon.gif");
    }

    protected boolean isMapChangeConfirmed(MappedThumbnail mappedThumbnail, MappedThumbnail mappedThumbnail2, boolean bl) {
        if (CHANGE_CONFIRM_DIALOG_ACTIVE) {
            String string = "You are about to " + (bl ? "sever the mapping between" : "map") + " \"" + mappedThumbnail.toString() + "\" and \"" + mappedThumbnail2.toString() + "\".\nDo you wish to proceed?";
            String string2 = (bl ? "Sever " : "") + "Mapping Confirmation";
            ConfirmDialog confirmDialog = new ConfirmDialog(this, string2, string);
            if (confirmDialog.isConfirmed()) {
                CHANGE_CONFIRM_DIALOG_ACTIVE = confirmDialog.keepDialog();
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isImageDeleteConfirmed(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        String string = "You are about to delete medium " + ccMediaRecordThumbnail.getImageID() + ".\nNOTE: This operation cannot be undone.\nDo you wish to proceed?";
        String string2 = "Delete Media Confirmation";
        return new ConfirmDialog(this, string2, string, false).isConfirmed();
    }

    protected JTextField createTextField() {
        final JTextField jTextField = new JTextField();
        jTextField.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), new EmptyBorder(0, 2, 0, 0)));
        jTextField.getDocument().addDocumentListener(this);
        jTextField.addKeyListener(this);
        jTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                jTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        return jTextField;
    }

    protected JButton createButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setSize(jButton.getPreferredSize());
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        return jButton;
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setSize(jLabel.getPreferredSize());
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }
}

