/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mpd;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.mpd.CsMpd;
import com.luna.insight.admin.collserver.mpd.CsMpdtEditComponent;
import com.luna.insight.admin.collserver.table.CsTableInfo;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CsMpdTemplate
extends EditableDataObject
implements DatabaseRecord,
DocumentListener {
    private Collection collection = null;
    private AdministeredServerConnector serverConnector = null;
    private Integer uniqueCollectionID = null;
    private int documentId = 0;
    private int targetGroupId = 0;
    private int identityFieldId = 0;
    private String minValue = "10";
    private String[] levelNames = null;
    private int[] levelFieldIds = null;
    private Vector levelInfo = new Vector();
    private Vector groupList = new Vector();
    private Vector fieldList = new Vector();
    private Vector levelfieldList = new Vector();
    private Vector mpdocs = new Vector();
    private Map docmap;
    private String IdValues = null;
    private CsMpdtEditComponent editComponent = null;

    public CsMpdTemplate(Integer n, int n2, Collection collection, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this.uniqueCollectionID = n;
        this.collection = collection;
        this.documentId = n2;
        this.levelInfo = vector;
        this.groupList = vector2;
        this.fieldList = vector3;
        this.levelfieldList = vector4;
        this.levelNames = new String[vector.size()];
        this.levelFieldIds = new int[vector.size()];
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public EditComponent getEditComponent() {
        int n;
        int n2;
        int n3;
        int n4;
        this.editComponent = new CsMpdtEditComponent(this.fieldList, this.levelfieldList, this.groupList, this.levelInfo, this.targetGroupId);
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        if (this.levelNames != null) {
            for (n4 = 0; n4 < this.levelNames.length; ++n4) {
                if (this.levelNames.equals("null")) {
                    jTextFieldArray[n4].setText("");
                    continue;
                }
                jTextFieldArray[n4].setText(this.levelNames[n4]);
            }
        }
        if (this.levelFieldIds != null) {
            block1: for (n4 = 0; n4 < this.levelFieldIds.length; ++n4) {
                n3 = this.levelFieldIds[n4];
                for (n2 = 0; n2 < this.fieldList.size(); ++n2) {
                    if (((CsTableInfo)this.fieldList.elementAt(n2)).getTableId() != n3) continue;
                    jComboBoxArray[n4].setSelectedItem(this.fieldList.elementAt(n2));
                    continue block1;
                }
            }
        }
        JComboBox jComboBox = this.editComponent.getCollectionGroup();
        for (n3 = 0; n3 < this.groupList.size(); ++n3) {
            if (((CsTableInfo)this.groupList.elementAt(n3)).getTableId() != this.targetGroupId) continue;
            jComboBox.setSelectedItem(this.groupList.elementAt(n3));
            break;
        }
        JComboBox jComboBox2 = this.editComponent.getIdentityField();
        for (n2 = 0; n2 < this.fieldList.size(); ++n2) {
            if (((CsTableInfo)this.fieldList.elementAt(n2)).getTableId() != this.identityFieldId) continue;
            jComboBox2.setSelectedItem(this.fieldList.elementAt(n2));
            break;
        }
        JTextField jTextField = this.editComponent.getminValue();
        jTextField.setText(this.minValue);
        JTextField[] jTextFieldArray2 = this.editComponent.getLevelTextFields();
        for (n = 0; n < jTextFieldArray2.length; ++n) {
            jTextFieldArray2[n].getDocument().addDocumentListener(this);
        }
        for (n = 0; n < jComboBoxArray.length; ++n) {
            jComboBoxArray[n].setEnabled(jTextFieldArray[n].getText().length() > 0);
        }
        return this.editComponent;
    }

    public void save() {
        int n;
        boolean bl = true;
        boolean bl2 = true;
        this.requiresCommit = false;
        CsTableInfo csTableInfo = (CsTableInfo)this.editComponent.getCollectionGroup().getSelectedItem();
        this.targetGroupId = csTableInfo.getTableId();
        CsTableInfo csTableInfo2 = (CsTableInfo)this.editComponent.getIdentityField().getSelectedItem();
        this.identityFieldId = csTableInfo2.getTableId();
        this.minValue = this.editComponent.getminValue().getText();
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        JCheckBox jCheckBox = this.editComponent.getWriteOption();
        if (this.levelFieldIds != null) {
            for (n = 0; n < jComboBoxArray.length; ++n) {
                this.levelFieldIds[n] = ((CsTableInfo)jComboBoxArray[n].getSelectedItem()).getTableId();
            }
        }
        if (this.levelNames != null) {
            for (n = 0; n < this.levelNames.length; ++n) {
                String string = jTextFieldArray[n].getText().trim();
                if (string == null || string.length() <= 0) continue;
                this.levelNames[n] = string;
                bl = false;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(null, "At least one level definition is required.\nLevel definition should start from Level 1", "Template Validation Warning", 0);
            bl2 = false;
        }
        if (!bl && this.levelNames[0] == null) {
            JOptionPane.showMessageDialog(null, "Level definition should start from Level 1", "Template Validation Warning", 0);
            bl2 = false;
        }
        if (bl2) {
            if (this.processTemplateDocument() < 0) {
                JOptionPane.showMessageDialog(null, "No match for the specified criteria.\nNo documents were generated.", "Template Validation Warning", 0);
                this.collection.getServer().cancelEdit(this);
                return;
            }
            return;
        }
        this.collection.getServer().cancelEdit(this);
    }

    public void cancel() {
        this.editComponent = null;
        this.collection.getServer().cancelEdit(this);
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-mpd-node-icon.gif");
    }

    public int getIndex() {
        return this.documentId;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        boolean bl = true;
        if (databaseRecord instanceof CsMpd) {
            CsMpdTemplate csMpdTemplate = (CsMpdTemplate)databaseRecord;
            if (this.targetGroupId != csMpdTemplate.getTargetGroupId()) {
                bl = false;
            }
            if (this.identityFieldId != csMpdTemplate.getIdentityFieldId()) {
                bl = false;
            }
            if (!CsMpdTemplate.stringsAreEqual(this.minValue, csMpdTemplate.getminValue())) {
                bl = false;
            }
            String[] stringArray = csMpdTemplate.getLevelNames();
            for (int i = 0; i < this.levelNames.length; ++i) {
                if (this.levelNames[i] == null || stringArray[i] == null || this.levelNames[i].equals(stringArray[i])) continue;
                bl = false;
            }
            int[] nArray = csMpdTemplate.getLevelFieldIds();
            for (int i = 0; i < this.levelFieldIds.length; ++i) {
                if (this.levelFieldIds[i] == nArray[i]) continue;
                bl = false;
            }
        }
        return bl;
    }

    public String getEditWindowTitle() {
        return new String("Multi-Page Template");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        if (this.editComponent != null) {
            for (int i = 0; i < jTextFieldArray.length; ++i) {
                if (documentEvent.getDocument() != jTextFieldArray[i].getDocument()) continue;
                jComboBoxArray[i].setEnabled(jTextFieldArray[i].getText().length() > 0);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        if (this.editComponent != null) {
            for (int i = 0; i < jTextFieldArray.length; ++i) {
                if (documentEvent.getDocument() != jTextFieldArray[i].getDocument()) continue;
                jComboBoxArray[i].setEnabled(jTextFieldArray[i].getText().length() > 0);
            }
        }
    }

    public int getDocumentId() {
        return this.documentId;
    }

    public int getTargetGroupId() {
        return this.targetGroupId;
    }

    public int getIdentityFieldId() {
        return this.identityFieldId;
    }

    public String[] getLevelNames() {
        return this.levelNames;
    }

    public int[] getLevelFieldIds() {
        return this.levelFieldIds;
    }

    public Vector getLevelInfo() {
        return this.levelInfo;
    }

    public Vector getGroupList() {
        return this.groupList;
    }

    public Vector getFieldList() {
        return this.fieldList;
    }

    public boolean getSelectedOption() {
        return this.editComponent.getWriteOption().isSelected();
    }

    public String getminValue() {
        return this.minValue;
    }

    public String getIdValue() {
        return this.IdValues;
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut("CsMpdTemplate: " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut("CsMpdTemplate: " + string, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processTemplateDocument() {
        block12: {
            DatabaseConnector databaseConnector;
            int[] nArray = this.getLevelFieldIds();
            int n = this.getDocumentId();
            String string = null;
            this.mpdocs = this.getDocuments();
            if (this.getSelectedOption()) {
                databaseConnector = this.getDatabaseConnector();
                for (int i = 0; i < this.mpdocs.size(); ++i) {
                    Map map = (Map)this.mpdocs.get(i);
                    string = "DELETE ISDOCUMENTS WHERE DocumentID = " + map.get("DocumentID") + "";
                    databaseConnector.setQuery(string);
                    databaseConnector.runUpdateQuery();
                }
                string = "DELETE FROM IRGROUPIMAGEMAP WHERE MpdSeries = 1";
                databaseConnector.setQuery(string);
                databaseConnector.runUpdateQuery();
                string = "DELETE FROM IRIMAGETODOCUMENTMAP";
                databaseConnector.setQuery(string);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            databaseConnector = this.getDatabaseConnector();
            DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("DTVALUES", null, "ValueText");
            sqlQueryGenerator.appendToWhere("(DTVALUES.FieldID= " + this.getIdentityFieldId() + ")");
            String string2 = "SELECT COUNT(*) FROM DTVALUETOOBJECT, IROBJECTIMAGEMAP, IRGROUPIMAGEMAP WHERE DTVALUES.ValueID = DTVALUETOOBJECT.ValueID AND IRGROUPIMAGEMAP.GroupID = " + this.getTargetGroupId() + " AND " + "IROBJECTIMAGEMAP" + ".ImageID = " + "IRGROUPIMAGEMAP" + ".ImageID" + " AND " + "DTVALUETOOBJECT" + ".ObjectID = " + "IROBJECTIMAGEMAP" + ".ObjectID";
            sqlQueryGenerator.appendToWhere("(" + this.getminValue() + " <= (" + string2 + "))");
            databaseConnector2.setQuery(sqlQueryGenerator.getQuery());
            try {
                databaseConnector2.runQuery();
                if (databaseConnector2.more()) {
                    while (databaseConnector2.more()) {
                        this.IdValues = databaseConnector2.getFieldByName("ValueText");
                        if (this.getSelectedOption()) {
                            this.collection.getServer().commitDataObject(this);
                            ++this.documentId;
                        } else if (!this.findExistingDocument(this.getIdentityFieldId(), this.levelNames, nArray, this.mpdocs, databaseConnector2.getFieldByName("ValueText"))) {
                            this.collection.getServer().commitDataObject(this);
                            ++this.documentId;
                        }
                        databaseConnector2.next();
                    }
                    databaseConnector2.close();
                    break block12;
                }
                databaseConnector2.close();
                int n2 = -1;
                return n2;
            }
            catch (Exception exception) {
                this.debugOut("Exception in mpdt doInsert()");
                exception.printStackTrace();
            }
            finally {
                databaseConnector2.close();
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getDocuments() {
        Vector<Map> vector = new Vector<Map>();
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
        sqlQueryGenerator.addTable("ISDOCUMENTS", null, new String[]{"DocumentID", "DocumentName", "IdentityFieldID", "IdentityValue", "LevelFieldID1", "LevelFieldID2"});
        sqlQueryGenerator.addOrderBy("ISDOCUMENTS", "DocumentID");
        databaseConnector.setQuery(sqlQueryGenerator.getQuery());
        databaseConnector.runQuery();
        try {
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    this.docmap = new HashMap();
                    this.docmap.put("DocumentID", new Integer(databaseConnector.getIntegerFieldByName("DocumentID")));
                    this.docmap.put("DocumentName", databaseConnector.getFieldByName("DocumentName"));
                    this.docmap.put("IdentityFieldID", new Integer(databaseConnector.getIntegerFieldByName("IdentityFieldID")));
                    this.docmap.put("IdentityValue", databaseConnector.getFieldByName("IdentityValue"));
                    this.docmap.put("LevelFieldID1", new Integer(databaseConnector.getIntegerFieldByName("LevelFieldID1")));
                    this.docmap.put("LevelFieldID2", new Integer(databaseConnector.getIntegerFieldByName("LevelFieldID2")));
                    vector.addElement(this.docmap);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in getDocuments()");
            exception.printStackTrace();
        }
        finally {
            databaseConnector.close();
        }
        return vector;
    }

    private boolean findExistingDocument(int n, String[] stringArray, int[] nArray, Vector vector, String string) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Map map = (Map)vector.get(i);
            String string2 = (String)map.get("IdentityValue");
            int n2 = (Integer)map.get("IdentityFieldID");
            int n3 = (Integer)map.get("LevelFieldID1");
            int n4 = (Integer)map.get("LevelFieldID2");
            if (n != n2 || !string.equalsIgnoreCase(string2) || nArray[0] != n3 || nArray[1] != n4) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public DatabaseConnector getDatabaseConnector() {
        this.serverConnector = this.collection.getServer().getCollectionServerConnector();
        return this.serverConnector.getDatabaseConnector();
    }

    public SqlQueryGenerator getQueryGenerator() {
        this.serverConnector = this.collection.getServer().getCollectionServerConnector();
        return this.serverConnector.getQueryGenerator();
    }
}

