/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mpd;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.mpd.CsMpd;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CsMpdNode
extends TableDisplayControlPanelNode {
    private JPopupMenu tablePopup = null;
    private InsightAdministrator insightAdministrator = null;
    private CollectionNode collectionNode = null;
    private CollectionServer collectionServer = null;

    public CsMpdNode(CollectionNode collectionNode) {
        super(collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Multi-Page Documents", false);
        this.collectionNode = collectionNode;
        this.insightAdministrator = collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator();
        this.collectionServer = collectionNode.getCollectionServerNode().getCollectionServer();
    }

    public void updateInformationDisplay() {
        this.columnNames = this.constructColumnNames();
        Integer n = this.collectionNode.getCollection().getUniqueCollectionID();
        this.tableModel.setDataVector(this.getTableData(this.collectionNode.getCollectionServerNode().getCollectionServer().getMpds(n)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CsMpd csMpd = (CsMpd)vector.elementAt(i);
            objectArray[i][0] = csMpd;
            objectArray[i][1] = new Integer(csMpd.getTargetGroupId());
            objectArray[i][2] = new Integer(csMpd.getIdentityFieldId());
            objectArray[i][3] = csMpd.getIdentityValue();
            int n = 4;
            String[] stringArray = csMpd.getLevelNames();
            int[] nArray = csMpd.getLevelFieldIds();
            for (int j = 0; j < csMpd.getLevelNames().length; ++j) {
                objectArray[i][n++] = stringArray[j];
                objectArray[i][n++] = new Integer(nArray[j]);
            }
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New Mpd Command", this.collectionNode));
        jPopupMenu.add(this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("Create Multi-Page Template...", "New Mpdt Command", this.collectionNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-mpd-node-icon.gif");
        }
        return this.treeIcon;
    }

    public String toString() {
        return "Multi-Page Document";
    }

    public CollectionServer getCollectionServer() {
        return this.collectionServer;
    }

    public CollectionServerNode getCollectionServerNode() {
        return this.collectionNode.getCollectionServerNode();
    }

    private String[] constructColumnNames() {
        Vector vector = this.collectionServer.getCollectionServerConnector().getMpdLevelData(-1);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("DocumentName");
        vector2.addElement("Target Group");
        vector2.addElement("Identity Field");
        vector2.addElement("Identity Value");
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement("LevelName" + (i + 1));
            vector2.addElement("LevelFieldId" + (i + 1));
        }
        String[] stringArray = new String[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            stringArray[i] = (String)vector2.elementAt(i);
        }
        return stringArray;
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionNode.getCollectionServerNode().editMpd((CsMpd)object);
        }
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Mpd Command")) {
            this.collectionNode.getCollectionServerNode().createNewMpd(this.collectionNode.getCollection().getUniqueCollectionID());
        } else if (string.equals("Delete Mpd Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionNode.getCollectionServerNode().removeMpd(vector);
            }
        } else if (string.equals("Edit Mpd Command") && vector != null && vector.size() == 1) {
            this.collectionNode.getCollectionServerNode().editMpd((CsMpd)vector.firstElement());
        }
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.collectionNode.getCollectionServerNode().getAdminAccount(), "New Mpd Command", "Edit Mpd Command", "Delete Mpd Command");
    }

    public static void debugOut(String string) {
        CsMpdNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsMpdNode: " + string, n);
    }
}

