/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.sun.media.jai.codec.JPEGEncodeParam;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_ProfileGray;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Comparator;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.MedianFilterDescriptor;
import javax.media.jai.operator.TransposeDescriptor;

public class ImageManager
implements TileCache {
    public static final int DEFAULT_BRIGHTNESS = 0;
    public static final int DEFAULT_CONTRAST = 256;
    public static final int BRIGHTNESS_HIGH = 256;
    public static final int BRIGHTNESS_LOW = -256;
    public static final int CONTRAST_HIGH = 512;
    public static final int CONTRAST_LOW = 0;
    public static final int STEP_VALUE = 10;
    public static final int DEFAULT_NO_CONTRAST = -1;
    public static final int DEFAULT_NO_BRIGHTNESS = -2;
    public static final int FLIP_VERTICAL = 0;
    public static final int FLIP_HORIZONTAL = 1;
    public static final int FLIP_DIAGONAL = 2;
    public static final int FLIP_ANTIDIAGONAL = 3;
    public static final int ROTATE_90 = 4;
    public static final int ROTATE_180 = 5;
    public static final int ROTATE_270 = 6;
    public static final int MEDIAN_SQUARE = 30;
    public static final int MEDIAN_X = 31;
    public static final int MEDIAN_PLUS = 32;
    public static final int MEDIAN_SEPARABLE = 33;
    public static final int LOW_PASS = 10;
    public static final int HIGH_PASS = 11;
    public static final int LAPLACIAN = 12;
    static final float[] lowPassData = new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f};
    static final float[] highPassData = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    static final float[] laplacianData = new float[]{1.0f, 2.0f, 1.0f, -2.0f, 5.0f, -2.0f, 1.0f, -2.0f, 1.0f};
    private static RenderingHints mRenderHints;
    private static float mfSaveQuality;
    private static int miMedianMaskSize;
    private static Interpolation mInterpolation;
    private static TileCache mTileCache;
    private static JAI mJAI;
    private static ImageManager mSingleInstance;

    private ImageManager() {
        this.init();
    }

    public static ImageManager getInstance() {
        return mSingleInstance;
    }

    private void init() {
        mRenderHints = null;
        mfSaveQuality = 0.75f;
        miMedianMaskSize = 3;
        mInterpolation = Interpolation.getInstance((int)1);
        mJAI = new JAI();
        mTileCache = mJAI.getTileCache();
        long l = 0x3000000L;
        mTileCache.setMemoryCapacity(l);
        mTileCache.setTileCapacity(10);
        mJAI.setTileCache(mTileCache);
    }

    public static TileCache getTileCache() {
        return mTileCache;
    }

    public void setTileCapacity(int n) {
        mTileCache.setTileCapacity(n);
    }

    public int getTileCapacity() {
        return mTileCache.getTileCapacity();
    }

    public static void add(PlanarImage planarImage) {
        mTileCache.add((RenderedImage)planarImage, planarImage.getMinX(), planarImage.getMinY(), planarImage.getData());
    }

    public void add(RenderedImage renderedImage, int n, int n2, Raster raster, Object object) {
        mTileCache.add(renderedImage, n, n2, raster, object);
    }

    public Raster[] getTiles(RenderedImage renderedImage) {
        return mTileCache.getTiles(renderedImage);
    }

    public void addTiles(RenderedImage renderedImage, Point[] pointArray, Raster[] rasterArray, Object object) {
        mTileCache.addTiles(renderedImage, pointArray, rasterArray, object);
    }

    public Raster[] getTiles(RenderedImage renderedImage, Point[] pointArray) {
        return mTileCache.getTiles(renderedImage, pointArray);
    }

    public void memoryControl() {
        mTileCache.memoryControl();
    }

    public void setMemoryThreshold(float f) {
        mTileCache.setMemoryThreshold(f);
    }

    public float getMemoryThreshold() {
        return mTileCache.getMemoryThreshold();
    }

    public void setTileComparator(Comparator comparator) {
        mTileCache.setTileComparator(comparator);
    }

    public Comparator getTileComparator() {
        return mTileCache.getTileComparator();
    }

    public void add(RenderedImage renderedImage, int n, int n2, Raster raster) {
        mTileCache.add(renderedImage, n, n2, raster);
    }

    public void flush() {
        mTileCache.flush();
    }

    public long getMemoryCapacity() {
        return mTileCache.getMemoryCapacity();
    }

    public Raster getTile(RenderedImage renderedImage, int n, int n2) {
        return mTileCache.getTile(renderedImage, n, n2);
    }

    public void remove(RenderedImage renderedImage, int n, int n2) {
        mTileCache.remove(renderedImage, n, n2);
    }

    public void removeTiles(RenderedImage renderedImage) {
        mTileCache.removeTiles(renderedImage);
    }

    public void setMemoryCapacity(long l) {
        mTileCache.setMemoryCapacity(l);
    }

    public void save(RenderedOp renderedOp, String string) {
        this.save(renderedOp, string, mfSaveQuality);
        renderedOp = null;
    }

    public void save(RenderedOp renderedOp, String string, float f) {
        JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
        jPEGEncodeParam.setQuality(f);
        JAI.create((String)"filestore", (RenderedImage)renderedOp.createInstance(), (Object)string, (Object)"JPEG", (Object)jPEGEncodeParam);
        renderedOp = null;
        jPEGEncodeParam = null;
    }

    public void save(PlanarImage planarImage, String string, float f) {
        JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
        jPEGEncodeParam.setQuality(f);
        JAI.create((String)"filestore", (RenderedImage)planarImage, (Object)string, (Object)"JPEG", (Object)jPEGEncodeParam);
        planarImage.dispose();
        planarImage = null;
        jPEGEncodeParam = null;
    }

    public RenderedOp transpose(RenderedOp renderedOp, int n) {
        return this.transpose(renderedOp.createInstance(), n);
    }

    public synchronized RenderedOp transpose(PlanarImage planarImage, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        switch (n) {
            case 4: {
                parameterBlock.add(TransposeDescriptor.ROTATE_90);
                break;
            }
            case 5: {
                parameterBlock.add(TransposeDescriptor.ROTATE_180);
                break;
            }
            case 6: {
                parameterBlock.add(TransposeDescriptor.ROTATE_270);
                break;
            }
            case 2: {
                parameterBlock.add(TransposeDescriptor.FLIP_DIAGONAL);
                break;
            }
            case 3: {
                parameterBlock.add(TransposeDescriptor.FLIP_ANTIDIAGONAL);
                break;
            }
            case 1: {
                parameterBlock.add(TransposeDescriptor.FLIP_HORIZONTAL);
                break;
            }
            case 0: {
                parameterBlock.add(TransposeDescriptor.FLIP_VERTICAL);
                break;
            }
            default: {
                parameterBlock.add(TransposeDescriptor.FLIP_HORIZONTAL);
            }
        }
        RenderedOp renderedOp = JAI.create((String)"transpose", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
        return renderedOp;
    }

    public RenderedOp blur(RenderedOp renderedOp, int n, int n2) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedOp.createInstance());
        parameterBlock.add(n);
        parameterBlock.add(n2);
        RenderedOp renderedOp2 = JAI.create((String)"BoxFilter", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
        renderedOp = null;
        parameterBlock = null;
        return renderedOp2;
    }

    public RenderedOp medianFilter(RenderedOp renderedOp, int n) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedOp.createInstance());
        switch (n) {
            case 30: {
                parameterBlock.add(MedianFilterDescriptor.MEDIAN_MASK_SQUARE);
                break;
            }
            case 31: {
                parameterBlock.add(MedianFilterDescriptor.MEDIAN_MASK_X);
                break;
            }
            case 32: {
                parameterBlock.add(MedianFilterDescriptor.MEDIAN_MASK_PLUS);
                break;
            }
            case 33: {
                parameterBlock.add(MedianFilterDescriptor.MEDIAN_MASK_SQUARE_SEPARABLE);
                break;
            }
            default: {
                parameterBlock.add(MedianFilterDescriptor.MEDIAN_MASK_SQUARE);
            }
        }
        parameterBlock.add(miMedianMaskSize);
        RenderedOp renderedOp2 = JAI.create((String)"medianfilter", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
        renderedOp = null;
        parameterBlock = null;
        return renderedOp2;
    }

    public RenderedOp increaseThreshold(PlanarImage planarImage, int n) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        dArray[0] = 0.0;
        dArray2[0] = 0.0;
        dArray3[0] = n;
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(dArray);
        parameterBlock.add(dArray3);
        parameterBlock.add(dArray2);
        return JAI.create((String)"threshold", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
    }

    public RenderedOp convertWhiteToBlack(PlanarImage planarImage) {
        int n = planarImage.getSampleModel().getNumBands() - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 253.0;
            dArray2[i] = 255.0;
            dArray3[i] = 0.0;
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(dArray);
        parameterBlock.add(dArray2);
        parameterBlock.add(dArray3);
        return JAI.create((String)"threshold", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
    }

    public RenderedOp decreaseThreshold(PlanarImage planarImage, int n) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        dArray[0] = 0.0;
        dArray2[0] = 255.0;
        dArray3[0] = n;
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(dArray);
        parameterBlock.add(dArray3);
        parameterBlock.add(dArray2);
        return JAI.create((String)"threshold", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
    }

    public synchronized PlanarImage adjustBrightness(PlanarImage planarImage, int n) {
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = this.clampByte(i + n);
        }
        LookupTableJAI lookupTableJAI = new LookupTableJAI(byArray);
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(lookupTableJAI);
        RenderedOp renderedOp = JAI.create((String)"lookup", (ParameterBlock)parameterBlock, null);
        mTileCache.removeTiles((RenderedImage)planarImage);
        planarImage.dispose();
        planarImage = null;
        return renderedOp;
    }

    public synchronized int getClampedBrightness(double d) {
        return Math.round((float)d * 100.0f / 256.0f);
    }

    public synchronized double unclampBrightness(int n) {
        return (double)n * 256.0 / 100.0;
    }

    public synchronized int getClampedRealBrightness(int n) {
        int n2;
        if (this.getClampedBrightness(n) % 10 == 0) {
            return Math.abs(n);
        }
        if (n < 0) {
            n = Math.abs(n);
        }
        if ((n2 = this.getClampedBrightness(n)) % 10 < 5) {
            while (n2 % 10 != 0) {
                n2 = this.getClampedBrightness(--n);
            }
        } else {
            while (n2 % 10 != 0) {
                n2 = this.getClampedBrightness(++n);
            }
        }
        return n;
    }

    public synchronized int getClampedContrast(double d) {
        return Math.round((float)d * 100.0f / 256.0f - 100.0f);
    }

    public synchronized double unclampContrast(int n) {
        return ((double)n + 100.0) * 256.0 / 100.0;
    }

    public synchronized int getClampedRealContrast(int n) {
        if (Math.abs(this.getClampedContrast(n)) % 10 == 0) {
            return n;
        }
        int n2 = this.getClampedContrast(n);
        if (Math.abs(n2 % 10) < 5) {
            while (n2 % 10 != 0) {
                n = n2 % 10 < 0 ? ++n : --n;
                n2 = this.getClampedContrast(n);
            }
        } else {
            while (n2 % 10 != 0) {
                n2 = this.getClampedContrast(++n);
            }
        }
        return n;
    }

    private final int maxInt(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private final int minInt(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    private final byte clampByte(int n) {
        if (n > 255) {
            return -1;
        }
        if (n < 0) {
            return 0;
        }
        return (byte)n;
    }

    public static final synchronized PlanarImage adjustContrast(PlanarImage planarImage, double d) {
        if (d > 512.0) {
            d = 512.0;
        } else if (d < 0.0) {
            d = 0.0;
        }
        return ImageManager.getRescaledImage(planarImage, 0.0, d);
    }

    public static final PlanarImage getRescaledImage(PlanarImage planarImage, double d, double d2) {
        if (planarImage == null) {
            return null;
        }
        ParameterBlock parameterBlock = null;
        RenderedOp renderedOp = null;
        int n = planarImage.getSampleModel().getNumBands();
        int n2 = planarImage.getSampleModel().getDataType();
        if (n2 == 0) {
            double d3;
            double d4;
            if (d2 != d) {
                d4 = 256.0 / (d2 - d);
                d3 = 256.0 - d4 * d2;
            } else {
                d4 = 0.0;
                d3 = 0.0;
            }
            byte[][] byArray = new byte[n][256];
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n3 = (int)(d4 * (double)i + d3);
                    n3 = n3 < (int)d ? 0 : (n3 > (int)d2 ? 255 : (n3 &= 0xFF));
                    byArray[j][i] = (byte)n3;
                }
            }
            LookupTableJAI lookupTableJAI = new LookupTableJAI(byArray);
            parameterBlock = new ParameterBlock();
            parameterBlock.addSource(planarImage);
            parameterBlock.add(lookupTableJAI);
            renderedOp = JAI.create((String)"lookup", (ParameterBlock)parameterBlock, null);
        } else if (n2 == 2 || n2 == 1) {
            double d5;
            double d6;
            if (d2 != d) {
                d6 = 256.0 / (d2 - d);
                d5 = 256.0 - d6 * d2;
            } else {
                d6 = 0.0;
                d5 = 0.0;
            }
            byte[][] byArray = new byte[n][65536];
            for (int i = 0; i < 65535; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n4 = (int)(d6 * (double)i + d5);
                    if (n2 == 1) {
                        n4 &= 0xFFFF;
                    }
                    n4 = n4 < (int)d ? 0 : (n4 > (int)d2 ? 255 : (n4 &= 0xFF));
                    byArray[j][i] = (byte)n4;
                }
            }
            LookupTableJAI lookupTableJAI = new LookupTableJAI(byArray);
            parameterBlock = new ParameterBlock();
            parameterBlock.addSource(planarImage);
            parameterBlock.add(lookupTableJAI);
            renderedOp = JAI.create((String)"lookup", (ParameterBlock)parameterBlock, null);
        } else if (n2 == 3 || n2 == 4 || n2 == 5) {
            double d7;
            double d8;
            if (d2 != d) {
                d8 = 256.0 / (d2 - d);
                d7 = 256.0 - d8 * d2;
            } else {
                d8 = 0.0;
                d7 = 0.0;
            }
            parameterBlock = new ParameterBlock();
            parameterBlock.addSource(planarImage);
            parameterBlock.add(d8);
            parameterBlock.add(d7);
            renderedOp = JAI.create((String)"rescale", (ParameterBlock)parameterBlock, null);
            parameterBlock = new ParameterBlock();
            parameterBlock.addSource(renderedOp);
            parameterBlock.add(0);
            renderedOp = JAI.create((String)"format", (ParameterBlock)parameterBlock, null);
        }
        planarImage.dispose();
        return renderedOp;
    }

    public RenderedOp scale(RenderedOp renderedOp, Dimension dimension) {
        return this.scale(renderedOp.createInstance(), dimension);
    }

    public RenderedOp scale(PlanarImage planarImage, Dimension dimension) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (planarImage.getWidth() > planarImage.getHeight()) {
            f2 = f = (float)dimension.width / (float)planarImage.getWidth();
        } else {
            f = f2 = (float)dimension.width / (float)planarImage.getHeight();
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(0.0f);
        parameterBlock.add(0.0f);
        parameterBlock.add(mInterpolation);
        RenderedOp renderedOp = JAI.create((String)"scale", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
        mTileCache.removeTiles((RenderedImage)planarImage);
        planarImage.dispose();
        planarImage = null;
        parameterBlock = null;
        return renderedOp;
    }

    public RenderedOp convolve(PlanarImage planarImage, int n, boolean bl) {
        if (!bl) {
            switch (n) {
                case 10: {
                    KernelJAI kernelJAI = new KernelJAI(3, 3, lowPassData);
                    return JAI.create((String)"convolve", (RenderedImage)planarImage, (Object)kernelJAI, (Object)mRenderHints);
                }
                case 11: {
                    KernelJAI kernelJAI = new KernelJAI(3, 3, highPassData);
                    return JAI.create((String)"convolve", (RenderedImage)planarImage, (Object)kernelJAI, (Object)mRenderHints);
                }
                case 12: {
                    KernelJAI kernelJAI = new KernelJAI(3, 3, laplacianData);
                    return JAI.create((String)"convolve", (RenderedImage)planarImage, (Object)kernelJAI, (Object)mRenderHints);
                }
            }
            KernelJAI kernelJAI = new KernelJAI(3, 3, lowPassData);
            return JAI.create((String)"convolve", (RenderedImage)planarImage, (Object)kernelJAI, (Object)mRenderHints);
        }
        float[] fArray = new float[9];
        int n2 = n;
        float f = n2 > 150 ? ((float)n2 - 125.0f) / 25.0f : (float)n2 / 150.0f;
        float f2 = (1.0f - f) / 8.0f;
        for (int i = 0; i < 9; ++i) {
            fArray[i] = f2;
        }
        fArray[4] = f;
        KernelJAI kernelJAI = new KernelJAI(3, 3, 1, 1, fArray);
        return JAI.create((String)"convolve", (RenderedImage)planarImage, (Object)kernelJAI, (Object)mRenderHints);
    }

    public TiledImage getICCSingleBandedGrayscale(PlanarImage planarImage) {
        int n = planarImage.getWidth();
        int n2 = planarImage.getHeight();
        ICC_ProfileGray iCC_ProfileGray = (ICC_ProfileGray)ICC_ProfileGray.getInstance(1003);
        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_ProfileGray);
        int[] nArray = new int[]{8};
        ComponentColorModel componentColorModel = new ComponentColorModel(iCC_ColorSpace, nArray, false, false, planarImage.getColorModel().getTransparency(), 0);
        WritableRaster writableRaster = componentColorModel.createCompatibleWritableRaster(n, n2);
        writableRaster = planarImage.copyData(writableRaster);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        bufferedImage.setData(writableRaster);
        return new TiledImage((RenderedImage)bufferedImage, false);
    }

    public PlanarImage getCombinedGrayscale(PlanarImage planarImage) {
        PlanarImage planarImage2 = planarImage.createSnapshot();
        int n = planarImage.getSampleModel().getNumBands() + 1;
        double[][] dArray = new double[1][n];
        dArray[0][0] = 0.114;
        dArray[0][1] = 0.587;
        dArray[0][2] = 0.299;
        dArray[0][3] = 0.0;
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(planarImage2);
        parameterBlock.add(dArray);
        return JAI.create((String)"bandcombine", (ParameterBlock)parameterBlock, (RenderingHints)mRenderHints);
    }

    public final void addRenderingHint(RenderingHints.Key key, Object object) {
        if (mRenderHints == null) {
            mRenderHints = new RenderingHints(key, object);
        } else {
            mRenderHints.add(new RenderingHints(key, object));
        }
    }

    public final void removeRenderingHint(Object object) {
        if (mRenderHints != null) {
            Object object2 = mRenderHints.remove(object);
        }
    }

    public void clearRenderingHints() {
        if (mRenderHints != null) {
            mRenderHints.clear();
        }
    }

    public void setInterpolation(Interpolation interpolation) {
        mInterpolation = interpolation;
    }

    public Interpolation getInterpolation() {
        return mInterpolation;
    }

    public void setSaveQuality(float f) {
        mfSaveQuality = f;
    }

    public void setMedianMaskSize(int n) {
        miMedianMaskSize = n;
    }

    static {
        mSingleInstance = new ImageManager();
    }
}

