/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.mediacreation.CcMediaSourceRecord;
import com.luna.insight.admin.collserver.mediacreation.CsMediaFile;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class CsMediaFileRecordHandler
extends DatabaseRecordHandler {
    public CsMediaFileRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CsMediaFileRecordHandler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMultipleRecords(Vector vector) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            this.debugOut("Inserting " + vector.size() + " media file records.", 2);
            HashSet<Long> hashSet = new HashSet<Long>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CsMediaFile csMediaFile = (CsMediaFile)enumeration.nextElement();
                String string = "INSERT INTO IRIMAGEFILES (ImageID, ResolutionSize, Format, MediaType, LPSid, Filename, Width, Height) VALUES (" + csMediaFile.mediaID + ", " + csMediaFile.resolutionSize + ", " + this.prepForInsertQuery(csMediaFile.format) + ", " + csMediaFile.mediaType + ", " + csMediaFile.lpsId + ", " + this.prepForInsertQuery(csMediaFile.filename) + ", " + csMediaFile.width + ", " + csMediaFile.height + ")";
                this.debugOut("Insert media command:\n" + string, 2);
                databaseConnector.setQuery(string);
                databaseConnector.runUpdateQuery();
                if (!hashSet.contains(new Long(csMediaFile.mediaID))) {
                    string = "INSERT INTO IRCOLLECTIONMEDIAMAP (UniqueCollectionID, MediaID) VALUES (" + csMediaFile.collection.getUniqueCollectionID() + ", " + csMediaFile.mediaID + ")";
                    databaseConnector.setQuery(string);
                    databaseConnector.runUpdateQuery();
                    hashSet.add(new Long(csMediaFile.mediaID));
                }
                databaseConnector.setQuery("DELETE FROM IRRESERVEDMEDIAIDS WHERE ReservedMediaID = " + csMediaFile.mediaID);
                databaseConnector.runUpdateQuery();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert():\n" + InsightUtilities.getStackTrace(exception), 2);
        }
        finally {
            databaseConnector.close();
        }
    }

    public void doInsert(DatabaseRecord databaseRecord) {
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
    }

    public Vector getRecords() {
        return null;
    }

    public Vector getRecords(Integer n) {
        return this.getRecords(n, true);
    }

    public Vector getRecords(Integer n, boolean bl) {
        this.debugOut("in getRecords()");
        Vector<CsMediaFile> vector = new Vector<CsMediaFile>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRIMAGEFILES", null, "*");
            sqlQueryGenerator.addJoin("IRIMAGEFILES", "ImageID", "IRCOLLECTIONMEDIAMAP", "MediaID", 0);
            sqlQueryGenerator.appendToWhere("IRCOLLECTIONMEDIAMAP.UniqueCollectionID =" + n);
            if (bl) {
                sqlQueryGenerator.appendToWhere("(IRIMAGEFILES.ResolutionSize=0)");
            }
            sqlQueryGenerator.addOrderBy("IRIMAGEFILES", "ImageID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Media files query is:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                CsMediaFile csMediaFile = null;
                while (databaseConnector.more()) {
                    long l = databaseConnector.getLongField("ImageID");
                    int n2 = databaseConnector.getIntegerFieldByName("ResolutionSize");
                    csMediaFile = new CsMediaFile(((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCollectionNode(n).getCollection(), l, n2, databaseConnector.getFieldByName("Format"), databaseConnector.getIntegerFieldByName("MediaType"), databaseConnector.getIntegerFieldByName("LPSid"), databaseConnector.getFieldByName("Filename"), databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
                    vector.addElement(csMediaFile);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        this.debugOut("size : " + vector.size());
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CsMediaFile csMediaFile = null;
        int n = (int)((CsMediaFile)databaseRecord).mediaID;
        int n2 = ((CsMediaFile)databaseRecord).resolutionSize;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRIMAGEFILES", null, "*");
            sqlQueryGenerator.appendToWhere("(IRIMAGEFILES.ImageID=" + n + ")" + "AND (" + "IRIMAGEFILES" + ".ResolutionSize=" + n2 + ")");
            sqlQueryGenerator.addOrderBy("IRIMAGEFILES", "ImageID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Media file query is:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                csMediaFile = new CsMediaFile(((CsMediaFile)databaseRecord).collection, databaseConnector.getLongField("ImageID"), databaseConnector.getIntegerFieldByName("ResolutionSize"), databaseConnector.getFieldByName("Format"), databaseConnector.getIntegerFieldByName("MediaType"), databaseConnector.getIntegerFieldByName("LPSid"), databaseConnector.getFieldByName("Filename"), databaseConnector.getIntegerFieldByName("Width"), databaseConnector.getIntegerFieldByName("Height"));
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + exception);
        }
        return csMediaFile;
    }

    public String getNextValidIDQuery() {
        return "";
    }

    public void updateMaxIDValue(long l) {
    }

    public long getMaxID() {
        long l = 0L;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT MAX(ImageID) AS MaxID FROM IRIMAGEFILES");
            this.debugOut("Get max ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l = databaseConnector.getLongField("MaxID");
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMaxID(): " + InsightUtilities.getStackTrace(exception));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyBatchDatabaseEntries(List list) {
        if (list == null) {
            return false;
        }
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            CcMediaSourceRecord ccMediaSourceRecord = (CcMediaSourceRecord)list.get(i);
            long l = ccMediaSourceRecord.getDestMediaID();
            int n2 = 0;
            try {
                String string = "SELECT COUNT(*) AS Count FROM IRIMAGEFILES WHERE ((ImageID=" + l + ")" + " AND (ResolutionSize=0 OR ResolutionSize=1 OR ResolutionSize=2))";
                databaseConnector.setQuery(string);
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    n2 = databaseConnector.getIntegerFieldByName("Count");
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in verifyBatchDatabaseEntries(): " + exception);
            }
            finally {
                databaseConnector.close();
            }
            if (bl && n != n2) {
                return false;
            }
            bl = true;
            n = n2;
        }
        databaseConnector.close();
        return true;
    }
}

