/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdminDesktopPane;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcPublishMediaBatchUrlListDialog;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.admin.collserver.objectmediamap.ConfirmDialog;
import com.luna.insight.admin.collserver.sps.CcSpsData;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CcPublishMediaBatchDialog
extends JInternalFrame
implements KeyListener,
FocusListener,
ActionListener,
DocumentListener {
    public static final String COMMAND_PUBLISH_TO_EXISTING = "command-publish-to-existing";
    public static final String COMMAND_PUBLISH_TO_NEW = "command-publish-to-new";
    protected CollectionServer server;
    protected CcMediaBatch batch;
    protected JScrollPane scroller = null;
    protected JPanel internalPanel = null;
    protected JButton pubToNewButton = null;
    protected JTextField groupTextField = null;
    protected JButton pubToExistingButton = null;
    protected JComboBox groupSelector = null;
    protected Vector mediaGroups;

    public static void debugOut(String string) {
        CcPublishMediaBatchDialog.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcPublishMediaBatchDialog: " + string, n);
    }

    public CcPublishMediaBatchDialog(CollectionServer collectionServer, CcMediaBatch ccMediaBatch) {
        super("Publish Batch \"" + ccMediaBatch.getBatchName() + "\"", false, true, false, true);
        this.server = collectionServer;
        this.batch = ccMediaBatch;
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                CcPublishMediaBatchDialog.this.close();
            }
        });
        this.setFrameIcon(IconMaker.createImage("images/cc-publish-media-batch-icon.gif"));
        this.getContentPane().setLayout(new BorderLayout());
        this.scroller = new JScrollPane();
        this.getContentPane().add((Component)this.scroller, "Center");
        this.populateInternalPanel();
        this.scroller.getViewport().add(this.internalPanel);
        this.scroller.getViewport().doLayout();
        this.scroller.getVerticalScrollBar().setUnitIncrement(10);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(10);
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        }
        this.scroller.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, colorUIResource));
        this.pack();
        Dimension dimension = this.getPreferredSize();
        int n = new JScrollBar().getPreferredSize().width;
        this.setPreferredSize(new Dimension(dimension.width + n, dimension.height + n));
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    protected void populateInternalPanel() {
        int n = 5;
        int n2 = 10;
        this.internalPanel = new JPanel(new VerticalStackResizeWidthLayout(5));
        this.internalPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel jLabel = this.createLabel("Publish \"" + this.batch.getBatchName() + "\"");
        jLabel.setBorder(new EmptyBorder(0, n, 5, 0));
        this.internalPanel.add(jLabel);
        jLabel = this.createLabel("To new collection group");
        this.groupTextField = this.createTextField();
        this.pubToNewButton = this.createButton("Publish To New", COMMAND_PUBLISH_TO_NEW);
        this.pubToNewButton.setEnabled(false);
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        jPanel.setBorder(new EmptyBorder(0, n2, 0, n2));
        jPanel.add(jLabel);
        jPanel.add(this.groupTextField);
        jPanel.add(this.pubToNewButton);
        jPanel.setSize(jPanel.getPreferredSize());
        this.internalPanel.add(jPanel);
        this.mediaGroups = this.server.getCollectionServerConnector().getMediaGroupRecords(this.batch.getUniqueCollectionID(), 1);
        if (this.mediaGroups != null && this.mediaGroups.size() > 0) {
            jPanel = new JPanel(new GridLayout(1, 3, 5, 5));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, MetalLookAndFeel.getPrimaryControl()), new EmptyBorder(6, n2, 0, n2)));
            jLabel = this.createLabel("To existing collection group");
            this.groupSelector = new JComboBox(this.mediaGroups);
            this.groupSelector.doLayout();
            this.groupSelector.setSize(this.groupSelector.getPreferredSize());
            this.pubToExistingButton = this.createButton("Publish To Existing", COMMAND_PUBLISH_TO_EXISTING);
            jPanel.add(jLabel);
            jPanel.add(this.groupSelector);
            jPanel.add(this.pubToExistingButton);
            jPanel.setSize(jPanel.getPreferredSize());
            this.internalPanel.add(jPanel);
        }
    }

    public void show() {
        AdminDesktopPane adminDesktopPane = InsightAdministrator.getInsightAdministrator().getDesktop();
        adminDesktopPane.add(this);
        super.show();
    }

    public void setSelected(boolean bl) {
        try {
            super.setSelected(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestFocus();
    }

    public void close() {
        this.closeDialog(null);
        this.server.publishMediaBatchDialogClosed(this.batch);
    }

    protected void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    protected CsMediaGroup getMediaGroup(String string) {
        for (int i = 0; string != null && this.mediaGroups != null && i < this.mediaGroups.size(); ++i) {
            CsMediaGroup csMediaGroup = (CsMediaGroup)this.mediaGroups.get(i);
            if (csMediaGroup.getName() == null || !csMediaGroup.getName().equalsIgnoreCase(string)) continue;
            return csMediaGroup;
        }
        return null;
    }

    protected boolean isBatchPublicationConfirmed(String string) {
        if (string != null && string.trim().length() > 0) {
            String string2 = "You are about to publish the media from batch \"" + this.batch.getBatchName() + "\"\nto collection group \"" + string + "\".\nDo you wish to proceed?";
            String string3 = "Batch Publication Confirmation";
            return new ConfirmDialog(this, string3, string2, false).isConfirmed();
        }
        return false;
    }

    protected void publishToGroup(String string) {
        CsMediaGroup csMediaGroup = this.getMediaGroup(string);
        if (csMediaGroup == null) {
            csMediaGroup = new CsMediaGroup(this.server, this.batch.getUniqueCollectionID(), this.server.getCollectionServerConnector().getNextValidMediaGroupID(), string, 0, 1, "NA", null, null);
            this.server.commitDataObject(csMediaGroup);
        }
        this.publishToGroup(csMediaGroup);
    }

    protected void publishToGroup(CsMediaGroup csMediaGroup) {
        this.server.getCollectionServerConnector().publishMediaBatch(this.batch, csMediaGroup);
        this.showBatchPublishingInstructions();
        this.close();
    }

    protected void showBatchPublishingInstructions() {
        String string = "Copy Images To Web Server";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Vector vector = this.server.getCollectionServerConnector().getSpsDataRecordsForPublishDialog();
        stringBuffer2 = CcPublishMediaBatchDialog.constructSpsList(vector);
        CcPublishMediaBatchUrlListDialog ccPublishMediaBatchUrlListDialog = new CcPublishMediaBatchUrlListDialog(this.server.getInsightAdministrator());
        ccPublishMediaBatchUrlListDialog.getCurrentLocationLabel().setText("\"" + this.batch.getDestDir() + "\"");
        ccPublishMediaBatchUrlListDialog.getUrlListTextArea().setText(stringBuffer2.toString());
        ccPublishMediaBatchUrlListDialog.show();
    }

    protected static StringBuffer constructSpsList(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return new StringBuffer("[None specified]");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        String string = "";
        int n2 = -1;
        for (int i = 0; i < vector.size(); ++i) {
            CcSpsData ccSpsData = (CcSpsData)vector.elementAt(i);
            if (ccSpsData.mediaType != n) {
                n = ccSpsData.mediaType;
                string = ccSpsData.format;
                n2 = ccSpsData.resolutionSize;
                if (n == 1 && string.equals("JPEG")) {
                    stringBuffer.append("Size " + n2 + ":   ");
                } else if (n == 1 && ccSpsData.format.equals("SID")) {
                    stringBuffer.append("SIDS:    ");
                } else if (n == 1 && ccSpsData.format.equals("JP2")) {
                    stringBuffer.append("JP2K:    ");
                } else if (n == 2) {
                    stringBuffer.append("AUDIO:   ");
                } else if (n == 4) {
                    stringBuffer.append("QTVR:    ");
                } else if (n == 3) {
                    stringBuffer.append("VIDEO:   ");
                }
            } else if (!ccSpsData.format.equals(string) && n == 1) {
                string = ccSpsData.format;
                n2 = ccSpsData.resolutionSize;
                if (string.equals("SID")) {
                    stringBuffer.append("SIDS:    ");
                } else if (string.equals("JP2")) {
                    stringBuffer.append("JP2K:    ");
                } else {
                    stringBuffer.append("Size " + n2 + ":   ");
                }
            } else if (ccSpsData.resolutionSize != n2 && n == 1 && ccSpsData.format.equals("JPEG")) {
                n2 = ccSpsData.resolutionSize;
                stringBuffer.append("Size " + n2 + ":   ");
            } else {
                stringBuffer.append("                ");
            }
            stringBuffer.append(ccSpsData.url + "\n");
        }
        return stringBuffer;
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            Rectangle rectangle = component.getBounds();
            Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), rectangle, this.scroller.getViewport());
            this.scroller.getViewport().scrollRectToVisible(rectangle2);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.close();
        } else if (keyEvent.getSource() == this.groupTextField) {
            if (keyEvent.getKeyCode() == 10) {
                this.pubToNewButton.doClick();
                keyEvent.consume();
            }
        } else if (keyEvent.getSource() == this.groupSelector && keyEvent.getKeyCode() == 10) {
            this.pubToExistingButton.doClick();
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CsMediaGroup csMediaGroup;
        String string = actionEvent.getActionCommand();
        CcPublishMediaBatchDialog.debugOut("Received command: " + string);
        if (string.equals(COMMAND_PUBLISH_TO_NEW)) {
            String string2 = this.groupTextField.getText().trim();
            if (this.isBatchPublicationConfirmed(string2)) {
                this.publishToGroup(string2);
            }
        } else if (string.equals(COMMAND_PUBLISH_TO_EXISTING) && this.isBatchPublicationConfirmed((csMediaGroup = (CsMediaGroup)this.groupSelector.getSelectedItem()).getName())) {
            this.publishToGroup(csMediaGroup);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.groupTextField.getDocument()) {
            this.pubToNewButton.setEnabled(this.groupTextField.getText().length() > 0);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.groupTextField.getDocument()) {
            this.pubToNewButton.setEnabled(this.groupTextField.getText().length() > 0);
        }
    }

    protected JButton createButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setSize(jButton.getPreferredSize());
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        return jButton;
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setSize(jLabel.getPreferredSize());
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    protected JTextField createTextField() {
        final JTextField jTextField = new JTextField();
        jTextField.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), new EmptyBorder(0, 2, 0, 0)));
        jTextField.getDocument().addDocumentListener(this);
        jTextField.addKeyListener(this);
        jTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                jTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        return jTextField;
    }

    protected void refreshLayout() {
        this.scroller.doLayout();
        this.scroller.getViewport().doLayout();
        this.internalPanel.doLayout();
        this.scroller.getViewport().doLayout();
        this.scroller.invalidate();
        this.scroller.validate();
        this.scroller.repaint();
        this.scroller.getVerticalScrollBar().repaint();
        this.scroller.getHorizontalScrollBar().repaint();
    }
}

