/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElement;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchProcessListItem;
import com.luna.insight.admin.collserver.mediacreation.CcMediaCreationProgressDisplay;
import com.luna.insight.admin.collserver.mediacreation.CsMediaFile;
import com.luna.insight.admin.collserver.mediacreation.ImageMagickInvoker;
import com.luna.insight.admin.collserver.mediacreation.MBConvertInvoker;
import com.luna.insight.admin.collserver.mediacreation.SidGenerator;
import com.luna.insight.client.media.MediaFileMetadata;
import com.luna.insight.core.jpeg2000.IJPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.util.metadata.tool.MetadataTool;
import com.luna.insight.server.util.metadata.tool.MetadataToolFactory;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import net.sf.ij.jaiio.JAIReader;

public class CcMediaSourceRecord
extends CcMediaBatchElement {
    public static final int MULTIMEDIA_RESOLUTION = 2;
    public static final String JPEG_EXT = ".jpg";
    public static final String SID_EXT = ".sid";
    public static final String JP2_EXT = ".jp2";
    public static final String PHOTO_CD_EXT = ".pcd";
    public static final String SHORT_TIFF_EXT = ".tif";
    public static final String LONG_TIFF_EXT = ".tiff";
    public static final String TEMP_TIFF_DIRECTORY = "tmp_tiffs";
    private static final int BRIGHTNESS_HIGH = 256;
    private static final int BRIGHTNESS_LOW = -256;
    private static final String MOGRIFY_FILTER = "box";
    public static final int SID_LEVEL_8_MAX = 30000;
    public static final int SID_LEVEL_7_MAX = 12288;
    public static final int SID_LEVEL_6_MAX = 6144;
    public static final int SID_LEVEL_5_MAX = 3072;
    public static final int SID_LEVEL_4_MAX = 1536;
    public static final int SID_LEVEL_3_MAX = 768;
    public static final int SID_LEVEL_2_MAX = 384;
    public static final int SID_LEVEL_1_MAX = 192;
    public static final int SID_LEVEL_0_MAX = 96;
    private static boolean configuredJPEG2KCodec = false;
    protected Collection collection;
    protected List resolutions;
    protected String batchCode;
    protected String sequenceCode;
    protected boolean resampleDuringResize = true;
    protected boolean processSourceImage = false;
    protected RenderedOp source = null;
    protected int sourceWidth = 0;
    protected int sourceHeight = 0;
    protected boolean mediaCreationComplete = false;
    protected ImageIcon thumbImage = null;
    protected int resIndex = 0;
    protected String outputFilename = "";
    protected int destWidth = 0;
    protected int destHeight = 0;
    protected Vector mediaFileRecords = new Vector();
    protected Vector writtenFilePaths = new Vector();
    protected boolean jp2GenerationComplete = false;
    protected String jp2Filename = null;
    protected boolean sidGenerationComplete = false;
    protected String sidFilename = null;
    protected boolean preserveFilenames = false;
    protected CcMediaCreationProgressDisplay mediaProgressListener = null;
    protected static MetadataTool metadataTool = null;
    int[] pixel = new int[3];

    public static void debugOut(String string) {
        CcMediaSourceRecord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaSourceRecord: " + string, n);
    }

    public CcMediaSourceRecord(Collection collection, CcMediaBatchProcessListItem ccMediaBatchProcessListItem) {
        super(ccMediaBatchProcessListItem);
        this.collection = collection;
    }

    public CcMediaSourceRecord(Collection collection, CcMediaBatch ccMediaBatch, long l, int n, String string, String string2, long l2, int n2, String string3, String string4, String string5) {
        super(ccMediaBatch, l, n, string, string2, l2, n2, string3, string4, string5);
        this.collection = collection;
    }

    public void setResolutions(List list) {
        this.resolutions = list;
    }

    public void setBatchCode(String string) {
        this.batchCode = string;
    }

    public void setSequenceCode(String string) {
        this.sequenceCode = string;
    }

    public void setResampleDuringResize(boolean bl) {
        this.resampleDuringResize = bl;
    }

    public void setProcessSourceImage(boolean bl) {
        this.processSourceImage = bl;
    }

    public void setPreserveFilenames(boolean bl) {
        this.preserveFilenames = bl;
    }

    public void setMediaProgressListener(CcMediaCreationProgressDisplay ccMediaCreationProgressDisplay) {
        this.mediaProgressListener = ccMediaCreationProgressDisplay;
    }

    public void setStatusMessage(String string) {
        if (this.mediaProgressListener != null) {
            this.mediaProgressListener.setStatusMessage(string);
        }
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public String getSequenceCode() {
        return this.sequenceCode;
    }

    public boolean getResampleDuringResize() {
        return this.resampleDuringResize;
    }

    public ImageIcon getThumbnailImage() {
        return this.thumbImage;
    }

    public int getResolutionSize() {
        return this.resIndex;
    }

    public String getDestFilename() {
        return this.outputFilename;
    }

    public int getDestWidth() {
        return this.destWidth;
    }

    public int getDestHeight() {
        return this.destHeight;
    }

    public void flushThumbnailImages() {
        if (this.thumbImage != null && this.thumbImage.getImage() != null) {
            this.thumbImage.getImage().flush();
            this.thumbImage = null;
        }
    }

    public void generateMedia() {
        this.setStatusMessage("Analyzing media type for " + this.getSrcFilename());
        MediaFileMetadata mediaFileMetadata = new MediaFileMetadata(this.getFullSrcFilepath(), this.collection.getServer().getInsightAdministrator().readMiscFileExtensionList());
        mediaFileMetadata.getMetadata();
        if (mediaFileMetadata.getMediaType() == 1) {
            this.createImages();
        } else {
            this.createMultimedia(mediaFileMetadata);
        }
        if (this.mediaCreationComplete) {
            this.setStatus(1);
            this.setProcessedTimestamp(new SimpleDate().get());
        } else {
            this.setStatus(2);
            this.logLineToFile(new Date() + "- WARNING: Derivative image creation could not be completed.");
        }
        this.setStatusMessage("Writing media records to database.");
        this.commitMediaFileRecords();
        try {
            this.collection.getServer().getCollectionServerConnector().commitRecord(this);
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Batch element " + this.getBatchElementID() + " could not be updated. exc: " + InsightUtilities.getStackTrace(exception));
            this.logLineToFile(new Date() + ": Batch element " + this.getBatchElementID() + " could not be updated. exc: " + InsightUtilities.getStackTrace(exception));
        }
        if (this.source != null) {
            this.source.dispose();
        }
        this.flushThumbnailImages();
    }

    protected void createMultimedia(MediaFileMetadata mediaFileMetadata) {
        StringBuffer stringBuffer = new StringBuffer(new Date() + "- Source: " + this.getSrcFilename());
        String[] stringArray = new String[9];
        try {
            String string;
            int n;
            this.mediaCreationComplete = true;
            CcMediaSourceRecord.debugOut("Generating source file " + this.getSrcFilename() + " as " + mediaFileMetadata.getMediaTypeName() + " media.");
            stringBuffer.append(", processed as " + mediaFileMetadata.getMediaTypeName() + " media");
            stringArray[0] = this.objectKey;
            stringArray[1] = this.getDestMediaID() + "";
            stringArray[2] = "2";
            stringArray[3] = mediaFileMetadata.getFileFormatExtension();
            stringArray[4] = mediaFileMetadata.getMediaType() + "";
            this.destWidth = mediaFileMetadata.getMediaWidth();
            this.destHeight = mediaFileMetadata.getMediaHeight();
            this.resIndex = 2;
            this.outputFilename = this.getSrcFilename();
            if (!this.preserveFilenames) {
                this.outputFilename = this.batchCode + 2 + this.sequenceCode;
                if (this.getSrcFilename().lastIndexOf(46) != -1) {
                    this.outputFilename = this.outputFilename + this.getSrcFilename().substring(this.getSrcFilename().lastIndexOf(46)).toLowerCase();
                }
            }
            if ((n = this.outputFilename.lastIndexOf(46)) != -1) {
                string = this.outputFilename.substring(n).toLowerCase();
                if (string.equals(".mpeg")) {
                    string = ".mpg";
                }
                this.outputFilename = this.outputFilename.substring(0, n) + string;
            }
            string = this.batch.getDestDir() + File.separator + CcBatchProfileResolution.getRelativeDirectoryPath(mediaFileMetadata.getMediaType(), 2, mediaFileMetadata.getMediaFormat()) + File.separator + this.batch.getLpsDir().replace('/', File.separatorChar);
            stringBuffer.append(", Output dir path: \"" + string + "\"");
            stringBuffer.append(", Output filename: \"" + this.outputFilename + "\"");
            stringArray[5] = this.batchCode;
            stringArray[6] = this.outputFilename;
            stringArray[7] = "0";
            stringArray[8] = "0";
            String string2 = string + File.separator + this.outputFilename;
            CcMediaSourceRecord.debugOut("Output file path: \"" + string2 + "\"");
            stringBuffer.append(", Output file path: \"" + string2 + "\"");
            File file = new File(string);
            file.mkdirs();
            this.setStatusMessage("Copying source " + mediaFileMetadata.getMediaTypeName() + " file to destination.");
            if (CoreUtilities.copyFileBytes(this.getFullSrcFilepath(), string2)) {
                Object object;
                CcMediaSourceRecord.debugOut("Successfully copied file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
                stringBuffer.append(", Successfully copied src file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
                CsMediaFile csMediaFile = new CsMediaFile(this.collection, this.getDestMediaID(), 2, ImageFile.getFormatTypeToString(mediaFileMetadata.getMediaFormat()), mediaFileMetadata.getMediaType(), this.batch.getBatchID(), this.outputFilename, this.destWidth, this.destHeight);
                if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                    csMediaFile.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                }
                this.mediaFileRecords.addElement(csMediaFile);
                this.setStatusMessage("Searching for thumbnail image source file.");
                CcMediaSourceRecord.debugOut("Searching for thumbnail image source file for " + this.getSrcFilename() + ".");
                stringBuffer.append(", searching for thumbnail image source file for " + this.getSrcFilename());
                List list = MediaFileMetadata.NON_IMAGE_FILE_EXTS;
                String[] stringArray2 = this.collection.getServer().getInsightAdministrator().readMiscFileExtensionList();
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = stringArray2[i];
                    if (!((String)object).startsWith(".")) {
                        object = "." + (String)object;
                    }
                    list.add(object);
                }
                List list2 = InsightUtilities.getFilesWithFirstName(this.getFullSrcFilepath(), list, true);
                if (list2 != null && list2.size() > 0) {
                    object = (File)list2.get(0);
                    this.setStatusMessage("Thumbnail image source file found: " + ((File)object).getName());
                    CcMediaSourceRecord.debugOut("Thumbnail image source file found: " + ((File)object).getName());
                    stringBuffer.append(", thumbnail image source file found: " + ((File)object).getName());
                    this.createImages(((File)object).getName(), ((File)object).getPath(), mediaFileMetadata.getMediaType(), 1);
                } else {
                    CcMediaSourceRecord.debugOut("Thumbnail image source file not found.");
                    stringBuffer.append(", thumbnail image source file not found");
                    object = this.outputFilename.lastIndexOf(46) != -1 ? this.outputFilename.substring(0, this.outputFilename.lastIndexOf(46)) + JPEG_EXT : this.outputFilename;
                    CsMediaFile csMediaFile2 = new CsMediaFile(this.collection, this.getDestMediaID(), 0, ImageFile.getFormatTypeToString(mediaFileMetadata.getMediaFormat()), mediaFileMetadata.getMediaType(), this.batch.getBatchID(), (String)object, 0, 0);
                    if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                        csMediaFile2.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                    }
                    this.mediaFileRecords.addElement(csMediaFile2);
                    CsMediaFile csMediaFile3 = new CsMediaFile(this.collection, this.getDestMediaID(), 1, ImageFile.getFormatTypeToString(mediaFileMetadata.getMediaFormat()), mediaFileMetadata.getMediaType(), this.batch.getBatchID(), (String)(mediaFileMetadata.getMediaType() == 2 ? this.outputFilename : object), 0, 0);
                    if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                        csMediaFile3.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                    }
                    this.mediaFileRecords.addElement(csMediaFile3);
                }
            } else {
                this.mediaCreationComplete = false;
                CcMediaSourceRecord.debugOut("Failed to copy src file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
                stringBuffer.append(", Failed to copy src file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
            }
        }
        catch (Exception exception) {
            this.mediaCreationComplete = false;
            CcMediaSourceRecord.debugOut("Exception creating multimedia exc:\n" + InsightUtilities.getStackTrace(exception));
            stringBuffer.append("Exception creating multimedia exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        this.logValuesToFile(stringArray);
    }

    protected void createImages() {
        this.createImages(this.getSrcFilename(), this.getFullSrcFilepath(), 1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createImages(String var1_1, String var2_2, int var3_3, int var4_4) {
        block145: {
            block166: {
                block164: {
                    block165: {
                        block144: {
                            block140: {
                                block163: {
                                    block141: {
                                        var5_5 = new StringBuffer("");
                                        var6_6 = new String[9];
                                        var6_6[0] = this.objectKey;
                                        var6_6[1] = this.getDestMediaID() + "";
                                        var7_7 = new Vector<String>();
                                        var8_8 = null;
                                        var9_9 = false;
                                        var10_10 = false;
                                        if (this.collection.getServer().getInsightAdministrator().readMediaGenerationConfigurationValue() == 2) {
                                            var9_9 = true;
                                        } else if (this.collection.getServer().getInsightAdministrator().readMediaGenerationConfigurationValue() == 0) {
                                            var10_10 = true;
                                        }
                                        var11_11 = null;
                                        var12_12 = null;
                                        var13_13 = null;
                                        var14_14 = null;
                                        try {
                                            try {
                                                block142: {
                                                    block148: {
                                                        CcMediaSourceRecord.debugOut("------- image \"" + var1_1 + "\"-------");
                                                        var5_5.append(new Date() + "- Source: " + var1_1);
                                                        this.mediaCreationComplete = true;
                                                        if (var9_9 || var10_10) break block148;
                                                        this.source = null;
                                                        try {
                                                            this.setStatusMessage("Loading source file \"" + var1_1 + "\".");
                                                            var15_15 = new Opener();
                                                            var11_11 = var15_15.openImage(var2_2);
                                                            var14_14 = MetadataToolFactory.getMetadataTool().getOrientation(var2_2);
                                                            if (var11_11 == null) {
                                                                CcMediaSourceRecord.debugOut("Attempting to use JAI to open the file, ImagePlus Failed");
                                                                try {
                                                                    var16_20 = new File(var2_2);
                                                                    var17_22 = JAIReader.read((File)var16_20);
                                                                    var11_11 = var17_22[0];
                                                                    if (var11_11.getOriginalFileInfo() == null) {
                                                                        var18_23 = var11_11.getFileInfo();
                                                                        var18_23.directory = var16_20.getParent();
                                                                        var18_23.fileName = var16_20.getName();
                                                                        var11_11.setFileInfo((FileInfo)var18_23);
                                                                    }
                                                                }
                                                                catch (Throwable var16_21) {
                                                                    CcMediaSourceRecord.debugOut("JAI Failed too...\n" + InsightUtilities.getStackTrace(var16_21));
                                                                    throw var16_21;
                                                                }
                                                            }
                                                            if (var11_11 == null) {
                                                                CcMediaSourceRecord.debugOut("Unable to load source image: " + var2_2);
                                                                this.logLineToFile(new Date() + "- WARNING: Unable to load image: " + var2_2);
                                                                this.mediaCreationComplete = false;
                                                            }
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (Throwable var15_16) {
                                                            CcMediaSourceRecord.debugOut("Caught exception while loading source image: " + var15_16);
                                                            this.logLineToFile(new Date() + "- WARNING: Caught exception while loading image " + var2_2 + ": " + var15_16);
                                                            if (var11_11 != null) {
                                                                var11_11.flush();
                                                                var11_11 = null;
                                                            }
                                                            System.runFinalization();
                                                            System.gc();
                                                            this.mediaCreationComplete = false;
                                                            var37_26 = null;
                                                            if (var12_12 != null) {
                                                                try {
                                                                    var12_12.close();
                                                                }
                                                                catch (IOException var38_31) {
                                                                    CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var38_31);
                                                                }
                                                                var12_12 = null;
                                                            }
                                                            if (var13_13 == null) return;
                                                            try {
                                                                var13_13.close();
                                                                return;
                                                            }
                                                            catch (IOException var38_31) {
                                                                CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var38_31);
                                                            }
                                                            return;
                                                        }
                                                        var37_25 = null;
                                                        if (var12_12 == null) break block140;
                                                        break block141;
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            if (var14_14 != null) {
                                                                this.adjustOrientation((ImagePlus)var11_11, var14_14);
                                                            }
                                                            var16_20 = var11_11.getProcessor();
                                                            this.sourceWidth = var16_20.getWidth();
                                                            this.sourceHeight = var16_20.getHeight();
                                                            var16_20 = null;
                                                            break block142;
                                                        }
                                                    }
                                                    try {
                                                        if (this.source == null) {
                                                            this.setStatusMessage("Loading source file \"" + var1_1 + "\".");
                                                            this.source = JAI.create((String)"fileload", (Object)var2_2);
                                                            this.sourceWidth = this.source.getWidth();
                                                            this.sourceHeight = this.source.getHeight();
                                                        }
                                                    }
                                                    catch (Exception var15_17) {
                                                        block149: {
                                                            block150: {
                                                                CcMediaSourceRecord.debugOut("Caught exception while loading image: " + InsightUtilities.getStackTrace(var15_17));
                                                                this.logLineToFile(new Date() + "- WARNING: Caught exception while loading image " + var2_2 + ": " + var15_17);
                                                                this.source = null;
                                                                this.mediaCreationComplete = false;
                                                                var37_27 = null;
                                                                if (var12_12 == null) break block149;
                                                                ** try [egrp 16[TRYBLOCK] [25 : 5459->5467)] { 
lbl106:
                                                                // 1 sources

                                                                var12_12.close();
                                                                break block150;
lbl108:
                                                                // 1 sources

                                                                catch (IOException var38_32) {
                                                                    CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var38_32);
                                                                }
                                                            }
                                                            var12_12 = null;
                                                        }
                                                        if (var13_13 == null) return;
                                                        ** try [egrp 17[TRYBLOCK] [26 : 5501->5509)] { 
lbl115:
                                                        // 1 sources

                                                        var13_13.close();
                                                        return;
lbl117:
                                                        // 1 sources

                                                        catch (IOException var38_32) {
                                                            CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var38_32);
                                                        }
                                                        return;
                                                    }
                                                }
                                                var15_15 = var11_11;
                                                this.setStatusMessage("Calculating target resolution sizes.");
                                                var16_20 = CcMediaSourceRecord.determineActualResolutions(this.sourceWidth, this.sourceHeight, this.resolutions);
                                                var17_22 = new Vector<E>();
                                                if (var9_9) {
                                                    CcMediaSourceRecord.debugOut("Generating derivative JPEGs using mbconvert utility.");
                                                    var17_22 = this.createJpegsWithoutJAI(var1_1, var2_2, var3_3, var4_4);
                                                }
                                                var19_35 = true;
                                                var20_36 = var16_20.size() - 1;
                                                if (var4_4 >= 0 && var4_4 < var20_36) {
                                                    var20_36 = var4_4;
                                                }
                                                if (this.processSourceImage) {
                                                    this.processSourceImage(var16_20.size(), var3_3, var6_6);
                                                }
                                                this.resIndex = var20_36;
                                                while (this.resIndex >= 0) {
                                                    block156: {
                                                        block151: {
                                                            block143: {
                                                                block154: {
                                                                    block155: {
                                                                        block153: {
                                                                            block152: {
                                                                                var18_23 = (CcBatchProfileResolution)var16_20.get(this.resIndex);
                                                                                this.setStatusMessage("Generating derivative image " + this.resIndex + ".");
                                                                                this.destWidth = 0;
                                                                                this.destHeight = 0;
                                                                                if (var18_23 == null) break block151;
                                                                                CcMediaSourceRecord.debugOut("Generating image for resolution level " + this.resIndex + " format " + ImageFile.getFormatTypeToString(var18_23.getFormat()));
                                                                                var5_5 = new StringBuffer(new Date() + "- Source: " + var1_1);
                                                                                var5_5.append(", Resolution: " + this.resIndex);
                                                                                var6_6[2] = this.resIndex + "";
                                                                                this.outputFilename = var1_1;
                                                                                if (this.outputFilename.lastIndexOf(46) != -1) {
                                                                                    this.outputFilename = this.outputFilename.substring(0, this.outputFilename.lastIndexOf(46));
                                                                                }
                                                                                if (!this.preserveFilenames) {
                                                                                    this.outputFilename = this.batchCode + var18_23.getResolutionNumber() + this.sequenceCode;
                                                                                }
                                                                                var21_37 = this.batch.getDestDir() + File.separator + var18_23.getRelativeDirectoryPath(var3_3) + File.separator + this.batch.getLpsDir().replace('/', File.separatorChar);
                                                                                var5_5.append(", Output path: \"" + var21_37 + "\"");
                                                                                var22_38 = false;
                                                                                if (var18_23.getFormat() != 0) break block152;
                                                                                this.outputFilename = this.outputFilename + ".jpg";
                                                                                if (!var9_9) {
                                                                                    if (var10_10) {
                                                                                        var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                                        var6_6[3] = "JPEG";
                                                                                        var6_6[4] = "1";
                                                                                        var6_6[5] = this.batchCode;
                                                                                        var6_6[6] = this.outputFilename;
                                                                                        if (var8_8 == null) {
                                                                                            var23_39 = CcBatchProfileResolution.PIXEL_SIZES[4] + 10;
                                                                                            var8_8 = this.getMogrifiedSource(var2_2, var1_1, var23_39);
                                                                                            this.sourceWidth = var8_8.getWidth();
                                                                                            this.sourceHeight = var8_8.getHeight();
                                                                                            var7_7.addElement(this.getTemporaryImageMagickFilename(var1_1));
                                                                                        }
                                                                                        var23_40 = var21_37 + File.separator + this.outputFilename;
                                                                                        var12_12 = null;
                                                                                        try {
                                                                                            var12_12 = new FileOutputStream(var23_40);
                                                                                        }
                                                                                        catch (FileNotFoundException var24_44) {
                                                                                            var25_49 = new File(new File(var23_40).getParent());
                                                                                            var25_49.mkdirs();
                                                                                            var12_12 = new FileOutputStream(var23_40);
                                                                                        }
                                                                                        CcMediaSourceRecord.debugOut("Output file path: \"" + var23_40 + "\"");
                                                                                        var24_45 = var8_8;
                                                                                        if (var18_23.getJpegSettings().automaticTrimEdges) {
                                                                                            var25_50 = var18_23.getJpegSettings().edgeThreshold;
                                                                                            if (var25_50 < 0.0f) {
                                                                                                var25_50 = 0.0f;
                                                                                            }
                                                                                            if ((var26_55 = (float)this.sourceWidth - 2.0f * var25_50) < 0.0f) {
                                                                                                var26_55 = 0.0f;
                                                                                            }
                                                                                            if ((var27_61 = (float)this.sourceHeight - 2.0f * var25_50) < 0.0f) {
                                                                                                var27_61 = 0.0f;
                                                                                            }
                                                                                            var28_67 = new ParameterBlock();
                                                                                            var28_67.addSource(var8_8);
                                                                                            var28_67.add(var25_50);
                                                                                            var28_67.add(var25_50);
                                                                                            var28_67.add(var26_55);
                                                                                            var28_67.add(var27_61);
                                                                                            var5_5.append(", Edge threshold=" + var25_50 + ", crop width=" + var26_55 + ", crop height=" + var27_61);
                                                                                            this.setStatusMessage("Cropping image...");
                                                                                            var24_45 = JAI.create((String)"crop", (ParameterBlock)var28_67, null);
                                                                                        }
                                                                                        this.setStatusMessage("Scaling image...");
                                                                                        var25_52 = this.sourceWidth >= this.sourceHeight ? (float)var18_23.getResolutionPixels() / (float)this.sourceWidth : (float)var18_23.getResolutionPixels() / (float)this.sourceHeight;
                                                                                        CcMediaSourceRecord.debugOut("scale ratio: " + var25_52);
                                                                                        if (var25_52 > 1.0f && !var18_23.getJpegSettings().forceUpsize) {
                                                                                            var25_52 = 1.0f;
                                                                                        }
                                                                                        var5_5.append(", Scale Ratio=" + var25_52);
                                                                                        var26_56 = (int)(1.0f / var25_52) + 1;
                                                                                        var27_62 = var26_56 = (int)((float)var26_56 * 0.75f);
                                                                                        var24_45 = JAI.create((String)"boxfilter", (RenderedImage)var24_45, (int)var26_56, (int)var27_62, (int)(var26_56 / 2), (int)(var27_62 / 2));
                                                                                        var28_67 = new ParameterBlock();
                                                                                        var28_67.addSource(var24_45);
                                                                                        var28_67.add(var25_52);
                                                                                        var28_67.add(var25_52);
                                                                                        var28_67.add(0.0f);
                                                                                        var28_67.add(0.0f);
                                                                                        var28_67.add(Interpolation.getInstance((int)2));
                                                                                        var29_73 = JAI.create((String)"scale", (ParameterBlock)var28_67, null);
                                                                                        var30_76 = null;
                                                                                        if (this.thumbImage == null) {
                                                                                            var30_76 = var29_73.getAsBufferedImage();
                                                                                            this.destWidth = var30_76.getWidth();
                                                                                            this.destHeight = var30_76.getHeight();
                                                                                            var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                                            this.thumbImage = new ImageIcon((Image)var30_76);
                                                                                        } else {
                                                                                            this.destWidth = var29_73.getWidth();
                                                                                            this.destHeight = var29_73.getHeight();
                                                                                        }
                                                                                        var6_6[7] = this.destWidth + "";
                                                                                        var6_6[8] = this.destHeight + "";
                                                                                        var31_79 = var29_73;
                                                                                        if (var18_23.getJpegSettings().useBrightness) {
                                                                                            this.setStatusMessage("Performing gamma correction.");
                                                                                            var32_81 = var18_23.getJpegSettings().brightness;
                                                                                            if (var32_81 > 256) {
                                                                                                var32_81 = 256;
                                                                                            } else if (var32_81 < -256) {
                                                                                                var32_81 = -256;
                                                                                            }
                                                                                            var33_88 = new byte[256];
                                                                                            for (var34_91 = 0; var34_91 < 256; ++var34_91) {
                                                                                                var33_88[var34_91] = this.clampByte(var34_91 + var32_81);
                                                                                            }
                                                                                            var34_92 = new LookupTableJAI(var33_88);
                                                                                            var35_96 = new ParameterBlock();
                                                                                            var35_96.addSource(var29_73);
                                                                                            var35_96.add(var34_92);
                                                                                            var31_79 = JAI.create((String)"lookup", (ParameterBlock)var35_96, null);
                                                                                        }
                                                                                        var32_82 = new com.sun.media.jai.codec.JPEGEncodeParam();
                                                                                        var33_87 = var18_23.getJpegSettings().jpegCompression;
                                                                                        if (var33_87 < 0) {
                                                                                            var33_87 = 0;
                                                                                        } else if (var33_87 > 100) {
                                                                                            var33_87 = 100;
                                                                                        }
                                                                                        var34_93 = 1.0f - (float)var33_87 / 100.0f;
                                                                                        var32_82.setQuality(var34_93);
                                                                                        var5_5.append(", Compression level: " + var33_87 + ", quality level: " + var34_93);
                                                                                        this.setStatusMessage("Writing media file to " + var23_40 + ".");
                                                                                        JAI.create((String)"encode", (RenderedImage)var31_79, (Object)var12_12, (Object)"JPEG", (Object)var32_82);
                                                                                        CcMediaSourceRecord.debugOut("encoded");
                                                                                        this.writtenFilePaths.addElement(var23_40);
                                                                                        CcMediaSourceRecord.debugOut("written");
                                                                                        var24_45 = null;
                                                                                        var29_73 = null;
                                                                                        var31_79 = null;
                                                                                        if (var30_76 != null) {
                                                                                            var30_76.flush();
                                                                                        }
                                                                                        var30_76 = null;
                                                                                        var12_12.close();
                                                                                        var12_12 = null;
                                                                                        break block143;
                                                                                    } else {
                                                                                        var23_41 = null;
                                                                                        var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                                        var6_6[3] = "JPEG";
                                                                                        var6_6[4] = "1";
                                                                                        var6_6[5] = this.batchCode;
                                                                                        var6_6[6] = this.outputFilename;
                                                                                        var24_46 = var21_37 + File.separator + this.outputFilename;
                                                                                        var12_12 = null;
                                                                                        try {
                                                                                            var12_12 = new FileOutputStream(var24_46);
                                                                                        }
                                                                                        catch (FileNotFoundException var25_53) {
                                                                                            var26_57 = new File(new File(var24_46).getParent());
                                                                                            var26_57.mkdirs();
                                                                                            var12_12 = new FileOutputStream(var24_46);
                                                                                        }
                                                                                        var13_13 = new BufferedOutputStream(var12_12);
                                                                                        CcMediaSourceRecord.debugOut("Output file path: \"" + var24_46 + "\"");
                                                                                        this.setStatusMessage("Scaling image...");
                                                                                        var25_54 = this.sourceWidth >= this.sourceHeight ? (float)var18_23.getResolutionPixels() / (float)this.sourceWidth : (float)var18_23.getResolutionPixels() / (float)this.sourceHeight;
                                                                                        CcMediaSourceRecord.debugOut("scale ratio: " + var25_54);
                                                                                        var5_5.append(", Scale Ratio=" + var25_54);
                                                                                        var14_14 = MetadataToolFactory.getMetadataTool().getOrientation(var24_46);
                                                                                        if (var14_14 != null) {
                                                                                            this.adjustOrientation((ImagePlus)var11_11, var14_14);
                                                                                        }
                                                                                        var26_58 = var11_11.getProcessor();
                                                                                        if (var25_54 > 1.0f) {
                                                                                            var27_63 = this.sourceWidth >= this.sourceHeight ? this.sourceWidth : this.sourceHeight;
                                                                                            var26_58 = this.averageReductionScale(var26_58, (ImagePlus)var11_11, var27_63);
                                                                                        } else if (var19_35 && var25_54 != 1.0f) {
                                                                                            if (this.getResampleDuringResize()) {
                                                                                                var26_58.smooth();
                                                                                            } else {
                                                                                                CcMediaSourceRecord.debugOut("*** createImages(): Smoothing is turned OFF");
                                                                                            }
                                                                                            var26_58.setInterpolate(true);
                                                                                            var26_58 = var26_58.resize(Math.round((float)var26_58.getWidth() * var25_54), Math.round((float)var26_58.getHeight() * var25_54));
                                                                                        } else {
                                                                                            var26_58 = this.averageReductionScale(var26_58, (ImagePlus)var11_11, var18_23.getResolutionPixels());
                                                                                        }
                                                                                        this.destWidth = var26_58.getWidth();
                                                                                        this.destHeight = var26_58.getHeight();
                                                                                        var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                                        var6_6[7] = this.destWidth + "";
                                                                                        var6_6[8] = this.destHeight + "";
                                                                                        var23_41 = new BufferedImage(this.destWidth, this.destHeight, 1);
                                                                                        var27_64 = var23_41.createGraphics();
                                                                                        var27_64.drawImage(var26_58.createImage(), 0, 0, null);
                                                                                        var27_64.dispose();
                                                                                        var26_58 = null;
                                                                                        var28_68 = var18_23.getJpegSettings().jpegCompression;
                                                                                        if (var28_68 < 0) {
                                                                                            var28_68 = 0;
                                                                                        } else if (var28_68 > 100) {
                                                                                            var28_68 = 100;
                                                                                        }
                                                                                        var29_74 = 1.0f - (float)var28_68 / 100.0f;
                                                                                        var30_76 = JPEGCodec.createJPEGEncoder((OutputStream)var13_13);
                                                                                        var31_79 = var30_76.getDefaultJPEGEncodeParam(var23_41);
                                                                                        var31_79.setQuality(var29_74, true);
                                                                                        var5_5.append(", Compression level: " + var28_68 + ", quality level: " + var29_74);
                                                                                        this.setStatusMessage("Writing media file to " + var24_46 + ".");
                                                                                        var30_76.encode(var23_41, (JPEGEncodeParam)var31_79);
                                                                                        var23_41.flush();
                                                                                        var23_41 = null;
                                                                                        CcMediaSourceRecord.debugOut("encoded");
                                                                                        if (var19_35 && var25_54 < 1.0f && this.resIndex > 0) {
                                                                                            try {
                                                                                                var11_11.flush();
                                                                                                var32_83 = new Opener();
                                                                                                var11_11 = var32_83.openImage(var24_46);
                                                                                                var19_35 = false;
                                                                                                var26_58 = var11_11.getProcessor();
                                                                                                this.sourceWidth = var26_58.getWidth();
                                                                                                this.sourceHeight = var26_58.getHeight();
                                                                                                var26_58 = null;
                                                                                            }
                                                                                            catch (Throwable var32_84) {
                                                                                                CcMediaSourceRecord.debugOut("Caught exception while loading source image: " + var32_84);
                                                                                                throw var32_84;
                                                                                            }
                                                                                        } else if (var25_54 <= 1.0f) {
                                                                                            var19_35 = false;
                                                                                        }
                                                                                        this.writtenFilePaths.addElement(var24_46);
                                                                                        CcMediaSourceRecord.debugOut("written");
                                                                                        try {
                                                                                            this.copyMetadata(var2_2, var24_46, var22_38);
                                                                                        }
                                                                                        catch (Exception var32_85) {
                                                                                            CcMediaSourceRecord.debugOut("createImages(...): calling copyMetadata(...): " + var32_85.getMessage());
                                                                                        }
                                                                                        if (!var22_38) {
                                                                                            var22_38 = true;
                                                                                        }
                                                                                    }
                                                                                }
                                                                                break block143;
                                                                            }
                                                                            if (var18_23.getFormat() != 13) break block153;
                                                                            CcMediaSourceRecord.debugOut("Generating JP2 image for resolution level " + this.resIndex);
                                                                            this.outputFilename = this.outputFilename + ".jp2";
                                                                            if (this.jp2Filename == null) {
                                                                                this.jp2Filename = this.outputFilename;
                                                                            }
                                                                            this.outputFilename = this.jp2Filename;
                                                                            var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                            var6_6[3] = "JP2";
                                                                            var6_6[4] = "1";
                                                                            var6_6[5] = this.batchCode;
                                                                            var6_6[6] = this.outputFilename;
                                                                            var23_39 = var18_23.getResolutionPixels();
                                                                            var24_47 = (float)this.sourceWidth / (float)this.sourceHeight;
                                                                            if (this.sourceWidth >= this.sourceHeight) {
                                                                                if (var23_39 > this.sourceWidth) {
                                                                                    var23_39 = this.sourceWidth;
                                                                                }
                                                                                this.destWidth = var23_39;
                                                                                this.destHeight = (int)((float)this.destWidth / var24_47);
                                                                            } else {
                                                                                if (var23_39 > this.sourceHeight) {
                                                                                    var23_39 = this.sourceHeight;
                                                                                }
                                                                                this.destHeight = var23_39;
                                                                                this.destWidth = (int)((float)this.destHeight * var24_47);
                                                                            }
                                                                            var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                            var6_6[7] = this.destWidth + "";
                                                                            var6_6[8] = this.destHeight + "";
                                                                            if (this.jp2GenerationComplete) {
                                                                                this.setStatusMessage("JP2 images have already been generated.");
                                                                                CcMediaSourceRecord.debugOut("JP2 images have already been generated.");
                                                                                var5_5.append(", JP2 images have already been generated.");
                                                                                break block143;
                                                                            } else {
                                                                                var25_49 = var21_37 + File.separator + this.outputFilename;
                                                                                CcMediaSourceRecord.debugOut("Output file path: \"" + (String)var25_49 + "\"");
                                                                                var26_59 = this.getSrcFilepath();
                                                                                if (!var26_59.endsWith(File.separator)) {
                                                                                    var26_59 = var26_59 + File.separator;
                                                                                }
                                                                                var26_59 = var26_59 + var1_1;
                                                                                var27_65 = var25_49;
                                                                                try {
                                                                                    var28_67 = new File(new File((String)var27_65).getParent());
                                                                                    if (!var28_67.exists()) {
                                                                                        var28_67.mkdirs();
                                                                                    }
                                                                                }
                                                                                catch (Exception var28_69) {
                                                                                    // empty catch block
                                                                                }
                                                                                this.setStatusMessage("Generating JP2.");
                                                                                if (!CcMediaSourceRecord.configuredJPEG2KCodec) {
                                                                                    JPEG2KCodec.configure();
                                                                                    CcMediaSourceRecord.configuredJPEG2KCodec = true;
                                                                                }
                                                                                try {
                                                                                    var28_67 = JPEG2KCodec.getDefaultJPEG2KEncodeParam();
                                                                                    var29_73 = JPEG2KCodec.createJPEG2KEncoder((String)var27_65);
                                                                                    if (var15_15 != null) {
                                                                                        var29_73.encode((ImagePlus)var15_15, (IJPEG2KEncodeParam)var28_67);
                                                                                    } else {
                                                                                        var29_73.encode(var26_59, (IJPEG2KEncodeParam)var28_67);
                                                                                    }
                                                                                    CcMediaSourceRecord.debugOut("JP2 creation done");
                                                                                    try {
                                                                                        var30_76 = new File((String)var27_65);
                                                                                        if (!var30_76.isFile() || !var30_76.exists()) ** GOTO lbl552
                                                                                        this.writtenFilePaths.addElement(var27_65);
                                                                                        this.jp2GenerationComplete = true;
                                                                                    }
                                                                                    catch (Exception var30_77) {}
                                                                                }
                                                                                catch (Exception var28_70) {
                                                                                    CcMediaSourceRecord.debugOut("JP2 creation failed: " + var28_70);
                                                                                    this.mediaCreationComplete = false;
                                                                                    throw var28_70;
                                                                                }
                                                                                catch (OutOfMemoryError var28_71) {
                                                                                    CcMediaSourceRecord.debugOut("JP2 creation failed due to memory limitation: " + var28_71);
                                                                                    throw var28_71;
                                                                                }
                                                                            }
                                                                        }
                                                                        if (var18_23.getFormat() != 1) break block154;
                                                                        this.outputFilename = this.outputFilename + ".sid";
                                                                        if (this.sidFilename == null) {
                                                                            this.sidFilename = this.outputFilename;
                                                                        }
                                                                        this.outputFilename = this.sidFilename;
                                                                        var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                        var6_6[3] = "SID";
                                                                        var6_6[4] = "1";
                                                                        var6_6[5] = this.batchCode;
                                                                        var6_6[6] = this.outputFilename;
                                                                        var23_39 = var18_23.getResolutionPixels();
                                                                        var24_48 = (float)this.sourceWidth / (float)this.sourceHeight;
                                                                        if (this.sourceWidth >= this.sourceHeight) {
                                                                            this.destWidth = var23_39;
                                                                            this.destHeight = (int)((float)this.destWidth / var24_48);
                                                                        } else {
                                                                            this.destHeight = var23_39;
                                                                            this.destWidth = (int)((float)this.destHeight * var24_48);
                                                                        }
                                                                        var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                        var6_6[7] = this.destWidth + "";
                                                                        var6_6[8] = this.destHeight + "";
                                                                        if (!this.sidGenerationComplete) break block155;
                                                                        this.setStatusMessage("SID images have already been generated.");
                                                                        CcMediaSourceRecord.debugOut("SID images have already been generated.");
                                                                        var5_5.append(", SID images have already been generated.");
                                                                        break block143;
                                                                    }
                                                                    var25_49 = var21_37 + File.separator + this.outputFilename;
                                                                    CcMediaSourceRecord.debugOut("Output file path: \"" + (String)var25_49 + "\"");
                                                                    var26_60 = this.getSrcFilepath();
                                                                    if (!var26_60.endsWith(File.separator)) {
                                                                        var26_60 = var26_60 + File.separator;
                                                                    }
                                                                    var27_66 = var26_60 = var26_60 + var1_1;
                                                                    if (!CcMediaSourceRecord.isTiffFile(var1_1)) {
                                                                        try {
                                                                            var27_66 = this.generateTemporaryTiffSourceFile(var26_60, this.outputFilename);
                                                                        }
                                                                        catch (Exception var28_72) {
                                                                            var27_66 = null;
                                                                        }
                                                                        if (var27_66 != null && !var27_66.equalsIgnoreCase(var26_60)) {
                                                                            var7_7.addElement(var27_66);
                                                                        } else {
                                                                            var27_66 = var26_60;
                                                                        }
                                                                    }
                                                                    var28_67 = var25_49;
                                                                    var29_75 = this.getSidZoomLevel();
                                                                    var30_78 = 20;
                                                                    if (var18_23.getSidSettings().nonDefaultSidCompressionRatio) {
                                                                        var30_78 = var18_23.getSidSettings().sidCompressionRatio;
                                                                    }
                                                                    var31_80 = 2;
                                                                    if (var18_23.getSidSettings().nonDefaultSidGamma) {
                                                                        var31_80 = var18_23.getSidSettings().sidGamma;
                                                                    }
                                                                    var32_86 = 4;
                                                                    if (var18_23.getSidSettings().nonDefaultSidWeight) {
                                                                        var32_86 = var18_23.getSidSettings().sidWeight;
                                                                    }
                                                                    try {
                                                                        var33_89 = new File(new File((String)var28_67).getParent());
                                                                        if (!var33_89.exists()) {
                                                                            var33_89.mkdirs();
                                                                        }
                                                                    }
                                                                    catch (Exception var33_90) {
                                                                        // empty catch block
                                                                    }
                                                                    this.setStatusMessage("Generating SID.");
                                                                    var33_87 = SidGenerator.generate(var27_66, (String)var28_67, var29_75, var30_78, var31_80, var32_86);
                                                                    CcMediaSourceRecord.debugOut("SID creation done, exit code: " + var33_87);
                                                                    var5_5.append("; exit code: " + var33_87);
                                                                    if (var33_87 == 0) {
                                                                        try {
                                                                            var34_94 = new File((String)var28_67);
                                                                            if (var34_94.isFile() && var34_94.exists()) {
                                                                                this.writtenFilePaths.addElement(var28_67);
                                                                                this.sidGenerationComplete = true;
                                                                            }
                                                                            break block143;
                                                                        }
                                                                        catch (Exception var34_95) {}
                                                                        break block143;
                                                                    } else {
                                                                        this.mediaCreationComplete = false;
                                                                    }
                                                                    break block143;
                                                                }
                                                                CcMediaSourceRecord.debugOut("Unknown image type: " + var18_23.getFormat());
                                                                var5_5 = new StringBuffer("");
                                                                this.logLineToFile(new Date() + "- WARNING: Unknown image type: " + var18_23.getFormat());
                                                                this.mediaCreationComplete = false;
                                                            }
                                                            var23_39 = this.destWidth;
                                                            var24_43 = this.destHeight;
                                                            if (var9_9 && var17_22.size() > this.resIndex && var17_22.get(this.resIndex) != null && var18_23.getFormat() != 13) {
                                                                var23_39 = ((Dimension)var17_22.get((int)this.resIndex)).width;
                                                                var24_43 = ((Dimension)var17_22.get((int)this.resIndex)).height;
                                                            }
                                                            var25_49 = new CsMediaFile(this.collection, this.getDestMediaID(), var18_23.getResolutionNumber(), ImageFile.getFormatTypeToString(var18_23.getFormat()), var3_3, this.batch.getBatchID(), this.outputFilename, var23_39, var24_43);
                                                            if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                                                                var25_49.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                                                            }
                                                            this.mediaFileRecords.addElement(var25_49);
                                                            break block156;
                                                        }
                                                        CcMediaSourceRecord.debugOut("Resolution " + this.resIndex + " was not specified.");
                                                        var5_5 = new StringBuffer("");
                                                        this.logLineToFile(new Date() + "- WARNING: Resolution " + this.resIndex + " was not specified.");
                                                        this.mediaCreationComplete = false;
                                                    }
                                                    if (var5_5 != null && !var5_5.toString().equals("")) {
                                                        var5_5 = new StringBuffer("");
                                                    }
                                                    if (var18_23.getFormat() != 0 || !var9_9) {
                                                        this.logValuesToFile(var6_6);
                                                    }
                                                    --this.resIndex;
                                                }
                                                break block144;
                                            }
                                            catch (Throwable var15_18) {
                                                block159: {
                                                    block157: {
                                                        block158: {
                                                            System.runFinalization();
                                                            System.gc();
                                                            CcMediaSourceRecord.debugOut("Error occurred while creating derivative images: " + var15_18);
                                                            CcMediaSourceRecord.debugOut("Stack Trace: " + InsightUtilities.getStackTrace(var15_18));
                                                            var5_5 = new StringBuffer("");
                                                            this.logLineToFile(new Date() + "- WARNING: Caught exception while creating derivative images for " + var2_2 + ": " + var15_18);
                                                            this.logLineToFile(new Date() + "Stack Trace: " + InsightUtilities.getStackTrace(var15_18));
                                                            this.mediaCreationComplete = false;
                                                            var37_28 = null;
                                                            if (var12_12 == null) break block157;
                                                            ** try [egrp 16[TRYBLOCK] [25 : 5459->5467)] { 
lbl589:
                                                            // 1 sources

                                                            var12_12.close();
                                                            break block158;
lbl591:
                                                            // 1 sources

                                                            catch (IOException var38_33) {
                                                                CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var38_33);
                                                            }
                                                        }
                                                        var12_12 = null;
                                                    }
                                                    if (var13_13 == null) break block145;
                                                    ** try [egrp 17[TRYBLOCK] [26 : 5501->5509)] { 
lbl598:
                                                    // 1 sources

                                                    var13_13.close();
                                                    break block159;
lbl600:
                                                    // 1 sources

                                                    catch (IOException var38_33) {
                                                        CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var38_33);
                                                    }
                                                }
                                                var13_13 = null;
                                                break block145;
                                            }
                                        }
                                        catch (Throwable var36_97) {
                                            block162: {
                                                block160: {
                                                    block161: {
                                                        var37_29 = null;
                                                        if (var12_12 == null) break block160;
                                                        ** try [egrp 16[TRYBLOCK] [25 : 5459->5467)] { 
lbl610:
                                                        // 1 sources

                                                        var12_12.close();
                                                        break block161;
lbl612:
                                                        // 1 sources

                                                        catch (IOException var38_34) {
                                                            CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var38_34);
                                                        }
                                                    }
                                                    var12_12 = null;
                                                }
                                                if (var13_13 == null) throw var36_97;
                                                ** try [egrp 17[TRYBLOCK] [26 : 5501->5509)] { 
lbl619:
                                                // 1 sources

                                                var13_13.close();
                                                break block162;
lbl621:
                                                // 1 sources

                                                catch (IOException var38_34) {
                                                    CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var38_34);
                                                }
                                            }
                                            var13_13 = null;
                                            throw var36_97;
                                        }
                                    }
                                    ** try [egrp 16[TRYBLOCK] [25 : 5459->5467)] { 
lbl628:
                                    // 1 sources

                                    var12_12.close();
                                    break block163;
lbl630:
                                    // 1 sources

                                    catch (IOException var38_30) {
                                        CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var38_30);
                                    }
                                }
                                var12_12 = null;
                            }
                            if (var13_13 == null) return;
                            ** try [egrp 17[TRYBLOCK] [26 : 5501->5509)] { 
lbl637:
                            // 1 sources

                            var13_13.close();
                            return;
lbl639:
                            // 1 sources

                            catch (IOException var38_30) {
                                CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var38_30);
                            }
                            return;
                        }
                        var37_28 = null;
                        if (var12_12 == null) break block164;
                        ** try [egrp 16[TRYBLOCK] [25 : 5459->5467)] { 
lbl646:
                        // 1 sources

                        var12_12.close();
                        break block165;
lbl648:
                        // 1 sources

                        catch (IOException var38_33) {
                            CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var38_33);
                        }
                    }
                    var12_12 = null;
                }
                if (var13_13 == null) break block145;
                ** try [egrp 17[TRYBLOCK] [26 : 5501->5509)] { 
lbl655:
                // 1 sources

                var13_13.close();
                break block166;
lbl657:
                // 1 sources

                catch (IOException var38_33) {
                    CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var38_33);
                }
            }
            var13_13 = null;
        }
        this.source = null;
        if (var11_11 != null) {
            var11_11.flush();
            var11_11 = null;
        }
        var8_8 = null;
        var15_19 = 0;
        while (var15_19 < var7_7.size()) {
            block147: {
                var16_20 = "";
                var17_22 = null;
                try {
                    block146: {
                        try {
                            var16_20 = (String)var7_7.elementAt(var15_19);
                            var18_23 = new File((String)var16_20);
                            var19_35 = var18_23.delete();
                            if (!var19_35) {
                                var17_22 = new FileOutputStream((File)var18_23);
                                var17_22.getFD().sync();
                                var17_22.close();
                                var19_35 = var18_23.delete();
                            }
                            if (var19_35) break block146;
                            CcMediaSourceRecord.debugOut("Could not delete temporary TIFF file: '" + (String)var16_20 + "'; requesting deletion upon JVM termination.");
                            var18_23.deleteOnExit();
                        }
                        catch (Exception var18_24) {
                            CcMediaSourceRecord.debugOut("Exception trying to delete temporary TIFF file: " + (String)var16_20 + ": " + var18_24);
                            var40_98 = null;
                            try {
                                if (var17_22 != null) {
                                    var17_22.close();
                                }
                                break block147;
                            }
                            catch (IOException var41_99) {}
                            break block147;
                        }
                    }
                    var40_98 = null;
                }
                catch (Throwable var39_100) {
                    var40_98 = null;
                    ** try [egrp 20[TRYBLOCK] [31 : 5745->5758)] { 
lbl703:
                    // 1 sources

                    if (var17_22 == null) throw var39_100;
                    var17_22.close();
                    throw var39_100;
lbl706:
                    // 1 sources

                    catch (IOException var41_99) {
                        // empty catch block
                    }
                    throw var39_100;
                }
                try {}
                catch (IOException var41_99) {}
                if (var17_22 != null) {
                    var17_22.close();
                }
            }
            ++var15_19;
        }
    }

    protected void copyMetadata(String string, String string2, boolean bl) throws Exception {
        if (metadataTool == null) {
            metadataTool = MetadataToolFactory.getMetadataTool();
        }
        if (metadataTool != null) {
            if (!bl) {
                CcMediaSourceRecord.debugOut("copyMetadata(...): fromPath: " + string);
                CcMediaSourceRecord.debugOut("copyMetadata(...): toPath: " + string2);
                metadataTool.init();
                metadataTool.copyAllTags(string, string2);
            } else {
                metadataTool.copyTags(string2);
            }
        } else {
            CcMediaSourceRecord.debugOut("copyMetadata(...): metadataTool is null.");
        }
    }

    private void processSourceImage(int n, int n2, String[] stringArray) {
        CsMediaFile csMediaFile = new CsMediaFile(this.collection, this.getDestMediaID(), n, "SOURCE", n2, this.batch.getBatchID(), this.srcFilename, this.sourceWidth, this.sourceHeight);
        if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
            csMediaFile.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
        }
        this.mediaFileRecords.addElement(csMediaFile);
        String string = this.batch.getDestDir() + File.separator + "SOURCE" + File.separator + this.batch.getLpsDir().replace('/', File.separatorChar);
        File file = new File(string);
        file.mkdirs();
        String string2 = string + File.separator + this.srcFilename;
        CcMediaSourceRecord.debugOut("Copying source " + this.outputFilename + " file to destination.");
        if (CoreUtilities.copyFileBytes(this.fullSrcFilepath, string2)) {
            CcMediaSourceRecord.debugOut("Successfully copied file \"" + this.fullSrcFilepath + "\" to \"" + string2 + "\".");
        } else {
            CcMediaSourceRecord.debugOut("Could not copy file \"" + this.fullSrcFilepath + "\" to \"" + string2 + "\".");
        }
        stringArray[2] = n + "";
        stringArray[3] = "SOURCE";
        stringArray[4] = n2 + "";
        stringArray[5] = this.batchCode;
        stringArray[6] = this.srcFilename;
        stringArray[7] = this.sourceWidth + "";
        stringArray[8] = this.sourceHeight + "";
        this.logValuesToFile(stringArray);
    }

    protected List createJpegsWithoutJAI(String string, String string2, int n, int n2) {
        Vector<Dimension> vector = new Vector<Dimension>();
        StringBuffer stringBuffer = new StringBuffer("");
        String[] stringArray = new String[9];
        stringArray[0] = this.objectKey;
        stringArray[1] = this.getDestMediaID() + "";
        try {
            CcMediaSourceRecord.debugOut("------- image \"" + string + "\"-------");
            stringBuffer.append(new Date() + "- Source: " + string);
            this.mediaCreationComplete = true;
            try {
                if (this.source == null) {
                    this.setStatusMessage("Loading source file \"" + string + "\".");
                    this.source = JAI.create((String)"fileload", (Object)string2);
                    this.sourceWidth = this.source.getWidth();
                    this.sourceHeight = this.source.getHeight();
                }
            }
            catch (Exception exception) {
                CcMediaSourceRecord.debugOut("Caught exception while loading image: " + InsightUtilities.getStackTrace(exception));
                this.logLineToFile(stringBuffer.toString());
                this.logLineToFile(new Date() + "- WARNING: Caught exception while loading image: " + exception);
                this.source = null;
                return vector;
            }
            this.setStatusMessage("Calculating target resolution sizes.");
            Vector vector2 = CcMediaSourceRecord.determineActualResolutions(this.source.getWidth(), this.source.getHeight(), this.resolutions);
            String string3 = " -s \"" + string2 + "\" -o \"" + this.batch.getDestDir() + "\"";
            if (!this.preserveFilenames) {
                string3 = string3 + " -b \"" + this.batchCode + "\" -q \"" + this.sequenceCode + "\"";
            }
            this.resIndex = 0;
            while (this.resIndex < vector2.size() && (n2 < 0 || this.resIndex <= n2)) {
                CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)vector2.get(this.resIndex);
                this.setStatusMessage("Generating derivative image " + this.resIndex + " using " + "mbconvert" + " utility.");
                this.destWidth = 0;
                this.destHeight = 0;
                if (ccBatchProfileResolution != null) {
                    CcMediaSourceRecord.debugOut("Generating image for resolution level " + this.resIndex);
                    stringBuffer = new StringBuffer(new Date() + "- Source: " + string);
                    stringBuffer.append(", Resolution: " + this.resIndex);
                    stringArray[2] = this.resIndex + "";
                    if (ccBatchProfileResolution.getFormat() == 0) {
                        this.outputFilename = string;
                        if (this.outputFilename.lastIndexOf(46) != -1) {
                            this.outputFilename = this.outputFilename.substring(0, this.outputFilename.lastIndexOf(46));
                        }
                        if (!this.preserveFilenames) {
                            this.outputFilename = this.batchCode + ccBatchProfileResolution.getResolutionNumber() + this.sequenceCode;
                        }
                        this.outputFilename = this.outputFilename + JPEG_EXT;
                        stringBuffer.append(", filename: \"" + this.outputFilename + "\"");
                        stringArray[3] = "JPEG";
                        stringArray[4] = "1";
                        stringArray[5] = this.batchCode;
                        stringArray[6] = this.outputFilename;
                        string3 = string3 + " -r" + ccBatchProfileResolution.getResolutionNumber() + " ";
                        int n3 = ccBatchProfileResolution.getJpegSettings().jpegCompression;
                        string3 = string3 + n3 + ";";
                        int n4 = 0;
                        if (ccBatchProfileResolution.getJpegSettings().useBrightness) {
                            n4 = ccBatchProfileResolution.getJpegSettings().brightness;
                            if (n4 > 256) {
                                n4 = 256;
                            } else if (n4 < -256) {
                                n4 = -256;
                            }
                        }
                        string3 = string3 + n4 + ";";
                        int n5 = 0;
                        if (ccBatchProfileResolution.getJpegSettings().automaticTrimEdges) {
                            n5 = ccBatchProfileResolution.getJpegSettings().edgeThreshold;
                        }
                        string3 = string3 + n5 + ";";
                        float f = this.sourceWidth >= this.sourceHeight ? (float)ccBatchProfileResolution.getResolutionPixels() / (float)this.sourceWidth : (float)ccBatchProfileResolution.getResolutionPixels() / (float)this.sourceHeight;
                        if (f > 1.0f && !ccBatchProfileResolution.getJpegSettings().forceUpsize) {
                            f = 1.0f;
                        }
                        int n6 = (int)((float)this.sourceWidth * f);
                        int n7 = (int)((float)this.sourceHeight * f);
                        string3 = string3 + n6 + ";" + n7;
                        vector.insertElementAt(new Dimension(n6, n7), this.resIndex);
                        stringBuffer.append(", Scale Ratio=" + f + ", Generated width: " + n6 + ", height: " + n7);
                        stringArray[7] = n6 + "";
                        stringArray[8] = n7 + "";
                        String string4 = this.batch.getDestDir() + File.separator + ccBatchProfileResolution.getRelativeDirectoryPath(n) + File.separator + this.batch.getLpsDir().replace('/', File.separatorChar);
                        File file = new File(new File(string4).getParent());
                        file.mkdirs();
                        this.logValuesToFile(stringArray);
                    }
                }
                ++this.resIndex;
            }
            string3 = string3 + " -d \"" + this.batch.getLpsDir().replace('/', File.separatorChar) + "\"";
            MBConvertInvoker.generate(string3);
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Caught exception while creating derivative images: " + exception);
            CcMediaSourceRecord.debugOut("Stack Trace: " + InsightUtilities.getStackTrace(exception));
            stringBuffer = new StringBuffer("");
            this.logLineToFile(new Date() + "- WARNING: Caught exception while creating derivative images: " + exception);
            this.logLineToFile(new Date() + "Stack Trace: " + InsightUtilities.getStackTrace(exception));
            this.mediaCreationComplete = false;
        }
        return vector;
    }

    private RenderedOp getMogrifiedSource(String string, String string2, int n) {
        Object object;
        if (this.source == null) {
            return null;
        }
        String string3 = this.getTemporaryImageMagickFilename(string2);
        try {
            boolean bl;
            object = new File(TEMP_TIFF_DIRECTORY);
            if (!(((File)object).exists() && ((File)object).isDirectory() || (bl = ((File)object).mkdirs()))) {
                CcMediaSourceRecord.debugOut("WARNING: Could not create temporary source TIFF directory for ImageMagick utility.");
                return null;
            }
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("WARNING: Could not create temporary source TIFF directory for ImageMagick utility: " + exception);
            return null;
        }
        object = n + "x" + n;
        ImageMagickInvoker.generate(string, string3, MOGRIFY_FILTER, (String)object);
        RenderedOp renderedOp = JAI.create((String)"fileload", (Object)string3);
        return renderedOp;
    }

    private String getTemporaryImageMagickFilename(String string) {
        String string2 = "IMTEMP_" + this.batchCode + this.sequenceCode + "_" + string;
        File file = new File(TEMP_TIFF_DIRECTORY + File.separator + string2);
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean copyFile(String string, String string2) {
        boolean bl;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                while ((n = bufferedInputStream.read()) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                bl = true;
                Object var7_8 = null;
            }
            catch (IOException iOException) {
                CcMediaSourceRecord.debugOut("CcMediaSourceRecord.copyFile() Exception: " + iOException.getMessage());
                boolean bl2 = false;
                Object var7_9 = null;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (filterOutputStream == null) return bl2;
                    filterOutputStream.close();
                    return bl2;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (filterOutputStream == null) throw throwable;
            filterOutputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        if (bufferedInputStream != null) {
            bufferedInputStream.close();
        }
        if (filterOutputStream == null) return bl;
        filterOutputStream.close();
        return bl;
    }

    private static Vector determineActualResolutions(int n, int n2, List list) {
        int n3;
        if (list == null || list.size() == 0) {
            return new Vector();
        }
        Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>();
        int n4 = n >= n2 ? n : n2;
        CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)list.get(0);
        int n5 = 0;
        while (n5 < list.size() && ccBatchProfileResolution.getFormat() == 0 && n4 >= ccBatchProfileResolution.getMinimumPixelSize()) {
            vector.addElement(ccBatchProfileResolution.getCopy());
            if (++n5 >= list.size()) continue;
            ccBatchProfileResolution = (CcBatchProfileResolution)list.get(n5);
        }
        if (n4 < ccBatchProfileResolution.getMinimumPixelSize()) {
            return vector;
        }
        int n6 = ccBatchProfileResolution.getResolutionNumber();
        int n7 = CcBatchProfileResolution.determineResolutionForSize(n4);
        int[] nArray = new int[n7 - n6 + 1];
        int n8 = n4;
        for (n3 = n7; n3 >= n6; --n3) {
            nArray[n3 - n6] = n8;
            n8 /= 2;
        }
        n3 = 0;
        while (n5 < list.size() && n5 <= n7) {
            CcBatchProfileResolution ccBatchProfileResolution2 = ccBatchProfileResolution.getCopy();
            ccBatchProfileResolution2.setNonDefaultPixelSize(nArray[n3]);
            vector.addElement(ccBatchProfileResolution2);
            ++n3;
            if (++n5 >= list.size()) continue;
            ccBatchProfileResolution = (CcBatchProfileResolution)list.get(n5);
        }
        return vector;
    }

    private void commitMediaFileRecords() {
        if (this.collection == null || this.collection.getServer() == null) {
            CcMediaSourceRecord.debugOut("Could not write image file records, no collection server.");
            return;
        }
        if (this.mediaFileRecords == null) {
            CcMediaSourceRecord.debugOut("No image file records to write.");
            return;
        }
        CcMediaSourceRecord.debugOut("About to write " + this.mediaFileRecords.size() + " mediaFileRecords");
        this.collection.getServer().commitMediaFiles(this.mediaFileRecords);
    }

    private final byte clampByte(int n) {
        if (n > 255) {
            return -1;
        }
        if (n < 0) {
            return 0;
        }
        return (byte)n;
    }

    private int getSidZoomLevel() {
        int n = 0;
        if (this.sourceWidth <= this.sourceHeight) {
            if (this.sourceHeight > 12288 && this.sourceHeight <= 30000) {
                n = 8;
            } else if (this.sourceHeight > 6144 && this.sourceHeight <= 12288) {
                n = 7;
            } else if (this.sourceHeight > 3072 && this.sourceHeight <= 6144) {
                n = 6;
            } else if (this.sourceHeight > 1536 && this.sourceHeight <= 3072) {
                n = 5;
            } else if (this.sourceHeight > 768 && this.sourceHeight <= 1536) {
                n = 4;
            } else if (this.sourceHeight > 384 && this.sourceHeight <= 768) {
                n = 3;
            } else if (this.sourceHeight > 192 && this.sourceHeight <= 384) {
                n = 2;
            } else if (this.sourceHeight > 96 && this.sourceHeight <= 192) {
                n = 1;
            }
        } else if (this.sourceWidth > 12288 && this.sourceWidth <= 30000) {
            n = 8;
        } else if (this.sourceWidth > 6144 && this.sourceWidth <= 12288) {
            n = 7;
        } else if (this.sourceWidth > 3072 && this.sourceWidth <= 6144) {
            n = 6;
        } else if (this.sourceWidth > 1536 && this.sourceWidth <= 3072) {
            n = 5;
        } else if (this.sourceWidth > 768 && this.sourceWidth <= 1536) {
            n = 4;
        } else if (this.sourceWidth > 384 && this.sourceWidth <= 768) {
            n = 3;
        } else if (this.sourceWidth > 192 && this.sourceWidth <= 384) {
            n = 2;
        } else if (this.sourceWidth > 96 && this.sourceWidth <= 192) {
            n = 1;
        }
        return n;
    }

    private String convertFromPcdToTiff(String string) {
        CcMediaSourceRecord.debugOut("convertFromPcdToTiff is not implemented");
        return string;
    }

    private boolean needToGenerateTiff(String string) {
        try {
            File file = new File(CcMediaSourceRecord.replaceFileExtension(string, LONG_TIFF_EXT));
            File file2 = new File(CcMediaSourceRecord.replaceFileExtension(string, SHORT_TIFF_EXT));
            return !file.exists() && !file2.exists();
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Exception in needToGenerateTiff(): " + exception);
            return true;
        }
    }

    public static String replaceFileExtension(String string, String string2) {
        if (string.lastIndexOf(46) > 0) {
            return string.substring(0, string.lastIndexOf(46)) + string2;
        }
        return string + string2;
    }

    public static boolean isTiffFile(String string) {
        if (string == null) {
            return false;
        }
        return string.toUpperCase().endsWith(LONG_TIFF_EXT.toUpperCase()) || string.toUpperCase().endsWith(SHORT_TIFF_EXT.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateTemporaryTiffSourceFile(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "temporary";
        }
        String string3 = this.batchCode + "_" + CcMediaSourceRecord.replaceFileExtension(string2, SHORT_TIFF_EXT);
        String string4 = TEMP_TIFF_DIRECTORY + File.separator + string3;
        RenderedOp renderedOp = null;
        RenderedOp renderedOp2 = null;
        try {
            boolean bl;
            File file = new File(TEMP_TIFF_DIRECTORY);
            if (!(file.exists() && file.isDirectory() || (bl = file.mkdirs()))) {
                CcMediaSourceRecord.debugOut("WARNING: Could not create temporary source TIFF directory for SID generation.");
                String string5 = null;
                return string5;
            }
            File file2 = new File(file, string3);
            string4 = file2.getAbsolutePath();
            renderedOp = JAI.create((String)"fileload", (Object)string);
            renderedOp2 = JAI.create((String)"filestore", (RenderedImage)renderedOp, (Object)string4, (Object)"TIFF");
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Exception occurred while trying to create temporary source TIFF for SID generation: " + exception);
            String string6 = null;
            return string6;
        }
        finally {
            renderedOp = null;
            renderedOp2 = null;
        }
        return string4;
    }

    public static void main(String[] stringArray) {
    }

    public void debugFile(String string) {
        if (this.batch.getLogFilepath() != null && this.batch.getLogFilepath().length() > 0) {
            try {
                FileWriter fileWriter = new FileWriter(this.batch.getLogFilepath(), true);
                fileWriter.write(new Date() + "- \"" + this.getSrcFilename() + "\": " + string + "\r\n");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void logToFile(String string) {
        if (this.batch.getLogFilepath() != null && this.batch.getLogFilepath().length() > 0) {
            try {
                FileWriter fileWriter = new FileWriter(this.batch.getLogFilepath(), true);
                fileWriter.write(string);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void logLineToFile(String string) {
        this.logToFile(string + "\r\n");
    }

    public void logValuesToFile(String[] stringArray, char c) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().equals("")) {
                    this.logToFile("N/A" + c);
                    continue;
                }
                this.logToFile(stringArray[i] + c);
            }
            this.logToFile("\r\n");
        }
    }

    public void logValuesToFile(String[] stringArray) {
        this.logValuesToFile(stringArray, '\t');
    }

    public boolean adjustOrientation(ImagePlus imagePlus, String string) {
        boolean bl = false;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        try {
            if (!"1".equals(string)) {
                if ("3".equals(string)) {
                    imageProcessor = imageProcessor.rotateRight();
                    imageProcessor = imageProcessor.rotateRight();
                    imagePlus.setProcessor(imagePlus.getTitle(), imageProcessor);
                    CcMediaSourceRecord.debugOut("adjustOrientation(..): Rotated the image from 3 to 1.");
                } else if ("6".equals(string)) {
                    imageProcessor = imageProcessor.rotateRight();
                    imagePlus.setProcessor(imagePlus.getTitle(), imageProcessor);
                    CcMediaSourceRecord.debugOut("adjustOrientation(..): Rotated the image from 6 to 1.");
                } else if ("8".equals(string)) {
                    imageProcessor = imageProcessor.rotateLeft();
                    imagePlus.setProcessor(imagePlus.getTitle(), imageProcessor);
                    CcMediaSourceRecord.debugOut("adjustOrientation(..): Rotated the image from 8 to 1.");
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private ImageProcessor averageReductionScale(ImageProcessor imageProcessor, ImagePlus imagePlus, int n) {
        int n2 = imageProcessor.getWidth() > imageProcessor.getHeight() ? imageProcessor.getWidth() : imageProcessor.getHeight();
        double d = (double)n2 / (double)n;
        int n3 = (int)d;
        double d2 = n3 * n3;
        if (imagePlus.getBitDepth() == 32) {
            return null;
        }
        int n4 = imageProcessor instanceof ColorProcessor ? 3 : 1;
        int n5 = (int)((double)imageProcessor.getWidth() / d);
        int n6 = (int)((double)imageProcessor.getHeight() / d);
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n5, n6);
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                imageProcessor2.putPixel(j, i, this.getAverage(imageProcessor, j, i, n3, d2, n4));
            }
        }
        imageProcessor2.resetMinAndMax();
        return imageProcessor2;
    }

    private int[] getAverage(ImageProcessor imageProcessor, int n, int n2, int n3, double d, int n4) {
        int n5;
        int[] nArray = new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = 0;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            for (int i = 0; i < n3; ++i) {
                this.pixel = imageProcessor.getPixel(n * n3 + i, n2 * n3 + n5, this.pixel);
                for (int j = 0; j < n4; ++j) {
                    int n6 = j;
                    nArray[n6] = nArray[n6] + this.pixel[j];
                }
            }
        }
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = (int)((double)nArray[n5] / d + 0.5);
        }
        return nArray;
    }
}

