/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcMediaCreator;
import com.luna.insight.admin.collserver.mediacreation.CcMediaSourceRecord;
import com.luna.insight.server.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CcMediaCreationProgressDisplay
extends JPanel {
    protected static final Dimension DEFAULT_SIZE = new Dimension(340, 200);
    protected static final int PROGRESS_BAR_HEIGHT = 25;
    protected CcMediaCreator mediaCreator;
    protected CcMediaSourceRecord currentMedia = null;
    protected JLabel thumbLabel = this.createLabel("");
    protected JLabel sourceFileLabel = this.createLabel("Source file:", 2);
    protected JLabel sourceFileValueLabel = this.createLabel("", 2);
    protected JLabel mediaIDLabel = this.createLabel("Media ID:", 2);
    protected JLabel mediaIDValueLabel = this.createLabel("", 2);
    protected JLabel messageLabel = this.createLabel("Preparing for media creation.", 2);
    protected JLabel sizeLabel = this.createLabel("Resolution size:", 2);
    protected JLabel sizeValueLabel = this.createLabel("", 2);
    protected JLabel destFileLabel = this.createLabel("Output file:", 2);
    protected JLabel destFileValueLabel = this.createLabel("", 2);
    protected JLabel destWidthLabel = this.createLabel("Width:", 2);
    protected JLabel destWidthValueLabel = this.createLabel("", 2);
    protected JLabel destHeightLabel = this.createLabel("Height:", 2);
    protected JLabel destHeightValueLabel = this.createLabel("", 2);
    protected JLabel completedLabel = this.createLabel("Media completed:", 2);
    protected JLabel completedValueLabel = this.createLabel("", 2);
    protected JLabel remainingLabel = this.createLabel("Media remaining:", 2);
    protected JLabel remainingValueLabel = this.createLabel("", 2);
    protected JProgressBar progressBar;
    protected JPanel thumbnailPanel;
    protected JPanel sourcePanel;
    protected JPanel outputPanel;
    protected JPanel overallProgressPanel;

    public static void debugOut(String string) {
        CcMediaCreationProgressDisplay.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaCreationProgressDisplay: " + string, n);
    }

    public CcMediaCreationProgressDisplay(CcMediaCreator ccMediaCreator) {
        this.mediaCreator = ccMediaCreator;
        this.initialize();
    }

    protected void initialize() {
        this.setSize(DEFAULT_SIZE);
        this.setLayout(null);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        Insets insets = new Insets(3, 3, 3, 3);
        CompoundBorder compoundBorder = new CompoundBorder(BorderFactory.createLineBorder(MetalLookAndFeel.getPrimaryControl()), new EmptyBorder(insets));
        this.thumbnailPanel = new JPanel(new BorderLayout(2, 2));
        this.thumbnailPanel.setBorder(new MatteBorder(1, 1, 0, 0, MetalLookAndFeel.getPrimaryControl()));
        this.thumbnailPanel.add((Component)this.thumbLabel, "Center");
        this.add(this.thumbnailPanel);
        this.sourcePanel = new JPanel(new GridLayout(2, 2, 5, 3));
        this.sourcePanel.setBorder(compoundBorder);
        this.sourcePanel.add(this.sourceFileLabel);
        this.sourcePanel.add(this.sourceFileValueLabel);
        this.sourcePanel.add(this.mediaIDLabel);
        this.sourcePanel.add(this.mediaIDValueLabel);
        this.add(this.sourcePanel);
        this.messageLabel.setBorder(new CompoundBorder(new MatteBorder(1, 1, 0, 1, MetalLookAndFeel.getPrimaryControl()), new EmptyBorder(insets)));
        this.add(this.messageLabel);
        this.outputPanel = new JPanel(new GridLayout(4, 2, 5, 3));
        this.outputPanel.setBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 1, MetalLookAndFeel.getPrimaryControl()), new EmptyBorder(insets)));
        this.outputPanel.add(this.sizeLabel);
        this.outputPanel.add(this.sizeValueLabel);
        this.outputPanel.add(this.destFileLabel);
        this.outputPanel.add(this.destFileValueLabel);
        this.outputPanel.add(this.destWidthLabel);
        this.outputPanel.add(this.destWidthValueLabel);
        this.outputPanel.add(this.destHeightLabel);
        this.outputPanel.add(this.destHeightValueLabel);
        this.add(this.outputPanel);
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 5, 3));
        jPanel.add(this.completedLabel);
        jPanel.add(this.completedValueLabel);
        jPanel.add(this.remainingLabel);
        jPanel.add(this.remainingValueLabel);
        jPanel.setSize(jPanel.getPreferredSize());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setSize(5, 25);
        this.overallProgressPanel = new JPanel(new VerticalStackResizeWidthLayout(3));
        this.overallProgressPanel.setBorder(compoundBorder);
        this.overallProgressPanel.add(jPanel);
        this.overallProgressPanel.add(this.progressBar);
        this.add((Component)this.overallProgressPanel, 0);
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        int n3 = insets.left;
        int n4 = insets.top;
        n4 = this.getHeight() - insets.bottom - this.overallProgressPanel.getPreferredSize().height;
        this.overallProgressPanel.setBounds(n3, n4, n, this.getHeight() - insets.bottom - n4);
        this.overallProgressPanel.doLayout();
        n4 = insets.top;
        this.thumbnailPanel.setBounds(n3, n4, CcBatchProfileResolution.PIXEL_SIZES[0] + 5, this.overallProgressPanel.getY() - 0 - n3);
        this.thumbnailPanel.doLayout();
        int n5 = this.getWidth() - insets.right - (n3 += this.thumbnailPanel.getWidth() + 0);
        n4 = insets.top;
        this.sourcePanel.setBounds(n3, n4, n5, this.sourcePanel.getPreferredSize().height);
        this.sourcePanel.doLayout();
        n4 = this.overallProgressPanel.getY() - 0 - this.messageLabel.getPreferredSize().height;
        this.messageLabel.setBounds(n3, n4, n5, this.messageLabel.getPreferredSize().height);
        this.messageLabel.doLayout();
        n4 = this.sourcePanel.getY() + this.sourcePanel.getHeight() + 0;
        this.outputPanel.setBounds(n3, n4, n5, this.messageLabel.getY() - 0 - n4);
        this.outputPanel.doLayout();
    }

    public void setCurrentMedia(CcMediaSourceRecord ccMediaSourceRecord) {
        if (this.currentMedia != null) {
            this.currentMedia.flushThumbnailImages();
        }
        this.currentMedia = ccMediaSourceRecord;
        this.updateProgress();
    }

    public void setStatusMessage(String string) {
        this.messageLabel.setText(string);
        this.updateProgress();
    }

    public void updateProgress() {
        if (this.currentMedia == null) {
            this.thumbLabel.setText(null);
            this.thumbLabel.setIcon(null);
        } else if (this.currentMedia.getThumbnailImage() == null) {
            this.thumbLabel.setText(this.currentMedia.getSrcFilename());
            this.thumbLabel.setIcon(null);
        } else {
            this.thumbLabel.setText(null);
            this.thumbLabel.setIcon(this.currentMedia.getThumbnailImage());
        }
        this.thumbLabel.repaint();
        this.sourceFileValueLabel.setText(this.currentMedia == null ? "" : this.currentMedia.getSrcFilename());
        this.mediaIDValueLabel.setText(this.currentMedia == null ? "" : this.currentMedia.getDestMediaID() + "");
        this.sizeValueLabel.setText(this.currentMedia == null ? "" : this.currentMedia.getResolutionSize() + "");
        this.destFileValueLabel.setText(this.currentMedia == null ? "" : this.currentMedia.getDestFilename());
        this.destWidthValueLabel.setText(this.currentMedia == null ? "" : this.currentMedia.getDestWidth() + "");
        this.destHeightValueLabel.setText(this.currentMedia == null ? "" : this.currentMedia.getDestHeight() + "");
        this.progressBar.setString(null);
        this.progressBar.setMinimum(this.mediaCreator.getProgressMin());
        this.progressBar.setMaximum(this.mediaCreator.getProgressMax());
        this.progressBar.setValue(this.mediaCreator.getProgressCurrent());
        this.completedValueLabel.setText(this.mediaCreator.getCompletedImageCount() + "");
        this.remainingValueLabel.setText(this.mediaCreator.getRemainingImageCount() + "");
        this.repaint();
    }

    public void batchProcessComplete() {
        CcMediaCreationProgressDisplay.debugOut("in batchProcessComplete()");
        this.messageLabel.setText("Complete.");
        this.progressBar.setString("COMPLETE");
        this.progressBar.setMinimum(this.mediaCreator.getProgressMin());
        this.progressBar.setMaximum(this.mediaCreator.getProgressMax());
        this.progressBar.setValue(this.mediaCreator.getProgressMax());
        this.completedValueLabel.setText("" + this.mediaCreator.getCompletedImageCount());
        this.remainingValueLabel.setText("0");
        this.repaint();
    }

    protected JLabel createLabel(String string) {
        return this.createLabel(string, 0, 0);
    }

    protected JLabel createLabel(String string, int n) {
        return this.createLabel(string, n, 0);
    }

    protected JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setSize(jLabel.getPreferredSize());
        jLabel.setHorizontalAlignment(n);
        jLabel.setVerticalAlignment(n2);
        return jLabel;
    }
}

