/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CcMediaBatchesNode
extends TableDisplayControlPanelNode {
    public static final String COMMAND_MAP_OBJECTS_TO_IMAGES = "command-map-objects-to-images";
    public static final String COMMAND_PUBLISH_IMAGES = "command-publish-images";
    protected CollectionNode collectionNode = null;

    public CcMediaBatchesNode(CollectionNode collectionNode) {
        super(collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Media Batches", false);
        this.collectionNode = collectionNode;
        this.columnNames = new Object[]{"Batch Name", "Destination Directory", "LPS Directory", "Log File"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionNode.getCollectionServerNode().getCollectionServer().getCollectionServerConnector().getMediaBatches(this.collectionNode.getCollection().getUniqueCollectionID())), this.columnNames);
    }

    private Object[][] getTableData(List list) {
        Object[][] objectArray = new Object[list.size()][this.columnNames.length];
        for (int i = 0; i < list.size(); ++i) {
            CcMediaBatch ccMediaBatch = (CcMediaBatch)list.get(i);
            objectArray[i][0] = ccMediaBatch;
            objectArray[i][1] = ccMediaBatch.getDestDir();
            objectArray[i][2] = ccMediaBatch.getLpsDir();
            objectArray[i][3] = ccMediaBatch.getLogFilepath();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New", "New-media-batch", this.collectionNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-creation-image-creation-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New media batch", "New-media-batch", actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.collectionNode.getCollectionServerNode().getAdminAccount().createMenuItem("Edit media batch", "Edit-media-batch", actionListener);
        jMenuItem.setEnabled(n == 1);
        jPopupMenu.add(jMenuItem);
        jMenuItem = this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("Delete media batch" + (n == 1 ? "" : "es"), "Delete-media-batch", actionListener);
        jMenuItem.setEnabled(n > 0);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu("Tools");
        jMenu.setDelay(0);
        jMenu.setEnabled(n == 1);
        jMenuItem = this.collectionNode.getCollectionServerNode().getAdminAccount().createMenuItem("Process media batch", "Edit-media-batch", actionListener);
        jMenuItem.setEnabled(n == 1);
        jMenu.add(jMenuItem);
        jMenuItem = this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("Map objects to media", COMMAND_MAP_OBJECTS_TO_IMAGES, actionListener);
        jMenuItem.setEnabled(n == 1);
        jMenu.add(jMenuItem);
        jMenuItem = this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("Publish media", COMMAND_PUBLISH_IMAGES, actionListener);
        jMenuItem.setEnabled(n == 1);
        jMenu.add(jMenuItem);
        jPopupMenu.add(jMenu);
        return jPopupMenu;
    }

    public void actionPerformed(String string, Vector vector) {
        CcMediaBatchesNode.debugOut("Received command: " + string);
        if (string.equals("New-media-batch")) {
            this.collectionNode.getCollectionServerNode().createNewMediaBatch(this.collectionNode.getCollection().getUniqueCollectionID());
        } else if (string.equals("Delete-media-batch")) {
            if (vector != null && vector.size() > 0) {
                this.collectionNode.getCollectionServerNode().deleteMediaBatches(vector);
            }
        } else if (string.equals("Edit-media-batch")) {
            if (vector != null && vector.size() == 1) {
                this.collectionNode.getCollectionServerNode().getCollectionServer().editDataObject((CcMediaBatch)vector.firstElement(), true);
            }
        } else if (string.equals(COMMAND_MAP_OBJECTS_TO_IMAGES)) {
            if (vector != null && vector.size() == 1) {
                this.collectionNode.getCollectionServerNode().getCollectionServer().manageObjectImageMappings(this.collectionNode.getCollection().getUniqueCollectionID(), (CcMediaBatch)vector.firstElement());
            }
        } else if (string.equals(COMMAND_PUBLISH_IMAGES) && vector != null && vector.size() == 1) {
            this.collectionNode.getCollectionServerNode().getCollectionServer().showPublishMediaBatchDialog((CcMediaBatch)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionNode.getCollectionServerNode().getCollectionServer().editDataObject((CcMediaBatch)object, true);
        }
    }

    public static void debugOut(String string) {
        CcMediaBatchesNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaBatchesNode: " + string, n);
    }
}

