/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.CollectionServerTableNames;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElement;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElementRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CcMediaBatchRecordHandler
extends DatabaseRecordHandler
implements CollectionServerTableNames {
    protected CcMediaBatchElementRecordHandler batchElementRh;

    public CcMediaBatchRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcMediaBatchRH";
        this.batchElementRh = new CcMediaBatchElementRecordHandler(administeredServerConnector);
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CcMediaBatch ccMediaBatch = (CcMediaBatch)databaseRecord;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, ccMediaBatch.getUniqueCollectionID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BatchID", 2, stringBuffer2, ccMediaBatch.getBatchID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BatchName", 1, stringBuffer2, ccMediaBatch.getBatchName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BatchStatus", 2, stringBuffer2, ccMediaBatch.getBatchStatus());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ResolutionProfileID", 2, stringBuffer2, ccMediaBatch.getBatchProfileID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DestDir", 1, stringBuffer2, ccMediaBatch.getDestDir());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LPSDir", 1, stringBuffer2, ccMediaBatch.getLpsDir());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LogFilepath", 1, stringBuffer2, ccMediaBatch.getLogFilepath());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingFilepath", 1, stringBuffer2, ccMediaBatch.getMappingFilepath());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MappingFieldID", 2, stringBuffer2, ccMediaBatch.getMappingFieldID());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StartingMediaID", 2, stringBuffer2, ccMediaBatch.getStartingMediaID());
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("INSERT INTO CCMEDIABATCHES (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert media batch query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            ((CollectionServerConnector)this.serverConnector).clearBatchElementRecords(ccMediaBatch.getBatchID());
            List list = ccMediaBatch.batchElements;
            for (int i = 0; list != null && i < list.size(); ++i) {
                CcMediaBatchElement ccMediaBatchElement = (CcMediaBatchElement)list.get(i);
                if (ccMediaBatchElement == null) continue;
                try {
                    ccMediaBatchElement.setBatchElementID(((CollectionServerConnector)this.serverConnector).getNextValidMediaBatchElementID(ccMediaBatch.getBatchID()));
                    ((CollectionServerConnector)this.serverConnector).commitRecord(ccMediaBatchElement);
                    continue;
                }
                catch (Exception exception) {
                    this.debugOut("Exception while writing batch element to the database: " + exception);
                    ccMediaBatch.batchElements = new Vector(0);
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            CcMediaBatch ccMediaBatch = (CcMediaBatch)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM CCMEDIABATCHES WHERE BatchID = " + ccMediaBatch.getBatchID());
            this.debugOut("Delete batch query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            this.batchElementRh.deleteBatchElements(ccMediaBatch);
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public Vector getRecords() {
        return this.getRecords(null);
    }

    public Vector getRecords(Integer n) {
        this.debugOut("in getRecords()");
        Vector<CcMediaBatch> vector = new Vector<CcMediaBatch>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHES", null, "*");
            if (n != null) {
                sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            }
            sqlQueryGenerator.addOrderBy("CCMEDIABATCHES", "BatchID");
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Batches query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                Integer n2 = new Integer(databaseConnector.getIntegerFieldByName("UniqueCollectionID"));
                Collection collection = ((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCollectionNode(n2).getCollection();
                vector.addElement(new CcMediaBatch(n2, collection, databaseConnector.getIntegerField("BatchID"), databaseConnector.getField("BatchName"), databaseConnector.getIntegerField("BatchStatus"), databaseConnector.getIntegerField("ResolutionProfileID"), databaseConnector.getField("DestDir"), databaseConnector.getField("LPSDir"), databaseConnector.getField("LogFilepath"), databaseConnector.getField("MappingFilepath"), databaseConnector.getIntegerField("MappingFieldID"), databaseConnector.getLongField("StartingMediaID")));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CcMediaBatch ccMediaBatch = null;
        try {
            CcMediaBatch ccMediaBatch2 = (CcMediaBatch)databaseRecord;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHES", null, "*");
            sqlQueryGenerator.appendToWhere("BatchID = " + ccMediaBatch2.getBatchID());
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Find batch query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                Collection collection = ((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCollectionNode(ccMediaBatch2.getUniqueCollectionID()).getCollection();
                ccMediaBatch = new CcMediaBatch(ccMediaBatch2.getUniqueCollectionID(), collection, databaseConnector.getIntegerField("BatchID"), databaseConnector.getField("BatchName"), databaseConnector.getIntegerField("BatchStatus"), databaseConnector.getIntegerField("ResolutionProfileID"), databaseConnector.getField("DestDir"), databaseConnector.getField("LPSDir"), databaseConnector.getField("LogFilepath"), databaseConnector.getField("MappingFilepath"), databaseConnector.getIntegerField("MappingFieldID"), databaseConnector.getLongField("StartingMediaID"));
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
        return ccMediaBatch;
    }

    public String getNextValidIDQuery() {
        return "SELECT BatchID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "CCMEDIABATCHES" + " ORDER BY BatchID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxIDValue(long l) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRMAXIDS", null, new String[]{"MAXBATCHID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("MAXBATCHID", 0);
            }
            databaseConnector.close();
            if (l > (long)n && n != 0) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MAXBATCHID = " + l);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateMaxIDValue():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public List getRecordsReferencingProfile(CcBatchProfile ccBatchProfile) {
        this.debugOut("in getRecordsReferencingProfile()");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHES", null, "*");
            sqlQueryGenerator.appendToWhere("ResolutionProfileID=" + ccBatchProfile.profileID);
            sqlQueryGenerator.addOrderBy("CCMEDIABATCHES", "BatchID");
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Batches query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                arrayList.add(new Integer(databaseConnector.getIntegerFieldByName("BatchID")));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecordsReferencingProfile():\n" + InsightUtilities.getStackTrace(exception));
        }
        return arrayList;
    }

    public void publishMediaBatch(CcMediaBatch ccMediaBatch, CsMediaGroup csMediaGroup) {
        this.debugOut("in publishMediaBatch()");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        DatabaseConnector databaseConnector2 = this.getDatabaseConnector();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHELEMENTS", null, "DestMediaID");
            sqlQueryGenerator.appendToWhere("BatchID = " + ccMediaBatch.getBatchID());
            sqlQueryGenerator.appendToWhere("ElementStatus = 1");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Get media IDs to publish:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            SqlQueryGenerator sqlQueryGenerator2 = this.getQueryGeneratorUtil();
            while (databaseConnector.more()) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "GroupID", 2, stringBuffer2, csMediaGroup.getGroupID());
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ImageID", 2, stringBuffer2, databaseConnector.getLongField("DestMediaID"));
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "MviSeries", 2, stringBuffer2, 0);
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "MpdSeries", 2, stringBuffer2, 0);
                sqlQueryGenerator2.appendFieldAndValue(stringBuffer, "ObjectID", 2, stringBuffer2, 0);
                databaseConnector2.setQuery("INSERT INTO IRGROUPIMAGEMAP (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
                this.debugOut("Publish media ID query:\n" + databaseConnector2.getQuery());
                databaseConnector2.runUpdateQuery();
                databaseConnector2.close();
                databaseConnector.next();
            }
            databaseConnector2.setQuery("UPDATE CCMEDIABATCHELEMENTS SET LastPublishedTimestamp = '" + new SimpleDate().get() + "' WHERE ElementStatus = " + 1 + " AND BatchID = " + ccMediaBatch.getBatchID());
            this.debugOut("Publish batch element timestamp update query:\n" + databaseConnector2.getQuery());
            databaseConnector2.runUpdateQuery();
            databaseConnector2.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in publishMediaBatch():\n" + InsightUtilities.getStackTrace(exception));
        }
        databaseConnector.close();
        databaseConnector2.close();
    }

    public void debugOut(String string) {
        this.debugOut(string, 2);
    }

    public void debugOut(String string, int n) {
        Debug.debugOut("CcMediaBatchRH: " + string, n);
    }
}

