/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchEditComponent;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchObjectLinkItem;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchProcessListItem;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchSourceFileItem;
import com.luna.insight.client.media.MediaFileMetadata;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class CcMediaBatchProcessListManager {
    protected static String[] imageFileExtensions = new String[]{"JPG", "JPEG", "TIF", "TIFF"};
    protected CcMediaBatch batch = null;
    protected CcMediaBatchEditComponent editComponent = null;

    public static void debugOut(String string) {
        CcMediaBatchProcessListManager.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaBatchProcessListManager: " + string, n);
    }

    public CcMediaBatchProcessListManager(CcMediaBatch ccMediaBatch) {
        this.batch = ccMediaBatch;
        if (ccMediaBatch != null) {
            this.editComponent = ccMediaBatch.editComponent;
        }
    }

    public void loadMappingFileIntoEditComponent() {
        if (this.editComponent == null) {
            return;
        }
        String string = this.editComponent.getMappingFileField().getText();
        Vector vector = CcMediaBatchProcessListManager.getObjectLinksInMappingFile(string);
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            defaultListModel.addElement(vector.elementAt(i));
        }
        this.editComponent.getObjectLinksList().setModel(defaultListModel);
    }

    public void addMatchToProcessList() {
        if (this.editComponent == null) {
            return;
        }
        CcMediaBatchObjectLinkItem ccMediaBatchObjectLinkItem = (CcMediaBatchObjectLinkItem)this.editComponent.getObjectLinksList().getSelectedValue();
        CcMediaBatchSourceFileItem ccMediaBatchSourceFileItem = (CcMediaBatchSourceFileItem)this.editComponent.getSourceFilesList().getSelectedValue();
        this.addMatchToProcessList(ccMediaBatchObjectLinkItem, ccMediaBatchSourceFileItem);
    }

    private void addMatchToProcessList(CcMediaBatchObjectLinkItem ccMediaBatchObjectLinkItem, CcMediaBatchSourceFileItem ccMediaBatchSourceFileItem) {
        if (this.editComponent == null) {
            return;
        }
        if (ccMediaBatchObjectLinkItem == null) {
            ccMediaBatchObjectLinkItem = new CcMediaBatchObjectLinkItem("", "");
        }
        if (ccMediaBatchObjectLinkItem != null && ccMediaBatchSourceFileItem != null) {
            CcMediaBatchProcessListItem ccMediaBatchProcessListItem = new CcMediaBatchProcessListItem(this.batch, ccMediaBatchObjectLinkItem, ccMediaBatchSourceFileItem);
            this.addItemToProcessList(ccMediaBatchProcessListItem);
            DefaultListModel defaultListModel = (DefaultListModel)this.editComponent.getObjectLinksList().getModel();
            defaultListModel.removeElement(ccMediaBatchObjectLinkItem);
            DefaultListModel defaultListModel2 = (DefaultListModel)this.editComponent.getSourceFilesList().getModel();
            defaultListModel2.removeElement(ccMediaBatchSourceFileItem);
        }
    }

    protected void addItemToProcessList(CcMediaBatchProcessListItem ccMediaBatchProcessListItem) {
        if (this.editComponent == null) {
            return;
        }
        String string = this.getDestinationPathForItems();
        String string2 = this.getDestinationFilenameForItem(ccMediaBatchProcessListItem);
        ccMediaBatchProcessListItem.setDestinationPath(string);
        ccMediaBatchProcessListItem.setDestinationFilename(string2);
        DefaultListModel defaultListModel = (DefaultListModel)this.editComponent.getProcessList().getModel();
        defaultListModel.addElement(ccMediaBatchProcessListItem);
    }

    public void removeFromProcessList() {
        if (this.editComponent == null) {
            return;
        }
        Object[] objectArray = this.editComponent.getProcessList().getSelectedValues();
        this.removeFromProcessList(objectArray);
    }

    protected void removeFromProcessList(Object[] objectArray) {
        if (this.editComponent == null) {
            return;
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                CcMediaBatchProcessListItem ccMediaBatchProcessListItem = (CcMediaBatchProcessListItem)objectArray[i];
                if (ccMediaBatchProcessListItem.getBatchElementStatus() != 0) continue;
                DefaultListModel defaultListModel = (DefaultListModel)this.editComponent.getProcessList().getModel();
                defaultListModel.removeElement(ccMediaBatchProcessListItem);
                if (ccMediaBatchProcessListItem.getObjectLinkItem().getObjectLink() != null && ccMediaBatchProcessListItem.getObjectLinkItem().getObjectLink().length() > 0) {
                    defaultListModel = (DefaultListModel)this.editComponent.getObjectLinksList().getModel();
                    defaultListModel.addElement(ccMediaBatchProcessListItem.getObjectLinkItem());
                }
                defaultListModel = (DefaultListModel)this.editComponent.getSourceFilesList().getModel();
                defaultListModel.addElement(ccMediaBatchProcessListItem.getSourceFileItem());
            }
        }
    }

    public void addSourceFiles(File file) {
        if (file == null) {
            return;
        }
        DefaultListModel<CcMediaBatchSourceFileItem> defaultListModel = (DefaultListModel<CcMediaBatchSourceFileItem>)this.editComponent.getSourceFilesList().getModel();
        if (defaultListModel == null) {
            defaultListModel = new DefaultListModel<CcMediaBatchSourceFileItem>();
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new NormalFileFilter());
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    defaultListModel.addElement(new CcMediaBatchSourceFileItem(fileArray[i]));
                }
                this.editComponent.getSourceFilesList().setModel(defaultListModel);
            }
        } else {
            defaultListModel.addElement(new CcMediaBatchSourceFileItem(file));
        }
    }

    public void matchObjectsAndMedia() {
        DefaultListModel defaultListModel = (DefaultListModel)this.editComponent.getObjectLinksList().getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.editComponent.getSourceFilesList().getModel();
        Enumeration enumeration = defaultListModel.elements();
        while (enumeration.hasMoreElements()) {
            CcMediaBatchObjectLinkItem ccMediaBatchObjectLinkItem = (CcMediaBatchObjectLinkItem)enumeration.nextElement();
            String string = ccMediaBatchObjectLinkItem.sourceFileName;
            CcMediaBatchSourceFileItem ccMediaBatchSourceFileItem = null;
            Enumeration enumeration2 = defaultListModel2.elements();
            while (enumeration2.hasMoreElements()) {
                CcMediaBatchSourceFileItem ccMediaBatchSourceFileItem2 = (CcMediaBatchSourceFileItem)enumeration2.nextElement();
                if (!ccMediaBatchSourceFileItem2.getFileNameWithoutExtension().equalsIgnoreCase(string)) continue;
                ccMediaBatchSourceFileItem = ccMediaBatchSourceFileItem2;
                if (!MediaFileMetadata.NON_IMAGE_FILE_EXTS.contains(ccMediaBatchSourceFileItem2.getFileExtension())) continue;
            }
            if (ccMediaBatchSourceFileItem == null) continue;
            this.addMatchToProcessList(ccMediaBatchObjectLinkItem, ccMediaBatchSourceFileItem);
            enumeration = defaultListModel.elements();
        }
    }

    public static Vector getObjectLinksInMappingFile(String string) {
        Vector<CcMediaBatchObjectLinkItem> vector = new Vector<CcMediaBatchObjectLinkItem>();
        if (string != null && string.trim().length() > 0) {
            Object object;
            EnhancedProperties enhancedProperties = new EnhancedProperties();
            try {
                object = new FileInputStream(string);
                enhancedProperties.load((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (Exception exception) {
                CcMediaBatchProcessListManager.debugOut("Exception while loading mapping properties: " + exception);
                return vector;
            }
            Iterator iterator = enhancedProperties.keysInOrder();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string2 = enhancedProperties.getProperty((String)object, "");
                vector.addElement(new CcMediaBatchObjectLinkItem((String)object, string2));
            }
        }
        return vector;
    }

    public static File[] getImageFilesInDirectory(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        return file.listFiles(new ImageFileFilter());
    }

    public static Vector getImageFileItemsInDirectory(String string) {
        Vector<CcMediaBatchSourceFileItem> vector = new Vector<CcMediaBatchSourceFileItem>();
        File[] fileArray = CcMediaBatchProcessListManager.getImageFilesInDirectory(string);
        if (fileArray == null) {
            return vector;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            vector.addElement(new CcMediaBatchSourceFileItem(fileArray[i]));
        }
        return vector;
    }

    protected String getDestinationPathForItems() {
        if (this.editComponent == null) {
            return "";
        }
        return CcMediaBatchProcessListManager.appendSeparatorIfNeeded(this.editComponent.getDestinationField().getText()) + CcMediaBatchProcessListManager.appendSeparatorIfNeeded(CcMediaBatchProcessListItem.SPS_PLACEHOLDER) + CcMediaBatchProcessListManager.appendSeparatorIfNeeded(this.editComponent.getLpsDirectoryField().getText());
    }

    protected String getDestinationFilenameForItem(CcMediaBatchProcessListItem ccMediaBatchProcessListItem) {
        if (this.editComponent == null) {
            return "";
        }
        CcBatchProfile ccBatchProfile = (CcBatchProfile)this.editComponent.getProfileComboBox().getSelectedItem();
        return ccMediaBatchProcessListItem.getDestinationFilename(ccBatchProfile.preserveFilenames);
    }

    protected static String appendSeparatorIfNeeded(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public static boolean isImageFile(File file) {
        try {
            if (file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            for (int i = 0; i < imageFileExtensions.length; ++i) {
                if (!string2.equalsIgnoreCase(imageFileExtensions[i])) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            CcMediaBatchProcessListManager.debugOut("Exception in isImageFile(): " + exception);
            return false;
        }
    }

    public static class NormalFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return file.isFile();
        }
    }

    public static class ImageFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return CcMediaBatchProcessListManager.isImageFile(file);
        }
    }
}

