/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElement;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchObjectLinkItem;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchSourceFileItem;
import java.io.File;

public class CcMediaBatchProcessListItem {
    protected static String SPS_PLACEHOLDER = "<SPS-DIRECTORY>\\";
    protected static String FILE_EXT_PLACEHOLDER = ".EXT";
    protected static String FILE_RESOLUTION_CODE_PLACEHOLDER = "R";
    protected static String FILE_SEQUENCE_CODE_PLACEHOLDER = "SSS";
    protected static String DISPLAY_FIELD_SEPARATOR = ",   ";
    protected CcMediaBatch batch = null;
    protected CcMediaBatchElement batchElement = null;
    protected CcMediaBatchObjectLinkItem objectLinkItem = null;
    protected CcMediaBatchSourceFileItem sourceFileItem = null;
    protected String destinationPath = "--";
    protected String destinationFilename = "--";

    public CcMediaBatchProcessListItem(CcMediaBatch ccMediaBatch, CcMediaBatchObjectLinkItem ccMediaBatchObjectLinkItem, CcMediaBatchSourceFileItem ccMediaBatchSourceFileItem) {
        this.batch = ccMediaBatch;
        this.objectLinkItem = ccMediaBatchObjectLinkItem;
        this.sourceFileItem = ccMediaBatchSourceFileItem;
    }

    public CcMediaBatchProcessListItem(CcMediaBatchElement ccMediaBatchElement) {
        if (ccMediaBatchElement != null) {
            this.batch = ccMediaBatchElement.getBatch();
            this.batchElement = ccMediaBatchElement;
            this.objectLinkItem = new CcMediaBatchObjectLinkItem(ccMediaBatchElement.getSrcFilename(), ccMediaBatchElement.getObjectKey());
            this.sourceFileItem = new CcMediaBatchSourceFileItem(new File(ccMediaBatchElement.getSrcFilepath(), ccMediaBatchElement.getSrcFilename()));
        }
    }

    public CcMediaBatchObjectLinkItem getObjectLinkItem() {
        return this.objectLinkItem;
    }

    public CcMediaBatchSourceFileItem getSourceFileItem() {
        return this.sourceFileItem;
    }

    public CcMediaBatch getBatch() {
        return this.batch;
    }

    public long getBatchElementID() {
        if (this.batchElement != null) {
            return this.batchElement.getBatchElementID();
        }
        return 0L;
    }

    public int getBatchElementStatus() {
        if (this.batchElement != null) {
            return this.batchElement.getStatus();
        }
        return 0;
    }

    public long getDestMediaID() {
        if (this.batchElement != null) {
            return this.batchElement.getDestMediaID();
        }
        return -1L;
    }

    public String getProcessedTimestamp() {
        if (this.batchElement != null) {
            return this.batchElement.getProcessedTimestamp();
        }
        return "";
    }

    public String getLastPublishedTimestamp() {
        if (this.batchElement != null) {
            return this.batchElement.getLastPublishedTimestamp();
        }
        return "";
    }

    public void setDestinationPath(String string) {
        this.destinationPath = string != null ? string : "";
    }

    public void setDestinationFilename(String string) {
        this.destinationFilename = string != null ? string : "";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CcMediaBatchElement.getStatusToString(this.getBatchElementStatus()) + " - ");
        stringBuffer.append(this.sourceFileItem != null ? this.sourceFileItem.getFileParent() : " -- ");
        stringBuffer.append(this.sourceFileItem != null ? File.separator + this.sourceFileItem.getFileName() : " -- ");
        stringBuffer.append(DISPLAY_FIELD_SEPARATOR + this.destinationPath);
        stringBuffer.append(DISPLAY_FIELD_SEPARATOR + this.destinationFilename);
        stringBuffer.append(DISPLAY_FIELD_SEPARATOR + (this.objectLinkItem != null ? this.objectLinkItem.getObjectLink() : " -- "));
        return stringBuffer.toString();
    }

    public String getDestinationFilename(boolean bl) {
        if (bl) {
            return this.sourceFileItem.getFileNameWithoutExtension() + FILE_EXT_PLACEHOLDER;
        }
        StringBuffer stringBuffer = new StringBuffer("" + this.batch.getBatchID());
        while (stringBuffer.length() < 4) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString() + FILE_RESOLUTION_CODE_PLACEHOLDER + FILE_SEQUENCE_CODE_PLACEHOLDER + FILE_EXT_PLACEHOLDER;
    }
}

