/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElement;
import com.luna.insight.admin.collserver.mediacreation.CcMediaSourceRecord;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public class CcMediaBatchElementRecordHandler
extends DatabaseRecordHandler {
    public CcMediaBatchElementRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcMediaBatchElementRH";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CcMediaBatchElement ccMediaBatchElement = (CcMediaBatchElement)databaseRecord;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BatchElementID", 2, stringBuffer2, ccMediaBatchElement.getBatchElementID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "BatchID", 2, stringBuffer2, ccMediaBatchElement.getBatchID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ElementStatus", 2, stringBuffer2, ccMediaBatchElement.getStatus() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SrcFilepath", 1, stringBuffer2, ccMediaBatchElement.getSrcFilepath());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SrcFilename", 1, stringBuffer2, ccMediaBatchElement.getSrcFilename());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DestMediaID", 2, stringBuffer2, ccMediaBatchElement.getDestMediaID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectKeyFieldID", 2, stringBuffer2, ccMediaBatchElement.getObjectKeyFieldID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ObjectKey", 1, stringBuffer2, ccMediaBatchElement.getObjectKey());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ProcessedTimestamp", 1, stringBuffer2, ccMediaBatchElement.getProcessedTimestamp());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LastPublishedTimestamp", 1, stringBuffer2, ccMediaBatchElement.getLastPublishedTimestamp());
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("INSERT INTO CCMEDIABATCHELEMENTS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert media batch element query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            CcMediaBatchElement ccMediaBatchElement = (CcMediaBatchElement)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM CCMEDIABATCHELEMENTS WHERE BatchID = " + ccMediaBatchElement.getBatchID() + " AND BatchElementID = " + ccMediaBatchElement.getBatchElementID());
            this.debugOut("Delete batch element query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void deleteBatchElements(CcMediaBatch ccMediaBatch) {
        this.debugOut("in deleteBatchElements()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM CCMEDIABATCHELEMENTS WHERE BatchID = " + ccMediaBatch.getBatchID());
            this.debugOut("Delete batch elements query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in deleteBatchElements():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public void clearRecords(int n) {
        this.debugOut("in clearRecords()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM CCMEDIABATCHELEMENTS WHERE BatchID = " + n;
            databaseConnector.setQuery(string);
            this.debugOut("deleteElementsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in clearRecords(): " + exception);
        }
    }

    public Vector getRecords() {
        return new Vector(0);
    }

    public Vector getRecords(CcMediaBatch ccMediaBatch) {
        this.debugOut("in getRecords()");
        Vector<CcMediaSourceRecord> vector = new Vector<CcMediaSourceRecord>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHELEMENTS", null, "*");
            sqlQueryGenerator.appendToWhere("BatchID = " + ccMediaBatch.getBatchID());
            sqlQueryGenerator.addOrderBy("CCMEDIABATCHELEMENTS", "BatchElementID");
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Batch elements query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                vector.add(new CcMediaSourceRecord(ccMediaBatch.getCollection(), ccMediaBatch, databaseConnector.getLongField("BatchElementID"), databaseConnector.getIntegerField("ElementStatus"), databaseConnector.getFieldByName("SrcFilepath"), databaseConnector.getFieldByName("SrcFilename"), databaseConnector.getLongField("DestMediaID"), databaseConnector.getIntegerField("ObjectKeyFieldID"), databaseConnector.getFieldByName("ObjectKey"), databaseConnector.getFieldByName("ProcessedTimestamp"), databaseConnector.getFieldByName("LastPublishedTimestamp")));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CcMediaSourceRecord ccMediaSourceRecord = null;
        try {
            CcMediaBatchElement ccMediaBatchElement = (CcMediaBatchElement)databaseRecord;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHELEMENTS", null, "*");
            sqlQueryGenerator.appendToWhere("BatchID = " + ccMediaBatchElement.getBatchID());
            sqlQueryGenerator.appendToWhere("BatchElementID = " + ccMediaBatchElement.getBatchElementID());
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Find batch element query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccMediaSourceRecord = new CcMediaSourceRecord(ccMediaBatchElement.getBatch().getCollection(), ccMediaBatchElement.getBatch(), databaseConnector.getLongField("BatchElementID"), databaseConnector.getIntegerField("ElementStatus"), databaseConnector.getField("SrcFilepath"), databaseConnector.getField("SrcFilename"), databaseConnector.getLongField("DestMediaID"), databaseConnector.getIntegerField("ObjectKeyFieldID"), databaseConnector.getField("ObjectKey"), databaseConnector.getFieldByName("ProcessedTimestamp"), databaseConnector.getFieldByName("LastPublishedTimestamp"));
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord():\n" + InsightUtilities.getStackTrace(exception));
        }
        return ccMediaSourceRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextBatchElementID(int n) {
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            if (n > 0) {
                databaseConnector.setQuery("SELECT MAX(BatchElementID) AS MaxBatchElementID FROM CCMEDIABATCHELEMENTS WHERE BatchID = " + n);
            } else {
                databaseConnector.setQuery("SELECT MAX(BatchElementID) AS MaxBatchElementID FROM CCMEDIABATCHELEMENTS");
            }
            databaseConnector.runQuery();
            this.debugOut("Get max BatchElementID query:\n" + databaseConnector.getQuery());
            long l = 0L;
            if (databaseConnector.more()) {
                l = databaseConnector.getIntegerField("MaxBatchElementID");
            }
            databaseConnector.close();
            long l2 = l + 1L;
            return l2;
        }
        catch (Exception exception) {
            this.debugOut("Exception in getNextBatchElementID():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            databaseConnector.close();
        }
        return this.getNextValidID();
    }

    public String getNextValidIDQuery() {
        return "SELECT BatchElementID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "CCMEDIABATCHELEMENTS" + " ORDER BY BatchElementID";
    }

    public void debugOut(String string) {
        this.debugOut(string, 2);
    }

    public void debugOut(String string, int n) {
        Debug.debugOut("CcMediaBatchElementRH: " + string, n);
    }

    public void updateMaxIDValue(long l) {
    }
}

