/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcImageCreationSpecialSettingsJpegEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class CcImageCreationSpecialSettingsJpeg
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public static final int[] DEFAULT_JPEG_COMPRESSIONS = new int[]{5, 10, 15, 15, 15, 15, 15, 15, 15};
    public static final int DEFAULT_JPEG_BRIGHTNESS = 0;
    public static final int DEFAULT_JPEG_EDGE_TRIMMING = 0;
    protected CcBatchProfileResolution ccBatchProfileResolution;
    protected int jpegCompression = 0;
    protected boolean useBrightness = false;
    protected boolean automaticTrimEdges = false;
    protected boolean forceUpsize = false;
    protected int brightness = 0;
    protected int edgeThreshold = 0;
    protected CcImageCreationSpecialSettingsJpegEditComponent editComponent = null;

    public CcImageCreationSpecialSettingsJpeg(CcBatchProfileResolution ccBatchProfileResolution) {
        this.ccBatchProfileResolution = ccBatchProfileResolution;
        if (ccBatchProfileResolution != null) {
            this.jpegCompression = DEFAULT_JPEG_COMPRESSIONS[ccBatchProfileResolution.getResolutionNumber()];
        }
    }

    public CcImageCreationSpecialSettingsJpeg(CcBatchProfileResolution ccBatchProfileResolution, int n, boolean bl, boolean bl2, boolean bl3, int n2, int n3) {
        this.ccBatchProfileResolution = ccBatchProfileResolution;
        this.jpegCompression = n;
        this.useBrightness = bl;
        this.automaticTrimEdges = bl2;
        this.forceUpsize = bl3;
        this.brightness = n2;
        this.edgeThreshold = n3;
    }

    public String toString() {
        return "";
    }

    public String getName() {
        return "";
    }

    public int getIndex() {
        return 0;
    }

    public String getUniqueIdentifier() {
        if (this.ccBatchProfileResolution != null) {
            return this.ccBatchProfileResolution.getUniqueIdentifier() + "-SS";
        }
        return "";
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcImageCreationSpecialSettingsJpegEditComponent();
        this.editComponent.getJpegCompressionField().setText("" + this.jpegCompression);
        this.editComponent.getUseBrightnessCheckBox().setSelected(this.useBrightness);
        this.editComponent.getBrightnessField().setText("" + this.brightness);
        this.editComponent.getTrimEdgesCheckBox().setSelected(this.automaticTrimEdges);
        this.editComponent.getEdgeThresholdField().setText("" + this.edgeThreshold);
        this.editComponent.getForceUpsizeCheckBox().setSelected(this.forceUpsize);
        return this.editComponent;
    }

    public void save() {
        CcImageCreationSpecialSettingsJpeg.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (!this.editComponent.verify()) {
            return;
        }
        try {
            if (this.hasChanged(this.jpegCompression, Integer.parseInt(this.editComponent.getJpegCompressionField().getText()))) {
                this.jpegCompression = Integer.parseInt(this.editComponent.getJpegCompressionField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.useBrightness, this.editComponent.getUseBrightnessCheckBox().isSelected())) {
            this.useBrightness = this.editComponent.getUseBrightnessCheckBox().isSelected();
        }
        try {
            if (this.hasChanged(this.brightness, Integer.parseInt(this.editComponent.getBrightnessField().getText()))) {
                this.brightness = Integer.parseInt(this.editComponent.getBrightnessField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.automaticTrimEdges, this.editComponent.getTrimEdgesCheckBox().isSelected())) {
            this.automaticTrimEdges = this.editComponent.getTrimEdgesCheckBox().isSelected();
        }
        try {
            if (this.hasChanged(this.edgeThreshold, Integer.parseInt(this.editComponent.getEdgeThresholdField().getText()))) {
                this.edgeThreshold = Integer.parseInt(this.editComponent.getEdgeThresholdField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.forceUpsize, this.editComponent.getForceUpsizeCheckBox().isSelected())) {
            this.forceUpsize = this.editComponent.getForceUpsizeCheckBox().isSelected();
        }
        this.creationCompleted = true;
        this.ccBatchProfileResolution.clearSpecialSettingsEditDialog();
    }

    public void cancel() {
        CcImageCreationSpecialSettingsJpeg.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.ccBatchProfileResolution.clearSpecialSettingsEditDialog();
    }

    public String getEditWindowTitle() {
        String string = this.ccBatchProfileResolution != null ? "" + this.ccBatchProfileResolution.getResolutionNumber() : "";
        return "Resolution " + string + ": JPEG Special Settings";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
    }

    public boolean equals(Object object) {
        if (object instanceof CcImageCreationSpecialSettingsJpeg) {
            CcImageCreationSpecialSettingsJpeg ccImageCreationSpecialSettingsJpeg = (CcImageCreationSpecialSettingsJpeg)object;
            return this.ccBatchProfileResolution.equals(ccImageCreationSpecialSettingsJpeg.ccBatchProfileResolution);
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcImageCreationSpecialSettingsJpeg) {
            CcImageCreationSpecialSettingsJpeg ccImageCreationSpecialSettingsJpeg = (CcImageCreationSpecialSettingsJpeg)databaseRecord;
            return this.jpegCompression == ccImageCreationSpecialSettingsJpeg.jpegCompression && this.useBrightness == ccImageCreationSpecialSettingsJpeg.useBrightness && this.automaticTrimEdges == ccImageCreationSpecialSettingsJpeg.automaticTrimEdges && this.forceUpsize == ccImageCreationSpecialSettingsJpeg.forceUpsize && this.brightness == ccImageCreationSpecialSettingsJpeg.brightness && this.edgeThreshold == ccImageCreationSpecialSettingsJpeg.edgeThreshold;
        }
        return false;
    }

    public static void debugOut(String string) {
        CcImageCreationSpecialSettingsJpeg.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcImageCreationSettingsJpeg: " + string, n);
    }
}

