/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public class CcBatchProfileRecordHandler
extends DatabaseRecordHandler {
    public CcBatchProfileRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcBatchProfileRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CcBatchProfile ccBatchProfile = (CcBatchProfile)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "INSERT INTO CCMEDIABATCHPROFILES (ProfileID, ProfileName, URLPrefix, SidUrlPrefix, PreserveFilenames, PreserveDirStructure) VALUES (" + ccBatchProfile.profileID + ", " + this.prepForInsertQuery(ccBatchProfile.profileName) + ", " + this.prepForInsertQuery(ccBatchProfile.urlPrefix) + ", " + this.prepForInsertQuery(ccBatchProfile.sidUrlPrefix) + ", " + (ccBatchProfile.preserveFilenames ? 1 : 0) + ", " + (ccBatchProfile.preserveDirStructure ? 1 : 0) + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertProfileQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            ((CollectionServerConnector)this.serverConnector).clearResolutionRecords(ccBatchProfile.profileID);
            Vector vector = ccBatchProfile.resolutions != null ? ccBatchProfile.resolutions : new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)vector.elementAt(i);
                if (ccBatchProfileResolution == null) continue;
                try {
                    ((CollectionServerConnector)this.serverConnector).commitRecord(ccBatchProfileResolution);
                    continue;
                }
                catch (Exception exception) {
                    this.debugOut("Exception while writing resolution to the database: " + exception);
                    ccBatchProfile.resolutions = new Vector();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM CCIMAGECREATIONRESOLUTIONS WHERE ResolutionSetID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteProfileResolutionsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string2 = "DELETE FROM CCMEDIABATCHPROFILES WHERE ProfileID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string2);
            this.debugOut("deleteProfileQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector<CcBatchProfile> vector = new Vector<CcBatchProfile>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHPROFILES", null, "*");
            sqlQueryGenerator.addOrderBy("CCMEDIABATCHPROFILES", "ProfileID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Profiles query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CcBatchProfile ccBatchProfile = new CcBatchProfile((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ProfileID"), databaseConnector.getFieldByName("ProfileName"), databaseConnector.getFieldByName("URLPrefix"), databaseConnector.getFieldByName("SidURLPrefix"), databaseConnector.getIntegerFieldByName("PreserveFilenames") == 1, databaseConnector.getIntegerFieldByName("PreserveDirStructure") == 1, new Vector(0));
                    Vector vector2 = ((CollectionServerConnector)this.serverConnector).getResolutionRecords(ccBatchProfile.profileID);
                    if (vector2 != null) {
                        ccBatchProfile.setResolutions(vector2);
                    }
                    vector.addElement(ccBatchProfile);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CcBatchProfile ccBatchProfile = null;
        int n = databaseRecord.getIndex();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHPROFILES", null, "*");
            sqlQueryGenerator.appendToWhere("ProfileID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Profile query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccBatchProfile = new CcBatchProfile((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ProfileID"), databaseConnector.getFieldByName("ProfileName"), databaseConnector.getFieldByName("URLPrefix"), databaseConnector.getFieldByName("SidURLPrefix"), databaseConnector.getIntegerFieldByName("PreserveFilenames") == 1, databaseConnector.getIntegerFieldByName("PreserveDirStructure") == 1, new Vector(0));
                Vector vector = ((CollectionServerConnector)this.serverConnector).getResolutionRecords(ccBatchProfile.profileID);
                if (vector != null) {
                    ccBatchProfile.setResolutions(vector);
                }
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return ccBatchProfile;
    }

    public CcBatchProfile getBatchProfileRecord(int n) {
        this.debugOut("in getBatchProfileRecord()");
        CcBatchProfile ccBatchProfile = null;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCMEDIABATCHPROFILES", null, "*");
            sqlQueryGenerator.appendToWhere("ProfileID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Profile query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccBatchProfile = new CcBatchProfile((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("ProfileID"), databaseConnector.getFieldByName("ProfileName"), databaseConnector.getFieldByName("URLPrefix"), databaseConnector.getFieldByName("SidURLPrefix"), databaseConnector.getIntegerFieldByName("PreserveFilenames") == 1, databaseConnector.getIntegerFieldByName("PreserveDirStructure") == 1, new Vector(0));
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getBatchProfileRecord(): " + InsightUtilities.getStackTrace(exception));
        }
        return ccBatchProfile;
    }

    public String getNextValidIDQuery() {
        return "SELECT ProfileID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "CCMEDIABATCHPROFILES" + " ORDER BY ProfileID";
    }

    public void updateMaxIDValue(long l) {
    }
}

